/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import cern.jet.random.Normal;
import cern.jet.random.engine.MersenneTwister;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Node;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.commons.math3.util.FastMath;

class QQPlot {
    private final DataSet dataSet;
    private ContinuousVariable selectedVariable;
    private double[] comparisonVariable;
    private double minComparison;
    private double maxComparison;
    private double minData;
    private double maxData;

    public QQPlot(DataSet dataSet, Node selectedNode) {
        if (dataSet == null) {
            throw new NullPointerException("the given dataset must not be null");
        }
        if (dataSet.getNumColumns() == 0) {
            throw new IllegalArgumentException("The given dataset should not be empty");
        }
        for (int i = 0; i < dataSet.getNumColumns() && !(dataSet.getVariable(i) instanceof ContinuousVariable); ++i) {
            if (i != dataSet.getNumColumns() - 1) continue;
            JOptionPane.showMessageDialog(new JFrame(), "You must have at least one continuous variable to construct a q-q plot!");
            throw new IllegalArgumentException("You must have at least one continuous variable to construct a q-q plot!");
        }
        this.dataSet = dataSet.copy();
        if (selectedNode == null && dataSet.getNumColumns() != 0) {
            int[] selected = dataSet.getSelectedIndices();
            assert (selected != null);
        }
        try {
            this.selectedVariable = (ContinuousVariable)selectedNode;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(new JFrame(), "You cannot construct a q-q plot for a discrete variable!");
            throw new IllegalArgumentException("Only attempt to construct a q-q plot on a continuous variable!");
        }
        this.buildQQPlotData(this.selectedVariable);
    }

    public double getMaxSample() {
        return this.maxData;
    }

    public double getMinSample() {
        return this.minData;
    }

    public double getMinIdeal() {
        return this.minComparison;
    }

    public Node getSelectedVariable() {
        return this.selectedVariable;
    }

    public void setSelectedVariable(ContinuousVariable c) {
        this.selectedVariable = c;
    }

    public double[] getComparisonVariable() {
        return this.comparisonVariable;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    private void calculateComparisonSet(Normal n, DataSet data) {
        this.comparisonVariable = new double[data.getNumRows()];
        for (int i = 0; i < data.getNumRows(); ++i) {
            double valueAtQuantile;
            this.comparisonVariable[i] = valueAtQuantile = QQPlot.findQuantile((double)(i + 1) / ((double)data.getNumRows() + 1.0), this.minData, this.maxData, n, 1.0E-4, 0, 50);
            if (valueAtQuantile < this.minComparison) {
                this.minComparison = valueAtQuantile;
            }
            if (!(valueAtQuantile > this.maxComparison)) continue;
            this.maxComparison = valueAtQuantile;
        }
    }

    private static double findQuantile(double quantile, double low, double high, Normal n, double precision, int count, int searchCap) {
        double mid = low + (high - low) / 2.0;
        double cdfResult = n.cdf(mid);
        if (FastMath.abs(cdfResult - quantile) < precision || count > searchCap) {
            return mid;
        }
        if (cdfResult > quantile) {
            return QQPlot.findQuantile(quantile, low, mid - precision, n, precision, count + 1, searchCap);
        }
        return QQPlot.findQuantile(quantile, mid + precision, high, n, precision, count + 1, searchCap);
    }

    private void buildQQPlotData(Node selectedNode) {
        int i;
        int columnIndex = this.dataSet.getColumn(selectedNode);
        double mean = 0.0;
        double sd = 0.0;
        this.minData = 1.0E13;
        this.maxData = 0.0;
        this.minComparison = 1.0E12;
        this.maxComparison = 0.0;
        if (columnIndex == -1) {
            for (i = 0; i < this.dataSet.getNumColumns(); ++i) {
                if (!(this.dataSet.getVariable(i) instanceof ContinuousVariable)) continue;
                this.selectedVariable = (ContinuousVariable)this.dataSet.getVariable(i);
                columnIndex = i;
                break;
            }
            if (columnIndex == -1) {
                JOptionPane.showMessageDialog(new JFrame(), "You need at least one complete continuous variable for a q-q plot!");
                throw new IllegalArgumentException("You need at least one complete continuous variable for a q-q plot!");
            }
        }
        for (i = 0; i < this.dataSet.getNumRows(); ++i) {
            double value = this.dataSet.getDouble(i, columnIndex);
            if (Double.isNaN(value) || value == Double.NEGATIVE_INFINITY || value == Double.POSITIVE_INFINITY) continue;
            mean += value;
            if (value < this.minData) {
                this.minData = value;
            }
            if (!(value > this.maxData)) continue;
            this.maxData = value;
        }
        for (i = 0; i < this.dataSet.getNumRows(); ++i) {
            for (int k = i; k < this.dataSet.getNumRows(); ++k) {
                double value1 = this.dataSet.getDouble(i, columnIndex);
                double value2 = this.dataSet.getDouble(k, columnIndex);
                if (Double.isNaN(value1) || value1 == Double.NEGATIVE_INFINITY || value1 == Double.POSITIVE_INFINITY || Double.isNaN(value2) || value2 == Double.NEGATIVE_INFINITY || value2 == Double.POSITIVE_INFINITY || !(value1 > value2)) continue;
                double temp = this.dataSet.getDouble(i, columnIndex);
                this.dataSet.setDouble(i, columnIndex, value2);
                this.dataSet.setDouble(k, columnIndex, temp);
            }
        }
        mean = mean == 0.0 ? 1.0 : (mean /= (double)this.dataSet.getNumRows());
        for (i = 0; i < this.dataSet.getNumRows(); ++i) {
            double value1 = this.dataSet.getDouble(i, columnIndex);
            double value2 = this.dataSet.getDouble(i, columnIndex);
            if (Double.isNaN(value1) || value1 == Double.NEGATIVE_INFINITY || value1 == Double.POSITIVE_INFINITY || Double.isNaN(value2) || value2 == Double.NEGATIVE_INFINITY || value2 == Double.POSITIVE_INFINITY) continue;
            sd += (value1 - mean) * (value2 - mean);
        }
        if (sd == 0.0) {
            sd = 1.0;
        } else {
            sd /= (double)this.dataSet.getNumRows() - 1.0;
            sd = FastMath.sqrt(sd);
        }
        Normal comparison = new Normal(mean, sd, new MersenneTwister());
        this.calculateComparisonSet(comparison, this.dataSet);
    }
}

