/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.editor.QQPlot;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Ellipse2D;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JPanel;
import org.apache.commons.math3.util.FastMath;

class QQPlotDisplayPanel
extends JPanel {
    private static final Color LINE_COLOR = Color.GRAY.darker();
    private static final int PADDING = 50;
    private static final int HEIGHT = 450;
    private static final int WIDTH = 450;
    private static final int SPACE = 2;
    private static final int DASH = 10;
    private final Dimension size = new Dimension(454, 450);
    private final NumberFormat format = NumberFormatUtil.getInstance().getNumberFormat();
    private QQPlot qqPlot;
    private String displayString;
    private final Map<Rectangle, Integer> rectMap = new ConcurrentHashMap<Rectangle, Integer>();

    public QQPlotDisplayPanel(QQPlot qqPlot) {
        this.qqPlot = qqPlot;
        if (qqPlot == null) {
            throw new NullPointerException("Given q-q plot must be null");
        }
        this.addMouseMotionListener(new MouseMovementListener());
        this.setToolTipText(" ");
    }

    public synchronized void updateQQPlot(QQPlot qqPlot) {
        if (qqPlot == null) {
            throw new NullPointerException("The given q-q plot must not be null");
        }
        this.displayString = null;
        this.qqPlot = qqPlot;
        this.repaint();
    }

    @Override
    public String getToolTipText(MouseEvent evt) {
        return null;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int i;
        this.rectMap.clear();
        Graphics2D g2d = (Graphics2D)graphics;
        int height = 400;
        FontMetrics fontMetrics = g2d.getFontMetrics();
        g2d.setColor(this.getBackground());
        g2d.fillRect(0, 0, 454, 450);
        g2d.setColor(Color.WHITE);
        g2d.fillRect(50, 0, 402, 400);
        g2d.setColor(LINE_COLOR);
        g2d.drawRect(50, 0, 402, 400);
        g2d.setColor(LINE_COLOR);
        g2d.drawString(this.format.format(FastMath.floor(this.qqPlot.getMinSample())), 55, 415);
        g2d.drawLine(50, 410, 50, 400);
        String maxStr = this.format.format((int)FastMath.ceil(this.qqPlot.getMaxSample()));
        g2d.drawString(maxStr, 450 - fontMetrics.stringWidth(maxStr), 415);
        g2d.drawLine(452, 410, 452, 400);
        g2d.setColor(LINE_COLOR);
        boolean topY = false;
        String top = "" + FastMath.ceil(this.qqPlot.getMaxSample());
        g2d.drawString(top, 50 - fontMetrics.stringWidth(top), 10);
        g2d.drawLine(40, 0, 50, 0);
        g2d.drawString(FastMath.floor(this.qqPlot.getMinSample()) + "", 50 - fontMetrics.stringWidth(FastMath.floor(this.qqPlot.getMinIdeal()) + ""), 398);
        g2d.drawLine(40, 400, 50, 400);
        int dataColumn = this.qqPlot.getDataSet().getColumn(this.qqPlot.getSelectedVariable());
        if (dataColumn == -1) {
            for (i = 0; i < this.qqPlot.getDataSet().getNumColumns(); ++i) {
                if (!(this.qqPlot.getDataSet().getVariable(i) instanceof ContinuousVariable)) continue;
                this.qqPlot.setSelectedVariable((ContinuousVariable)this.qqPlot.getDataSet().getVariable(i));
                dataColumn = i;
                break;
            }
        }
        g2d.setColor(new Color(255, 0, 0));
        for (i = 0; i < this.qqPlot.getDataSet().getNumRows(); ++i) {
            double x = this.qqPlot.getDataSet().getDouble(i, dataColumn);
            double y = this.qqPlot.getComparisonVariable()[i];
            if (!(x >= this.qqPlot.getMinSample()) || !(x <= this.qqPlot.getMaxSample()) || !(y >= this.qqPlot.getMinSample()) || !(y <= this.qqPlot.getMaxSample())) continue;
            double[] result = this.plotPoint(x, y, FastMath.floor(this.qqPlot.getMinSample()), FastMath.ceil(this.qqPlot.getMaxSample()));
            g2d.fill(new Ellipse2D.Double(result[0], result[1], 4.0, 4.0));
        }
        g2d.setColor(LINE_COLOR);
        g2d.drawString(this.getDisplayString(), 50, 445);
    }

    private String getDisplayString() {
        if (this.displayString == null) {
            this.displayString = "Showing: " + this.qqPlot.getSelectedVariable().getName();
        }
        return this.displayString;
    }

    private double[] plotPoint(double x, double y, double minRange, double maxRange) {
        double[] result = new double[2];
        double range = maxRange - minRange;
        result[0] = 400.0 * ((y - minRange) / range) - 2.0 + 50.0;
        result[1] = 450.0 - 400.0 * ((x - minRange) / range) - 2.0 - 50.0;
        return result;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.size;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.size;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.size;
    }

    private class MouseMovementListener
    implements MouseMotionListener {
        private MouseMovementListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Rectangle rect;
            Point point = e.getPoint();
            Iterator iterator = QQPlotDisplayPanel.this.rectMap.keySet().iterator();
            while (iterator.hasNext() && !(rect = (Rectangle)iterator.next()).contains(point)) {
            }
        }
    }
}

