/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetradapp.util.DoubleTextField;
import edu.cmu.tetradapp.util.IntTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.DecimalFormat;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

class RandomDagScaleFreeEditor
extends JPanel {
    private final IntTextField numNodesField = new IntTextField(this.getNumMeasuredNodes(), 4);
    private final IntTextField numLatentsField = new IntTextField(this.getNumLatents(), 4);
    private final DoubleTextField scaleFreeGammaField;

    public RandomDagScaleFreeEditor() {
        DecimalFormat nf = new DecimalFormat("0.00");
        DoubleTextField scaleFreeAlphaField = new DoubleTextField(this.getScaleFreeAlpha(), 4, nf);
        DoubleTextField scaleFreeBetaField = new DoubleTextField(this.getScaleFreeBeta(), 4, nf);
        this.scaleFreeGammaField = new DoubleTextField(this.getScaleFreeGamma(), 4, nf);
        DoubleTextField scaleFreeDeltaInField = new DoubleTextField(this.getScaleFreeDeltaIn(), 4, nf);
        DoubleTextField scaleFreeDeltaOutField = new DoubleTextField(this.getScaleFreeDeltaOut(), 4, nf);
        this.numNodesField.setFilter((value, oldValue) -> {
            if (value == this.numNodesField.getValue()) {
                return oldValue;
            }
            try {
                this.setNumMeasuredNodes(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return value;
        });
        this.numLatentsField.setFilter((value, oldValue) -> {
            if (value == this.numLatentsField.getValue()) {
                return oldValue;
            }
            try {
                this.setNumLatents(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return value;
        });
        scaleFreeAlphaField.setFilter((value, oldValue) -> {
            this.setScaleFreeAlpha(value);
            this.setGamma();
            return value;
        });
        scaleFreeBetaField.setFilter((value, oldValue) -> {
            this.setScaleFreeBeta(value);
            this.setGamma();
            return value;
        });
        this.scaleFreeGammaField.setEnabled(false);
        this.setGamma();
        scaleFreeDeltaInField.setFilter((value, oldValue) -> {
            this.setScaleFreeDeltaIn(value);
            return value;
        });
        scaleFreeDeltaOutField.setFilter((value, oldValue) -> {
            this.setScaleFreeDeltaOut(value);
            return value;
        });
        this.setLayout(new BorderLayout());
        Box b1 = Box.createVerticalBox();
        Box b2 = Box.createHorizontalBox();
        b2.add(new JLabel("Parameters for Graph:"));
        b2.add(Box.createHorizontalGlue());
        b1.add(b2);
        Box b10 = Box.createHorizontalBox();
        b10.add(new JLabel("Number of measured nodes:"));
        b10.add(Box.createHorizontalGlue());
        b10.add(this.numNodesField);
        b1.add(b10);
        Box b11 = Box.createHorizontalBox();
        b11.add(new JLabel("Max # latent confounders:"));
        b11.add(Box.createHorizontalGlue());
        b11.add(this.numLatentsField);
        b1.add(b11);
        Box b14 = Box.createHorizontalBox();
        b14.add(new JLabel("Alpha:"));
        b14.add(Box.createHorizontalGlue());
        b14.add(scaleFreeAlphaField);
        b1.add(b14);
        Box b15 = Box.createHorizontalBox();
        b15.add(new JLabel("Beta:"));
        b15.add(Box.createHorizontalGlue());
        b15.add(scaleFreeBetaField);
        b1.add(b15);
        Box b15a = Box.createHorizontalBox();
        b15a.add(new JLabel("Gamma:"));
        b15a.add(Box.createHorizontalGlue());
        b15a.add(this.scaleFreeGammaField);
        b1.add(b15a);
        Box b15b = Box.createHorizontalBox();
        b15b.add(new JLabel("Note: Gamma = 1 - Alpha - Beta; Alpha, Beta, Gamma > 0"));
        b1.add(b15b);
        Box b13 = Box.createHorizontalBox();
        b13.add(new JLabel("Delta In:"));
        b13.add(Box.createHorizontalGlue());
        b13.add(scaleFreeDeltaInField);
        b1.add(b13);
        Box b16 = Box.createHorizontalBox();
        b16.add(new JLabel("Delta Out:"));
        b16.add(Box.createHorizontalGlue());
        b16.add(scaleFreeDeltaOutField);
        b1.add(b16);
        Box d = Box.createVerticalBox();
        b1.setBorder(new TitledBorder(""));
        d.add(b1);
        d.add(Box.createVerticalGlue());
        this.add((Component)d, "Center");
    }

    private void setGamma() {
        this.scaleFreeGammaField.setValue(this.getScaleFreeGamma());
    }

    public int getNumNodes() {
        return this.getNumMeasuredNodes() + this.getNumLatents();
    }

    private int getNumMeasuredNodes() {
        return Preferences.userRoot().getInt("newGraphNumMeasuredNodes", 5);
    }

    private void setNumMeasuredNodes(int numMeasuredNodes) {
        if (numMeasuredNodes + this.getNumLatents() < 2) {
            throw new IllegalArgumentException("Number of nodes Must be greater than or equal to 2.");
        }
        Preferences.userRoot().putInt("newGraphNumMeasuredNodes", numMeasuredNodes);
    }

    public int getNumLatents() {
        return Preferences.userRoot().getInt("newGraphNumLatents", 0);
    }

    private void setNumLatents(int numLatentNodes) {
        if (numLatentNodes < 0) {
            throw new IllegalArgumentException("Max # latent confounders must be >= 0: " + numLatentNodes);
        }
        Preferences.userRoot().putInt("newGraphNumLatents", numLatentNodes);
    }

    public boolean isConnected() {
        return Preferences.userRoot().getBoolean("randomGraphConnected", false);
    }

    public double getScaleFreeAlpha() {
        return Preferences.userRoot().getDouble("scaleFreeAlpha", 0.2);
    }

    private void setScaleFreeAlpha(double scaleFreeAlpha) {
        Preferences.userRoot().putDouble("scaleFreeAlpha", scaleFreeAlpha);
    }

    public double getScaleFreeBeta() {
        return Preferences.userRoot().getDouble("scaleFreeBeta", 0.6);
    }

    private void setScaleFreeBeta(double scaleFreeBeta) {
        Preferences.userRoot().putDouble("scaleFreeBeta", scaleFreeBeta);
    }

    private double getScaleFreeGamma() {
        return 1.0 - this.getScaleFreeAlpha() - this.getScaleFreeBeta();
    }

    public double getScaleFreeDeltaIn() {
        return Preferences.userRoot().getDouble("scaleFreeDeltaIn", 0.2);
    }

    private void setScaleFreeDeltaIn(double scaleFreeDeltaIn) {
        Preferences.userRoot().putDouble("scaleFreeDeltaIn", scaleFreeDeltaIn);
    }

    public double getScaleFreeDeltaOut() {
        return Preferences.userRoot().getDouble("scaleFreeDeltaOut", 0.2);
    }

    private void setScaleFreeDeltaOut(double scaleFreeDeltaOut) {
        Preferences.userRoot().putDouble("scaleFreeDeltaOut", scaleFreeDeltaOut);
    }
}

