/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.util.IntTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import org.apache.commons.math3.util.FastMath;

class RandomGraphEditor
extends JPanel {
    private final Parameters parameters;
    private final IntTextField numNodesField;
    private final IntTextField numLatentsField;
    private final IntTextField maxEdgesField;
    private final IntTextField maxIndegreeField;
    private final IntTextField maxOutdegreeField;
    private final IntTextField maxDegreeField;
    private final JRadioButton chooseUniform;
    private final JRadioButton chooseFixed;
    private final JComboBox connectedBox;
    private final IntTextField numTwoCyclesField;
    private final IntTextField minCycleLengthField;

    public RandomGraphEditor(boolean cyclicAllowed, Parameters parameters) {
        this(new EdgeListGraph(), cyclicAllowed, parameters);
    }

    public RandomGraphEditor(Graph oldGraph, boolean cyclicAllowed, Parameters parameters) {
        if (parameters == null) {
            throw new NullPointerException();
        }
        this.parameters = parameters;
        int oldNumMeasured = 0;
        int oldNumLatents = 0;
        for (Node node : oldGraph.getNodes()) {
            if (node.getNodeType() == NodeType.LATENT) {
                ++oldNumMeasured;
            }
            if (node.getNodeType() != NodeType.LATENT) continue;
            ++oldNumLatents;
        }
        int oldNumNodes = oldNumMeasured + oldNumLatents;
        if (oldNumNodes > 1 && oldNumMeasured == this.getNumMeasuredNodes() && oldNumLatents == this.getNumLatents()) {
            this.setNumMeasuredNodes(oldNumMeasured);
            this.setNumLatents(oldNumLatents);
            this.setMaxEdges(FastMath.min(this.getMaxEdges(), oldNumNodes * (oldNumNodes - 1) / 2));
        }
        this.numNodesField = new IntTextField(this.getNumMeasuredNodes(), 4);
        this.numLatentsField = new IntTextField(this.getNumLatents(), 4);
        this.maxEdgesField = new IntTextField(this.getMaxEdges(), 4);
        this.maxIndegreeField = new IntTextField(this.getMaxIndegree(), 4);
        this.maxOutdegreeField = new IntTextField(this.getMaxOutdegree(), 4);
        this.maxDegreeField = new IntTextField(this.getMaxDegree(), 4);
        JRadioButton randomForward = new JRadioButton("Add random forward edges");
        this.chooseUniform = new JRadioButton("Draw uniformly from all such DAGs");
        this.chooseFixed = new JRadioButton("Guarantee maximum number of edges");
        this.connectedBox = new JComboBox<String>(new String[]{"No", "Yes"});
        JComboBox<String> addCyclesBox = new JComboBox<String>(new String[]{"No", "Yes"});
        this.numTwoCyclesField = new IntTextField(this.getMinNumCycles(), 4);
        this.minCycleLengthField = new IntTextField(this.getMinCycleLength(), 4);
        ButtonGroup group = new ButtonGroup();
        group.add(randomForward);
        group.add(this.chooseUniform);
        group.add(this.chooseFixed);
        randomForward.setSelected(this.isRandomForward());
        this.chooseUniform.setSelected(this.isUniformlySelected());
        this.chooseFixed.setSelected(this.isChooseFixed());
        this.numNodesField.setFilter((value, oldValue) -> {
            if (value == this.numNodesField.getValue()) {
                return oldValue;
            }
            try {
                this.setNumMeasuredNodes(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.maxEdgesField.setValue(this.getMaxEdges());
            return value;
        });
        this.numLatentsField.setFilter((value, oldValue) -> {
            if (value == this.numLatentsField.getValue()) {
                return oldValue;
            }
            try {
                this.setNumLatents(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.maxEdgesField.setValue(this.getMaxEdges());
            return value;
        });
        this.maxEdgesField.setFilter((value, oldValue) -> {
            if (value == this.maxEdgesField.getValue()) {
                return oldValue;
            }
            try {
                this.setMaxEdges(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return value;
        });
        this.maxIndegreeField.setFilter((value, oldValue) -> {
            if (value == this.maxIndegreeField.getValue()) {
                return oldValue;
            }
            try {
                this.setMaxIndegree(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.maxOutdegreeField.setValue(this.getMaxOutdegree());
            return value;
        });
        this.maxOutdegreeField.setFilter((value, oldValue) -> {
            if (value == this.maxOutdegreeField.getValue()) {
                return oldValue;
            }
            try {
                this.setMaxOutdegree(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.maxIndegreeField.setValue(this.getMaxIndegree());
            this.maxDegreeField.setValue(this.getMaxDegree());
            return value;
        });
        this.maxDegreeField.setFilter((value, oldValue) -> {
            if (value == this.maxDegreeField.getValue()) {
                return oldValue;
            }
            try {
                this.setMaxDegree(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.maxIndegreeField.setValue(this.getMaxIndegree());
            this.maxOutdegreeField.setValue(this.getMaxOutdegree());
            return value;
        });
        if (this.isConnected()) {
            this.connectedBox.setSelectedItem("Yes");
        } else {
            this.connectedBox.setSelectedItem("No");
        }
        if (this.isUniformlySelected() || this.isChooseFixed()) {
            this.maxIndegreeField.setEnabled(true);
            this.maxOutdegreeField.setEnabled(true);
            this.maxDegreeField.setEnabled(true);
            this.connectedBox.setEnabled(true);
        } else {
            this.maxIndegreeField.setEnabled(false);
            this.maxOutdegreeField.setEnabled(false);
            this.maxDegreeField.setEnabled(false);
            this.connectedBox.setEnabled(false);
        }
        this.minCycleLengthField.setEnabled(this.isAddCycles());
        this.connectedBox.setMaximumSize(this.connectedBox.getPreferredSize());
        this.connectedBox.addActionListener(e -> {
            JComboBox box = (JComboBox)e.getSource();
            if ("Yes".equals(box.getSelectedItem())) {
                this.setConnected(true);
            } else if ("No".equals(box.getSelectedItem())) {
                this.setConnected(false);
            } else {
                throw new IllegalArgumentException();
            }
            this.maxIndegreeField.setValue(this.getMaxIndegree());
            this.maxOutdegreeField.setValue(this.getMaxOutdegree());
            this.maxDegreeField.setValue(this.getMaxDegree());
            this.maxEdgesField.setValue(this.getMaxEdges());
        });
        randomForward.addActionListener(e -> {
            JRadioButton button = (JRadioButton)e.getSource();
            button.setSelected(true);
            this.setRandomForward(true);
            this.setUniformlySelected(false);
            this.setChooseFixed(false);
            this.maxIndegreeField.setEnabled(true);
            this.maxOutdegreeField.setEnabled(true);
            this.maxDegreeField.setEnabled(true);
            this.connectedBox.setEnabled(true);
        });
        this.chooseUniform.addActionListener(e -> {
            JRadioButton button = (JRadioButton)e.getSource();
            button.setSelected(true);
            this.setRandomForward(false);
            this.setUniformlySelected(true);
            this.setChooseFixed(false);
            this.maxIndegreeField.setEnabled(true);
            this.maxOutdegreeField.setEnabled(true);
            this.maxDegreeField.setEnabled(true);
            this.connectedBox.setEnabled(true);
        });
        this.chooseFixed.addActionListener(e -> {
            JRadioButton button = (JRadioButton)e.getSource();
            button.setSelected(true);
            this.setRandomForward(false);
            this.setUniformlySelected(false);
            this.setChooseFixed(true);
            this.maxIndegreeField.setEnabled(false);
            this.maxOutdegreeField.setEnabled(false);
            this.maxDegreeField.setEnabled(false);
            this.connectedBox.setEnabled(false);
        });
        if (this.isAddCycles()) {
            addCyclesBox.setSelectedItem("Yes");
        } else {
            addCyclesBox.setSelectedItem("No");
        }
        addCyclesBox.setMaximumSize(addCyclesBox.getPreferredSize());
        addCyclesBox.addActionListener(e -> {
            JComboBox box = (JComboBox)e.getSource();
            if ("Yes".equals(box.getSelectedItem())) {
                this.setAddCycles(true);
                this.minCycleLengthField.setEnabled(true);
            } else if ("No".equals(box.getSelectedItem())) {
                this.setAddCycles(false);
                this.minCycleLengthField.setEnabled(false);
            } else {
                throw new IllegalArgumentException();
            }
        });
        this.numTwoCyclesField.setFilter((value, oldValue) -> {
            if (value == this.numTwoCyclesField.getValue()) {
                return oldValue;
            }
            try {
                this.setMinNumCycles(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return value;
        });
        this.minCycleLengthField.setFilter((value, oldValue) -> {
            if (value == this.minCycleLengthField.getValue()) {
                return oldValue;
            }
            try {
                this.setMinCycleLength(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return value;
        });
        this.setLayout(new BorderLayout());
        Box b1 = Box.createVerticalBox();
        Box b2 = Box.createHorizontalBox();
        b2.add(new JLabel("Parameters for Random DAG:"));
        b2.add(Box.createHorizontalGlue());
        b1.add(b2);
        b1.add(Box.createVerticalStrut(5));
        Box b10 = Box.createHorizontalBox();
        b10.add(new JLabel("Number of measured nodes:"));
        b10.add(Box.createRigidArea(new Dimension(10, 0)));
        b10.add(Box.createHorizontalGlue());
        b10.add(this.numNodesField);
        b1.add(b10);
        Box b11 = Box.createHorizontalBox();
        b11.add(new JLabel("Max # latent confounders:"));
        b11.add(Box.createHorizontalStrut(25));
        b11.add(Box.createHorizontalGlue());
        b11.add(this.numLatentsField);
        b1.add(b11);
        b1.add(Box.createVerticalStrut(5));
        Box b12 = Box.createHorizontalBox();
        b12.add(new JLabel("Maximum number of edges:"));
        b12.add(Box.createHorizontalGlue());
        b12.add(this.maxEdgesField);
        b1.add(b12);
        b1.add(Box.createVerticalStrut(5));
        Box b14 = Box.createHorizontalBox();
        b14.add(new JLabel("Maximum indegree:"));
        b14.add(Box.createHorizontalGlue());
        b14.add(this.maxIndegreeField);
        b1.add(b14);
        Box b15 = Box.createHorizontalBox();
        b15.add(new JLabel("Maximum outdegree:"));
        b15.add(Box.createHorizontalGlue());
        b15.add(this.maxOutdegreeField);
        b1.add(b15);
        Box b13 = Box.createHorizontalBox();
        b13.add(new JLabel("Maximum degree:"));
        b13.add(Box.createHorizontalGlue());
        b13.add(this.maxDegreeField);
        b1.add(b13);
        b1.add(Box.createVerticalStrut(5));
        Box b16 = Box.createHorizontalBox();
        b16.add(new JLabel("Connected:"));
        b16.add(Box.createHorizontalGlue());
        b16.add(this.connectedBox);
        b1.add(b16);
        b1.add(Box.createVerticalStrut(5));
        Box b17a = Box.createHorizontalBox();
        b17a.add(randomForward);
        b17a.add(Box.createHorizontalGlue());
        b1.add(b17a);
        Box b17 = Box.createHorizontalBox();
        b17.add(this.chooseUniform);
        b17.add(Box.createHorizontalGlue());
        b1.add(b17);
        Box b18 = Box.createHorizontalBox();
        b18.add(this.chooseFixed);
        b18.add(Box.createHorizontalGlue());
        b1.add(b18);
        Box d = Box.createVerticalBox();
        b1.setBorder(new TitledBorder(""));
        d.add(b1);
        if (cyclicAllowed) {
            Box c1 = Box.createVerticalBox();
            Box c2 = Box.createHorizontalBox();
            c2.add(new JLabel("Create a cyclic graph?"));
            c2.add(Box.createHorizontalGlue());
            c2.add(addCyclesBox);
            c1.add(c2);
            c1.add(Box.createVerticalStrut(5));
            Box c3 = Box.createHorizontalBox();
            c3.add(new JLabel("Number of two cycles to add:"));
            c3.add(Box.createHorizontalGlue());
            c3.add(this.numTwoCyclesField);
            c1.add(c3);
            c1.add(Box.createVerticalStrut(5));
            c1.setBorder(new TitledBorder(""));
            d.add(Box.createVerticalStrut(5));
            d.add(c1);
        }
        this.add((Component)d, "Center");
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.isChooseFixed() && enabled) {
            this.numNodesField.setEnabled(enabled);
            this.numLatentsField.setEnabled(enabled);
            this.maxEdgesField.setEnabled(enabled);
            this.maxIndegreeField.setEnabled(false);
            this.maxOutdegreeField.setEnabled(false);
            this.maxDegreeField.setEnabled(false);
            this.connectedBox.setEnabled(false);
            this.chooseUniform.setEnabled(enabled);
            this.chooseFixed.setEnabled(enabled);
        } else {
            this.numNodesField.setEnabled(enabled);
            this.numLatentsField.setEnabled(enabled);
            this.maxEdgesField.setEnabled(enabled);
            this.maxIndegreeField.setEnabled(enabled);
            this.maxOutdegreeField.setEnabled(enabled);
            this.maxDegreeField.setEnabled(enabled);
            this.connectedBox.setEnabled(enabled);
            this.chooseUniform.setEnabled(enabled);
            this.chooseFixed.setEnabled(enabled);
        }
    }

    public boolean isRandomForward() {
        return this.parameters.getBoolean("graphRandomFoward", true);
    }

    public boolean isUniformlySelected() {
        return this.parameters.getBoolean("graphUniformlySelected", true);
    }

    public boolean isChooseFixed() {
        return this.parameters.getBoolean("graphChooseFixed", true);
    }

    private void setRandomForward(boolean randomFoward) {
        this.parameters.set("graphRandomFoward", (Object)randomFoward);
    }

    private void setUniformlySelected(boolean uniformlySelected) {
        this.parameters.set("graphUniformlySelected", (Object)uniformlySelected);
    }

    private void setChooseFixed(boolean chooseFixed) {
        this.parameters.set("graphChooseFixed", (Object)chooseFixed);
    }

    public int getNumNodes() {
        return this.getNumMeasuredNodes() + this.getNumLatents();
    }

    private int getNumMeasuredNodes() {
        return this.parameters.getInt("newGraphNumMeasuredNodes", 10);
    }

    private void setNumMeasuredNodes(int numMeasuredNodes) {
        if (numMeasuredNodes + this.getNumLatents() < 2) {
            throw new IllegalArgumentException("Number of nodes Must be greater than or equal to 2.");
        }
        this.parameters.set("newGraphNumMeasuredNodes", (Object)numMeasuredNodes);
        if (this.isConnected()) {
            this.setMaxEdges(FastMath.max(this.getMaxEdges(), numMeasuredNodes + this.getNumLatents()));
        }
    }

    public int getNumLatents() {
        return this.parameters.getInt("newGraphNumLatents", 0);
    }

    private void setNumLatents(int numLatentNodes) {
        if (numLatentNodes < 0) {
            throw new IllegalArgumentException("Max # latent confounders must be >= 0: " + numLatentNodes);
        }
        this.parameters.set("newGraphNumLatents", (Object)numLatentNodes);
    }

    public int getMaxEdges() {
        return this.parameters.getInt("newGraphNumEdges", 10);
    }

    private void setMaxEdges(int numEdges) {
        if (numEdges < 0) {
            throw new IllegalArgumentException("Number of edges Must be greater than or equal to 0: " + numEdges);
        }
        int maxNumEdges = this.getNumNodes() * (this.getNumNodes() - 1) / 2;
        if (numEdges > maxNumEdges) {
            numEdges = maxNumEdges;
        }
        this.parameters.set("newGraphNumEdges", (Object)numEdges);
    }

    public int getMaxDegree() {
        return this.parameters.getInt("randomGraphMaxDegree", 6);
    }

    private void setMaxDegree(int maxDegree) {
        if (!this.isConnected() && maxDegree < 1) {
            this.parameters.set("randomGraphMaxDegree", (Object)1);
            return;
        }
        if (this.isConnected() && maxDegree < 3) {
            this.parameters.set("randomGraphMaxDegree", (Object)3);
            return;
        }
        this.parameters.set("randomGraphMaxDegree", (Object)maxDegree);
    }

    public int getMaxIndegree() {
        return this.parameters.getInt("randomGraphMaxIndegree", 3);
    }

    private void setMaxIndegree(int maxIndegree) {
        if (!this.isConnected() && maxIndegree < 1) {
            this.parameters.set("randomGraphMaxIndegree", (Object)1);
            return;
        }
        if (this.isConnected() && maxIndegree < 2) {
            this.parameters.set("randomGraphMaxIndegree", (Object)2);
            return;
        }
        this.parameters.set("randomGraphMaxIndegree", (Object)maxIndegree);
    }

    public int getMaxOutdegree() {
        return this.parameters.getInt("randomGraphMaxOutdegree", 3);
    }

    private void setMaxOutdegree(int maxOutDegree) {
        if (!this.isConnected() && maxOutDegree < 1) {
            this.parameters.set("randomGraphMaxOutdegree", (Object)1);
            return;
        }
        if (this.isConnected() && maxOutDegree < 2) {
            this.parameters.set("randomGraphMaxOutdegree", (Object)2);
            return;
        }
        this.parameters.set("randomGraphMaxOutdegree", (Object)maxOutDegree);
    }

    private void setConnected(boolean connected) {
        this.parameters.set("randomGraphConnected", (Object)connected);
        if (connected) {
            if (this.getMaxIndegree() < 2) {
                this.setMaxIndegree(2);
            }
            if (this.getMaxOutdegree() < 2) {
                this.setMaxOutdegree(2);
            }
            if (this.getMaxDegree() < 3) {
                this.setMaxDegree(3);
            }
            if (this.getMaxEdges() < this.getNumNodes()) {
                this.setMaxEdges(this.getNumNodes());
            }
        }
    }

    public boolean isConnected() {
        return this.parameters.getBoolean("randomGraphConnected", false);
    }

    private void setAddCycles(boolean addCycles) {
        this.parameters.set("randomGraphAddCycles", (Object)addCycles);
    }

    public boolean isAddCycles() {
        return this.parameters.getBoolean("randomGraphAddCycles", false);
    }

    public int getMinNumCycles() {
        int minNumCycles = this.parameters.getInt("randomGraphMinNumCycles", 0);
        System.out.println("get min num cycles = " + minNumCycles);
        return minNumCycles;
    }

    private void setMinNumCycles(int minNumCycles) {
        System.out.println("set min num cycles = " + minNumCycles);
        if (minNumCycles < 0) {
            this.parameters.set("randomGraphMinNumCycles", (Object)0);
            return;
        }
        this.parameters.set("randomGraphMinNumCycles", (Object)minNumCycles);
    }

    public int getMinCycleLength() {
        return this.parameters.getInt("randomGraphMinCycleLength", 2);
    }

    private void setMinCycleLength(int minCycleLength) {
        if (minCycleLength < 2) {
            this.parameters.set("randomGraphMinCycleLength", (Object)2);
            return;
        }
        this.parameters.set("randomGraphMinCycleLength", (Object)minCycleLength);
    }
}

