/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.util.IntTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

class RandomMimParamsEditor
extends JPanel {
    private static final long serialVersionUID = -1478898170626611725L;

    public RandomMimParamsEditor(Parameters parameters) {
        JComboBox<String> numFactors = new JComboBox<String>();
        numFactors.addItem("1");
        numFactors.addItem("2");
        numFactors.addActionListener(e -> {
            if (Objects.equals(numFactors.getSelectedItem(), "1")) {
                parameters.set("randomMimNumFactors", (Object)1);
            } else if (numFactors.getSelectedItem().equals("2")) {
                parameters.set("randomMimNumFactors", (Object)2);
            }
        });
        numFactors.setSelectedItem(Integer.toString(parameters.getInt("randomMimNumFactors", 1)));
        numFactors.setMaximumSize(numFactors.getPreferredSize());
        IntTextField numStructuralEdges = new IntTextField(parameters.getInt("numStructuralEdges", 3), 4);
        numStructuralEdges.setFilter((value, oldValue) -> {
            try {
                int n = parameters.getInt("numStructuralNodes", 3);
                int maxNumLatentEdges = n * (n - 1) / 2;
                if (value > maxNumLatentEdges) {
                    value = maxNumLatentEdges;
                }
                parameters.set("numStructuralEdges", (Object)value);
                return value;
            }
            catch (Exception exception) {
                TetradLogger.getInstance().forceLogMessage(exception.toString());
                return oldValue;
            }
        });
        IntTextField numStructuralNodes = new IntTextField(parameters.getInt("numStructuralNodes", 3), 4);
        numStructuralNodes.setFilter((value, oldValue) -> {
            try {
                if (value < 1) {
                    throw new IllegalArgumentException("Number of structural nodes Must be greater than 0: " + value);
                }
                parameters.set("numStructuralNodes", (Object)value);
                numStructuralEdges.setValue(numStructuralEdges.getValue());
                return value;
            }
            catch (Exception exception) {
                TetradLogger.getInstance().forceLogMessage(exception.toString());
                numStructuralEdges.setValue(numStructuralEdges.getValue());
                return oldValue;
            }
        });
        IntTextField numMeasurementsPerLatent = new IntTextField(parameters.getInt("measurementModelDegree", 5), 4);
        numMeasurementsPerLatent.setFilter((value, oldValue) -> {
            try {
                if (value < 2) {
                    throw new IllegalArgumentException();
                }
                parameters.set("measurementModelDegree", (Object)value);
                return value;
            }
            catch (Exception exception) {
                TetradLogger.getInstance().forceLogMessage(exception.toString());
                return oldValue;
            }
        });
        IntTextField numLatentMeasuredImpureParents = new IntTextField(parameters.getInt("latentMeasuredImpureParents", 0), 4);
        numLatentMeasuredImpureParents.setFilter((value, oldValue) -> {
            try {
                if (value < 0) {
                    throw new IllegalArgumentException();
                }
                parameters.set("latentMeasuredImpureParents", (Object)value);
                return value;
            }
            catch (Exception exception) {
                TetradLogger.getInstance().forceLogMessage(exception.toString());
                return oldValue;
            }
        });
        IntTextField numMeasuredMeasuredImpureParents = new IntTextField(parameters.getInt("measuredMeasuredImpureParents", 0), 4);
        numMeasuredMeasuredImpureParents.setFilter((value, oldValue) -> {
            try {
                if (value < 0) {
                    throw new IllegalArgumentException();
                }
                parameters.set("measuredMeasuredImpureParents", (Object)value);
                return value;
            }
            catch (Exception exception) {
                TetradLogger.getInstance().forceLogMessage(exception.toString());
                return oldValue;
            }
        });
        IntTextField numMeasuredMeasuredImpureAssociations = new IntTextField(parameters.getInt("measuredMeasuredImpureAssociations", 0), 4);
        numMeasuredMeasuredImpureAssociations.setFilter((value, oldValue) -> {
            try {
                if (value < 0) {
                    throw new IllegalArgumentException();
                }
                parameters.set("measuredMeasuredImpureAssociations", (Object)value);
                return value;
            }
            catch (Exception exception) {
                TetradLogger.getInstance().forceLogMessage(exception.toString());
                return oldValue;
            }
        });
        this.setLayout(new BorderLayout());
        Box b1 = Box.createVerticalBox();
        Box b9 = Box.createHorizontalBox();
        b9.add(new JLabel("Number of Factors:"));
        b9.add(Box.createHorizontalGlue());
        b9.add(numFactors);
        b1.add(b9);
        Box b10 = Box.createHorizontalBox();
        b10.add(new JLabel("Number of structural nodes:"));
        b10.add(Box.createHorizontalGlue());
        b10.add(numStructuralNodes);
        b1.add(b10);
        Box b12 = Box.createHorizontalBox();
        b12.add(new JLabel("Number of structural edges:"));
        b12.add(Box.createHorizontalGlue());
        b12.add(numStructuralEdges);
        b1.add(b12);
        Box b15 = Box.createHorizontalBox();
        b15.add(new JLabel("Number of measurements per latent:"));
        b15.add(Box.createHorizontalGlue());
        b15.add(numMeasurementsPerLatent);
        b1.add(b15);
        b1.add(Box.createVerticalStrut(10));
        Box b16 = Box.createHorizontalBox();
        b16.add(new JLabel("Add impure edges:"));
        b16.add(Box.createHorizontalGlue());
        b1.add(b16);
        Box b17 = Box.createHorizontalBox();
        b17.add(new JLabel("Latent --> Measured"));
        b17.add(Box.createHorizontalGlue());
        b17.add(numLatentMeasuredImpureParents);
        b1.add(b17);
        Box b18 = Box.createHorizontalBox();
        b18.add(new JLabel("Measured --> Measured"));
        b18.add(Box.createHorizontalGlue());
        b18.add(numMeasuredMeasuredImpureParents);
        b1.add(b18);
        Box b19 = Box.createHorizontalBox();
        b19.add(new JLabel("Measured <-> Measured"));
        b19.add(Box.createHorizontalGlue());
        b19.add(numMeasuredMeasuredImpureAssociations);
        b1.add(b19);
        b1.add(Box.createVerticalGlue());
        this.add((Component)b1, "Center");
    }
}

