/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.LayoutUtil;
import edu.cmu.tetrad.regression.RegressionResult;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetrad.util.TextTable;
import edu.cmu.tetradapp.editor.RegressionParamsEditorPanel;
import edu.cmu.tetradapp.model.RegressionRunner;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class RegressionEditor
extends JPanel {
    private final GraphWorkbench workbench;
    private final JTextArea reportText;
    private final JComponent textWithTable = TextWithTable.emptyCompoenent();
    private final RegressionRunner runner;

    public RegressionEditor(RegressionRunner regressionRunner) {
        if (regressionRunner == null) {
            throw new NullPointerException("The regression runner is required.");
        }
        this.runner = regressionRunner;
        EdgeListGraph outGraph = new EdgeListGraph();
        JButton executeButton = new JButton("Execute");
        executeButton.addActionListener(e -> {
            this.runRegression();
            TetradLogger.getInstance().log("result", this.reportText.getText());
        });
        this.workbench = new GraphWorkbench(outGraph);
        JScrollPane workbenchScroll = new JScrollPane(this.workbench);
        workbenchScroll.setPreferredSize(new Dimension(400, 400));
        this.reportText = new JTextArea();
        this.reportText.setFont(new Font("Monospaced", 0, 12));
        this.reportText.setTabSize(10);
        if (this.runner.getResult() != null) {
            this.reportText.setText(this.runner.getResult().toString());
        }
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setPreferredSize(new Dimension(600, 400));
        tabbedPane.add("Model", new JScrollPane(this.reportText));
        tabbedPane.add("Output Graph", workbenchScroll);
        Box b = Box.createVerticalBox();
        Box b1 = Box.createHorizontalBox();
        RegressionParamsEditorPanel editorPanel = new RegressionParamsEditorPanel(this.runner, this.runner.getParams(), this.runner.getDataModel(), false);
        editorPanel.addPropertyChangeListener(evt -> {
            String propertyName = evt.getPropertyName();
            if ("significanceChanged".equals(propertyName)) {
                this.runRegression();
            }
        });
        b1.add(editorPanel);
        b1.add(tabbedPane);
        b.add(b1);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add(executeButton);
        b.add((Component)buttonPanel, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)b, "Center");
        int numModels = this.runner.getNumModels();
        if (numModels > 1) {
            JComboBox<Integer> comp = new JComboBox<Integer>();
            for (int i = 0; i < numModels; ++i) {
                comp.addItem(i + 1);
            }
            comp.addActionListener(e -> {
                Object selectedItem = comp.getSelectedItem();
                if (selectedItem instanceof Integer) {
                    this.runner.setModelIndex((Integer)selectedItem - 1);
                }
            });
            comp.setMaximumSize(comp.getPreferredSize());
            Box c = Box.createHorizontalBox();
            c.add(new JLabel("Using model"));
            c.add(comp);
            c.add(new JLabel("from "));
            c.add(new JLabel(this.runner.getModelSourceName()));
            c.add(Box.createHorizontalGlue());
            this.add((Component)c, "North");
        }
        this.setName("Regression Result:");
    }

    @Override
    public void setName(String name) {
        String oldName = this.getName();
        super.setName(name);
        this.firePropertyChange("name", oldName, this.getName());
    }

    private void runRegression() {
        this.runner.execute();
        Graph graph = this.runner.getOutGraph();
        LayoutUtil.circleLayout(graph, 200, 200, 150);
        LayoutUtil.fruchtermanReingoldLayout(graph);
        this.workbench.setGraph(graph);
        RegressionResult report = this.runner.getResult();
        this.reportText.setText(report.toString());
        this.textWithTable.removeAll();
        this.textWithTable.setLayout(new BorderLayout());
        this.textWithTable.add(TextWithTable.component(report.getPreamble(), report.getResultsTable()));
        this.textWithTable.revalidate();
        this.textWithTable.repaint();
    }

    private static class TextWithTable {
        private TextWithTable() {
        }

        public static JComponent emptyCompoenent() {
            JPanel jPanel = new JPanel();
            jPanel.setBackground(Color.WHITE);
            return jPanel;
        }

        public static JComponent component(String preamble, TextTable textTable) {
            TextWithTable textWithTable = new TextWithTable();
            JPanel panel = new JPanel();
            panel.setBackground(Color.WHITE);
            Box b = Box.createVerticalBox();
            Box b1 = Box.createHorizontalBox();
            b1.add(new JTextArea(preamble));
            b.add(b1);
            Box b2 = Box.createHorizontalBox();
            JScrollPane pane = new JScrollPane(textWithTable.getJTableFor(textTable));
            b2.add(pane);
            b.add(b2);
            panel.setLayout(new BorderLayout());
            panel.add((Component)b, "Center");
            return panel;
        }

        private JTable getJTableFor(final TextTable textTable) {
            AbstractTableModel model = new AbstractTableModel(){

                @Override
                public int getRowCount() {
                    return textTable.getNumRows();
                }

                @Override
                public int getColumnCount() {
                    return textTable.getNumColumns();
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    return textTable.getTokenAt(rowIndex, columnIndex);
                }

                @Override
                public String getColumnName(int column) {
                    return null;
                }
            };
            JTable table = new JTable(model);
            for (int j = 0; j < 6; ++j) {
                TableColumn column = table.getColumnModel().getColumn(j);
                column.setCellRenderer(new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        Component renderer = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                        this.setText((String)value);
                        this.setHorizontalAlignment(4);
                        return renderer;
                    }
                });
            }
            return table;
        }
    }
}

