/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.model.RegressionModel;
import edu.cmu.tetradapp.util.DoubleTextField;
import edu.cmu.tetradapp.workbench.LayoutUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;

class RegressionParamsEditorPanel
extends JPanel {
    private static final long serialVersionUID = -194301447990323529L;
    private final boolean logistic;
    private final RegressionModel regressionModel;
    private final Parameters params;
    private static JList PREDICTORS_LIST;
    private static JList SOURCE_LIST;
    private static JTextField RESPONSE_FIELD;
    private static final Map<String, Integer> VAR_MAP;
    private static final Font FONT;

    public RegressionParamsEditorPanel(RegressionModel regressionModel, Parameters parameters, DataModel model, boolean logistic) {
        this.setLayout(new BoxLayout(this, 1));
        if (parameters == null) {
            throw new NullPointerException("The given params must not be null");
        }
        this.params = parameters;
        this.logistic = logistic;
        List<String> variableNames = regressionModel.getVariableNames();
        this.regressionModel = regressionModel;
        PREDICTORS_LIST = RegressionParamsEditorPanel.createList();
        VariableListModel predictorsModel = (VariableListModel)RegressionParamsEditorPanel.getPredictorsList().getModel();
        SOURCE_LIST = RegressionParamsEditorPanel.createList();
        if (logistic && model instanceof DataSet) {
            this.buildMap((DataSet)model);
            RegressionParamsEditorPanel.getSourceList().setCellRenderer(new LogisticRegRenderer());
        }
        VariableListModel variableModel = (VariableListModel)RegressionParamsEditorPanel.getSourceList().getModel();
        RESPONSE_FIELD = this.createResponse(RegressionParamsEditorPanel.getSourceList());
        List<String> regressors = regressionModel.getRegressorNames();
        if (regressors != null) {
            predictorsModel.addAll(regressors);
            ArrayList<String> initVars = new ArrayList<String>(variableNames);
            initVars.removeAll(regressors);
            variableModel.addAll(initVars);
        } else {
            variableModel.addAll(variableNames);
        }
        String target = regressionModel.getTargetName();
        if (target != null) {
            variableModel.remove((Comparable)((Object)target));
        }
        new DropTarget(RegressionParamsEditorPanel.getSourceList(), 2, new TargetListener(), true);
        new DropTarget(RegressionParamsEditorPanel.getResponseField(), 2, new TargetListener(), true);
        new DropTarget(RegressionParamsEditorPanel.getPredictorsList(), 2, new TargetListener(), true);
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(RegressionParamsEditorPanel.getResponseField(), 2, new SourceListener());
        dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(RegressionParamsEditorPanel.getSourceList(), 2, new SourceListener());
        dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(RegressionParamsEditorPanel.getPredictorsList(), 2, new SourceListener());
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(10));
        Box label = RegressionParamsEditorPanel.createLabel("Variables:");
        int height = label.getPreferredSize().height + RegressionParamsEditorPanel.getResponseField().getPreferredSize().height + 10;
        Box vBox1 = Box.createVerticalBox();
        vBox1.add(label);
        JScrollPane pane = RegressionParamsEditorPanel.createScrollPane(RegressionParamsEditorPanel.getSourceList(), new Dimension(100, 350 + height));
        vBox1.add(pane);
        vBox1.add(Box.createVerticalStrut(10));
        vBox1.add(this.buildAlphaArea(this.params.getDouble("alpha", 0.001)));
        vBox1.add(Box.createVerticalStrut(10));
        vBox1.add(this.buildSortButton());
        vBox1.add(Box.createVerticalGlue());
        box.add(vBox1);
        box.add(Box.createHorizontalStrut(4));
        box.add(this.buildSelectorArea(label.getPreferredSize().height));
        box.add(Box.createHorizontalStrut(4));
        Box vBox = Box.createVerticalBox();
        vBox.add(RegressionParamsEditorPanel.createLabel("Response:"));
        vBox.add(RegressionParamsEditorPanel.getResponseField());
        vBox.add(Box.createVerticalStrut(10));
        vBox.add(RegressionParamsEditorPanel.createLabel("Predictor(s):"));
        vBox.add(RegressionParamsEditorPanel.createScrollPane(RegressionParamsEditorPanel.getPredictorsList(), new Dimension(100, 350)));
        vBox.add(Box.createVerticalGlue());
        box.add(vBox);
        box.add(Box.createHorizontalStrut(10));
        box.add(Box.createHorizontalGlue());
        this.add(Box.createVerticalStrut(20));
        this.add(box);
    }

    private static List<Comparable> getSelected(JList list) {
        List selected = list.getSelectedValuesList();
        ArrayList<Comparable> selectedList = new ArrayList<Comparable>(selected == null ? 0 : selected.size());
        if (selected != null) {
            for (Object o : selected) {
                selectedList.add((Comparable)o);
            }
        }
        return selectedList;
    }

    private Box buildSelectorArea(int startHeight) {
        Box box = Box.createVerticalBox();
        JButton moveToResponse = new JButton(">");
        JButton moveToPredictor = new JButton(">");
        JButton moveToSource = new JButton("<");
        moveToResponse.addActionListener(e -> {
            VariableListModel sourceModel = (VariableListModel)RegressionParamsEditorPanel.getSourceList().getModel();
            String target = RegressionParamsEditorPanel.getResponseField().getText();
            List<Comparable> selected = RegressionParamsEditorPanel.getSelected(RegressionParamsEditorPanel.getSourceList());
            if (selected.isEmpty()) {
                return;
            }
            if (1 < selected.size()) {
                JOptionPane.showMessageDialog(this, "Cannot have more than one response variable");
                return;
            }
            if (this.logistic && !this.isBinary((String)((Object)selected.get(0)))) {
                JOptionPane.showMessageDialog(this, "Response variable must be binary.");
                return;
            }
            sourceModel.removeAll(selected);
            RegressionParamsEditorPanel.getResponseField().setText((String)((Object)selected.get(0)));
            RegressionParamsEditorPanel.getResponseField().setCaretPosition(0);
            this.regressionModel.setTargetName((String)((Object)selected.get(0)));
            if (target != null && target.length() != 0) {
                sourceModel.add((Comparable)((Object)target));
            }
        });
        moveToPredictor.addActionListener(e -> {
            VariableListModel predictorsModel = (VariableListModel)RegressionParamsEditorPanel.getPredictorsList().getModel();
            VariableListModel sourceModel = (VariableListModel)RegressionParamsEditorPanel.getSourceList().getModel();
            List<Comparable> selected = RegressionParamsEditorPanel.getSelected(RegressionParamsEditorPanel.getSourceList());
            sourceModel.removeAll(selected);
            predictorsModel.addAll(selected);
            this.regressionModel.setRegressorName(this.getPredictors());
        });
        moveToSource.addActionListener(e -> {
            VariableListModel predictorsModel = (VariableListModel)RegressionParamsEditorPanel.getPredictorsList().getModel();
            VariableListModel sourceModel = (VariableListModel)RegressionParamsEditorPanel.getSourceList().getModel();
            List<Comparable> selected = RegressionParamsEditorPanel.getSelected(RegressionParamsEditorPanel.getPredictorsList());
            if (!selected.isEmpty()) {
                predictorsModel.removeAll(selected);
                sourceModel.addAll(selected);
                this.regressionModel.setRegressorName(this.getPredictors());
            } else if (RegressionParamsEditorPanel.getResponseField().getText() != null && RegressionParamsEditorPanel.getResponseField().getText().length() != 0) {
                String text = RegressionParamsEditorPanel.getResponseField().getText();
                this.regressionModel.setTargetName(null);
                RegressionParamsEditorPanel.getResponseField().setText(null);
                sourceModel.addAll(Collections.singletonList(text));
            }
        });
        box.add(Box.createVerticalStrut(startHeight));
        box.add(moveToResponse);
        box.add(Box.createVerticalStrut(150));
        box.add(moveToPredictor);
        box.add(Box.createVerticalStrut(10));
        box.add(moveToSource);
        box.add(Box.createVerticalGlue());
        return box;
    }

    private Box buildSortButton() {
        JButton sort = new JButton("Sort Variables");
        sort.setFont(sort.getFont().deriveFont(11.0f));
        sort.setMargin(new Insets(3, 3, 3, 3));
        sort.addActionListener(e -> {
            VariableListModel predictorsModel = (VariableListModel)RegressionParamsEditorPanel.getPredictorsList().getModel();
            VariableListModel sourceModel = (VariableListModel)RegressionParamsEditorPanel.getSourceList().getModel();
            predictorsModel.sort();
            sourceModel.sort();
        });
        Box box = Box.createHorizontalBox();
        box.add(sort);
        box.add(Box.createHorizontalGlue());
        return box;
    }

    private Box buildAlphaArea(double alpha) {
        DoubleTextField field = new DoubleTextField(alpha, 4, NumberFormatUtil.getInstance().getNumberFormat());
        field.setFilter((value, oldValue) -> {
            if (0.0 <= value && value <= 1.0) {
                this.params.set("alpha", (Object)value);
                this.firePropertyChange("significanceChanged", oldValue, value);
                return value;
            }
            return oldValue;
        });
        Box box = Box.createHorizontalBox();
        box.add(new JLabel("Alpha: "));
        box.add(field);
        box.add(Box.createHorizontalGlue());
        return box;
    }

    private void buildMap(DataSet model) {
        for (Node node : model.getVariables()) {
            if (DataUtils.isBinary(model, model.getColumn(node))) {
                RegressionParamsEditorPanel.getVarMap().put(node.getName(), 1);
                continue;
            }
            if (node instanceof DiscreteVariable) {
                RegressionParamsEditorPanel.getVarMap().put(node.getName(), 2);
                continue;
            }
            RegressionParamsEditorPanel.getVarMap().put(node.getName(), 3);
        }
    }

    private static JScrollPane createScrollPane(JList comp, Dimension dim) {
        JScrollPane pane = new JScrollPane(comp);
        LayoutUtils.setAllSizes(pane, dim);
        return pane;
    }

    private static Box createLabel(String text) {
        JLabel label = new JLabel(text);
        label.setAlignmentX(0.0f);
        Box box = Box.createHorizontalBox();
        box.add(label);
        box.add(Box.createHorizontalGlue());
        return box;
    }

    private JTextField createResponse(JList list) {
        JTextField pane = new JTextField();
        pane.setFont(RegressionParamsEditorPanel.getFONT());
        pane.setFocusable(true);
        pane.setEditable(false);
        pane.setBackground(list.getBackground());
        String target = this.regressionModel.getTargetName();
        if (target != null) {
            pane.setText(target);
        } else {
            pane.setText("Hello");
        }
        pane.setCaretPosition(0);
        LayoutUtils.setAllSizes(pane, new Dimension(100, pane.getPreferredSize().height));
        if (target == null) {
            pane.setText(null);
        }
        pane.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                RegressionParamsEditorPanel.getPredictorsList().clearSelection();
            }
        });
        return pane;
    }

    private static JList createList() {
        JList list = new JList(new VariableListModel());
        list.setFont(RegressionParamsEditorPanel.getFONT());
        list.setSelectionMode(2);
        list.setVisibleRowCount(10);
        return list;
    }

    private static DataFlavor getListDataFlavor() {
        try {
            return new DataFlavor("application/x-java-jvm-local-objectref; class=java.lang.Object", "Local Variable List");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<String> getPredictors() {
        ListModel model = RegressionParamsEditorPanel.getPredictorsList().getModel();
        ArrayList<String> predictors = new ArrayList<String>();
        for (int i = 0; i < model.getSize(); ++i) {
            predictors.add((String)model.getElementAt(i));
        }
        return predictors;
    }

    private void addToSource(String var) {
        VariableListModel model = (VariableListModel)RegressionParamsEditorPanel.getSourceList().getModel();
        model.add((Comparable)((Object)var));
    }

    private boolean isBinary(String node) {
        int i = RegressionParamsEditorPanel.getVarMap().get(node);
        return i == 1;
    }

    private static Map<String, Integer> getVarMap() {
        return VAR_MAP;
    }

    private static JList getPredictorsList() {
        return PREDICTORS_LIST;
    }

    private static JList getSourceList() {
        return SOURCE_LIST;
    }

    private static JTextField getResponseField() {
        return RESPONSE_FIELD;
    }

    private static Font getFONT() {
        return FONT;
    }

    public Parameters getParams() {
        return this.params;
    }

    static /* synthetic */ DataFlavor access$1300() {
        return RegressionParamsEditorPanel.getListDataFlavor();
    }

    static {
        VAR_MAP = new HashMap<String, Integer>();
        FONT = new Font("Dialog", 0, 12);
    }

    private static class VariableListModel
    extends AbstractListModel {
        private final Vector<Comparable> delegate = new Vector();

        private VariableListModel() {
        }

        @Override
        public int getSize() {
            return this.delegate.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.delegate.get(index);
        }

        public void remove(Comparable element) {
            int index = this.delegate.indexOf(element);
            if (0 <= index) {
                this.delegate.remove(index);
                this.fireIntervalRemoved(this, index, index);
            }
        }

        public void add(Comparable element) {
            this.delegate.add(element);
            this.fireIntervalAdded(this, this.delegate.size(), this.delegate.size());
        }

        public void removeFirst(Comparable element) {
            this.delegate.removeElement(element);
            this.fireContentsChanged(this, 0, this.delegate.size());
        }

        public void removeAll(List<? extends Comparable> elements) {
            this.delegate.removeAll(elements);
            this.fireContentsChanged(this, 0, this.delegate.size());
        }

        public void addAll(List<? extends Comparable> elements) {
            this.delegate.addAll(elements);
            this.fireContentsChanged(this, 0, this.delegate.size());
        }

        public void removeAll() {
            this.delegate.clear();
            this.fireContentsChanged(this, 0, 0);
        }

        public void sort() {
            Collections.sort(this.delegate);
            this.fireContentsChanged(this, 0, this.delegate.size());
        }
    }

    private static class LogisticRegRenderer
    extends DefaultListCellRenderer {
        private LogisticRegRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String var = (String)value;
            if (var == null) {
                this.setText(" ");
                return this;
            }
            int binary = (Integer)RegressionParamsEditorPanel.getVarMap().get(var);
            if (binary == 1) {
                var = var + " (Binary)";
            } else if (binary == 2) {
                var = var + " (Discrete)";
            } else if (binary == 3) {
                var = var + " (Continuous)";
            }
            this.setText(var);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }

    private class TargetListener
    extends DropTargetAdapter {
        private TargetListener() {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            Transferable t = dtde.getTransferable();
            Component comp = dtde.getDropTargetContext().getComponent();
            if (comp instanceof JList || comp instanceof JTextField) {
                try {
                    if (comp == RegressionParamsEditorPanel.getResponseField()) {
                        List vars;
                        String var = RegressionParamsEditorPanel.getResponseField().getText();
                        if (var != null && var.length() != 0) {
                            RegressionParamsEditorPanel.this.addToSource(var);
                        }
                        if ((vars = (List)t.getTransferData(ListTransferable.FLAVOR)).isEmpty()) {
                            dtde.rejectDrop();
                            return;
                        }
                        if (1 < vars.size()) {
                            JOptionPane.showMessageDialog(RegressionParamsEditorPanel.this, "There can only be one response variable.");
                            dtde.rejectDrop();
                            return;
                        }
                        if (RegressionParamsEditorPanel.this.logistic && !RegressionParamsEditorPanel.this.isBinary((String)vars.get(0))) {
                            JOptionPane.showMessageDialog(RegressionParamsEditorPanel.this, "The response variable must be binary");
                            dtde.rejectDrop();
                            return;
                        }
                        RegressionParamsEditorPanel.getResponseField().setText((String)vars.get(0));
                        RegressionParamsEditorPanel.getResponseField().setCaretPosition(0);
                    } else {
                        JList list = (JList)comp;
                        VariableListModel model = (VariableListModel)list.getModel();
                        List vars = (List)t.getTransferData(ListTransferable.FLAVOR);
                        model.addAll(vars);
                    }
                    RegressionParamsEditorPanel.this.regressionModel.setTargetName(RegressionParamsEditorPanel.getResponseField().getText());
                    RegressionParamsEditorPanel.this.regressionModel.setRegressorName(RegressionParamsEditorPanel.this.getPredictors());
                    dtde.getDropTargetContext().dropComplete(true);
                }
                catch (Exception ex) {
                    dtde.rejectDrop();
                    ex.printStackTrace();
                }
            } else {
                dtde.rejectDrop();
            }
        }
    }

    private class SourceListener
    extends DragSourceAdapter
    implements DragGestureListener {
        private SourceListener() {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent evt) {
            if (evt.getDropSuccess()) {
                Component comp = evt.getDragSourceContext().getComponent();
                Transferable t = evt.getDragSourceContext().getTransferable();
                if (t instanceof ListTransferable) {
                    try {
                        List o = (List)t.getTransferData(ListTransferable.FLAVOR);
                        if (comp instanceof JList) {
                            JList list = (JList)comp;
                            VariableListModel model = (VariableListModel)list.getModel();
                            for (Comparable c : o) {
                                model.removeFirst(c);
                            }
                        } else {
                            JTextField pane = (JTextField)comp;
                            pane.setText(null);
                        }
                        RegressionParamsEditorPanel.this.regressionModel.setTargetName(RegressionParamsEditorPanel.getResponseField().getText());
                        RegressionParamsEditorPanel.this.regressionModel.setRegressorName(RegressionParamsEditorPanel.this.getPredictors());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            Component comp = dge.getComponent();
            List<Object> selected = null;
            if (comp instanceof JList) {
                JList list = (JList)comp;
                selected = list.getSelectedValuesList();
            } else {
                JTextField pane = (JTextField)comp;
                String text = pane.getText();
                if (text != null && text.length() != 0) {
                    selected = Collections.singletonList(text);
                }
            }
            if (selected != null) {
                ListTransferable t = new ListTransferable(Collections.singletonList(selected));
                dge.startDrag(DragSource.DefaultMoveDrop, t, this);
            }
        }
    }

    private static class ListTransferable
    implements Transferable {
        private static final DataFlavor FLAVOR = RegressionParamsEditorPanel.access$1300();
        private final List object;

        public ListTransferable(List object) {
            if (object == null) {
                throw new NullPointerException();
            }
            this.object = object;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{FLAVOR};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor == FLAVOR;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (FLAVOR != flavor) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.object;
        }
    }
}

