/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.util.NumberFormatUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import javax.swing.JPanel;

class RocPlot
extends JPanel
implements PropertyChangeListener {
    private Dimension size;
    private final Color backgroundColor = Color.WHITE;
    private final Color boundaryColor = Color.DARK_GRAY;
    private final Color titleColor = Color.DARK_GRAY;
    private final Color plotColor = Color.BLUE;
    private Rectangle plotRect;
    private Insets graphInsets = new Insets(25, 25, 25, 25);
    private String title = "ROC Plot";
    private final Font fontBold = new Font("Serif", 1, 12);
    private final Font titleFont = new Font("Serif", 1, 18);
    private final FontMetrics titleFm;
    private final FontMetrics fm;
    private final double[][] points;
    private final String info;

    public RocPlot(double[][] points, String title, String info) {
        this.points = points;
        this.info = info;
        Font font = new Font("Serif", 0, 12);
        this.fm = this.getFontMetrics(font);
        this.titleFm = this.getFontMetrics(this.titleFont);
        this.setFont(font);
        if (title != null) {
            this.title = title;
        }
    }

    private void calcPlotRect(Dimension size) {
        int left = this.graphInsets.left;
        int top = this.graphInsets.top;
        int width = size.width - this.graphInsets.left - this.graphInsets.right;
        int height = size.height - this.graphInsets.top - this.graphInsets.bottom;
        this.plotRect = new Rectangle(left, top, width, height);
    }

    private void drawBoundary(Graphics g) {
        Rectangle r = this.getPlotRect();
        g.setColor(this.boundaryColor);
        g.drawRect(r.x, r.y, r.width, r.height);
    }

    private void drawXTickMarks(Graphics g) {
        Rectangle plotRect = this.getPlotRect();
        int yPos = plotRect.y + plotRect.height;
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        for (double d = 0.0; d <= 1.0; d += 0.1) {
            int xPos = this.getXPos(d);
            g.setColor(this.boundaryColor);
            g.drawLine(xPos, yPos, xPos, yPos - 10);
            g.drawString(nf.format(d), xPos - 3, yPos + 12);
        }
    }

    private void drawYTickMarks(Graphics g) {
        Rectangle plotRect = this.getPlotRect();
        int xPos = plotRect.x;
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumFractionDigits(1);
        nf.setMaximumFractionDigits(1);
        for (double d = 0.0; d <= 1.0; d += 0.1) {
            int yPos = this.getYPos(d);
            g.setColor(this.boundaryColor);
            g.drawLine(xPos, yPos, xPos + 10, yPos);
            String str = nf.format(d);
            int strWid = this.fm.stringWidth(str);
            int strHgt = this.fm.getAscent();
            g.drawString(str, xPos - strWid - 5, yPos + strHgt / 2);
        }
    }

    private void drawTitle(Graphics g) {
        int stringWidth = this.titleFm.stringWidth(this.title);
        int stringHeight = this.titleFm.getHeight();
        g.setFont(this.titleFont);
        g.setColor(this.titleColor);
        g.drawString(this.title, this.plotRect.x + this.plotRect.width / 2 - stringWidth / 2, stringHeight);
    }

    private Rectangle getPlotRect() {
        return this.plotRect;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(600, 600);
    }

    private int getXPos(double x) {
        Rectangle r = this.getPlotRect();
        double range = 1.0;
        return r.x + (int)(x / 1.0 * (double)this.plotRect.width);
    }

    private int getYPos(double y) {
        Rectangle r = this.getPlotRect();
        return r.y + r.height - (int)(y * (double)r.height);
    }

    @Override
    public void paint(Graphics g) {
        Dimension size = this.getSize();
        if (this.size == null || !this.size.equals(size)) {
            this.size = size;
            this.calcGraphInsets();
            this.calcPlotRect(size);
        }
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.drawBoundary(g);
        this.drawXTickMarks(g);
        this.drawYTickMarks(g);
        this.drawTitle(g);
        this.drawXLabel(g);
        this.drawYLabel(g);
        g.setColor(this.plotColor);
        for (double[] point : this.points) {
            int x = this.getXPos(point[0]);
            int y = this.getYPos(point[1]);
            g.drawLine(x - 2, y + 2, x + 2, y - 2);
            g.drawLine(x - 2, y - 2, x + 2, y + 2);
        }
        g.setColor(this.boundaryColor);
        g.drawString(this.info, this.getXPos(0.6), this.getYPos(0.2));
    }

    private void drawXLabel(Graphics g) {
        g.setFont(this.fontBold);
        Rectangle plotRect = this.getPlotRect();
        String xLabel = "False Positive Fraction";
        int stringWidth = this.fm.stringWidth("False Positive Fraction");
        Point translate = new Point(plotRect.x + plotRect.width / 2 - stringWidth / 2, this.getSize().height - 8);
        g.setColor(this.boundaryColor);
        g.drawString("False Positive Fraction", translate.x, translate.y);
    }

    private void drawYLabel(Graphics g) {
        g.setFont(this.fontBold);
        double theta = -1.5707963267948966;
        Rectangle plotRect = this.getPlotRect();
        String yLabel = "True Positive Fraction";
        int stringWidth = this.fm.stringWidth("True Positive Fraction");
        Point translate = new Point(this.fm.getAscent(), plotRect.y + (plotRect.height / 2 + stringWidth / 2));
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform save = g2.getTransform();
        g2.translate(translate.x, translate.y);
        g2.rotate(-1.5707963267948966);
        g2.setColor(this.boundaryColor);
        g2.drawString("True Positive Fraction", 0, 0);
        g2.setTransform(save);
    }

    private void calcGraphInsets() {
        int top = this.titleFm.getHeight() + this.titleFm.getDescent() + 10;
        int left = (int)(2.5 * (double)this.fm.getHeight());
        int bottom = 2 * this.fm.getHeight();
        int right = (int)(2.5 * (double)this.fm.getHeight());
        this.graphInsets = new Insets(top, left, bottom, right);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.repaint();
    }
}

