/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetradapp.model.EditorUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JComponent;

public class SaveComponentImage
extends AbstractAction {
    private final JComponent comp;
    private final String actionName;

    public SaveComponentImage(JComponent comp, String actionName) {
        super(actionName);
        this.actionName = actionName;
        if (comp == null) {
            throw new NullPointerException("Component must not be null.");
        }
        this.comp = comp;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File file = EditorUtils.getSaveFile("image", "png", this.getComp(), false, this.actionName);
        Dimension size = this.getComp().getSize();
        BufferedImage image = new BufferedImage(size.width, size.height, 3);
        Graphics graphics = image.getGraphics();
        this.getComp().paint(graphics);
        try {
            ImageIO.write((RenderedImage)image, "png", file);
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
    }

    private Component getComp() {
        return this.comp;
    }
}

