/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataWriter;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.editor.DataEditor;
import edu.cmu.tetradapp.editor.MarkovBlanketSearchEditor;
import edu.cmu.tetradapp.model.EditorUtils;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.NumberFormat;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

final class SaveDataAction
extends AbstractAction {
    private DataEditor dataEditor;
    private MarkovBlanketSearchEditor searchEditor;
    private final NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();

    public SaveDataAction(DataEditor editor) {
        super("Save Data...");
        if (editor == null) {
            throw new NullPointerException("Data Editor must not be null.");
        }
        this.setDataEditor(editor);
    }

    public SaveDataAction(MarkovBlanketSearchEditor editor) {
        super("Save Data...");
        if (editor == null) {
            throw new NullPointerException("Editor must not be null");
        }
        this.searchEditor = editor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.saveData();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Error in saving: " + e1.getMessage());
        }
    }

    private void saveData() throws IOException {
        String name;
        DataModel dataModel = this.dataEditor != null ? this.getDataEditor().getDataModelList() : this.searchEditor.getDataModel();
        if (dataModel == null) {
            return;
        }
        if (dataModel instanceof DataModelList && ((DataModelList)dataModel).size() == 1) {
            dataModel = ((DataModelList)dataModel).get(0);
        }
        if ((name = dataModel.getName()) == null) {
            name = "data";
        }
        if (dataModel instanceof DataSet) {
            PrintWriter out;
            File file = EditorUtils.getSaveFile(name.replace(" ", "_"), "txt", this.getDataEditor(), false, "Save Data...");
            if (file == null) {
                return;
            }
            char delimiter = '\t';
            if (file.getName().endsWith(".csv")) {
                delimiter = ',';
            }
            try {
                out = new PrintWriter(new FileOutputStream(file));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Output file could not be opened: " + file);
            }
            DataSet dataSet = (DataSet)dataModel;
            if (dataSet.isContinuous()) {
                DataWriter.writeRectangularData(dataSet, out, delimiter);
            } else if (dataSet.isDiscrete()) {
                DataWriter.writeRectangularData(dataSet, out, delimiter);
            } else {
                DataWriter.writeRectangularData(dataSet, out, delimiter);
            }
            out.close();
        } else if (dataModel instanceof ICovarianceMatrix) {
            PrintWriter out;
            File file = EditorUtils.getSaveFile(name.replace(" ", "_"), "txt", this.getDataEditor(), false, "Save Data...");
            if (file == null) {
                return;
            }
            try {
                out = new PrintWriter(new FileOutputStream(file));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Output file could not be opened: " + file);
            }
            DataWriter.writeCovMatrix((ICovarianceMatrix)dataModel, out, this.nf);
            out.close();
        } else if (dataModel instanceof DataModelList) {
            File file = EditorUtils.getSaveFile(name.replace(" ", "_"), "txt", this.getDataEditor(), false, "Save Data...");
            int delimiter = 9;
            DataModelList list = (DataModelList)dataModel;
            for (int i = 0; i < list.size(); ++i) {
                PrintWriter out;
                File file1;
                DataModel _dataModel = list.get(i);
                if (_dataModel == null) {
                    throw new NullPointerException("Null data model.");
                }
                if (_dataModel instanceof DataSet) {
                    try {
                        file1 = new File(file.getParent(), file.getName() + "_" + (i + 1) + ".txt");
                        System.out.println(file1);
                        out = new PrintWriter(new FileOutputStream(file1));
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException("Output file could not be opened: " + name.replace(" ", "_") + ".txt");
                    }
                    DataSet dataSet = (DataSet)((DataModelList)dataModel).get(i);
                    if (dataSet.isContinuous()) {
                        DataWriter.writeRectangularData(dataSet, out, '\t');
                    } else if (dataSet.isDiscrete()) {
                        DataWriter.writeRectangularData(dataSet, out, '\t');
                    } else {
                        DataWriter.writeRectangularData(dataSet, out, '\t');
                    }
                    out.close();
                    continue;
                }
                if (!(_dataModel instanceof ICovarianceMatrix)) continue;
                try {
                    file1 = new File(file.getParent(), file.getName() + "_" + (i + 1) + ".txt");
                    System.out.println(file1);
                    out = new PrintWriter(new FileOutputStream(file1));
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Output file could not be opened: " + name.replace(" ", "_") + ".txt");
                }
                DataWriter.writeCovMatrix((ICovarianceMatrix)_dataModel, out, this.nf);
            }
        } else {
            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Sorry, don't know how to save that.");
        }
    }

    private DataEditor getDataEditor() {
        return this.dataEditor;
    }

    private void setDataEditor(DataEditor dataEditor) {
        this.dataEditor = dataEditor;
    }
}

