/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphPersistence;
import edu.cmu.tetradapp.editor.GraphEditable;
import edu.cmu.tetradapp.model.EditorUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class SaveGraph
extends AbstractAction {
    private final GraphEditable graphEditable;
    private String title;
    private final Type type;

    public SaveGraph(GraphEditable graphEditable, String title, Type type) {
        super(title);
        this.title = title;
        this.type = type;
        if (this.title == null) {
            this.title = "Save";
        }
        if (graphEditable == null) {
            throw new NullPointerException("Component must not be null.");
        }
        this.graphEditable = graphEditable;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Graph graph = this.getGraphEditable().getGraph();
        Component parent = (Component)((Object)this.getGraphEditable());
        if (this.type == Type.xml) {
            File file = EditorUtils.getSaveFile("graph", "xml", parent, false, this.title);
            PrintWriter out = GraphPersistence.saveGraph(graph, file, true);
            Preferences.userRoot().put("fileSaveLocation", file.getParent());
            out.close();
        } else if (this.type == Type.text) {
            File file = EditorUtils.getSaveFile("graph", "txt", parent, false, this.title);
            PrintWriter out = GraphPersistence.saveGraph(graph, file, false);
            Preferences.userRoot().put("fileSaveLocation", file.getParent());
            out.close();
        } else if (this.type == Type.r) {
            File file = EditorUtils.getSaveFile("graph", "r.txt", parent, false, this.title);
            try {
                String text = GraphPersistence.graphRMatrixTxt(graph);
                PrintWriter out = new PrintWriter(file);
                out.println(text);
                Preferences.userRoot().put("fileSaveLocation", file.getParent());
                out.close();
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
                throw new RuntimeException("Not a directed graph.", e1);
            }
            catch (IllegalArgumentException e1) {
                JOptionPane.showMessageDialog(this.getGraphEditable().getWorkbench(), e1.getMessage());
            }
        } else if (this.type == Type.json) {
            File file = EditorUtils.getSaveFile("graph", "json", parent, false, this.title);
            try {
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                String text = gson.toJson(graph);
                PrintWriter out = new PrintWriter(file);
                out.println(text);
                Preferences.userRoot().put("fileSaveLocation", file.getParent());
                out.close();
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
                throw new RuntimeException("Not a directed graph.", e1);
            }
            catch (IllegalArgumentException e1) {
                JOptionPane.showMessageDialog(this.getGraphEditable().getWorkbench(), e1.getMessage());
            }
        } else if (this.type == Type.dot) {
            File file = EditorUtils.getSaveFile("graph", "dot", parent, false, this.title);
            try {
                String text = GraphPersistence.graphToDot(graph);
                PrintWriter out = new PrintWriter(file);
                out.println(text);
                Preferences.userRoot().put("fileSaveLocation", file.getParent());
                out.close();
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
                throw new RuntimeException("Not a directed graph.", e1);
            }
            catch (IllegalArgumentException e1) {
                JOptionPane.showMessageDialog(this.getGraphEditable().getWorkbench(), e1.getMessage());
            }
        } else if (this.type == Type.pcalg) {
            File file = EditorUtils.getSaveFile("graph", "pcalg.csv", parent, false, this.title);
            try {
                String text = GraphPersistence.graphToPcalg(graph);
                PrintWriter out = new PrintWriter(file);
                out.println(text);
                Preferences.userRoot().put("fileSaveLocation", file.getParent());
                out.close();
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
                throw new RuntimeException("Not a directed graph.", e1);
            }
            catch (IllegalArgumentException e1) {
                JOptionPane.showMessageDialog(this.getGraphEditable().getWorkbench(), e1.getMessage());
            }
        }
    }

    private GraphEditable getGraphEditable() {
        return this.graphEditable;
    }

    public static enum Type {
        text,
        xml,
        json,
        r,
        dot,
        pcalg;

    }
}

