/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.regression.RegressionDataset;
import edu.cmu.tetrad.regression.RegressionResult;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.editor.ScatterPlotOld;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Ellipse2D;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JPanel;
import org.apache.commons.math3.util.FastMath;

class ScatterPlotDisplayPanel
extends JPanel {
    private static final Color LINE_COLOR = Color.GRAY.darker();
    private int PADDINGLEFT = 75;
    private int PADDINGOTHER = 50;
    private int HEIGHT = 600 + this.PADDINGOTHER;
    private int WIDTH = 600 + this.PADDINGLEFT;
    private int SPACE = 2;
    private final Dimension size = new Dimension(this.WIDTH + 2 * this.SPACE, this.HEIGHT);
    private final NumberFormat format = NumberFormatUtil.getInstance().getNumberFormat();
    private ScatterPlotOld scatterPlot;
    private final Map<Rectangle, Integer> rectMap = new ConcurrentHashMap<Rectangle, Integer>();

    public ScatterPlotDisplayPanel(ScatterPlotOld scatterPlot) {
        this.scatterPlot = scatterPlot;
        if (scatterPlot == null) {
            throw new NullPointerException("Given scatter plot must be null");
        }
        this.addMouseMotionListener(new MouseMovementListener());
        this.setToolTipText(" ");
    }

    public synchronized void updateScatterPlot(ScatterPlotOld scatterPlot) {
        if (scatterPlot == null) {
            throw new NullPointerException("The given scatter plot must not be null");
        }
        this.scatterPlot = scatterPlot;
        this.repaint();
    }

    @Override
    public String getToolTipText(MouseEvent evt) {
        return null;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Object originLeft;
        double least = this.scatterPlot.getMinSample();
        double greatest = this.scatterPlot.getMaxSample();
        String minStr = this.format.format(least);
        String maxStr = this.format.format(greatest);
        Graphics2D g2d = (Graphics2D)graphics;
        FontMetrics fontMetrics = g2d.getFontMetrics();
        int widthMinStr = fontMetrics.stringWidth(minStr);
        int widthMaxStr = fontMetrics.stringWidth(maxStr);
        this.PADDINGLEFT = FastMath.max(widthMinStr, widthMaxStr);
        this.PADDINGOTHER = 50;
        this.HEIGHT = 600 + this.PADDINGOTHER;
        this.WIDTH = 600 + this.PADDINGLEFT;
        this.SPACE = 2;
        int DASH = 10;
        this.setSize(new Dimension(this.WIDTH + 2 * this.SPACE, this.HEIGHT));
        this.rectMap.clear();
        int height = this.HEIGHT - this.PADDINGOTHER;
        g2d.setColor(this.getBackground());
        g2d.fillRect(0, 0, this.WIDTH + 2 * this.SPACE, this.HEIGHT);
        g2d.setColor(Color.WHITE);
        g2d.fillRect(this.PADDINGLEFT, 0, this.WIDTH + this.SPACE - this.PADDINGLEFT, height);
        g2d.setColor(LINE_COLOR);
        g2d.drawRect(this.PADDINGLEFT, 0, this.WIDTH + this.SPACE - this.PADDINGLEFT, height - 2 * this.SPACE);
        g2d.setColor(LINE_COLOR);
        g2d.drawString(minStr, this.PADDINGLEFT + 5, height + 15);
        g2d.drawLine(this.PADDINGLEFT, height + DASH, this.PADDINGOTHER, height);
        g2d.drawString(maxStr, this.WIDTH - widthMaxStr, height + 15);
        g2d.drawLine(this.WIDTH + this.SPACE, height + DASH, this.WIDTH + this.SPACE, height);
        g2d.setColor(LINE_COLOR);
        boolean topY = false;
        g2d.drawString(maxStr, this.PADDINGLEFT - fontMetrics.stringWidth(maxStr), 10);
        g2d.drawLine(this.PADDINGLEFT - DASH, 0, this.PADDINGOTHER, 0);
        g2d.drawString(minStr, this.PADDINGLEFT - fontMetrics.stringWidth(minStr), height - 2);
        g2d.drawLine(this.PADDINGLEFT - DASH, height, this.PADDINGOTHER, height);
        if (this.scatterPlot.getMinSample() < 0.0 && this.scatterPlot.getMaxSample() > 0.0) {
            originLeft = this.plotPoint(least, 0.0, least, greatest);
            double[] originRight = this.plotPoint(greatest, 0.0, least, greatest);
            double[] originTop = this.plotPoint(0.0, least, least, greatest);
            double[] originBottom = this.plotPoint(0.0, greatest, least, greatest);
            g2d.drawLine((int)originLeft[0] + 2, (int)originLeft[1] + 2, (int)originRight[0] + 2, (int)originRight[1] + 2);
            g2d.drawLine((int)originTop[0] + 2, (int)originTop[1] + 2, (int)originBottom[0] + 2, (int)originBottom[1] + 2);
        }
        g2d.setColor(new Color(255, 0, 0));
        originLeft = this.scatterPlot.getIndexSet().iterator();
        while (originLeft.hasNext()) {
            Object o = originLeft.next();
            int i = (Integer)o;
            double x = this.scatterPlot.getxData()[i];
            double y = this.scatterPlot.getyData()[i];
            double[] result = this.plotPoint(x, y, least, greatest);
            g2d.fill(new Ellipse2D.Double(result[0], result[1], 4.0, 4.0));
        }
        if (this.scatterPlot.isDrawRegLine()) {
            RegressionDataset regData;
            Parameters params = new Parameters();
            params.set("targetName", this.scatterPlot.getYVariable().getName());
            if (this.scatterPlot.getIndexSet().size() != this.scatterPlot.getDataSet().getNumRows()) {
                DataSet newDataSet = this.scatterPlot.getDataSet().copy();
                int[] throwAway = new int[this.scatterPlot.getComplementIndexSet().size()];
                for (int j = 0; j < throwAway.length; ++j) {
                    throwAway[j] = (Integer)this.scatterPlot.getComplementIndexSet().get(j);
                }
                newDataSet.removeRows(throwAway);
                regData = new RegressionDataset(newDataSet);
            } else {
                regData = new RegressionDataset(this.scatterPlot.getDataSet());
            }
            RegressionResult regResult = regData.regress((Node)this.scatterPlot.getYVariable(), this.scatterPlot.getXVariable());
            double[] coef = regResult.getCoef();
            double[] regLeft = this.plotPoint(least, coef[0] + coef[1] * least, least, greatest);
            double[] regRight = this.plotPoint(greatest, coef[0] + coef[1] * greatest, least, greatest);
            g2d.setColor(LINE_COLOR);
            g2d.drawLine((int)regLeft[0] + 2, (int)regLeft[1] + 2, (int)regRight[0] + 2, (int)regRight[1] + 2);
        }
        g2d.setColor(LINE_COLOR);
    }

    private double[] plotPoint(double x, double y, double minRange, double maxRange) {
        double[] result = new double[2];
        double range = maxRange - minRange;
        result[0] = (double)(this.WIDTH - this.PADDINGLEFT) * ((x - minRange) / range) + 4.0 + (double)this.PADDINGLEFT;
        result[1] = (double)this.HEIGHT - (double)(this.HEIGHT - this.PADDINGOTHER) * ((y - minRange) / range) - 8.0 - (double)this.PADDINGOTHER;
        return result;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.size;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.size;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.size;
    }

    private class MouseMovementListener
    implements MouseMotionListener {
        private MouseMovementListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Rectangle rect;
            Point point = e.getPoint();
            Iterator iterator = ScatterPlotDisplayPanel.this.rectMap.keySet().iterator();
            while (iterator.hasNext() && !(rect = (Rectangle)iterator.next()).contains(point)) {
            }
        }
    }
}

