/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetradapp.editor.AddVariableListener;
import edu.cmu.tetradapp.editor.ScatterListener;
import edu.cmu.tetradapp.editor.ScatterPlotOld;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

class ScatterPlotEditorPanel
extends JPanel {
    private final JComboBox yVariableBox;
    private final JComboBox xVariableBox;
    public final JComboBox newCondBox;
    public final DataSet dataSet;
    private ScatterPlotOld scatterPlot;
    Vector boxes;
    private final JCheckBox regressionBox = new JCheckBox();
    Vector granularity;
    Vector slideLabels;
    Vector scrollers;
    Vector condVariables;

    public ScatterPlotEditorPanel(ScatterPlotOld scatterPlot, DataSet dataSet) {
        this.setLayout(new BorderLayout());
        this.scatterPlot = scatterPlot;
        ContinuousVariable selected = scatterPlot.getYVariable();
        this.dataSet = dataSet;
        this.yVariableBox = new JComboBox();
        this.xVariableBox = new JComboBox();
        VariableBoxRenderer renderer = new VariableBoxRenderer();
        this.yVariableBox.setRenderer(renderer);
        for (Node node : dataSet.getVariables()) {
            if (!(node instanceof ContinuousVariable)) continue;
            this.yVariableBox.addItem(node);
            if (node != selected) continue;
            this.yVariableBox.setSelectedItem(node);
        }
        this.xVariableBox.setRenderer(renderer);
        for (Node node : dataSet.getVariables()) {
            if (!(node instanceof ContinuousVariable)) continue;
            this.xVariableBox.addItem(node);
            if (node != selected) continue;
            this.xVariableBox.setSelectedItem(node);
        }
        this.newCondBox = new JComboBox();
        this.newCondBox.setRenderer(renderer);
        for (Node node : dataSet.getVariables()) {
            if (!(node instanceof ContinuousVariable)) continue;
            this.newCondBox.addItem(node);
            if (node != selected) continue;
            this.newCondBox.setSelectedItem(node);
        }
        this.add(this.buildEditArea(dataSet));
    }

    private void changeScatterPlot(ScatterPlotOld scatterPlot) {
        this.scatterPlot = scatterPlot;
        this.firePropertyChange("histogramChange", null, scatterPlot);
    }

    public static void setPreferredAsMax(JComponent component) {
        component.setMaximumSize(component.getPreferredSize());
    }

    private Box buildEditArea(DataSet dataset) {
        ScatterPlotEditorPanel.setPreferredAsMax(this.yVariableBox);
        ScatterPlotEditorPanel.setPreferredAsMax(this.xVariableBox);
        ScatterPlotEditorPanel.setPreferredAsMax(this.newCondBox);
        Box main2 = Box.createVerticalBox();
        Box main = Box.createVerticalBox();
        Box hBox2 = Box.createHorizontalBox();
        hBox2.add(Box.createHorizontalStrut(10));
        hBox2.add(new JLabel("Select Variable for X-Axis: "));
        hBox2.add(Box.createHorizontalStrut(10));
        hBox2.add(this.xVariableBox);
        hBox2.add(Box.createHorizontalGlue());
        main.add(hBox2);
        Box hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalStrut(10));
        hBox.add(new JLabel("Select Variable for Y-Axis: "));
        hBox.add(Box.createHorizontalStrut(10));
        hBox.add(this.yVariableBox);
        hBox.add(Box.createHorizontalGlue());
        main.add(hBox);
        this.xVariableBox.addActionListener(new ScatterListener(this));
        this.yVariableBox.addActionListener(new ScatterListener(this));
        Box hBox6 = Box.createHorizontalBox();
        hBox6.add(Box.createHorizontalStrut(10));
        hBox6.add(new JLabel("Display Regression Line: "));
        hBox6.add(Box.createHorizontalStrut(10));
        hBox6.add(this.regressionBox);
        hBox6.add(Box.createHorizontalGlue());
        main.add(hBox6);
        this.regressionBox.addActionListener(new ScatterListener(this));
        JButton newCond = new JButton("Add New Conditional Variable");
        Box hBox3 = Box.createHorizontalBox();
        hBox3.add(Box.createHorizontalStrut(10));
        this.newCondBox.setPreferredSize(new Dimension(50, 20));
        hBox3.add(this.newCondBox);
        hBox3.add(Box.createHorizontalStrut(10));
        hBox3.add(newCond);
        main.add(hBox3);
        newCond.addActionListener(new AddVariableListener(main, this));
        this.boxes = new Vector();
        this.granularity = new Vector();
        this.slideLabels = new Vector();
        this.scrollers = new Vector();
        this.condVariables = new Vector();
        main2.add(main);
        main2.add(Box.createVerticalGlue());
        return main2;
    }

    public void redrawScatterPlot() {
        ScatterPlotOld newPlot = new ScatterPlotOld(this.scatterPlot.getDataSet(), (ContinuousVariable)this.yVariableBox.getSelectedItem(), (ContinuousVariable)this.xVariableBox.getSelectedItem());
        if (this.regressionBox.isSelected()) {
            newPlot.setDrawRegLine(true);
        }
        for (int i = 0; i < this.scrollers.size(); ++i) {
            double high;
            boolean breakNow = false;
            double low = ((JScrollBar)this.scrollers.get(i)).getValue();
            if (low > (high = (double)(((JScrollBar)this.scrollers.get(i)).getValue() + ((JScrollBar)this.scrollers.get(i)).getVisibleAmount()))) {
                breakNow = true;
            }
            ContinuousVariable currentNode = (ContinuousVariable)this.condVariables.get(i);
            int variableIndex = newPlot.getDataSet().getColumn(currentNode);
            Vector<Integer> newIndexSet = new Vector<Integer>();
            Vector<Integer> newComplementSet = new Vector<Integer>();
            for (int j = 0; j < newPlot.getIndexSet().size(); ++j) {
                int currentIndex = (Integer)newPlot.getIndexSet().get(j);
                double value = newPlot.getDataSet().getDouble(currentIndex, variableIndex);
                if (value >= low && value <= high) {
                    newIndexSet.add(currentIndex);
                    continue;
                }
                newComplementSet.add(currentIndex);
            }
            newPlot.setIndexSet(newIndexSet);
            newPlot.setComplementIndexSet(newComplementSet);
            if (breakNow) break;
        }
        this.changeScatterPlot(newPlot);
    }

    private static class VariableBoxRenderer
    extends DefaultListCellRenderer {
        private VariableBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Node node = (Node)value;
            if (node == null) {
                this.setText("");
            } else {
                this.setText(node.getName());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }
}

