/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataSet;
import java.util.Vector;

public class ScatterPlotOld {
    private DataSet dataSet;
    private Vector indexSet;
    private Vector complementIndexSet;
    private boolean drawRegLine;
    private ContinuousVariable yVariable;
    private ContinuousVariable xVariable;
    private double[] yData;
    private double[] xData;
    private double xMin;
    private double yMin;
    private double xMax;
    private double yMax;

    public ScatterPlotOld(DataSet dataSet, ContinuousVariable yVariable, ContinuousVariable xVariable) {
        int i;
        int i2;
        this.setDrawRegLine(false);
        if (xVariable != null) {
            this.xVariable = xVariable;
        } else {
            for (i2 = 0; i2 < dataSet.getNumColumns(); ++i2) {
                if (!(dataSet.getVariable(i2) instanceof ContinuousVariable)) continue;
                this.xVariable = (ContinuousVariable)dataSet.getVariable(i2);
                break;
            }
        }
        if (yVariable != null) {
            this.setyVariable(yVariable);
        } else {
            for (i2 = 0; i2 < dataSet.getNumColumns(); ++i2) {
                if (!(dataSet.getVariable(i2) instanceof ContinuousVariable)) continue;
                this.setyVariable((ContinuousVariable)dataSet.getVariable(i2));
                break;
            }
        }
        int yIndex = dataSet.getColumn(yVariable);
        int xIndex = dataSet.getColumn(xVariable);
        if (yIndex == -1) {
            yIndex = 0;
        }
        if (xIndex == -1) {
            xIndex = 0;
        }
        this.setxData(new double[dataSet.getNumRows()]);
        this.setyData(new double[dataSet.getNumRows()]);
        this.xMin = Double.MAX_VALUE;
        this.xMax = Double.MIN_VALUE;
        this.yMin = Double.MAX_VALUE;
        this.yMax = Double.MIN_VALUE;
        for (i = 0; i < dataSet.getNumRows(); ++i) {
            this.getyData()[i] = dataSet.getDouble(i, yIndex);
            this.getxData()[i] = dataSet.getDouble(i, xIndex);
            if (this.getyData()[i] < this.yMin) {
                this.yMin = this.getyData()[i];
            }
            if (this.getyData()[i] > this.yMax) {
                this.yMax = this.getyData()[i];
            }
            if (this.getxData()[i] < this.xMin) {
                this.xMin = this.getxData()[i];
            }
            if (!(this.getxData()[i] > this.xMax)) continue;
            this.xMax = this.getxData()[i];
        }
        this.setDataSet(dataSet);
        this.setIndexSet(new Vector());
        this.setComplementIndexSet(new Vector());
        for (i = 0; i < dataSet.getNumRows(); ++i) {
            this.getIndexSet().add(i);
        }
    }

    public double getMaxSample() {
        if (this.xMax > this.yMax) {
            return this.xMax;
        }
        return this.yMax;
    }

    public double getMinSample() {
        if (this.xMin < this.yMin) {
            return this.xMin;
        }
        return this.yMin;
    }

    public ContinuousVariable getXVariable() {
        return this.xVariable;
    }

    public ContinuousVariable getYVariable() {
        return this.getyVariable();
    }

    public double[] getYData() {
        return this.getyData();
    }

    public double[] getXData() {
        return this.getxData();
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public double[] getyData() {
        return this.yData;
    }

    private void setyData(double[] yData) {
        this.yData = yData;
    }

    public double[] getxData() {
        return this.xData;
    }

    private void setxData(double[] xData) {
        this.xData = xData;
    }

    private void setDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
    }

    public Vector getIndexSet() {
        return this.indexSet;
    }

    public void setIndexSet(Vector indexSet) {
        this.indexSet = indexSet;
    }

    public Vector getComplementIndexSet() {
        return this.complementIndexSet;
    }

    public void setComplementIndexSet(Vector complementIndexSet) {
        this.complementIndexSet = complementIndexSet;
    }

    public boolean isDrawRegLine() {
        return this.drawRegLine;
    }

    public void setDrawRegLine(boolean drawRegLine) {
        this.drawRegLine = drawRegLine;
    }

    private ContinuousVariable getyVariable() {
        return this.yVariable;
    }

    private void setyVariable(ContinuousVariable yVariable) {
        this.yVariable = yVariable;
    }
}

