/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.StatUtils;
import edu.cmu.tetradapp.editor.ScatterPlot;
import edu.cmu.tetradapp.util.DoubleTextField;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ScatterPlotView
extends JPanel {
    private final ScatterPlot scatterPlot;
    private final ScatterPlotChart scatterPlotChart;
    private String x;
    private String y;
    private static final String[] tiles = new String[]{"1-tile", "2-tile", "tertile", "quartile", "quintile", "sextile", "septile", "octile", "nontile", "decile"};

    public ScatterPlotView(DataSet dataSet) {
        if (dataSet.getNumColumns() < 2) {
            throw new IllegalArgumentException("Need at least two columns.");
        }
        this.x = dataSet.getVariable(0).getName();
        this.y = dataSet.getVariable(1).getName();
        this.setLayout(new BorderLayout());
        ScatterPlot ScatterPlot2 = new ScatterPlot(dataSet, false, this.x, this.y);
        ScatterPlotChart ScatterPlotChart2 = new ScatterPlotChart(ScatterPlot2);
        this.scatterPlot = ScatterPlot2;
        this.scatterPlotChart = ScatterPlotChart2;
        this.add((Component)ScatterPlotChart2, "Center");
        this.add((Component)new ScatterPlotController(this), "East");
        this.setPreferredSize(new Dimension(750, 450));
    }

    private void setX(String x) {
        this.x = x;
    }

    private void setY(String y) {
        this.y = y;
    }

    private ScatterPlot getScatterPlot() {
        return this.scatterPlot;
    }

    private static class ScatterPlotChart
    extends JPanel {
        private ScatterPlot scatterPlot;
        private final NumberFormat nf;

        public ScatterPlotChart(ScatterPlot ScatterPlot2) {
            this.scatterPlot = ScatterPlot2;
            this.setPreferredSize(new Dimension(600, 600));
            this.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
            this.nf = NumberFormat.getNumberInstance();
            this.nf.setMinimumFractionDigits(2);
            this.nf.setMaximumFractionDigits(2);
        }

        public void setScatterPlot(ScatterPlot ScatterPlot2) {
            this.scatterPlot = ScatterPlot2;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            double xmin = this.scatterPlot.getXmin();
            double xmax = this.scatterPlot.getXmax();
            double ymin = this.scatterPlot.getYmin();
            double ymax = this.scatterPlot.getYmax();
            Graphics2D g = (Graphics2D)graphics;
            g.setColor(Color.white);
            g.setFont(new Font("Dialog", 0, 11));
            g.fillRect(0, 0, this.getPreferredSize().width, this.getPreferredSize().height);
            int chartWidth = this.getPreferredSize().width * 8 / 10;
            int chartHeight = this.getPreferredSize().height * 7 / 10;
            int xStringMin = 10;
            int xMin = 60;
            int xMax = chartWidth - 10;
            int xRange = xMax - 60;
            int yMin = 35;
            int yMax = chartHeight - 18;
            int yRange = yMax - 35;
            g.setStroke(new BasicStroke());
            g.setPaint(Color.black);
            g.drawLine(60, yMax, xMax, yMax);
            g.drawLine(60, 35, 60, yMax);
            g.setFont(g.getFont().deriveFont(11.0f));
            String name = this.scatterPlot.getDataSet().getName();
            if (name != null) {
                g.setFont(g.getFont().deriveFont(11.0f));
                g.drawString(name, 5, 10);
            }
            g.drawString(this.nf.format(ymax), 12, 42);
            g.drawString(this.nf.format(ymin), 12, yMax);
            g.drawString(this.nf.format(xmax), xMax - 20, yMax + 14);
            g.drawString(this.nf.format(xmin), 50, yMax + 14);
            g.drawString(this.scatterPlot.getXvar(), 60 + xRange / 2 - 10, yMax + 14);
            g.translate(53, 35 + yRange / 2 + 10);
            g.rotate(-1.5707963267948966);
            g.drawString(this.scatterPlot.getYvar(), 10, 0);
            g.rotate(1.5707963267948966);
            g.translate(-53, -(35 + yRange / 2 + 10));
            Vector<Point2D.Double> pts = this.scatterPlot.getSievedValues();
            double _xRange = xmax - xmin;
            double _yRange = ymax - ymin;
            g.setColor(Color.red);
            for (Point2D.Double _pt : pts) {
                int x = (int)((_pt.getX() - xmin) / _xRange * (double)xRange + 60.0);
                int y = (int)((ymax - _pt.getY()) / _yRange * (double)yRange + 35.0);
                g.fillOval(x - 2, y - 2, 5, 5);
            }
            if (this.scatterPlot.isIncludeLine()) {
                double x2;
                double x1;
                double a = this.scatterPlot.getRegressionCoeff();
                double b = this.scatterPlot.getRegressionIntercept();
                double y1 = 0.0;
                for (x1 = xmin; !(!(x1 <= xmax) || (y1 = a * x1 + b) >= ymin && y1 <= ymax); x1 += 0.01) {
                }
                double y2 = 0.0;
                for (x2 = xmax; !(!(x2 >= xmin) || (y2 = a * x2 + b) >= ymin && y2 <= ymax); x2 -= 0.01) {
                }
                int xa = (int)((x1 - xmin) / _xRange * (double)xRange + 60.0);
                int ya = (int)((ymax - y1) / _yRange * (double)yRange + 35.0);
                int xb = (int)((x2 - xmin) / _xRange * (double)xRange + 60.0);
                int yb = (int)((ymax - y2) / _yRange * (double)yRange + 35.0);
                g.setColor(Color.BLUE);
                g.drawLine(xa, ya, xb, yb);
            }
            if (this.scatterPlot.isIncludeLine()) {
                g.setColor(Color.black);
                this.nf.setMinimumFractionDigits(3);
                this.nf.setMaximumFractionDigits(3);
                double r = this.scatterPlot.getCorrelationCoeff();
                double p = this.scatterPlot.getCorrelationPValue();
                g.drawString("correlation coef = " + this.nf.format(r) + "  (p=" + this.nf.format(p) + ")", 100, 21);
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }

    public static class ScatterPlotController
    extends JPanel {
        private final ScatterPlot scatterPlot;
        private final JComboBox xSelector;
        private final JComboBox ySelector;
        private final JComboBox newConditioningVariableSelector;
        private final JButton newConditioningVariableButton;
        private final JButton removeConditioningVariableButton;
        private final List<ConditioningPanel> conditioningPanels = new ArrayList<ConditioningPanel>();
        private final JCheckBox includeLineCheckbox;
        private final Map<Node, ConditioningPanel> conditioningPanelMap = new HashMap<Node, ConditioningPanel>();

        public ScatterPlotController(final ScatterPlotView ScatterPlotView2) {
            this.setLayout(new BorderLayout());
            this.scatterPlot = ScatterPlotView2.getScatterPlot();
            Node xNode = this.getXNode();
            Node yNode = this.getYNode();
            this.xSelector = new JComboBox();
            this.ySelector = new JComboBox();
            VariableBoxRenderer renderer = new VariableBoxRenderer();
            this.xSelector.setRenderer(renderer);
            this.ySelector.setRenderer(renderer);
            this.includeLineCheckbox = new JCheckBox("Show Regression Line");
            List<Node> variables = this.scatterPlot.getDataSet().getVariables();
            Collections.sort(variables);
            for (Node node : variables) {
                this.xSelector.addItem(node);
                if (node != xNode) continue;
                this.xSelector.setSelectedItem(node);
            }
            for (Node node : variables) {
                this.ySelector.addItem(node);
                if (node != yNode) continue;
                this.ySelector.setSelectedItem(node);
            }
            this.xSelector.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String node = ((Node)xSelector.getSelectedItem()).getName();
                    ScatterPlotView2.setX(node);
                    this.refreshChart(ScatterPlotView2);
                }
            });
            this.ySelector.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String node = ((Node)ySelector.getSelectedItem()).getName();
                    ScatterPlotView2.setY(node);
                    this.refreshChart(ScatterPlotView2);
                }
            });
            this.includeLineCheckbox.addActionListener(e -> this.refreshChart(ScatterPlotView2));
            this.newConditioningVariableSelector = new JComboBox();
            for (Node node : variables) {
                this.newConditioningVariableSelector.addItem(node);
            }
            this.newConditioningVariableButton = new JButton("Add");
            this.newConditioningVariableButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ContinuousConditioningPanel panel1;
                    ContinuousVariable _var;
                    System.out.println("New conditioning variable action performed");
                    Node selected = (Node)newConditioningVariableSelector.getSelectedItem();
                    for (ConditioningPanel panel : conditioningPanels) {
                        if (selected != panel.getVariable()) continue;
                        JOptionPane.showMessageDialog(this, "There is already a conditioning variable called " + selected + ".");
                        return;
                    }
                    if (selected instanceof ContinuousVariable) {
                        _var = (ContinuousVariable)selected;
                        panel1 = (ContinuousConditioningPanel)conditioningPanelMap.get(_var);
                        if (panel1 == null) {
                            panel1 = ContinuousConditioningPanel.getDefault(_var, scatterPlot);
                        }
                    } else {
                        throw new IllegalStateException();
                    }
                    ContinuousInquiryPanel panel2 = new ContinuousInquiryPanel(_var, scatterPlot, panel1);
                    JOptionPane.showOptionDialog(this, panel2, null, -1, -1, null, null, null);
                    ContinuousConditioningPanel.Type type = panel2.getType();
                    double low = panel2.getLow();
                    double high = panel2.getHigh();
                    int ntile = panel2.getNtile();
                    int ntileIndex = panel2.getNtileIndex();
                    ContinuousConditioningPanel panel3 = new ContinuousConditioningPanel(_var, low, high, ntile, ntileIndex, type);
                    conditioningPanels.add(panel3);
                    conditioningPanelMap.put(_var, panel3);
                    this.buildEditArea();
                    this.resetConditioning();
                    this.refreshChart(ScatterPlotView2);
                }
            });
            this.removeConditioningVariableButton = new JButton("Remove Checked");
            this.removeConditioningVariableButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (ConditioningPanel panel : new ArrayList(conditioningPanels)) {
                        if (!panel.isSelected()) continue;
                        panel.setSelected(false);
                        conditioningPanels.remove(panel);
                        scatterPlot.removeConditioningVariable(panel.getVariable().toString());
                        this.refreshChart(ScatterPlotView2);
                    }
                    this.buildEditArea();
                    this.resetConditioning();
                }
            });
            ScatterPlotController.restrictSize(this.xSelector);
            ScatterPlotController.restrictSize(this.newConditioningVariableSelector);
            ScatterPlotController.restrictSize(this.newConditioningVariableButton);
            ScatterPlotController.restrictSize(this.removeConditioningVariableButton);
            this.buildEditArea();
        }

        private void refreshChart(ScatterPlotView ScatterPlotView2) {
            ScatterPlot ScatterPlot2 = new ScatterPlot(ScatterPlotView2.scatterPlot.getDataSet(), this.includeLineCheckbox.isSelected(), ScatterPlotView2.x, ScatterPlotView2.y);
            ScatterPlot2.removeConditioningVariables();
            for (ConditioningPanel panel : this.conditioningPanels) {
                if (!(panel instanceof ContinuousConditioningPanel)) continue;
                Node node = panel.getVariable();
                double low = ((ContinuousConditioningPanel)panel).getLow();
                double high = ((ContinuousConditioningPanel)panel).getHigh();
                ScatterPlot2.addConditioningVariable(node.getName(), low, high);
            }
            ScatterPlotView2.scatterPlotChart.setScatterPlot(ScatterPlot2);
            ScatterPlotView2.scatterPlotChart.repaint();
        }

        private void resetConditioning() {
            this.scatterPlot.removeConditioningVariables();
            for (ConditioningPanel panel : this.conditioningPanels) {
                if (!(panel instanceof ContinuousConditioningPanel)) continue;
                Node node = panel.getVariable();
                double low = ((ContinuousConditioningPanel)panel).getLow();
                double high = ((ContinuousConditioningPanel)panel).getHigh();
                this.scatterPlot.addConditioningVariable(node.getName(), low, high);
            }
        }

        private void buildEditArea() {
            ScatterPlotController.restrictSize(this.xSelector);
            ScatterPlotController.restrictSize(this.ySelector);
            Box main = Box.createVerticalBox();
            Box b1 = Box.createHorizontalBox();
            b1.add(new JLabel("ScatterPlot for: "));
            b1.add(Box.createHorizontalGlue());
            main.add(b1);
            Box b1a = Box.createHorizontalBox();
            b1a.add(new JLabel("X-axis = "));
            b1a.add(Box.createHorizontalGlue());
            b1a.add(this.xSelector);
            main.add(b1a);
            Box b1b = Box.createHorizontalBox();
            b1b.add(new JLabel("Y-axis = "));
            b1b.add(Box.createHorizontalGlue());
            b1b.add(this.ySelector);
            main.add(b1b);
            Box b1c = Box.createHorizontalBox();
            b1c.add(this.includeLineCheckbox);
            main.add(b1c);
            main.add(Box.createVerticalStrut(20));
            Box b3 = Box.createHorizontalBox();
            JLabel l1 = new JLabel("Conditioning on: ");
            l1.setFont(l1.getFont().deriveFont(2));
            b3.add(l1);
            b3.add(Box.createHorizontalGlue());
            main.add(b3);
            main.add(Box.createVerticalStrut(20));
            for (ConditioningPanel panel : this.conditioningPanels) {
                main.add(panel.getBox());
                main.add(Box.createVerticalStrut(10));
            }
            main.add(Box.createVerticalStrut(10));
            main.add(Box.createVerticalGlue());
            main.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            Box b6 = Box.createHorizontalBox();
            b6.add(this.newConditioningVariableSelector);
            b6.add(this.newConditioningVariableButton);
            b6.add(Box.createHorizontalGlue());
            main.add(b6);
            Box b7 = Box.createHorizontalBox();
            b7.add(this.removeConditioningVariableButton);
            b7.add(Box.createHorizontalGlue());
            main.add(b7);
            this.removeAll();
            this.add((Component)main, "Center");
            this.revalidate();
            this.repaint();
        }

        private Node getXNode() {
            return this.scatterPlot.getDataSet().getVariable(this.scatterPlot.getXvar());
        }

        private Node getYNode() {
            return this.scatterPlot.getDataSet().getVariable(this.scatterPlot.getYvar());
        }

        private static void restrictSize(JComponent component) {
            component.setMaximumSize(component.getPreferredSize());
        }

        private static class VariableBoxRenderer
        extends DefaultListCellRenderer {
            private VariableBoxRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Node node = (Node)value;
                if (node == null) {
                    this.setText("");
                } else {
                    this.setText(node.getName());
                }
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                return this;
            }
        }

        private static interface ConditioningPanel {
            public Box getBox();

            public boolean isSelected();

            public Node getVariable();

            public void setSelected(boolean var1);
        }

        public static class ContinuousConditioningPanel
        implements ConditioningPanel {
            private final ContinuousVariable variable;
            private final Box box;
            private final Type type;
            private final double low;
            private final double high;
            private final int ntile;
            private final int ntileIndex;
            private final JCheckBox checkBox;

            public int getNtile() {
                return this.ntile;
            }

            public int getNtileIndex() {
                return this.ntileIndex;
            }

            public ContinuousConditioningPanel(ContinuousVariable variable, double low, double high, int ntile, int ntileIndex, Type type) {
                if (variable == null) {
                    throw new NullPointerException();
                }
                if (low >= high) {
                    throw new IllegalArgumentException("Low >= high.");
                }
                if (ntile < 2 || ntile > 10) {
                    throw new IllegalArgumentException("Ntile should be in range 2 to 10: " + ntile);
                }
                this.variable = variable;
                DecimalFormat nf = new DecimalFormat("0.0000");
                this.type = type;
                this.low = low;
                this.high = high;
                this.ntile = ntile;
                this.ntileIndex = ntileIndex;
                Box b4 = Box.createHorizontalBox();
                b4.add(Box.createRigidArea(new Dimension(10, 0)));
                if (type == Type.Range) {
                    b4.add(new JLabel(variable + " = (" + nf.format(low) + ", " + nf.format(high) + ")"));
                } else if (type == Type.AboveAverage) {
                    b4.add(new JLabel(variable + " = Above Average"));
                } else if (type == Type.BelowAverage) {
                    b4.add(new JLabel(variable + " = Below Average"));
                } else if (type == Type.Ntile) {
                    b4.add(new JLabel(variable + " = " + tiles[ntile - 1] + " " + ntileIndex));
                }
                b4.add(Box.createHorizontalGlue());
                this.checkBox = new JCheckBox();
                ScatterPlotController.restrictSize(this.checkBox);
                b4.add(this.checkBox);
                this.box = b4;
            }

            public static ContinuousConditioningPanel getDefault(ContinuousVariable variable, ScatterPlot ScatterPlot2) {
                double[] data = ScatterPlot2.getContinuousData(variable.getName());
                double max = StatUtils.max(data);
                double avg = StatUtils.mean(data);
                return new ContinuousConditioningPanel(variable, avg, max, 2, 1, Type.AboveAverage);
            }

            @Override
            public ContinuousVariable getVariable() {
                return this.variable;
            }

            public Type getType() {
                return this.type;
            }

            @Override
            public Box getBox() {
                return this.box;
            }

            @Override
            public boolean isSelected() {
                return this.checkBox.isSelected();
            }

            @Override
            public void setSelected(boolean b) {
                this.checkBox.setSelected(false);
            }

            public double getLow() {
                return this.low;
            }

            public double getHigh() {
                return this.high;
            }

            public static enum Type {
                Range,
                Ntile,
                AboveAverage,
                BelowAverage;

            }
        }
    }

    private static class ContinuousInquiryPanel
    extends JPanel {
        private final JComboBox ntileCombo;
        private final JComboBox ntileIndexCombo;
        private final DoubleTextField field1;
        private final DoubleTextField field2;
        private ScatterPlotController.ContinuousConditioningPanel.Type type;
        private final Map<String, Integer> ntileMap = new HashMap<String, Integer>();
        private final double[] data;

        public ContinuousInquiryPanel(ContinuousVariable variable, ScatterPlot ScatterPlot2, ScatterPlotController.ContinuousConditioningPanel conditioningPanel) {
            int n;
            this.data = ScatterPlot2.getContinuousData(variable.getName());
            if (conditioningPanel == null) {
                throw new NullPointerException();
            }
            if (variable != conditioningPanel.getVariable()) {
                throw new IllegalArgumentException("Wrong variable for conditioning panel.");
            }
            DecimalFormat nf = new DecimalFormat("0.00");
            this.field1 = new DoubleTextField(conditioningPanel.getLow(), 4, nf);
            this.field2 = new DoubleTextField(conditioningPanel.getHigh(), 4, nf);
            JRadioButton radio1 = new JRadioButton();
            JRadioButton radio2 = new JRadioButton();
            JRadioButton radio3 = new JRadioButton();
            JRadioButton radio4 = new JRadioButton();
            radio1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    type = ScatterPlotController.ContinuousConditioningPanel.Type.AboveAverage;
                    field1.setValue(StatUtils.mean(data));
                    field2.setValue(StatUtils.max(data));
                }
            });
            radio2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    type = ScatterPlotController.ContinuousConditioningPanel.Type.BelowAverage;
                    field1.setValue(StatUtils.min(data));
                    field2.setValue(StatUtils.mean(data));
                }
            });
            radio3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    type = ScatterPlotController.ContinuousConditioningPanel.Type.Ntile;
                    double[] breakpoints = ContinuousInquiryPanel.getNtileBreakpoints(data, this.getNtile());
                    double breakpoint1 = breakpoints[this.getNtileIndex() - 1];
                    double breakpoint2 = breakpoints[this.getNtileIndex()];
                    field1.setValue(breakpoint1);
                    field2.setValue(breakpoint2);
                }
            });
            radio4.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    type = ScatterPlotController.ContinuousConditioningPanel.Type.Range;
                }
            });
            ButtonGroup group = new ButtonGroup();
            group.add(radio1);
            group.add(radio2);
            group.add(radio3);
            group.add(radio4);
            this.type = conditioningPanel.getType();
            this.ntileCombo = new JComboBox();
            this.ntileIndexCombo = new JComboBox();
            int ntile = conditioningPanel.getNtile();
            int ntileIndex = conditioningPanel.getNtileIndex();
            for (n = 2; n <= 10; ++n) {
                this.ntileCombo.addItem(tiles[n - 1]);
                this.ntileMap.put(tiles[n - 1], n);
            }
            for (n = 1; n <= ntile; ++n) {
                this.ntileIndexCombo.addItem(n);
            }
            this.ntileCombo.setSelectedItem(tiles[ntile - 1]);
            this.ntileIndexCombo.setSelectedItem(ntileIndex);
            this.ntileCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    String item = (String)e.getItem();
                    int ntileIndex = (Integer)ntileMap.get(item);
                    for (int i = ntileIndexCombo.getItemCount() - 1; i >= 0; --i) {
                        ntileIndexCombo.removeItemAt(i);
                    }
                    for (int n = 1; n <= ntileIndex; ++n) {
                        ntileIndexCombo.addItem(n);
                    }
                    double[] breakpoints = ContinuousInquiryPanel.getNtileBreakpoints(data, this.getNtile());
                    double breakpoint1 = breakpoints[this.getNtileIndex() - 1];
                    double breakpoint2 = breakpoints[this.getNtileIndex()];
                    field1.setValue(breakpoint1);
                    field2.setValue(breakpoint2);
                }
            });
            this.ntileIndexCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    int ntile = this.getNtile();
                    int ntileIndex = this.getNtileIndex();
                    double[] breakpoints = ContinuousInquiryPanel.getNtileBreakpoints(data, ntile);
                    double breakpoint1 = breakpoints[ntileIndex - 1];
                    double breakpoint2 = breakpoints[ntileIndex];
                    field1.setValue(breakpoint1);
                    field2.setValue(breakpoint2);
                }
            });
            if (this.type == ScatterPlotController.ContinuousConditioningPanel.Type.AboveAverage) {
                radio1.setSelected(true);
                this.field1.setValue(StatUtils.mean(this.data));
                this.field2.setValue(StatUtils.max(this.data));
            } else if (this.type == ScatterPlotController.ContinuousConditioningPanel.Type.BelowAverage) {
                radio2.setSelected(true);
                this.field1.setValue(StatUtils.min(this.data));
                this.field2.setValue(StatUtils.mean(this.data));
            } else if (this.type == ScatterPlotController.ContinuousConditioningPanel.Type.Ntile) {
                radio3.setSelected(true);
                double[] breakpoints = ContinuousInquiryPanel.getNtileBreakpoints(this.data, this.getNtile());
                double breakpoint1 = breakpoints[this.getNtileIndex() - 1];
                double breakpoint2 = breakpoints[this.getNtileIndex()];
                this.field1.setValue(breakpoint1);
                this.field2.setValue(breakpoint2);
            } else if (this.type == ScatterPlotController.ContinuousConditioningPanel.Type.Range) {
                radio4.setSelected(true);
            }
            Box main = Box.createVerticalBox();
            Box b0 = Box.createHorizontalBox();
            b0.add(new JLabel("Condition on " + variable.getName() + " as:"));
            b0.add(Box.createHorizontalGlue());
            main.add(b0);
            main.add(Box.createVerticalStrut(10));
            Box b1 = Box.createHorizontalBox();
            b1.add(radio1);
            b1.add(new JLabel("Above average"));
            b1.add(Box.createHorizontalGlue());
            main.add(b1);
            Box b2 = Box.createHorizontalBox();
            b2.add(radio2);
            b2.add(new JLabel("Below average"));
            b2.add(Box.createHorizontalGlue());
            main.add(b2);
            Box b3 = Box.createHorizontalBox();
            b3.add(radio3);
            b3.add(new JLabel("In "));
            b3.add(this.ntileCombo);
            b3.add(this.ntileIndexCombo);
            b3.add(Box.createHorizontalGlue());
            main.add(b3);
            Box b4 = Box.createHorizontalBox();
            b4.add(radio4);
            b4.add(new JLabel("In ("));
            b4.add(this.field1);
            b4.add(new JLabel(", "));
            b4.add(this.field2);
            b4.add(new JLabel(")"));
            b4.add(Box.createHorizontalGlue());
            main.add(b4);
            this.add((Component)main, "Center");
        }

        public ScatterPlotController.ContinuousConditioningPanel.Type getType() {
            return this.type;
        }

        public double getLow() {
            return this.field1.getValue();
        }

        public double getHigh() {
            return this.field2.getValue();
        }

        public int getNtile() {
            String selectedItem = (String)this.ntileCombo.getSelectedItem();
            return this.ntileMap.get(selectedItem);
        }

        public int getNtileIndex() {
            Object selectedItem = this.ntileIndexCombo.getSelectedItem();
            return selectedItem == null ? 1 : (Integer)selectedItem;
        }

        public static double[] getNtileBreakpoints(double[] data, int ntiles) {
            double[] _data = new double[data.length];
            System.arraycopy(data, 0, _data, 0, _data.length);
            Arrays.sort(_data);
            ArrayList<Chunk> chunks = new ArrayList<Chunk>(_data.length);
            int startChunkCount = 0;
            double lastValue = _data[0];
            for (int i = 0; i < _data.length; ++i) {
                double value = _data[i];
                if (value != lastValue) {
                    chunks.add(new Chunk(startChunkCount, i, value));
                    startChunkCount = i;
                }
                lastValue = value;
            }
            chunks.add(new Chunk(startChunkCount, _data.length, _data[_data.length - 1]));
            double interval = (double)_data.length / (double)ntiles;
            double[] breakpoints = new double[ntiles + 1];
            breakpoints[0] = StatUtils.min(_data);
            int current = 1;
            int freq = 0;
            for (Chunk chunk : chunks) {
                int valuesInChunk = chunk.getNumberOfValuesInChunk();
                int halfChunk = (int)((double)valuesInChunk * 0.5);
                freq = (double)(freq + halfChunk) <= interval ? (freq += valuesInChunk) : valuesInChunk;
                if (!(interval <= (double)freq)) continue;
                freq = 0;
                if (current >= ntiles + 1) continue;
                breakpoints[current++] = chunk.value;
            }
            for (int i = current; i < breakpoints.length; ++i) {
                breakpoints[i] = StatUtils.max(_data);
            }
            return breakpoints;
        }

        private static class Chunk {
            private final int valuesInChunk;
            private final double value;

            public Chunk(int low, int high, double value) {
                this.valuesInChunk = high - low;
                this.value = value;
            }

            public int getNumberOfValuesInChunk() {
                return this.valuesInChunk;
            }
        }
    }
}

