/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.GraphScorer;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.editor.CopySubgraphAction;
import edu.cmu.tetradapp.editor.GraphEditable;
import edu.cmu.tetradapp.model.ScoredGraphsWrapper;
import edu.cmu.tetradapp.workbench.DisplayEdge;
import edu.cmu.tetradapp.workbench.DisplayNode;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.math3.util.FastMath;

public class ScoredGraphsDisplay
extends JPanel
implements GraphEditable {
    private GraphWorkbench workbench;
    private boolean showHighestScoreOnly;
    private final NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
    private Map<Graph, Double> dagsToScores;
    private List<Graph> dags;
    private JLabel scoreLabel;
    private ScoredGraphsWrapper scoredGraphsWrapper;

    public ScoredGraphsDisplay(ScoredGraphsWrapper scoredGraphsWrapper) {
        if (scoredGraphsWrapper == null) {
            throw new NullPointerException();
        }
        this.scoredGraphsWrapper = scoredGraphsWrapper;
        this.dagsToScores = scoredGraphsWrapper.getGraphsToScores();
        this.setup();
    }

    public ScoredGraphsDisplay(Graph graph, GraphScorer scorer) {
        List<Graph> _dags = SearchGraphUtils.generateCpdagDags(graph, true);
        for (Graph _graph : _dags) {
            double score = Double.NaN;
            if (scorer != null) {
                score = scorer.scoreDag(_graph);
            }
            this.dagsToScores.put(_graph, score);
        }
        this.setup();
    }

    private void setup() {
        int n;
        int n2;
        if (this.dagsToScores.isEmpty()) {
            throw new IllegalArgumentException("Empty map.");
        }
        double max = Double.NEGATIVE_INFINITY;
        for (Graph graph : this.dagsToScores.keySet()) {
            if (!(this.dagsToScores.get(graph) > max)) continue;
            max = this.dagsToScores.get(graph);
        }
        final ArrayList<Graph> dags = new ArrayList<Graph>();
        if (max != Double.NEGATIVE_INFINITY && this.showHighestScoreOnly) {
            for (Graph dag3 : this.dagsToScores.keySet()) {
                if (this.dagsToScores.get(dag3) != max) continue;
                dags.add(dag3);
            }
        } else {
            dags.addAll(this.dagsToScores.keySet());
        }
        if (max != Double.NEGATIVE_INFINITY) {
            Collections.sort(dags, new Comparator<Graph>(){

                @Override
                public int compare(Graph graph, Graph graph1) {
                    return (int)FastMath.signum((Double)ScoredGraphsDisplay.this.dagsToScores.get(graph) - (Double)ScoredGraphsDisplay.this.dagsToScores.get(graph1));
                }
            });
        }
        this.dags = dags;
        if (dags.size() == 0) {
            throw new IllegalArgumentException("No graphs to display.");
        }
        int n3 = -1;
        Graph dag = this.scoredGraphsWrapper.getGraph();
        if (dag == null) {
            this.scoredGraphsWrapper.setSelectedGraph((Graph)dags.get(0));
            dag = this.scoredGraphsWrapper.getGraph();
        }
        if ((n2 = dags.indexOf(dag)) == -1) {
            dag = (Graph)dags.get(0);
            n = 0;
        }
        this.workbench = new GraphWorkbench(dag);
        final SpinnerNumberModel model = new SpinnerNumberModel(n + 1, 1, dags.size(), 1);
        model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int index = model.getNumber().intValue() - 1;
                ScoredGraphsDisplay.this.workbench.setGraph((Graph)dags.get(index));
                if (ScoredGraphsDisplay.this.scoredGraphsWrapper != null) {
                    ScoredGraphsDisplay.this.scoredGraphsWrapper.setSelectedGraph((Graph)dags.get(index));
                }
                ScoredGraphsDisplay.this.setScore(index - 1);
                ScoredGraphsDisplay.this.firePropertyChange("modelChanged", null, null);
            }
        });
        JSpinner spinner = new JSpinner();
        spinner.setModel(model);
        JLabel totalLabel = new JLabel(" of " + dags.size() + " ");
        this.scoreLabel = new JLabel();
        this.setScore(dags.size() - 1);
        spinner.setPreferredSize(new Dimension(50, 20));
        spinner.setMaximumSize(spinner.getPreferredSize());
        Box b = Box.createVerticalBox();
        Box b1 = Box.createHorizontalBox();
        b1.add(Box.createHorizontalGlue());
        b1.add(new JLabel("DAG "));
        b1.add(spinner);
        b1.add(totalLabel);
        b1.add(Box.createHorizontalGlue());
        b1.add(new JLabel("Score =  "));
        b1.add(this.scoreLabel);
        b1.add(Box.createHorizontalStrut(10));
        b1.add(Box.createHorizontalGlue());
        b1.add(new JButton(new CopySubgraphAction(this)));
        b.add(b1);
        Box b2 = Box.createHorizontalBox();
        JPanel graphPanel = new JPanel();
        graphPanel.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.workbench);
        jScrollPane.setPreferredSize(new Dimension(400, 400));
        graphPanel.add(jScrollPane);
        graphPanel.setBorder(new TitledBorder("Maximum Scoring DAGs in forbid_latent_common_causes"));
        b2.add(graphPanel);
        b.add(b2);
        this.setLayout(new BorderLayout());
        this.add((Component)this.menuBar(), "North");
        this.add((Component)b, "Center");
    }

    private void setScore(int i) {
        Double score = this.dagsToScores.get(this.dags.get(i));
        String text = Double.isNaN(score) ? "Not provided" : this.nf.format(score);
        this.scoreLabel.setText(text);
    }

    @Override
    public List getSelectedModelComponents() {
        Component[] components = this.getWorkbench().getComponents();
        ArrayList<Comparable<Node>> selectedModelComponents = new ArrayList<Comparable<Node>>();
        for (Component comp : components) {
            if (comp instanceof DisplayNode) {
                selectedModelComponents.add(((DisplayNode)comp).getModelNode());
                continue;
            }
            if (!(comp instanceof DisplayEdge)) continue;
            selectedModelComponents.add(((DisplayEdge)comp).getModelEdge());
        }
        return selectedModelComponents;
    }

    @Override
    public void pasteSubsession(List<Object> sessionElements, Point upperLeft) {
        this.getWorkbench().pasteSubgraph(sessionElements, upperLeft);
        this.getWorkbench().deselectAll();
        for (Object o : sessionElements) {
            if (!(o instanceof GraphNode)) continue;
            Node modelNode = (Node)o;
            this.getWorkbench().selectNode(modelNode);
        }
        this.getWorkbench().selectConnectingEdges();
    }

    @Override
    public GraphWorkbench getWorkbench() {
        return this.workbench;
    }

    @Override
    public Graph getGraph() {
        return this.workbench.getGraph();
    }

    @Override
    public void setGraph(Graph graph) {
        this.workbench.setGraph(graph);
    }

    private JMenuBar menuBar() {
        JMenu edit = new JMenu("Edit");
        JMenuItem copy = new JMenuItem(new CopySubgraphAction(this));
        copy.setAccelerator(KeyStroke.getKeyStroke(67, 128));
        edit.add(copy);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(edit);
        return menuBar;
    }

    public void setShowHighestScoreOnly(boolean showHighestScoreOnly) {
        this.showHighestScoreOnly = showHighestScoreOnly;
    }
}

