/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeVariableType;
import edu.cmu.tetradapp.workbench.DisplayEdge;
import edu.cmu.tetradapp.workbench.DisplayNode;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.Component;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class SelectInterventionalAction
extends AbstractAction
implements ClipboardOwner {
    private static final long serialVersionUID = -1981559602783726423L;
    private final GraphWorkbench workbench;

    public SelectInterventionalAction(GraphWorkbench workbench) {
        super("Highlight Interventional Nodes");
        if (workbench == null) {
            throw new NullPointerException("Desktop must not be null.");
        }
        this.workbench = workbench;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.workbench.deselectAll();
        for (Component comp : this.workbench.getComponents()) {
            Edge edge;
            Node node;
            if (comp instanceof DisplayNode && ((node = ((DisplayNode)comp).getModelNode()).getNodeVariableType() == NodeVariableType.INTERVENTION_STATUS || node.getNodeVariableType() == NodeVariableType.INTERVENTION_VALUE)) {
                this.workbench.selectNode(node);
            }
            if (!(comp instanceof DisplayEdge) || (edge = ((DisplayEdge)comp).getModelEdge()).getNode1().getNodeVariableType() != NodeVariableType.INTERVENTION_STATUS && edge.getNode1().getNodeVariableType() != NodeVariableType.INTERVENTION_VALUE && edge.getNode2().getNodeVariableType() != NodeVariableType.INTERVENTION_STATUS && edge.getNode2().getNodeVariableType() != NodeVariableType.INTERVENTION_VALUE) continue;
            this.workbench.selectEdge(edge);
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

