/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetradapp.workbench.DisplayEdge;
import edu.cmu.tetradapp.workbench.DisplayNode;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.Component;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class SelectLatentsAction
extends AbstractAction
implements ClipboardOwner {
    private final GraphWorkbench workbench;

    public SelectLatentsAction(GraphWorkbench workbench) {
        super("Highlight Latent Nodes");
        if (workbench == null) {
            throw new NullPointerException("Desktop must not be null.");
        }
        this.workbench = workbench;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.workbench.deselectAll();
        for (Component comp : this.workbench.getComponents()) {
            Node node;
            if (!(comp instanceof DisplayNode) || (node = ((DisplayNode)comp).getModelNode()).getNodeType() != NodeType.LATENT) continue;
            this.workbench.selectNode(node);
        }
        for (Component comp : this.workbench.getComponents()) {
            Edge edge;
            if (!(comp instanceof DisplayEdge) || (edge = ((DisplayEdge)comp).getModelEdge()).getNode1().getNodeType() != NodeType.LATENT || edge.getNode2().getNodeType() != NodeType.LATENT) continue;
            this.workbench.selectEdge(edge);
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

