/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.sem.ISemIm;
import edu.cmu.tetrad.sem.ParamType;
import edu.cmu.tetrad.sem.Parameter;
import edu.cmu.tetrad.sem.ScoreType;
import edu.cmu.tetrad.sem.SemEstimator;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemOptimizer;
import edu.cmu.tetrad.sem.SemOptimizerEm;
import edu.cmu.tetrad.sem.SemOptimizerPowell;
import edu.cmu.tetrad.sem.SemOptimizerRegression;
import edu.cmu.tetrad.sem.SemOptimizerRicf;
import edu.cmu.tetrad.sem.SemOptimizerScattershot;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.sem.SemXmlRenderer;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.ProbUtils;
import edu.cmu.tetradapp.editor.DataCellEditor;
import edu.cmu.tetradapp.editor.EditorWindow;
import edu.cmu.tetradapp.editor.SaveComponentImage;
import edu.cmu.tetradapp.model.EditorUtils;
import edu.cmu.tetradapp.model.SemEstimatorWrapper;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.util.DoubleTextField;
import edu.cmu.tetradapp.util.IntTextField;
import edu.cmu.tetradapp.util.LayoutEditable;
import edu.cmu.tetradapp.util.WatchedProcess;
import edu.cmu.tetradapp.workbench.DisplayNode;
import edu.cmu.tetradapp.workbench.GraphNodeMeasured;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import edu.cmu.tetradapp.workbench.LayoutMenu;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Serializer;
import org.apache.commons.math3.util.FastMath;

public final class SemEstimatorEditor
extends JPanel {
    private static final long serialVersionUID = 960988184083427499L;
    private final JPanel targetPanel;
    private final NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
    private final DataSet dataSet;
    private final SemEstimatorWrapper wrapper;
    private OneEditor oneEditorPanel;
    private final String graphicalEditorTitle = "Graphical Editor";
    private final String tabularEditorTitle = "Tabular Editor";
    private final boolean editable = true;

    public SemEstimatorEditor(SemIm semIm, DataSet dataSet) {
        this(new SemEstimatorWrapper(dataSet, semIm.getSemPm(), new Parameters()));
    }

    public SemEstimatorEditor(SemPm semPm, DataSet dataSet) {
        this(new SemEstimatorWrapper(dataSet, semPm, new Parameters()));
    }

    public SemEstimatorEditor(SemEstimatorWrapper wrapper) {
        this.setLayout(new BorderLayout());
        this.targetPanel = new JPanel();
        this.targetPanel.setLayout(new BorderLayout());
        this.add((Component)this.targetPanel, "Center");
        this.wrapper = wrapper;
        this.dataSet = wrapper.getSemEstimator().getDataSet();
        this.oneEditorPanel = new OneEditor(wrapper, this.graphicalEditorTitle, this.tabularEditorTitle, TabbedPaneDefault.GRAPHICAL);
        this.targetPanel.add((Component)this.oneEditorPanel, "Center");
        JComboBox<String> optimizerCombo = new JComboBox<String>();
        optimizerCombo.addItem("Regression");
        optimizerCombo.addItem("EM");
        optimizerCombo.addItem("Powell");
        optimizerCombo.addItem("Random Search");
        optimizerCombo.addItem("RICF");
        optimizerCombo.addActionListener(e -> {
            JComboBox box = (JComboBox)e.getSource();
            wrapper.setSemOptimizerType((String)box.getSelectedItem());
        });
        JComboBox<String> scoreBox = new JComboBox<String>();
        IntTextField restarts = new IntTextField(1, 2);
        scoreBox.addItem("Fgls");
        scoreBox.addItem("Fml");
        scoreBox.addActionListener(e -> {
            JComboBox box = (JComboBox)e.getSource();
            String type = (String)box.getSelectedItem();
            if ("Fgls".equals(type)) {
                wrapper.setScoreType(ScoreType.Fgls);
            } else if ("Fml".equals(type)) {
                wrapper.setScoreType(ScoreType.Fml);
            }
        });
        restarts.setFilter((value, oldValue) -> {
            try {
                wrapper.setNumRestarts(value);
                return value;
            }
            catch (Exception e) {
                return oldValue;
            }
        });
        String semOptimizerType = wrapper.getParams().getString("semOptimizerType", "Regression");
        optimizerCombo.setSelectedItem(semOptimizerType);
        ScoreType scoreType = (ScoreType)((Object)wrapper.getParams().get("scoreType", (Object)ScoreType.Fgls));
        if (scoreType == null) {
            scoreType = ScoreType.Fgls;
        }
        scoreBox.setSelectedItem(scoreType.toString());
        restarts.setValue(wrapper.getParams().getInt("numRestarts", 1));
        JButton estimateButton = new JButton("Estimate Again");
        estimateButton.addActionListener(e -> {
            Window owner = (Window)this.getTopLevelAncestor();
            new WatchedProcess(owner){

                @Override
                public void watch() {
                    SemEstimatorEditor.this.reestimate();
                }
            };
        });
        JButton report = new JButton("Report");
        report.addActionListener(e -> {
            JTextArea textArea = new JTextArea();
            JScrollPane scroll = new JScrollPane(textArea);
            textArea.append(this.compileReport());
            Box b = Box.createVerticalBox();
            Box b2 = Box.createHorizontalBox();
            b2.add(scroll);
            textArea.setCaretPosition(0);
            b.add(b2);
            JPanel editorPanel = new JPanel(new BorderLayout());
            editorPanel.add(b);
            EditorWindow window = new EditorWindow(editorPanel, "All Paths", "Close", false, this);
            DesktopController.getInstance().addEditorWindow(window, JLayeredPane.PALETTE_LAYER);
            window.setVisible(true);
        });
        Box lowerBarA = Box.createHorizontalBox();
        lowerBarA.add(new JLabel("Score"));
        lowerBarA.add(scoreBox);
        lowerBarA.add(Box.createHorizontalGlue());
        lowerBarA.add(new JLabel("Random Restarts"));
        lowerBarA.add(restarts);
        Box lowerBarB = Box.createHorizontalBox();
        lowerBarB.add(new JLabel("Choose Optimizer:  "));
        lowerBarB.add(optimizerCombo);
        lowerBarB.add(Box.createHorizontalGlue());
        lowerBarB.add(estimateButton);
        Box lowerBar = Box.createVerticalBox();
        lowerBar.add(lowerBarA);
        lowerBar.add(lowerBarB);
        this.add((Component)lowerBar, "South");
        this.resetSemImEditor();
    }

    private String compileReport() {
        StringBuilder builder = new StringBuilder();
        builder.append("Datset\tFrom\tTo\tType\tValue\tSE\tT\tP");
        SemIm estSem = this.wrapper.getEstimatedSemIm();
        String dataName = this.dataSet.getName();
        estSem.getFreeParameters().forEach(parameter -> {
            builder.append("\n");
            builder.append(dataName).append("\t");
            builder.append(parameter.getNodeA()).append("\t");
            builder.append(parameter.getNodeB()).append("\t");
            builder.append(this.typeString((Parameter)parameter)).append("\t");
            builder.append(this.asString(this.paramValue(estSem, (Parameter)parameter))).append("\t");
            int maxFreeParamsForStatistics = 200;
            builder.append(this.asString(estSem.getStandardError((Parameter)parameter, 200))).append("\t");
            builder.append(this.asString(estSem.getTValue((Parameter)parameter, 200))).append("\t");
            builder.append(this.asString(estSem.getPValue((Parameter)parameter, 200))).append("\t");
        });
        List<Node> nodes = estSem.getVariableNodes();
        nodes.forEach(node -> {
            int n = estSem.getSampleSize();
            int df = n - 1;
            double mean = estSem.getMean((Node)node);
            double stdDev = estSem.getMeanStdDev((Node)node);
            double stdErr = stdDev / FastMath.sqrt(n);
            double tValue = mean / stdErr;
            double p = 2.0 * (1.0 - ProbUtils.tCdf(FastMath.abs(tValue), df));
            builder.append("\n");
            builder.append(dataName).append("\t");
            builder.append(node).append("\t");
            builder.append(node).append("\t");
            builder.append("Mean").append("\t");
            builder.append(this.asString(mean)).append("\t");
            builder.append(this.asString(stdErr)).append("\t");
            builder.append(this.asString(tValue)).append("\t");
            builder.append(this.asString(p)).append("\t");
        });
        return builder.toString();
    }

    private String asString(double value) {
        if (Double.isNaN(value)) {
            return " * ";
        }
        return this.nf.format(value);
    }

    private String typeString(Parameter parameter) {
        ParamType type = parameter.getType();
        if (type == ParamType.COEF) {
            return "Coef";
        }
        if (type == ParamType.VAR) {
            return "StdDev";
        }
        if (type == ParamType.COVAR) {
            return "Covar";
        }
        throw new IllegalStateException("Unknown param type.");
    }

    private double paramValue(SemIm im, Parameter parameter) {
        double paramValue = im.getParamValue(parameter);
        if (parameter.getType() == ParamType.VAR) {
            paramValue = FastMath.sqrt(paramValue);
        }
        return paramValue;
    }

    private void reestimate() {
        SemOptimizer optimizer;
        String type;
        switch (type = this.wrapper.getSemOptimizerType()) {
            case "Regression": {
                optimizer = new SemOptimizerRegression();
                break;
            }
            case "EM": {
                optimizer = new SemOptimizerEm();
                break;
            }
            case "Powell": {
                optimizer = new SemOptimizerPowell();
                break;
            }
            case "Random Search": {
                optimizer = new SemOptimizerScattershot();
                break;
            }
            case "RICF": {
                optimizer = new SemOptimizerRicf();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected optimizer type: " + type);
            }
        }
        int numRestarts = this.wrapper.getNumRestarts();
        optimizer.setNumRestarts(numRestarts);
        SemEstimator estimator = this.wrapper.getSemEstimator();
        estimator.setSemOptimizer(optimizer);
        estimator.setNumRestarts(numRestarts);
        estimator.setScoreType(this.wrapper.getScoreType());
        estimator.estimate();
        this.resetSemImEditor();
    }

    private void resetSemImEditor() {
        this.oneEditorPanel = new OneEditor(this.wrapper, this.graphicalEditorTitle, this.tabularEditorTitle, TabbedPaneDefault.GRAPHICAL);
        this.targetPanel.removeAll();
        this.targetPanel.add((Component)this.oneEditorPanel, "Center");
        this.validate();
    }

    private Component getComp() {
        EditorWindow editorWindow = (EditorWindow)SwingUtilities.getAncestorOfClass(EditorWindow.class, this);
        if (editorWindow != null) {
            return editorWindow.getRootPane().getContentPane();
        }
        return editorWindow;
    }

    private class OneEditor
    extends JPanel
    implements LayoutEditable {
        private static final long serialVersionUID = 6622060253747442717L;
        private final SemEstimatorWrapper semImWrapper;
        private final int maxFreeParamsForStatistics = 1000;
        private SemImGraphicalEditor semImGraphicalEditor;
        private SemImTabularEditor semImTabularEditor;
        private ImpliedMatricesPanel impliedMatricesPanel;
        private ModelStatisticsPanel modelStatisticsPanel;
        private boolean editCovariancesAsCorrelations;
        private boolean editIntercepts;
        private JTabbedPane tabbedPane;
        private String graphicalEditorTitle = "Graphical Editor";
        private String tabularEditorTitle = "Tabular Editor";
        private boolean editable = true;
        private JCheckBoxMenuItem meansItem;
        private JCheckBoxMenuItem interceptsItem;
        private JMenuItem errorTerms;

        public OneEditor(SemEstimatorWrapper wrapper, String graphicalEditorTitle, String tabularEditorTitle, TabbedPaneDefault tabbedPaneDefault) {
            this.semImWrapper = wrapper;
            this.graphicalEditorTitle = graphicalEditorTitle;
            this.tabularEditorTitle = tabularEditorTitle;
            this.displaySemIm(graphicalEditorTitle, tabularEditorTitle, tabbedPaneDefault);
        }

        private void displaySemIm(String graphicalEditorTitle, String tabularEditorTitle, TabbedPaneDefault tabbedPaneDefault) {
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.setTabLayoutPolicy(1);
            this.setLayout(new BorderLayout());
            if (tabbedPaneDefault == TabbedPaneDefault.GRAPHICAL) {
                this.tabbedPane.add(graphicalEditorTitle, this.graphicalEditor());
                this.tabbedPane.add(tabularEditorTitle, this.tabularEditor());
                this.tabbedPane.add("Implied Matrices", this.impliedMatricesPanel());
                this.tabbedPane.add("Model Statistics", this.modelStatisticsPanel());
            } else if (tabbedPaneDefault == TabbedPaneDefault.TABULAR) {
                this.tabbedPane.add(tabularEditorTitle, this.tabularEditor());
                this.tabbedPane.add(graphicalEditorTitle, this.graphicalEditor());
                this.tabbedPane.add("Implied Matrices", this.impliedMatricesPanel());
                this.tabbedPane.add("Model Statistics", this.modelStatisticsPanel());
            } else if (tabbedPaneDefault == TabbedPaneDefault.COVMATRIX) {
                this.tabbedPane.add("Implied Matrices", this.impliedMatricesPanel());
                this.tabbedPane.add("Model Statistics", this.modelStatisticsPanel());
                this.tabbedPane.add(graphicalEditorTitle, this.graphicalEditor());
                this.tabbedPane.add(tabularEditorTitle, this.tabularEditor());
            } else if (tabbedPaneDefault == TabbedPaneDefault.STATS) {
                this.tabbedPane.add("Model Statistics", this.modelStatisticsPanel());
                this.tabbedPane.add(graphicalEditorTitle, this.graphicalEditor());
                this.tabbedPane.add(tabularEditorTitle, this.tabularEditor());
                this.tabbedPane.add("Implied Matrices", this.impliedMatricesPanel());
            }
            SemEstimatorEditor.this.targetPanel.add((Component)this.tabbedPane, "Center");
            JMenuBar menuBar = new JMenuBar();
            JMenu file = new JMenu("File");
            menuBar.add(file);
            JMenuItem saveSemAsXml = new JMenuItem("Save SEM as XML");
            file.add(saveSemAsXml);
            file.add(this.getCopyMatrixMenuItem());
            file.addSeparator();
            file.add(new SaveComponentImage(this.semImGraphicalEditor.getWorkbench(), "Save Graph Image..."));
            saveSemAsXml.addActionListener(e -> {
                try {
                    File outfile = EditorUtils.getSaveFile("semIm", "xml", SemEstimatorEditor.this.getComp(), false, "Save SEM IM as XML...");
                    SemIm im = (SemIm)SemEstimatorEditor.this.oneEditorPanel.getSemIm();
                    FileOutputStream out = new FileOutputStream(outfile);
                    Element element = SemXmlRenderer.getElement(im);
                    Document document = new Document(element);
                    Serializer serializer = new Serializer(out);
                    serializer.setLineSeparator("\n");
                    serializer.setIndent(2);
                    serializer.write(document);
                    out.close();
                }
                catch (IOException ioException) {
                    ioException.printStackTrace();
                }
            });
            JCheckBoxMenuItem covariances = new JCheckBoxMenuItem("Show standard deviations");
            JCheckBoxMenuItem correlations = new JCheckBoxMenuItem("Show correlations");
            ButtonGroup correlationGroup = new ButtonGroup();
            correlationGroup.add(covariances);
            correlationGroup.add(correlations);
            covariances.setSelected(true);
            covariances.addActionListener(e -> this.setEditCovariancesAsCorrelations(false));
            correlations.addActionListener(e -> this.setEditCovariancesAsCorrelations(true));
            this.errorTerms = new JMenuItem();
            if (this.getSemGraph().isShowErrorTerms()) {
                this.errorTerms.setText("Hide Error Terms");
            } else {
                this.errorTerms.setText("Show Error Terms");
            }
            this.errorTerms.addActionListener(e -> {
                JMenuItem menuItem = (JMenuItem)e.getSource();
                if ("Hide Error Terms".equals(menuItem.getText())) {
                    menuItem.setText("Show Error Terms");
                    this.getSemGraph().setShowErrorTerms(false);
                    this.graphicalEditor().resetLabels();
                } else if ("Show Error Terms".equals(menuItem.getText())) {
                    menuItem.setText("Hide Error Terms");
                    this.getSemGraph().setShowErrorTerms(true);
                    this.graphicalEditor().resetLabels();
                }
            });
            this.meansItem = new JCheckBoxMenuItem("Show means");
            this.interceptsItem = new JCheckBoxMenuItem("Show intercepts");
            ButtonGroup meansGroup = new ButtonGroup();
            meansGroup.add(this.meansItem);
            meansGroup.add(this.interceptsItem);
            this.meansItem.setSelected(true);
            this.meansItem.addActionListener(e -> {
                if (this.meansItem.isSelected()) {
                    this.setEditIntercepts(false);
                }
            });
            this.interceptsItem.addActionListener(e -> {
                if (this.interceptsItem.isSelected()) {
                    this.setEditIntercepts(true);
                }
            });
            JMenu params = new JMenu("Parameters");
            params.add(this.errorTerms);
            params.addSeparator();
            params.add(covariances);
            params.add(correlations);
            params.addSeparator();
            if (!SemEstimatorEditor.this.wrapper.getEstimatedSemIm().isCyclic()) {
                params.add(this.meansItem);
                params.add(this.interceptsItem);
            }
            menuBar.add(params);
            menuBar.add(new LayoutMenu(this));
            SemEstimatorEditor.this.targetPanel.add((Component)menuBar, "North");
            this.add((Component)this.tabbedPane, "Center");
            this.add((Component)menuBar, "North");
        }

        @Override
        public Graph getGraph() {
            return this.semImGraphicalEditor.getWorkbench().getGraph();
        }

        @Override
        public Map<Edge, Object> getModelEdgesToDisplay() {
            return this.getWorkbench().getModelEdgesToDisplay();
        }

        @Override
        public Map<Node, Object> getModelNodesToDisplay() {
            return this.getWorkbench().getModelNodesToDisplay();
        }

        @Override
        public Knowledge getKnowledge() {
            return this.semImGraphicalEditor.getWorkbench().getKnowledge();
        }

        @Override
        public Graph getSourceGraph() {
            return this.semImGraphicalEditor.getWorkbench().getSourceGraph();
        }

        @Override
        public void layoutByGraph(Graph graph) {
            SemGraph _graph = (SemGraph)this.semImGraphicalEditor.getWorkbench().getGraph();
            _graph.setShowErrorTerms(false);
            this.semImGraphicalEditor.getWorkbench().layoutByGraph(graph);
            _graph.resetErrorPositions();
            this.errorTerms.setText("Show Error Terms");
        }

        @Override
        public void layoutByKnowledge() {
            SemGraph _graph = (SemGraph)this.semImGraphicalEditor.getWorkbench().getGraph();
            _graph.setShowErrorTerms(false);
            this.semImGraphicalEditor.getWorkbench().layoutByKnowledge();
            _graph.resetErrorPositions();
            this.errorTerms.setText("Show Error Terms");
        }

        private void checkForUnmeasuredLatents(ISemIm semIm) {
            List<Node> unmeasuredLatents = semIm.listUnmeasuredLatents();
            if (!unmeasuredLatents.isEmpty()) {
                StringBuilder buf = new StringBuilder();
                buf.append("This model has the following latent(s) without measured children: ");
                for (int i = 0; i < unmeasuredLatents.size(); ++i) {
                    buf.append(unmeasuredLatents.get(i));
                    if (i >= unmeasuredLatents.size() - 1) continue;
                    buf.append(", ");
                }
                buf.append(".\nAs a result, standard errors for non-mean parameters cannot be calculated.");
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), buf.toString(), "FYI", 1);
            }
        }

        private SemGraph getSemGraph() {
            return this.getSemIm().getSemPm().getGraph();
        }

        public int getTabSelectionIndex() {
            return this.tabbedPane.getSelectedIndex();
        }

        public int getMatrixSelection() {
            return this.impliedMatricesPanel().getMatrixSelection();
        }

        public GraphWorkbench getWorkbench() {
            return this.semImGraphicalEditor.getWorkbench();
        }

        private JMenuItem getCopyMatrixMenuItem() {
            JMenuItem item = new JMenuItem("Copy Implied Covariance Matrix");
            item.addActionListener(e -> {
                String s = this.impliedMatricesPanel.getMatrixInTabDelimitedForm();
                Clipboard board = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection selection = new StringSelection(s);
                board.setContents(selection, selection);
            });
            return item;
        }

        private ISemIm getSemIm() {
            return this.semImWrapper.getEstimatedSemIm();
        }

        private SemImGraphicalEditor graphicalEditor() {
            if (this.semImGraphicalEditor == null) {
                this.semImGraphicalEditor = new SemImGraphicalEditor(SemEstimatorEditor.this.wrapper, this, this.maxFreeParamsForStatistics);
                this.semImGraphicalEditor.addPropertyChangeListener(evt -> SemEstimatorEditor.this.firePropertyChange(evt.getPropertyName(), null, null));
            }
            return this.semImGraphicalEditor;
        }

        private SemImTabularEditor tabularEditor() {
            if (this.semImTabularEditor == null) {
                this.semImTabularEditor = new SemImTabularEditor(SemEstimatorEditor.this.wrapper, this, this.maxFreeParamsForStatistics);
            }
            this.semImTabularEditor.addPropertyChangeListener(evt -> SemEstimatorEditor.this.firePropertyChange(evt.getPropertyName(), null, null));
            return this.semImTabularEditor;
        }

        private ImpliedMatricesPanel impliedMatricesPanel() {
            if (this.impliedMatricesPanel == null) {
                int matrixSelection = 0;
                this.impliedMatricesPanel = new ImpliedMatricesPanel(SemEstimatorEditor.this.wrapper, matrixSelection);
            }
            return this.impliedMatricesPanel;
        }

        private ModelStatisticsPanel modelStatisticsPanel() {
            if (this.modelStatisticsPanel == null) {
                this.modelStatisticsPanel = new ModelStatisticsPanel(SemEstimatorEditor.this.wrapper);
            }
            return this.modelStatisticsPanel;
        }

        public boolean isEditCovariancesAsCorrelations() {
            return this.editCovariancesAsCorrelations;
        }

        private void setEditCovariancesAsCorrelations(boolean editCovariancesAsCorrelations) {
            this.editCovariancesAsCorrelations = editCovariancesAsCorrelations;
            this.graphicalEditor().resetLabels();
            this.tabularEditor().getTableModel().fireTableDataChanged();
        }

        public boolean isEditIntercepts() {
            return this.editIntercepts;
        }

        private void setEditIntercepts(boolean editIntercepts) {
            this.editIntercepts = editIntercepts;
            this.graphicalEditor().resetLabels();
            this.tabularEditor().getTableModel().fireTableDataChanged();
            this.meansItem.setSelected(!editIntercepts);
            this.interceptsItem.setSelected(editIntercepts);
        }

        private String getGraphicalEditorTitle() {
            return this.graphicalEditorTitle;
        }

        private String getTabularEditorTitle() {
            return this.tabularEditorTitle;
        }

        public boolean isEditable() {
            return this.editable;
        }

        public void setEditable(boolean editable) {
            this.graphicalEditor().setEditable(editable);
            this.tabularEditor().setEditable(editable);
            this.editable = editable;
        }
    }

    public static enum TabbedPaneDefault {
        GRAPHICAL,
        TABULAR,
        COVMATRIX,
        tabbedPanedDefault,
        STATS;

    }

    static final class ImpliedCovTable
    extends AbstractTableModel {
        private static final long serialVersionUID = -8269181589527893805L;
        private final boolean measured;
        private final boolean correlations;
        private final NumberFormat nf;
        private final SemEstimatorWrapper wrapper;
        private double[][] matrix;

        public ImpliedCovTable(SemEstimatorWrapper wrapper, boolean measured, boolean correlations) {
            this.wrapper = wrapper;
            this.measured = measured;
            this.correlations = correlations;
            this.nf = NumberFormatUtil.getInstance().getNumberFormat();
            if (this.measured() && this.covariances()) {
                this.matrix = this.getSemIm().getImplCovarMeas().toArray();
            } else if (this.measured() && !this.covariances()) {
                this.matrix = this.corr(this.getSemIm().getImplCovarMeas().toArray());
            } else if (!this.measured() && this.covariances()) {
                Matrix implCovarC = this.getSemIm().getImplCovar(false);
                this.matrix = implCovarC.toArray();
            } else if (!this.measured() && !this.covariances()) {
                Matrix implCovarC = this.getSemIm().getImplCovar(false);
                this.matrix = this.corr(implCovarC.toArray());
            }
        }

        @Override
        public int getRowCount() {
            if (this.measured()) {
                return this.getSemIm().getMeasuredNodes().size() + 1;
            }
            return this.getSemIm().getVariableNodes().size() + 1;
        }

        @Override
        public int getColumnCount() {
            if (this.measured()) {
                return this.getSemIm().getMeasuredNodes().size() + 1;
            }
            return this.getSemIm().getVariableNodes().size() + 1;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "";
            }
            if (this.measured()) {
                List<Node> nodes = this.getSemIm().getMeasuredNodes();
                Node node = nodes.get(columnIndex - 1);
                return node.getName();
            }
            List<Node> nodes = this.getSemIm().getVariableNodes();
            Node node = nodes.get(columnIndex - 1);
            return node.getName();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex == 0) {
                return this.getColumnName(columnIndex);
            }
            if (columnIndex == 0) {
                return this.getColumnName(rowIndex);
            }
            if (rowIndex < columnIndex) {
                return null;
            }
            return this.nf.format(this.matrix[rowIndex - 1][columnIndex - 1]);
        }

        private boolean covariances() {
            return !this.correlations();
        }

        private double[][] corr(double[][] implCovar) {
            int i;
            int length = implCovar.length;
            double[][] corr = new double[length][length];
            for (i = 1; i < length; ++i) {
                for (int j = 0; j < i; ++j) {
                    double d1 = implCovar[i][j];
                    double d2 = implCovar[i][i];
                    double d3 = implCovar[j][j];
                    double d4 = d1 / FastMath.pow(d2 * d3, 0.5);
                    if (!(d4 <= 1.0) && !Double.isNaN(d4)) {
                        throw new IllegalArgumentException("Off-diagonal element at (" + i + ", " + j + ") cannot be converted to correlation: " + d1 + " <= FastMath.pow(" + d2 + " * " + d3 + ", 0.5)");
                    }
                    corr[i][j] = d4;
                }
            }
            for (i = 0; i < length; ++i) {
                corr[i][i] = 1.0;
            }
            return corr;
        }

        private boolean measured() {
            return this.measured;
        }

        private boolean correlations() {
            return this.correlations;
        }

        private ISemIm getSemIm() {
            return this.wrapper.getEstimatedSemIm();
        }
    }

    static final class ModelStatisticsPanel
    extends JTextArea {
        private static final long serialVersionUID = -9096723049787232471L;
        private final NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        private final SemEstimatorWrapper wrapper;

        public ModelStatisticsPanel(SemEstimatorWrapper wrapper) {
            this.wrapper = wrapper;
            this.reset();
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent e) {
                    this.reset();
                }
            });
        }

        private void reset() {
            double modelPValue;
            double modelDof;
            double modelChiSquare;
            this.setText("");
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            SemPm semPm = this.semIm().getSemPm();
            List<Node> variables = semPm.getVariableNodes();
            boolean containsLatent = false;
            for (Node node : variables) {
                if (node.getNodeType() != NodeType.LATENT) continue;
                containsLatent = true;
                break;
            }
            try {
                modelChiSquare = this.semIm().getChiSquare();
                modelDof = this.semIm().getSemPm().getDof();
                modelPValue = this.semIm().getPValue();
            }
            catch (Exception exception) {
                this.append("Model statistics not available.");
                return;
            }
            if (containsLatent) {
                this.append("\nEstimated degrees of Freedom = " + (int)modelDof);
            } else {
                this.append("\nDegrees of Freedom = " + (int)modelDof);
            }
            this.append("\nChi Square = " + this.nf.format(modelChiSquare));
            if (modelDof >= 0.0) {
                String pValueString = modelPValue > 0.001 ? this.nf.format(modelPValue) : new DecimalFormat("0.0000E0").format(modelPValue);
                this.append("\nP Value = " + (Double.isNaN(modelPValue) || modelDof == 0.0 ? "undefined" : pValueString));
                this.append("\nBIC Score = " + this.nf.format(this.semIm().getBicScore()));
                this.append("\nCFI = " + this.nf.format(this.semIm().getCfi()));
                this.append("\nRMSEA = " + this.nf.format(this.semIm().getRmsea()));
            } else {
                int numToFix = (int)FastMath.abs(modelDof);
                this.append("\n\nA SEM with negative degrees of freedom is underidentified, \nand other model statistics are meaningless.  Please increase \nthe degrees of freedom to 0 or above by fixing at least " + numToFix + " parameter" + (numToFix == 1 ? "." : "s."));
            }
            this.append("\n\nThe above chi square test assumes that the maximum likelihood function over the measured variables has been minimized. Under that assumption, the null hypothesis for the test is that the population covariance matrix over all of the measured variables is equal to the estimated covariance matrix over all of the measured variables written as a function of the free model parameters--that is, the unfixed parameters for each directed edge (the linear coefficient for that edge), each exogenous variable (the variance for the error term for that variable), and each bidirected edge (the covariance for the exogenous variables it connects).  The model is explained in Bollen, Structural Equations with Latent Variable, 110. Degrees of freedom are calculated as m (m + 1) / 2 - d, where d is the number of linear coefficients, variance terms, and error covariance terms that are not fixed in the model. For latent models, the degrees of freedom are termed 'estimated' since extra contraints (e.g. pentad constraints) are not taken into account.");
        }

        private ISemIm semIm() {
            return this.wrapper.getEstimatedSemIm();
        }
    }

    final class SemImGraphicalEditor
    extends JPanel {
        private static final long serialVersionUID = 6469399368858967087L;
        private final Font SMALL_FONT = new Font("Dialog", 0, 10);
        private final SemEstimatorWrapper wrapper;
        private final int maxFreeParamsForStatistics;
        private final Color LIGHT_YELLOW = new Color(255, 255, 215);
        private GraphWorkbench workbench;
        private Object lastEditedObject;
        private int savedTooltipDelay;
        private final OneEditor editor;
        private boolean editable = true;
        private Container dialog;

        public SemImGraphicalEditor(SemEstimatorWrapper semImWrapper, OneEditor editor, int maxFreeParamsForStatistics) {
            this.wrapper = semImWrapper;
            this.editor = editor;
            this.maxFreeParamsForStatistics = maxFreeParamsForStatistics;
            this.setLayout(new BorderLayout());
            JScrollPane scroll = new JScrollPane(this.workbench());
            this.add((Component)scroll, "Center");
            this.setBorder(new TitledBorder("Click parameter values to edit"));
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            this.setSavedTooltipDelay(toolTipManager.getInitialDelay());
            this.workbench().addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent e) {
                    SemImGraphicalEditor.this.resetLabels();
                    ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
                    toolTipManager.setInitialDelay(100);
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                    ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
                    toolTipManager.setInitialDelay(SemImGraphicalEditor.this.getSavedTooltipDelay());
                }
            });
            this.workbench().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (SemImGraphicalEditor.this.workbench().contains(e.getPoint())) {
                        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
                        toolTipManager.setInitialDelay(100);
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (!SemImGraphicalEditor.this.workbench().contains(e.getPoint())) {
                        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
                        toolTipManager.setInitialDelay(SemImGraphicalEditor.this.getSavedTooltipDelay());
                    }
                }
            });
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent e) {
                    SemImGraphicalEditor.this.resetLabels();
                }
            });
        }

        private void beginEdgeEdit(Edge edge) {
            this.finishEdit();
            if (!this.isEditable()) {
                return;
            }
            Parameter parameter = this.getEdgeParameter(edge);
            double d = this.semIm().getParamValue(parameter);
            if (this.editor.isEditCovariancesAsCorrelations() && parameter.getType() == ParamType.COVAR) {
                Node nodeA = parameter.getNodeA();
                Node nodeB = parameter.getNodeB();
                double varA = this.semIm().getParamValue(nodeA, nodeA);
                double varB = this.semIm().getParamValue(nodeB, nodeB);
                d /= FastMath.sqrt(varA * varB);
            }
            final DoubleTextField field = new DoubleTextField(d, 10, NumberFormatUtil.getInstance().getNumberFormat());
            field.setFilter((value, oldValue) -> {
                try {
                    this.setEdgeValue(edge, "" + value);
                    return value;
                }
                catch (IllegalArgumentException e) {
                    return oldValue;
                }
            });
            Box box = Box.createHorizontalBox();
            box.add(Box.createHorizontalGlue());
            box.add(new JLabel("New value: "));
            box.add(field);
            box.add(Box.createHorizontalGlue());
            field.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorMoved(AncestorEvent ancestorEvent) {
                }

                @Override
                public void ancestorRemoved(AncestorEvent ancestorEvent) {
                }

                @Override
                public void ancestorAdded(AncestorEvent ancestorEvent) {
                    Container ancestor = ancestorEvent.getAncestor();
                    if (ancestor instanceof JDialog) {
                        SemImGraphicalEditor.this.dialog = ancestor;
                    }
                    field.selectAll();
                    field.grabFocus();
                }
            });
            field.addActionListener(e -> {
                if (this.dialog != null) {
                    this.dialog.setVisible(false);
                }
            });
            JOptionPane.showMessageDialog(this.workbench.getComponent(edge), box, "Coefficient for " + edge, -1);
        }

        private void beginNodeEdit(Node node) {
            double d;
            this.finishEdit();
            if (!this.isEditable()) {
                return;
            }
            Parameter parameter = this.getNodeParameter(node);
            if (this.editor.isEditCovariancesAsCorrelations() && parameter.getType() == ParamType.VAR) {
                return;
            }
            String postfix = "";
            if (parameter.getType() == ParamType.MEAN) {
                if (this.editor.isEditIntercepts()) {
                    d = this.semIm().getIntercept(node);
                    String prefix = "B0_" + node.getName() + " = ";
                } else {
                    d = this.semIm().getMean(node);
                    String prefix = "Mean(" + node.getName() + ") = ";
                }
            } else {
                d = FastMath.sqrt(this.semIm().getParamValue(parameter));
                String prefix = node.getName() + " ~ N(0,";
                postfix = ")";
            }
            DoubleTextField field = new DoubleTextField(d, 10, NumberFormatUtil.getInstance().getNumberFormat());
            field.setFilter((value, oldValue) -> {
                try {
                    this.setNodeValue(node, "" + value);
                    return value;
                }
                catch (IllegalArgumentException e) {
                    return oldValue;
                }
            });
            Box box = Box.createHorizontalBox();
            box.add(Box.createHorizontalGlue());
            box.add(new JLabel("New value: "));
            box.add(field);
            box.add(Box.createHorizontalGlue());
            field.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorMoved(AncestorEvent ancestorEvent) {
                }

                @Override
                public void ancestorRemoved(AncestorEvent ancestorEvent) {
                }

                @Override
                public void ancestorAdded(AncestorEvent ancestorEvent) {
                    Container ancestor = ancestorEvent.getAncestor();
                    if (ancestor instanceof JDialog) {
                        SemImGraphicalEditor.this.dialog = ancestor;
                    }
                }
            });
            field.addActionListener(e -> {
                if (this.dialog != null) {
                    this.dialog.setVisible(false);
                }
            });
            String s = parameter.getType() == ParamType.MEAN ? (this.editor.isEditIntercepts() ? "Intercept for " + node : "Mean for " + node) : "Standard Deviation for " + node;
            JOptionPane.showMessageDialog(this.workbench.getComponent(node), box, s, -1);
        }

        private void finishEdit() {
            if (this.lastEditedObject() != null) {
                this.resetLabels();
            }
        }

        private ISemIm semIm() {
            return this.wrapper.getEstimatedSemIm();
        }

        private Graph graph() {
            return this.wrapper.getEstimatedSemIm().getSemPm().getGraph();
        }

        private GraphWorkbench workbench() {
            if (this.getWorkbench() == null) {
                this.workbench = new GraphWorkbench(this.graph());
                this.workbench.enableEditing(false);
                this.getWorkbench().setAllowDoubleClickActions(false);
                this.getWorkbench().addPropertyChangeListener(evt -> {
                    if ("BackgroundClicked".equals(evt.getPropertyName())) {
                        this.finishEdit();
                    }
                });
                this.resetLabels();
                this.addMouseListenerToGraphNodesMeasured();
            }
            return this.getWorkbench();
        }

        private void setLastEditedObject(Object o) {
            this.lastEditedObject = o;
        }

        private Object lastEditedObject() {
            return this.lastEditedObject;
        }

        public void resetLabels() {
            Matrix implCovar = this.semIm().getImplCovar(false);
            for (Edge o : this.graph().getEdges()) {
                this.resetEdgeLabel(o, implCovar);
            }
            List<Node> nodes = this.graph().getNodes();
            for (Node node : nodes) {
                this.resetNodeLabel(node, implCovar);
            }
            this.workbench().repaint();
        }

        private void resetEdgeLabel(Edge edge, Matrix implCovar) {
            Parameter parameter = this.getEdgeParameter(edge);
            if (parameter != null) {
                double pValue;
                double tValue;
                double standardError;
                double val = this.semIm().getParamValue(parameter);
                try {
                    standardError = this.semIm().getStandardError(parameter, this.maxFreeParamsForStatistics);
                }
                catch (Exception exception) {
                    standardError = Double.NaN;
                }
                try {
                    tValue = this.semIm().getTValue(parameter, this.maxFreeParamsForStatistics);
                }
                catch (Exception exception) {
                    tValue = Double.NaN;
                }
                try {
                    pValue = this.semIm().getPValue(parameter, this.maxFreeParamsForStatistics);
                }
                catch (Exception exception) {
                    pValue = Double.NaN;
                }
                if (this.editor.isEditCovariancesAsCorrelations() && parameter.getType() == ParamType.COVAR) {
                    Node nodeA = edge.getNode1();
                    Node nodeB = edge.getNode2();
                    double varA = this.semIm().getVariance(nodeA, implCovar);
                    double varB = this.semIm().getVariance(nodeB, implCovar);
                    val /= FastMath.sqrt(varA * varB);
                }
                JLabel label = new JLabel();
                if (parameter.getType() == ParamType.COVAR) {
                    label.setForeground(Color.GREEN.darker().darker());
                }
                if (parameter.isFixed()) {
                    label.setForeground(Color.RED);
                }
                label.setBackground(Color.white);
                label.setOpaque(true);
                label.setFont(this.SMALL_FONT);
                label.setText(" " + this.asString(val) + " ");
                label.setToolTipText(parameter.getName() + " = " + this.asString(val));
                label.addMouseListener(new EdgeMouseListener(edge, this));
                if (!Double.isNaN(standardError) && this.semIm().isEstimated()) {
                    label.setToolTipText("SE=" + this.asString(standardError) + ", T=" + this.asString(tValue) + ", P=" + this.asString(pValue));
                }
                this.workbench().setEdgeLabel(edge, label);
            } else {
                this.workbench().setEdgeLabel(edge, null);
            }
        }

        private void resetNodeLabel(Node node, Matrix implCovar) {
            if (!this.semIm().getSemPm().getGraph().isParameterizable(node)) {
                return;
            }
            Parameter parameter = this.semIm().getSemPm().getVarianceParameter(node);
            double meanOrIntercept = Double.NaN;
            JLabel label = new JLabel();
            label.setBackground(Color.WHITE);
            label.addMouseListener(new NodeMouseListener(node, this));
            label.setFont(this.SMALL_FONT);
            String tooltip = "";
            NodeType nodeType = node.getNodeType();
            if (nodeType == NodeType.MEASURED || nodeType == NodeType.LATENT) {
                meanOrIntercept = this.editor.isEditIntercepts() ? this.semIm().getIntercept(node) : this.semIm().getMean(node);
            }
            double stdDev = this.semIm().getStdDev(node, implCovar);
            if (this.editor.isEditCovariancesAsCorrelations() && !Double.isNaN(stdDev)) {
                stdDev = 1.0;
            }
            if (parameter != null) {
                double standardError = this.semIm().getStandardError(parameter, this.maxFreeParamsForStatistics);
                double tValue = this.semIm().getTValue(parameter, this.maxFreeParamsForStatistics);
                double pValue = this.semIm().getPValue(parameter, this.maxFreeParamsForStatistics);
                tooltip = "SE=" + this.asString(standardError) + ", T=" + this.asString(tValue) + ", P=" + this.asString(pValue);
            }
            if (!Double.isNaN(meanOrIntercept)) {
                label.setForeground(Color.GREEN.darker());
                label.setText(this.asString(meanOrIntercept));
                tooltip = this.editor.isEditIntercepts() ? "<html>B0_" + node.getName() + " = " + this.asString(meanOrIntercept) + "</html>" : "<html>Mean(" + node.getName() + ") = " + this.asString(meanOrIntercept) + "</html>";
            } else if (!this.editor.isEditCovariancesAsCorrelations() && !Double.isNaN(stdDev)) {
                label.setForeground(Color.BLUE);
                label.setText(this.asString(stdDev));
                tooltip = "<html>" + node.getName() + " ~ N(0," + this.asString(stdDev) + ")<br><br>" + tooltip + "</html>";
            } else if (this.editor.isEditCovariancesAsCorrelations()) {
                label.setForeground(Color.GRAY);
                label.setText(this.asString(stdDev));
            }
            if (parameter != null && parameter.isFixed()) {
                label.setForeground(Color.RED);
            }
            label.setToolTipText(tooltip);
            if (nodeType == NodeType.ERROR) {
                label.setOpaque(false);
                this.workbench().setNodeLabel(node, label, -10, -10);
            } else {
                label.setOpaque(false);
                this.workbench().setNodeLabel(node, label, 0, 0);
            }
        }

        private Parameter getNodeParameter(Node node) {
            Parameter parameter = this.semIm().getSemPm().getMeanParameter(node);
            if (parameter == null) {
                parameter = this.semIm().getSemPm().getVarianceParameter(node);
            }
            return parameter;
        }

        private Parameter getEdgeParameter(Edge edge) {
            if (Edges.isDirectedEdge(edge)) {
                return this.semIm().getSemPm().getCoefficientParameter(edge.getNode1(), edge.getNode2());
            }
            if (Edges.isBidirectedEdge(edge)) {
                return this.semIm().getSemPm().getCovarianceParameter(edge.getNode1(), edge.getNode2());
            }
            throw new IllegalArgumentException("This is not a directed or bidirected edge: " + edge);
        }

        private void setEdgeValue(Edge edge, String text) {
            try {
                Parameter parameter = this.getEdgeParameter(edge);
                double d = Double.parseDouble(text);
                if (this.editor.isEditCovariancesAsCorrelations() && parameter.getType() == ParamType.COVAR) {
                    Node nodeA = edge.getNode1();
                    Node nodeB = edge.getNode2();
                    Matrix implCovar = this.semIm().getImplCovar(false);
                    double varA = this.semIm().getVariance(nodeA, implCovar);
                    double varB = this.semIm().getVariance(nodeB, implCovar);
                    this.semIm().setParamValue(parameter, d *= FastMath.sqrt(varA * varB));
                    this.firePropertyChange("modelChanged", null, null);
                } else if (!this.editor.isEditCovariancesAsCorrelations() && parameter.getType() == ParamType.COVAR) {
                    this.semIm().setParamValue(parameter, d);
                    this.firePropertyChange("modelChanged", null, null);
                } else if (parameter.getType() == ParamType.COEF) {
                    Node x = parameter.getNodeA();
                    Node y = parameter.getNodeB();
                    this.semIm().setEdgeCoef(x, y, d);
                    if (this.editor.isEditIntercepts()) {
                        double intercept = this.semIm().getIntercept(y);
                        this.semIm().setIntercept(y, intercept);
                    }
                    this.firePropertyChange("modelChanged", null, null);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.resetLabels();
            this.workbench().repaint();
            this.setLastEditedObject(null);
        }

        private void setNodeValue(Node node, String text) {
            try {
                Parameter parameter = this.getNodeParameter(node);
                double d = Double.parseDouble(text);
                if (parameter.getType() == ParamType.VAR && d >= 0.0) {
                    this.semIm().setParamValue(node, node, d * d);
                    this.firePropertyChange("modelChanged", null, null);
                } else if (parameter.getType() == ParamType.MEAN) {
                    if (this.editor.isEditIntercepts()) {
                        this.semIm().setIntercept(node, d);
                    } else {
                        this.semIm().setMean(node, d);
                    }
                    this.firePropertyChange("modelChanged", null, null);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
            this.resetLabels();
            this.workbench().repaint();
            this.setLastEditedObject(null);
        }

        private int getSavedTooltipDelay() {
            return this.savedTooltipDelay;
        }

        private void setSavedTooltipDelay(int savedTooltipDelay) {
            if (this.savedTooltipDelay == 0) {
                this.savedTooltipDelay = savedTooltipDelay;
            }
        }

        private String asString(double value) {
            NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
            if (Double.isNaN(value)) {
                return " * ";
            }
            return nf.format(value);
        }

        private void addMouseListenerToGraphNodesMeasured() {
            List<Node> nodes = this.graph().getNodes();
            for (Node node : nodes) {
                Object displayNode = this.workbench().getModelNodesToDisplay().get(node);
                if (!(displayNode instanceof GraphNodeMeasured)) continue;
                DisplayNode _displayNode = (DisplayNode)displayNode;
                _displayNode.setToolTipText(this.getEquationOfNode(_displayNode.getModelNode()));
            }
        }

        private String getEquationOfNode(Node node) {
            String eqn = node.getName() + " = B0_" + node.getName();
            SemGraph semGraph = this.semIm().getSemPm().getGraph();
            List<Node> parentNodes = semGraph.getParents(node);
            for (Node parentNodeObj : parentNodes) {
                Node parentNode = parentNodeObj;
                Parameter edgeParam = this.getEdgeParameter(semGraph.getDirectedEdge(parentNode, node));
                if (edgeParam == null) continue;
                eqn = eqn + " + " + edgeParam.getName() + "*" + parentNode;
            }
            eqn = eqn + " + " + this.semIm().getSemPm().getGraph().getExogenous(node);
            return eqn;
        }

        public GraphWorkbench getWorkbench() {
            return this.workbench;
        }

        private boolean isEditable() {
            return this.editable;
        }

        public void setEditable(boolean editable) {
            this.workbench().setAllowEdgeReorientations(editable);
            this.workbench().setAllowDoubleClickActions(editable);
            this.workbench().setAllowNodeEdgeSelection(editable);
            this.editable = editable;
        }

        final class EdgeMouseListener
        extends MouseAdapter {
            private final Edge edge;
            private final SemImGraphicalEditor editor;

            public EdgeMouseListener(Edge edge, SemImGraphicalEditor editor) {
                this.edge = edge;
                this.editor = editor;
            }

            private Edge getEdge() {
                return this.edge;
            }

            private SemImGraphicalEditor getEditor() {
                return this.editor;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                this.getEditor().beginEdgeEdit(this.getEdge());
            }
        }

        final class NodeMouseListener
        extends MouseAdapter {
            private final Node node;
            private final SemImGraphicalEditor editor;

            public NodeMouseListener(Node node, SemImGraphicalEditor editor) {
                this.node = node;
                this.editor = editor;
            }

            private Node getNode() {
                return this.node;
            }

            private SemImGraphicalEditor getEditor() {
                return this.editor;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                this.getEditor().beginNodeEdit(this.getNode());
            }
        }

        final class NodeActionListener
        implements ActionListener {
            private final SemImGraphicalEditor editor;
            private final Node node;

            public NodeActionListener(SemImGraphicalEditor editor, Node node) {
                this.editor = editor;
                this.node = node;
            }

            @Override
            public void actionPerformed(ActionEvent ev) {
                DoubleTextField doubleTextField = (DoubleTextField)ev.getSource();
                String s = doubleTextField.getText();
                this.getEditor().setNodeValue(this.getNode(), s);
            }

            private SemImGraphicalEditor getEditor() {
                return this.editor;
            }

            private Node getNode() {
                return this.node;
            }
        }

        final class EdgeActionListener
        implements ActionListener {
            private final SemImGraphicalEditor editor;
            private final Edge edge;

            public EdgeActionListener(SemImGraphicalEditor editor, Edge edge) {
                this.editor = editor;
                this.edge = edge;
            }

            @Override
            public void actionPerformed(ActionEvent ev) {
                DoubleTextField doubleTextField = (DoubleTextField)ev.getSource();
                String s = doubleTextField.getText();
                this.getEditor().setEdgeValue(this.getEdge(), s);
            }

            private SemImGraphicalEditor getEditor() {
                return this.editor;
            }

            private Edge getEdge() {
                return this.edge;
            }
        }
    }

    final class ParamTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 2210883212769846304L;
        private final NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        private final SemEstimatorWrapper wrapper;
        private final OneEditor editor;
        private int maxFreeParamsForStatistics = 50;
        private boolean editable = true;

        public ParamTableModel(SemEstimatorWrapper wrapper, OneEditor editor, int maxFreeParamsForStatistics) {
            this.wrapper = wrapper;
            if (maxFreeParamsForStatistics < 0) {
                throw new IllegalArgumentException();
            }
            this.maxFreeParamsForStatistics = maxFreeParamsForStatistics;
            this.editor = editor;
        }

        @Override
        public int getRowCount() {
            int numNodes = this.semIm().getVariableNodes().size();
            return this.semIm().getNumFreeParams() + this.semIm().getFixedParameters().size() + numNodes;
        }

        @Override
        public int getColumnCount() {
            return 7;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "From";
                }
                case 1: {
                    return "To";
                }
                case 2: {
                    return "Type";
                }
                case 3: {
                    return "Value";
                }
                case 4: {
                    return "SE";
                }
                case 5: {
                    return "T";
                }
                case 6: {
                    return "P";
                }
            }
            return null;
        }

        @Override
        public Object getValueAt(int row, int column) {
            List<Node> nodes = this.semIm().getVariableNodes();
            ArrayList<Parameter> parameters = new ArrayList<Parameter>(this.semIm().getFreeParameters());
            parameters.addAll(this.semIm().getFixedParameters());
            int numParams = this.semIm().getNumFreeParams() + this.semIm().getFixedParameters().size();
            if (row < numParams) {
                Parameter parameter = (Parameter)parameters.get(row);
                switch (column) {
                    case 0: {
                        return parameter.getNodeA();
                    }
                    case 1: {
                        return parameter.getNodeB();
                    }
                    case 2: {
                        return this.typeString(parameter);
                    }
                    case 3: {
                        return this.asString(this.paramValue(parameter));
                    }
                    case 4: {
                        if (parameter.isFixed()) {
                            return "*";
                        }
                        return this.asString(this.semIm().getStandardError(parameter, this.maxFreeParamsForStatistics));
                    }
                    case 5: {
                        if (parameter.isFixed()) {
                            return "*";
                        }
                        return this.asString(this.semIm().getTValue(parameter, this.maxFreeParamsForStatistics));
                    }
                    case 6: {
                        if (parameter.isFixed()) {
                            return "*";
                        }
                        return this.asString(this.semIm().getPValue(parameter, this.maxFreeParamsForStatistics));
                    }
                }
            } else if (row < numParams + nodes.size()) {
                int index = row - numParams;
                Node node = this.semIm().getVariableNodes().get(index);
                int n = this.semIm().getSampleSize();
                int df = n - 1;
                double mean = this.semIm().getMean(node);
                double stdDev = this.semIm().getMeanStdDev(node);
                double stdErr = stdDev / FastMath.sqrt(n);
                double tValue = mean / stdErr;
                double p = 2.0 * (1.0 - ProbUtils.tCdf(FastMath.abs(tValue), df));
                switch (column) {
                    case 0: {
                        return nodes.get(index);
                    }
                    case 1: {
                        return nodes.get(index);
                    }
                    case 2: {
                        if (this.editor.isEditIntercepts()) {
                            return "Intercept";
                        }
                        return "Mean";
                    }
                    case 3: {
                        if (this.editor.isEditIntercepts()) {
                            double intercept = this.semIm().getIntercept(node);
                            return this.asString(intercept);
                        }
                        return this.asString(mean);
                    }
                    case 4: {
                        return this.asString(stdErr);
                    }
                    case 5: {
                        return this.asString(tValue);
                    }
                    case 6: {
                        return this.asString(p);
                    }
                }
            }
            return null;
        }

        private double paramValue(Parameter parameter) {
            double paramValue = this.semIm().getParamValue(parameter);
            if (this.editor.isEditCovariancesAsCorrelations()) {
                if (parameter.getType() == ParamType.VAR) {
                    paramValue = 1.0;
                }
                if (parameter.getType() == ParamType.COVAR) {
                    Node nodeA = parameter.getNodeA();
                    Node nodeB = parameter.getNodeB();
                    double varA = this.semIm().getParamValue(nodeA, nodeA);
                    double varB = this.semIm().getParamValue(nodeB, nodeB);
                    paramValue *= FastMath.sqrt(varA * varB);
                }
            } else if (parameter.getType() == ParamType.VAR) {
                paramValue = FastMath.sqrt(paramValue);
            }
            return paramValue;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return this.isEditable() && columnIndex == 3;
        }

        private boolean isEditable() {
            return this.editable;
        }

        public void setEditable(boolean editable) {
            this.editable = editable;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 3) {
                try {
                    double value = Double.parseDouble((String)aValue);
                    if (rowIndex < this.semIm().getNumFreeParams()) {
                        Parameter parameter = this.semIm().getFreeParameters().get(rowIndex);
                        if (parameter.getType() == ParamType.VAR) {
                            value *= value;
                            this.semIm().setErrVar(parameter.getNodeA(), value);
                        } else if (parameter.getType() == ParamType.COEF) {
                            Node x = parameter.getNodeA();
                            Node y = parameter.getNodeB();
                            this.semIm().setEdgeCoef(x, y, value);
                            double intercept = this.semIm().getIntercept(y);
                            if (this.editor.isEditIntercepts()) {
                                this.semIm().setIntercept(y, intercept);
                            }
                        }
                        this.editor.firePropertyChange("modelChanged", 0, 0);
                    } else {
                        int index = rowIndex - this.semIm().getNumFreeParams();
                        Node node = this.semIm().getVariableNodes().get(index);
                        if (this.semIm().getMean(this.semIm().getVariableNodes().get(index)) != value) {
                            if (this.editor.isEditIntercepts()) {
                                this.semIm().setIntercept(node, value);
                            } else {
                                this.semIm().setMean(node, value);
                            }
                            this.editor.firePropertyChange("modelChanged", 0, 0);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.fireTableDataChanged();
            }
        }

        private String asString(double value) {
            if (Double.isNaN(value)) {
                return " * ";
            }
            return this.nf.format(value);
        }

        private String typeString(Parameter parameter) {
            ParamType type = parameter.getType();
            if (type == ParamType.COEF) {
                return "Edge Coef.";
            }
            if (this.editor.isEditCovariancesAsCorrelations()) {
                if (type == ParamType.VAR) {
                    return "Correlation";
                }
                if (type == ParamType.COVAR) {
                    return "Correlation";
                }
            }
            if (type == ParamType.VAR) {
                return "Std. Dev.";
            }
            if (type == ParamType.COVAR) {
                return "Covariance";
            }
            throw new IllegalStateException("Unknown param type.");
        }

        private ISemIm semIm() {
            return this.wrapper.getEstimatedSemIm();
        }
    }

    final class SemImTabularEditor
    extends JPanel {
        private static final long serialVersionUID = -3652030288654100645L;
        private final ParamTableModel tableModel;
        private final SemEstimatorWrapper wrapper;
        private boolean editable = true;

        public SemImTabularEditor(SemEstimatorWrapper wrapper, OneEditor editor, int maxFreeParamsForStatistics) {
            this.wrapper = wrapper;
            this.setLayout(new BoxLayout(this, 1));
            if (this.semIm().isEstimated()) {
                this.setBorder(new TitledBorder("Null hypothesis for T and P is that the parameter is zero"));
            } else {
                this.setBorder(new TitledBorder("Click parameter values to edit"));
            }
            JTable table = new JTable(){
                private static final long serialVersionUID = -530774590911763214L;

                @Override
                public TableCellEditor getCellEditor(int row, int col) {
                    return new DataCellEditor();
                }
            };
            this.tableModel = new ParamTableModel(wrapper, editor, maxFreeParamsForStatistics);
            table.setModel(this.getTableModel());
            this.tableModel.addTableModelListener(e -> this.firePropertyChange("modelChanged", null, null));
            this.add((Component)new JScrollPane(table), "Center");
        }

        private ISemIm semIm() {
            return this.wrapper.getEstimatedSemIm();
        }

        public ParamTableModel getTableModel() {
            return this.tableModel;
        }

        public boolean isEditable() {
            return this.editable;
        }

        public void setEditable(boolean editable) {
            this.tableModel.setEditable(editable);
            this.editable = editable;
            this.tableModel.fireTableStructureChanged();
        }
    }

    static class ImpliedMatricesPanel
    extends JPanel {
        private static final long serialVersionUID = 2462316724126834072L;
        private final SemEstimatorWrapper wrapper;
        private JTable impliedJTable;
        private int matrixSelection;
        private JComboBox selector;

        public ImpliedMatricesPanel(SemEstimatorWrapper wrapper, int matrixSelection) {
            this.wrapper = wrapper;
            this.setLayout(new BoxLayout(this, 1));
            this.add(this.selector());
            this.add(Box.createVerticalStrut(10));
            this.add(new JScrollPane(this.impliedJTable()));
            this.add(Box.createVerticalGlue());
            this.setBorder(new TitledBorder("Select Implied Matrix to View"));
            this.setMatrixSelection(matrixSelection);
        }

        public String getMatrixInTabDelimitedForm() {
            StringBuilder builder = new StringBuilder();
            TableModel model = this.impliedJTable().getModel();
            for (int row = 0; row < model.getRowCount(); ++row) {
                for (int col = 0; col < model.getColumnCount(); ++col) {
                    Object o = model.getValueAt(row, col);
                    if (o != null) {
                        builder.append(o);
                    }
                    builder.append('\t');
                }
                builder.append('\n');
            }
            return builder.toString();
        }

        private JTable impliedJTable() {
            if (this.impliedJTable == null) {
                this.impliedJTable = new JTable();
                this.impliedJTable.setTableHeader(null);
            }
            return this.impliedJTable;
        }

        private JComboBox selector() {
            if (this.selector == null) {
                this.selector = new JComboBox();
                List<String> selections = this.getImpliedSelections();
                for (String selection : selections) {
                    this.selector.addItem(selection);
                }
                this.selector.addItemListener(e -> {
                    String item = (String)e.getItem();
                    this.setMatrixSelection(this.getImpliedSelections().indexOf(item));
                });
            }
            return this.selector;
        }

        private void switchView(int index) {
            if (index < 0 || index > 3) {
                throw new IllegalArgumentException("Matrix selection must be 0, 1, 2, or 3.");
            }
            this.matrixSelection = index;
            switch (index) {
                case 0: {
                    this.switchView(false, false);
                    break;
                }
                case 1: {
                    this.switchView(true, false);
                    break;
                }
                case 2: {
                    this.switchView(false, true);
                    break;
                }
                case 3: {
                    this.switchView(true, true);
                }
            }
        }

        private void switchView(boolean a, boolean b) {
            this.impliedJTable().setModel(new ImpliedCovTable(this.wrapper, a, b));
            this.impliedJTable().setAutoResizeMode(0);
            this.impliedJTable().setRowSelectionAllowed(false);
            this.impliedJTable().setCellSelectionEnabled(false);
            this.impliedJTable().doLayout();
        }

        private List<String> getImpliedSelections() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("Implied covariance matrix (all variables)");
            list.add("Implied covariance matrix (measured variables only)");
            list.add("Implied correlation matrix (all variables)");
            list.add("Implied correlation matrix (measured variables only)");
            return list;
        }

        private ISemIm getSemIm() {
            return this.wrapper.getEstimatedSemIm();
        }

        public int getMatrixSelection() {
            return this.matrixSelection;
        }

        public void setMatrixSelection(int index) {
            this.selector().setSelectedIndex(index);
            this.switchView(index);
        }
    }
}

