/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.editor.ParameterEditor;
import edu.cmu.tetradapp.util.DoubleTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.text.DecimalFormat;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class SemImParamsEditor
extends JPanel
implements ParameterEditor {
    private Parameters params;

    @Override
    public void setParams(Parameters params) {
        if (params == null) {
            throw new NullPointerException();
        }
        this.params = params;
    }

    @Override
    public void setParentModels(Object[] parentModels) {
    }

    @Override
    public void setup() {
        this.setLayout(new BorderLayout());
        DecimalFormat decimalFormat = new DecimalFormat("0.0######");
        DoubleTextField coefLowField = new DoubleTextField(this.params.getDouble("coefLow"), 6, decimalFormat);
        coefLowField.setFilter((value, oldValue) -> {
            try {
                this.getParams().set("coefLow", (Object)value);
                this.getParams().set("coefHigh", (Object)this.params.getDouble("coefHigh"));
                return value;
            }
            catch (IllegalArgumentException e) {
                return oldValue;
            }
        });
        DoubleTextField coefHighField = new DoubleTextField(this.params.getDouble("coefHigh"), 6, decimalFormat);
        coefHighField.setFilter((value, oldValue) -> {
            try {
                this.getParams().set("coefLow", (Object)this.params.getDouble("coefLow"));
                this.getParams().set("coefHigh", (Object)value);
                return value;
            }
            catch (IllegalArgumentException e) {
                return oldValue;
            }
        });
        DoubleTextField covLowField = new DoubleTextField(this.params.getDouble("covLow", 0.0), 6, decimalFormat);
        covLowField.setFilter((value, oldValue) -> {
            try {
                this.params.set("covLow", (Object)value);
                this.params.set("covHigh", (Object)this.params.getDouble("covHigh"));
                return value;
            }
            catch (IllegalArgumentException e) {
                return oldValue;
            }
        });
        DoubleTextField covHighField = new DoubleTextField(this.params.getDouble("covHigh", 0.0), 6, decimalFormat);
        covHighField.setFilter((value, oldValue) -> {
            try {
                this.params.set("covLow", (Object)this.params.getDouble("covLow"));
                this.params.set("covHigh", (Object)value);
                return value;
            }
            catch (IllegalArgumentException e) {
                return oldValue;
            }
        });
        DoubleTextField varLowField = new DoubleTextField(this.params.getDouble("varLow", 1.0), 6, decimalFormat);
        varLowField.setFilter((value, oldValue) -> {
            try {
                this.params.set("varLow", (Object)value);
                this.params.set("varHigh", (Object)this.params.getDouble("varHigh"));
                return value;
            }
            catch (IllegalArgumentException e) {
                return oldValue;
            }
        });
        DoubleTextField varHighField = new DoubleTextField(this.params.getDouble("varHigh"), 6, decimalFormat);
        varHighField.setFilter((value, oldValue) -> {
            try {
                this.params.set("varLow", (Object)this.params.getDouble("varLow"));
                this.params.set("varHigh", (Object)value);
                return value;
            }
            catch (IllegalArgumentException e) {
                return oldValue;
            }
        });
        JCheckBox coefSymmetric = new JCheckBox("Symmetric about zero.");
        JCheckBox covSymmetric = new JCheckBox("Symmetric about zero.");
        coefSymmetric.setSelected(this.params.getBoolean("coefSymmetric", true));
        covSymmetric.setSelected(this.params.getBoolean("covSymmetric", true));
        coefSymmetric.addActionListener(e -> {
            JCheckBox checkBox = (JCheckBox)e.getSource();
            this.params.set("coefSymmetric", (Object)checkBox.isSelected());
        });
        covSymmetric.addActionListener(e -> {
            JCheckBox checkBox = (JCheckBox)e.getSource();
            this.params.set("covSymmetric", (Object)checkBox.isSelected());
        });
        Box b1 = Box.createVerticalBox();
        Box b2 = Box.createHorizontalBox();
        b2.add(new JLabel("Unfixed parameter values for this SEM IM are drawn as follows:"));
        b2.add(Box.createHorizontalGlue());
        b1.add(b2);
        b1.add(Box.createVerticalStrut(5));
        Box b4a = Box.createHorizontalBox();
        b4a.add(new JLabel("Coefficient values are drawn from "));
        b4a.add(new BigLabel("("));
        b4a.add(coefLowField);
        b4a.add(new BigLabel(", "));
        b4a.add(coefHighField);
        b4a.add(new BigLabel(") "));
        b4a.add(coefSymmetric);
        b4a.add(Box.createHorizontalGlue());
        b1.add(b4a);
        Box b4b = Box.createHorizontalBox();
        b4b.add(new JLabel("Covariance for correlated error terms are drawn from "));
        b4b.add(new BigLabel("("));
        b4b.add(covLowField);
        b4b.add(new BigLabel(", "));
        b4b.add(covHighField);
        b4b.add(new BigLabel(") "));
        b4b.add(covSymmetric);
        b4b.add(Box.createHorizontalGlue());
        b1.add(b4b);
        Box b4c = Box.createHorizontalBox();
        b4c.add(new JLabel("Error standard deviation values are drawn from "));
        b4c.add(new BigLabel("("));
        b4c.add(varLowField);
        b4c.add(new BigLabel(", "));
        b4c.add(varHighField);
        b4c.add(new BigLabel(")"));
        b4c.add(new JLabel("."));
        b4c.add(Box.createHorizontalGlue());
        b1.add(b4c);
        b1.add(Box.createHorizontalGlue());
        this.add((Component)b1, "Center");
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
    }

    @Override
    public boolean mustBeShown() {
        return false;
    }

    private synchronized Parameters getParams() {
        return this.params;
    }

    static final class BigLabel
    extends JLabel {
        private static final Font FONT = new Font("Dialog", 1, 20);

        public BigLabel(String text) {
            super(text);
            this.setFont(FONT);
        }
    }
}

