/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.sem.Parameter;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.session.DelegatesEditing;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.editor.SaveComponentImage;
import edu.cmu.tetradapp.editor.SemPmGraphicalEditor;
import edu.cmu.tetradapp.model.SemPmWrapper;
import edu.cmu.tetradapp.util.LayoutEditable;
import edu.cmu.tetradapp.workbench.LayoutMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public final class SemPmEditor
extends JPanel
implements DelegatesEditing,
LayoutEditable {
    private final SemPmWrapper semPmWrapper;
    private SemPmGraphicalEditor graphicalEditor;
    private final JMenuItem errorTerms;

    public SemPmEditor(SemPmWrapper wrapper) {
        this.semPmWrapper = wrapper;
        this.setLayout(new BorderLayout());
        this.add((Component)this.graphicalEditor(), "Center");
        JMenuBar menuBar = new JMenuBar();
        JMenu file = new JMenu("File");
        menuBar.add(file);
        file.add(new SaveComponentImage(this.graphicalEditor.getWorkbench(), "Save Graph Image..."));
        this.errorTerms = new JMenuItem();
        this.getSemGraph().setShowErrorTerms(false);
        this.graphicalEditor().resetLabels();
        if (this.getSemGraph().isShowErrorTerms()) {
            this.errorTerms.setText("Hide Error Terms");
        } else {
            this.errorTerms.setText("Show Error Terms");
        }
        this.errorTerms.addActionListener(e -> {
            JMenuItem menuItem = (JMenuItem)e.getSource();
            if ("Hide Error Terms".equals(menuItem.getText())) {
                menuItem.setText("Show Error Terms");
                this.getSemGraph().setShowErrorTerms(false);
                this.graphicalEditor().resetLabels();
            } else if ("Show Error Terms".equals(menuItem.getText())) {
                menuItem.setText("Hide Error Terms");
                this.getSemGraph().setShowErrorTerms(true);
                this.graphicalEditor().resetLabels();
            }
        });
        JMenuItem fixOneLoadingPerLatent = new JMenuItem("Fix One Loading Per Latent");
        fixOneLoadingPerLatent.addActionListener(e -> {
            int ret = JOptionPane.showConfirmDialog(JOptionUtils.centeringComp(), "This will fix one measurement for each latent to 1.0 and cannot be undone. Proceed?", "Confirm", 0, 2);
            if (ret == 0) {
                this.getSemPm().fixOneLoadingPerLatent();
                this.graphicalEditor.resetLabels();
            }
        });
        JMenuItem fixLatentErrorVariances = new JMenuItem("Fix Latent Error Variances");
        fixLatentErrorVariances.addActionListener(e -> {
            int ret = JOptionPane.showConfirmDialog(JOptionUtils.centeringComp(), "This will fix each latent error variance to 1.0. Proceed?", "Confirm", 0, 2);
            if (ret == 0) {
                this.getSemPm().fixLatentErrorVariances();
                this.graphicalEditor.resetLabels();
            }
        });
        JMenuItem startFactorLoadingsAtOne = new JMenuItem("Start All Factor Loadings At 1.0");
        startFactorLoadingsAtOne.addActionListener(e -> {
            int ret = JOptionPane.showConfirmDialog(JOptionUtils.centeringComp(), "This will start all factor loadings at 1.0 for purposes of estimation. Proceed?", "Confirm", 0, 2);
            if (ret == 0) {
                SemGraph graph = this.getSemPm().getGraph();
                for (Edge edge : graph.getEdges()) {
                    Parameter p;
                    Node x = edge.getNode1();
                    Node y = edge.getNode2();
                    if (edge.pointsTowards(x)) {
                        if (x.getNodeType() != NodeType.MEASURED || y.getNodeType() != NodeType.LATENT) continue;
                        p = this.getSemPm().getParameter(y, x);
                    } else {
                        if (y.getNodeType() != NodeType.MEASURED || x.getNodeType() != NodeType.LATENT) continue;
                        p = this.getSemPm().getParameter(x, y);
                    }
                    p.setInitializedRandomly(false);
                    p.setStartingValue(1.0);
                }
                this.graphicalEditor.resetLabels();
            }
        });
        JMenu params = new JMenu("Parameters");
        params.add(this.errorTerms);
        params.add(fixOneLoadingPerLatent);
        params.add(fixLatentErrorVariances);
        params.add(startFactorLoadingsAtOne);
        menuBar.add(params);
        menuBar.add(new LayoutMenu(this));
        this.add((Component)menuBar, "North");
    }

    private SemGraph getSemGraph() {
        return this.getSemPm().getGraph();
    }

    @Override
    public JComponent getEditDelegate() {
        return this;
    }

    @Override
    public Graph getGraph() {
        return this.graphicalEditor().getWorkbench().getGraph();
    }

    public Map getModelEdgesToDisplay() {
        return this.graphicalEditor().getWorkbench().getModelEdgesToDisplay();
    }

    public Map getModelNodesToDisplay() {
        return this.graphicalEditor().getWorkbench().getModelNodesToDisplay();
    }

    @Override
    public Knowledge getKnowledge() {
        return this.graphicalEditor().getWorkbench().getKnowledge();
    }

    @Override
    public Graph getSourceGraph() {
        return this.graphicalEditor().getWorkbench().getSourceGraph();
    }

    @Override
    public void layoutByGraph(Graph graph) {
        SemGraph _graph = (SemGraph)this.graphicalEditor().getWorkbench().getGraph();
        _graph.setShowErrorTerms(false);
        this.graphicalEditor().getWorkbench().layoutByGraph(graph);
        _graph.resetErrorPositions();
        this.errorTerms.setText("Show Error Terms");
    }

    @Override
    public void layoutByKnowledge() {
        SemGraph _graph = (SemGraph)this.graphicalEditor().getWorkbench().getGraph();
        _graph.setShowErrorTerms(false);
        this.graphicalEditor().getWorkbench().layoutByKnowledge();
        _graph.resetErrorPositions();
        this.errorTerms.setText("Show Error Terms");
    }

    private SemPm getSemPm() {
        return this.semPmWrapper.getSemPms().get(this.semPmWrapper.getModelIndex());
    }

    private SemPmGraphicalEditor graphicalEditor() {
        if (this.graphicalEditor == null) {
            this.graphicalEditor = new SemPmGraphicalEditor(this.semPmWrapper);
            this.graphicalEditor.addPropertyChangeListener(evt -> this.firePropertyChange(evt.getPropertyName(), null, null));
        }
        return this.graphicalEditor;
    }
}

