/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.sem.ParamType;
import edu.cmu.tetrad.sem.Parameter;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.model.SemPmWrapper;
import edu.cmu.tetradapp.util.DoubleTextField;
import edu.cmu.tetradapp.util.StringTextField;
import edu.cmu.tetradapp.workbench.DisplayNode;
import edu.cmu.tetradapp.workbench.GraphNodeMeasured;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import javax.swing.border.TitledBorder;

class SemPmGraphicalEditor
extends JPanel {
    private static final Font SMALL_FONT = new Font("Dialog", 0, 10);
    private final SemPmWrapper semPmWrapper;
    private final JPanel targetPanel;
    private GraphWorkbench workbench;
    private int savedTooltipDelay;

    public SemPmGraphicalEditor(SemPmWrapper wrapper) {
        this.semPmWrapper = wrapper;
        this.setLayout(new BorderLayout());
        if (wrapper.getNumModels() > 1) {
            JComboBox<Integer> comp = new JComboBox<Integer>();
            for (int i = 0; i < wrapper.getNumModels(); ++i) {
                comp.addItem(i + 1);
            }
            comp.addActionListener(e -> {
                Object selectedItem = comp.getSelectedItem();
                if (selectedItem instanceof Integer) {
                    wrapper.setModelIndex((Integer)selectedItem - 1);
                    this.workbench = new GraphWorkbench(this.graph());
                    this.workbench.setAllowDoubleClickActions(false);
                    this.workbench.enableEditing(false);
                    this.resetLabels();
                    this.setSemPm();
                }
            });
            comp.setMaximumSize(comp.getPreferredSize());
            Box b = Box.createHorizontalBox();
            b.add(new JLabel("Using model"));
            b.add(comp);
            b.add(new JLabel("from "));
            b.add(new JLabel(wrapper.getModelSourceName()));
            b.add(Box.createHorizontalGlue());
            this.add((Component)b, "North");
        }
        this.targetPanel = new JPanel();
        this.targetPanel.setLayout(new BorderLayout());
        this.add((Component)this.targetPanel, "Center");
        this.semPm().getGraph().setShowErrorTerms(true);
        this.setSemPm();
    }

    private void setSemPm() {
        JScrollPane scroll = new JScrollPane(this.workbench());
        scroll.setPreferredSize(new Dimension(450, 450));
        this.targetPanel.add((Component)scroll, "Center");
        scroll.setBorder(new TitledBorder("Double click parameter names to edit parameters"));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                SemPmGraphicalEditor.this.resetLabels();
                ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
                SemPmGraphicalEditor.this.setSavedTooltipDelay(toolTipManager.getInitialDelay());
                toolTipManager.setInitialDelay(100);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
                toolTipManager.setInitialDelay(SemPmGraphicalEditor.this.getSavedTooltipDelay());
            }
        });
        this.targetPanel.validate();
    }

    private void beginEdgeEdit(Edge edge) {
        Parameter parameter = this.getEdgeParameter(edge);
        ParameterEditor paramEditor = new ParameterEditor(parameter, this.semPm());
        paramEditor.addPropertyChangeListener(evt -> this.firePropertyChange("modelChanged", null, null));
        int ret = JOptionPane.showOptionDialog(this.workbench(), paramEditor, "Parameter Properties", 2, -1, null, null, null);
        if (ret == 0) {
            parameter.setName(paramEditor.getParamName());
            parameter.setFixed(paramEditor.isFixed());
            parameter.setInitializedRandomly(paramEditor.isInitializedRandomly());
            parameter.setStartingValue(paramEditor.getStartingValue());
            this.resetLabels();
        }
    }

    private void beginNodeEdit(Node node) {
        Parameter parameter = this.getNodeParameter(node);
        if (parameter == null) {
            throw new IllegalStateException("There is no variance parameter in model for node " + node + ".");
        }
        ParameterEditor paramEditor = new ParameterEditor(parameter, this.semPm());
        paramEditor.addPropertyChangeListener(evt -> {
            System.out.println("** " + evt.getPropertyName());
            this.firePropertyChange(evt.getPropertyName(), null, null);
        });
        int ret = JOptionPane.showOptionDialog(this.workbench(), paramEditor, "Parameter Properties", 2, -1, null, null, null);
        if (ret == 0) {
            parameter.setName(paramEditor.getParamName());
            parameter.setFixed(paramEditor.isFixed());
            parameter.setInitializedRandomly(paramEditor.isInitializedRandomly());
            parameter.setStartingValue(paramEditor.getStartingValue());
            this.resetLabels();
        }
    }

    private SemPm semPm() {
        return this.semPmWrapper.getSemPms().get(this.semPmWrapper.getModelIndex());
    }

    private Graph graph() {
        return this.semPm().getGraph();
    }

    private GraphWorkbench workbench() {
        if (this.workbench == null) {
            this.workbench = new GraphWorkbench(this.graph());
            this.getWorkbench().setAllowDoubleClickActions(false);
            this.workbench.enableEditing(false);
            this.resetLabels();
            this.addMouseListenerToGraphNodesMeasured();
        }
        return this.getWorkbench();
    }

    public void resetLabels() {
        for (Edge edge : this.graph().getEdges()) {
            this.resetEdgeLabel(edge);
        }
        List<Node> nodes = this.graph().getNodes();
        for (Node node : nodes) {
            this.resetNodeLabel(node);
        }
        this.workbench().repaint();
    }

    private void resetEdgeLabel(Edge edge) {
        Parameter parameter = this.getEdgeParameter(edge);
        if (parameter != null) {
            JLabel label = new JLabel();
            if (parameter.getType() == ParamType.COVAR) {
                label.setForeground(Color.GREEN.darker().darker());
            }
            if (parameter.isFixed()) {
                label.setForeground(Color.RED);
            }
            label.setBackground(Color.white);
            label.setOpaque(true);
            label.setFont(SMALL_FONT);
            label.setText(parameter.getName());
            label.addMouseListener(new EdgeMouseListener(edge, this));
            this.workbench().setEdgeLabel(edge, label);
        } else {
            this.workbench().setEdgeLabel(edge, null);
        }
    }

    private void resetNodeLabel(Node node) {
        Parameter parameter = this.getNodeParameter(node);
        if (parameter == null) {
            this.workbench().setNodeLabel(node, null, 0, 0);
        } else {
            JLabel label = new JLabel();
            label.setForeground(Color.blue);
            label.setBackground(Color.white);
            label.setFont(SMALL_FONT);
            label.setText(parameter.getName());
            label.addMouseListener(new NodeMouseListener(node, this));
            if (parameter.isFixed()) {
                label.setForeground(Color.RED);
            }
            if (node.getNodeType() == NodeType.ERROR) {
                label.setOpaque(false);
                this.workbench().setNodeLabel(node, label, -10, -10);
            } else {
                label.setOpaque(false);
                this.workbench().setNodeLabel(node, label, 0, 0);
            }
        }
    }

    private Parameter getNodeParameter(Node node) {
        Parameter parameter = this.semPm().getMeanParameter(node);
        if (parameter == null) {
            parameter = this.semPm().getVarianceParameter(node);
        }
        return parameter;
    }

    private Parameter getEdgeParameter(Edge edge) {
        if (Edges.isDirectedEdge(edge)) {
            return this.semPm().getCoefficientParameter(edge.getNode1(), edge.getNode2());
        }
        if (Edges.isBidirectedEdge(edge)) {
            return this.semPm().getCovarianceParameter(edge.getNode1(), edge.getNode2());
        }
        throw new IllegalArgumentException("This is not a directed or bidirected edge: " + edge);
    }

    private void addMouseListenerToGraphNodesMeasured() {
        List<Node> nodes = this.graph().getNodes();
        for (Node node : nodes) {
            Object displayNode = this.workbench().getModelNodesToDisplay().get(node);
            if (!(displayNode instanceof GraphNodeMeasured)) continue;
            DisplayNode _displayNode = (DisplayNode)displayNode;
            _displayNode.setToolTipText(this.getEquationOfNode(_displayNode.getModelNode()));
        }
    }

    private String getEquationOfNode(Node node) {
        StringBuilder eqn = new StringBuilder(node.getName() + " = B0_" + node.getName());
        SemGraph semGraph = this.semPm().getGraph();
        List<Node> parentNodes = semGraph.getParents(node);
        for (Node parentNodeObj : parentNodes) {
            Parameter edgeParam = this.getEdgeParameter(semGraph.getDirectedEdge(parentNodeObj, node));
            if (edgeParam == null) continue;
            eqn.append(" + ").append(edgeParam.getName()).append("*").append(parentNodeObj);
        }
        eqn.append(" + ").append(this.semPm().getGraph().getExogenous(node));
        return eqn.toString();
    }

    private int getSavedTooltipDelay() {
        return this.savedTooltipDelay;
    }

    private void setSavedTooltipDelay(int savedTooltipDelay) {
        this.savedTooltipDelay = savedTooltipDelay;
    }

    public GraphWorkbench getWorkbench() {
        return this.workbench;
    }

    private static final class ParameterEditor
    extends JPanel {
        private final SemPm semPm;
        private final Parameter parameter;
        private String paramName;
        private boolean fixed;
        private boolean initializedRandomly;
        private double startingValue;

        public ParameterEditor(Parameter parameter, SemPm semPm) {
            if (parameter == null) {
                throw new NullPointerException();
            }
            if (semPm == null) {
                throw new NullPointerException();
            }
            this.parameter = parameter;
            this.setParamName(parameter.getName());
            this.setFixed(parameter.isFixed());
            this.setInitializedRandomly(parameter.isInitializedRandomly());
            this.setStartingValue(parameter.getStartingValue());
            this.semPm = semPm;
            this.setupEditor();
        }

        private void setupEditor() {
            int length = 8;
            StringTextField nameField = new StringTextField(this.getParamName(), 8);
            nameField.setFilter((value, oldValue) -> {
                try {
                    Parameter paramForName = this.semPm().getParameter(value);
                    if (paramForName == null && !value.equals(this.getParamName())) {
                        this.setParamName(value);
                    }
                    return this.getParamName();
                }
                catch (Exception e) {
                    return this.getParamName();
                }
            });
            nameField.setHorizontalAlignment(4);
            nameField.grabFocus();
            nameField.selectAll();
            JCheckBox fixedCheckBox = new JCheckBox();
            fixedCheckBox.setSelected(this.isFixed());
            fixedCheckBox.addActionListener(e -> {
                JCheckBox checkBox = (JCheckBox)e.getSource();
                this.setFixed(checkBox.isSelected());
            });
            DoubleTextField startingValueField = new DoubleTextField(this.getStartingValue(), 8, NumberFormatUtil.getInstance().getNumberFormat());
            startingValueField.setFilter((value, oldValue) -> {
                try {
                    this.setStartingValue(value);
                    return value;
                }
                catch (Exception e) {
                    return oldValue;
                }
            });
            startingValueField.setEditable(!this.isInitializedRandomly());
            JRadioButton randomRadioButton = new JRadioButton("Drawn randomly");
            randomRadioButton.addActionListener(e -> {
                this.setInitializedRandomly(true);
                startingValueField.setEditable(false);
            });
            JRadioButton startRadioButton = new JRadioButton();
            startRadioButton.addActionListener(e -> {
                this.setInitializedRandomly(false);
                startingValueField.setEditable(true);
            });
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(randomRadioButton);
            buttonGroup.add(startRadioButton);
            if (this.isInitializedRandomly()) {
                buttonGroup.setSelected(randomRadioButton.getModel(), true);
            } else {
                buttonGroup.setSelected(startRadioButton.getModel(), true);
            }
            DoubleTextField meanField = new DoubleTextField(0.0, 8, NumberFormatUtil.getInstance().getNumberFormat());
            meanField.setEditable(!this.isInitializedRandomly());
            DoubleTextField rangeFromField = new DoubleTextField(0.0, 8, NumberFormatUtil.getInstance().getNumberFormat());
            rangeFromField.setEditable(!this.isInitializedRandomly());
            DoubleTextField rangeToField = new DoubleTextField(0.0, 8, NumberFormatUtil.getInstance().getNumberFormat());
            rangeToField.setEditable(!this.isInitializedRandomly());
            Box b0 = Box.createHorizontalBox();
            b0.add(new JLabel("Parameter Type: "));
            b0.add(Box.createHorizontalGlue());
            b0.add(new JLabel(this.parameter.getType().toString()));
            Box b1 = Box.createHorizontalBox();
            b1.add(new JLabel("Parameter Name: "));
            b1.add(Box.createHorizontalGlue());
            b1.add(nameField);
            Box b2 = Box.createHorizontalBox();
            b2.add(new JLabel("Fixed for Estimation? "));
            b2.add(Box.createHorizontalGlue());
            b2.add(fixedCheckBox);
            Box b3 = Box.createHorizontalBox();
            b3.add(new JLabel("Starting Value for Estimation:"));
            b3.add(Box.createHorizontalGlue());
            Box b4 = Box.createHorizontalBox();
            b4.add(Box.createHorizontalStrut(10));
            b4.add(randomRadioButton);
            b4.add(Box.createHorizontalGlue());
            Box b5 = Box.createHorizontalBox();
            b5.add(Box.createHorizontalStrut(10));
            b5.add(startRadioButton);
            b5.add(new JLabel("Set to: "));
            b5.add(Box.createHorizontalGlue());
            b5.add(startingValueField);
            Box p = Box.createVerticalBox();
            p.add(b0);
            p.add(b1);
            p.add(b2);
            p.add(b3);
            p.add(b4);
            p.add(b5);
            this.add(p);
        }

        private SemPm semPm() {
            return this.semPm;
        }

        public String getParamName() {
            return this.paramName;
        }

        public void setParamName(String name) {
            this.firePropertyChange("modelChanged", null, null);
            this.paramName = name;
        }

        public double getStartingValue() {
            return this.startingValue;
        }

        public void setStartingValue(double startingValue) {
            this.firePropertyChange("modelChanged", null, null);
            this.startingValue = startingValue;
        }

        public boolean isFixed() {
            return this.fixed;
        }

        public void setFixed(boolean fixed) {
            this.firePropertyChange("modelChanged", null, null);
            this.fixed = fixed;
        }

        public boolean isInitializedRandomly() {
            return this.initializedRandomly;
        }

        public void setInitializedRandomly(boolean initializedRandomly) {
            this.firePropertyChange("modelChanged", null, null);
            this.initializedRandomly = initializedRandomly;
        }

        public Parameter getParameter() {
            return this.parameter;
        }
    }

    private static final class EdgeMouseListener
    extends MouseAdapter {
        private final Edge edge;
        private final SemPmGraphicalEditor editor;

        public EdgeMouseListener(Edge edge, SemPmGraphicalEditor editor) {
            this.edge = edge;
            this.editor = editor;
        }

        private Edge getEdge() {
            return this.edge;
        }

        private SemPmGraphicalEditor getEditor() {
            return this.editor;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                this.getEditor().beginEdgeEdit(this.getEdge());
            }
        }
    }

    private static final class NodeMouseListener
    extends MouseAdapter {
        private final Node node;
        private final SemPmGraphicalEditor editor;

        public NodeMouseListener(Node node, SemPmGraphicalEditor editor) {
            this.node = node;
            this.editor = editor;
        }

        private Node getNode() {
            return this.node;
        }

        private SemPmGraphicalEditor getEditor() {
            return this.editor;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                this.getEditor().beginNodeEdit(this.getNode());
            }
        }
    }
}

