/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.sem.SemEvidence;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemUpdater;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.editor.SemImEditor;
import edu.cmu.tetradapp.model.SemImWrapper;
import edu.cmu.tetradapp.model.SemUpdaterWrapper;
import edu.cmu.tetradapp.util.DoubleTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class SemUpdaterEditor
extends JPanel {
    private static final long serialVersionUID = 7548536266087867739L;
    private final SemUpdater semUpdater;
    private final Map<JCheckBox, Integer> checkBoxesToVariables = new HashMap<JCheckBox, Integer>();
    private final Map<Integer, DoubleTextField> variablesToTextFields = new HashMap<Integer, DoubleTextField>();
    private final SemImEditor semImEditor;
    private final LinkedList<DoubleTextField> focusTraversalOrder = new LinkedList();
    private final Map<DoubleTextField, Integer> labels = new HashMap<DoubleTextField, Integer>();

    public SemUpdaterEditor(SemUpdater semUpdater) {
        if (semUpdater == null) {
            throw new NullPointerException("Bayes semUpdater must not be null.");
        }
        this.semUpdater = semUpdater;
        this.setLayout(new BorderLayout());
        this.setName("Bayes Updater Editor");
        Box b1 = Box.createHorizontalBox();
        this.semImEditor = new SemImEditor(new SemImWrapper(semUpdater.getSemIm()));
        this.semImEditor.add((Component)this.getUpdatePanel(), "West");
        this.semImEditor.setEditable(false);
        b1.add(this.semImEditor);
        this.add((Component)b1, "Center");
    }

    private Box getUpdatePanel() {
        SemEvidence evidence = this.semUpdater.getEvidence();
        this.focusTraversalOrder.clear();
        Box b = Box.createVerticalBox();
        Box b0 = Box.createHorizontalBox();
        b0.add(new JLabel("<html>In the list below, specify values for variables you have evidence <br>for. Click the 'Do Update Now' button to view updated model."));
        b0.add(Box.createHorizontalGlue());
        b.add(b0);
        b.add(Box.createVerticalStrut(10));
        Box d = Box.createHorizontalBox();
        d.add(new JLabel("Variable = value"));
        d.add(Box.createHorizontalGlue());
        d.add(new JLabel("Manipulated"));
        b.add(d);
        for (int i = 0; i < evidence.getNumNodes(); ++i) {
            Box c = Box.createHorizontalBox();
            SemIm semIm = evidence.getSemIm();
            Node node = semIm.getVariableNodes().get(i);
            String name = node.getName();
            JLabel label = new JLabel(name + " =  "){
                private static final long serialVersionUID = 820570350956700782L;

                @Override
                public Dimension getMaximumSize() {
                    return this.getPreferredSize();
                }
            };
            c.add(label);
            double mean = evidence.getProposition().getValue(i);
            DoubleTextField field = new DoubleTextField(mean, 5, NumberFormatUtil.getInstance().getNumberFormat());
            field.setFilter((value, oldValue) -> {
                try {
                    int nodeIndex = this.labels.get(field);
                    if (Double.isNaN(value) && evidence.isManipulated(nodeIndex)) {
                        throw new IllegalArgumentException();
                    }
                    evidence.getProposition().setValue(nodeIndex, value);
                    SemIm updatedSem = this.semUpdater.getUpdatedSemIm();
                    this.semImEditor.displaySemIm(updatedSem, this.semImEditor.getTabSelectionIndex(), this.semImEditor.getMatrixSelection());
                    return value;
                }
                catch (IllegalArgumentException e) {
                    return oldValue;
                }
            });
            this.labels.put(field, i);
            this.variablesToTextFields.put(i, field);
            this.focusTraversalOrder.add(field);
            c.add(field);
            c.add(Box.createHorizontalStrut(2));
            c.add(Box.createHorizontalGlue());
            JCheckBox checkbox = new JCheckBox(){
                private static final long serialVersionUID = -3808843047563493212L;

                @Override
                public Dimension getMaximumSize() {
                    return this.getPreferredSize();
                }
            };
            checkbox.setSelected(evidence.isManipulated(i));
            this.checkBoxesToVariables.put(checkbox, i);
            checkbox.addActionListener(e -> {
                JCheckBox chkbox = (JCheckBox)e.getSource();
                boolean selected = chkbox.isSelected();
                Integer o = this.checkBoxesToVariables.get(chkbox);
                double value = evidence.getProposition().getValue(o);
                if (Double.isNaN(value)) {
                    DoubleTextField dblTxtField = this.variablesToTextFields.get(o);
                    SemIm semIM = this.semUpdater.getSemIm();
                    Node varNode = semIM.getVariableNodes().get(o);
                    double semIMMean = semIM.getMean(varNode);
                    dblTxtField.setValue(semIMMean);
                }
                this.semUpdater.getEvidence().setManipulated(o, selected);
                SemIm updatedSem = this.semUpdater.getUpdatedSemIm();
                this.semImEditor.displaySemIm(updatedSem, this.semImEditor.getTabSelectionIndex(), this.semImEditor.getMatrixSelection());
            });
            checkbox.setBackground(Color.WHITE);
            checkbox.setBorder(null);
            c.add(checkbox);
            c.setMaximumSize(new Dimension(1000, 30));
            b.add(c);
        }
        b.add(Box.createVerticalGlue());
        Box b2 = Box.createHorizontalBox();
        b2.add(Box.createHorizontalGlue());
        JButton button = new JButton("Do Update Now");
        button.addActionListener(e -> {
            SemIm updatedSem = this.semUpdater.getUpdatedSemIm();
            this.semImEditor.displaySemIm(updatedSem, this.semImEditor.getTabSelectionIndex(), this.semImEditor.getMatrixSelection());
        });
        b2.add(button);
        b.add(b2);
        b.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

            @Override
            public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
                int index = SemUpdaterEditor.this.focusTraversalOrder.indexOf(aComponent);
                int size = SemUpdaterEditor.this.focusTraversalOrder.size();
                if (index != -1) {
                    return (Component)SemUpdaterEditor.this.focusTraversalOrder.get((index + 1) % size);
                }
                return this.getFirstComponent(focusCycleRoot);
            }

            @Override
            public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
                int index = SemUpdaterEditor.this.focusTraversalOrder.indexOf(aComponent);
                int size = SemUpdaterEditor.this.focusTraversalOrder.size();
                if (index != -1) {
                    return (Component)SemUpdaterEditor.this.focusTraversalOrder.get((index - 1) % size);
                }
                return this.getFirstComponent(focusCycleRoot);
            }

            @Override
            public Component getFirstComponent(Container focusCycleRoot) {
                return (Component)SemUpdaterEditor.this.focusTraversalOrder.getFirst();
            }

            @Override
            public Component getLastComponent(Container focusCycleRoot) {
                return (Component)SemUpdaterEditor.this.focusTraversalOrder.getLast();
            }

            @Override
            public Component getDefaultComponent(Container focusCycleRoot) {
                return this.getFirstComponent(focusCycleRoot);
            }
        });
        this.setFocusCycleRoot(true);
        return b;
    }

    public SemUpdaterEditor(SemUpdaterWrapper wrapper) {
        this(wrapper.getSemUpdater());
    }

    @Override
    public void setName(String name) {
        String oldName = this.getName();
        super.setName(name);
        this.firePropertyChange("name", oldName, this.getName());
    }
}

