/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.algcomparison.Comparison;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.editor.DataEditor;
import edu.cmu.tetradapp.editor.SimulationGraphEditor;
import edu.cmu.tetradapp.editor.simulation.ParameterTab;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.KnowledgeEditable;
import edu.cmu.tetradapp.model.Simulation;
import edu.cmu.tetradapp.ui.PaddingPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public final class SimulationEditor
extends JPanel
implements KnowledgeEditable,
PropertyChangeListener {
    private static final long serialVersionUID = -8424284512836439370L;
    final JTabbedPane tabbedPane = new JTabbedPane();
    private final Simulation simulation;
    private final DataEditor dataEditor;
    private final SimulationGraphEditor simulationGraphEditor;
    private final ParameterTab parameterTab;

    public SimulationEditor(Simulation simulation) {
        this.simulation = simulation;
        this.dataEditor = this.createDataEditor(simulation);
        this.simulationGraphEditor = this.createSimulationGraphEditor(simulation);
        this.parameterTab = new ParameterTab(simulation);
        this.initComponents();
        this.showTab();
    }

    private void initComponents() {
        this.parameterTab.addPropertyChangeListener(this);
        this.tabbedPane.addTab("Simulation Setup", new PaddingPanel(this.parameterTab));
        this.tabbedPane.addTab("True Graph", this.simulationGraphEditor);
        this.tabbedPane.addTab("Data", this.dataEditor);
        this.tabbedPane.setPreferredSize(new Dimension(800, 600));
        this.setLayout(new BorderLayout());
        this.add((Component)this.createMenuBar(), "North");
        this.add((Component)this.tabbedPane, "Center");
    }

    private void showTab() {
        if (this.simulation.getSimulation() == null) {
            this.tabbedPane.setEnabledAt(0, true);
            this.tabbedPane.setEnabledAt(1, false);
            this.tabbedPane.setEnabledAt(2, false);
        } else if (this.simulation.getDataModelList().size() > 0) {
            this.tabbedPane.setEnabledAt(0, true);
            this.tabbedPane.setEnabledAt(1, true);
            this.tabbedPane.setEnabledAt(2, true);
            if (!this.parameterTab.isInitial()) {
                this.tabbedPane.setSelectedIndex(2);
            }
        } else {
            this.tabbedPane.setEnabledAt(0, true);
            this.tabbedPane.setEnabledAt(1, false);
            this.tabbedPane.setEnabledAt(2, false);
        }
    }

    private SimulationGraphEditor createSimulationGraphEditor(Simulation simulation) {
        SimulationGraphEditor graphEditor = new SimulationGraphEditor(Collections.emptyList());
        if (simulation.getSimulation() != null) {
            ArrayList<Graph> trueGraphs = new ArrayList<Graph>();
            for (int i = 0; i < simulation.getSimulation().getNumDataModels(); ++i) {
                trueGraphs.add(simulation.getSimulation().getTrueGraph(i));
            }
            graphEditor.replace(trueGraphs);
        }
        return graphEditor;
    }

    private DataEditor createDataEditor(Simulation simulation) {
        edu.cmu.tetrad.algcomparison.simulation.Simulation sim = simulation.getSimulation();
        if (sim == null) {
            return new DataEditor(2);
        }
        DataModelList dataModelList = new DataModelList();
        for (int i = 0; i < sim.getNumDataModels(); ++i) {
            dataModelList.add(sim.getDataModel(i));
        }
        DataWrapper wrapper = new DataWrapper(new Parameters());
        wrapper.setDataModelList(dataModelList);
        return new DataEditor(wrapper, false, 2);
    }

    private JMenuBar createMenuBar() {
        JMenuItem saveSimulation = new JMenuItem("Save Simulation");
        saveSimulation.addActionListener(this.createSaveSimulationActionListener());
        JMenu file = new JMenu("File");
        file.add(saveSimulation);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(file);
        return menuBar;
    }

    private ActionListener createSaveSimulationActionListener() {
        return e -> {
            JFileChooser chooser = new JFileChooser();
            String sessionSaveLocation = Preferences.userRoot().get("fileSaveLocation", "");
            chooser.setCurrentDirectory(new File(sessionSaveLocation));
            chooser.setFileSelectionMode(0);
            int ret = chooser.showSaveDialog(JOptionUtils.centeringComp());
            if (ret != 0) {
                return;
            }
            File selectedFile = chooser.getSelectedFile();
            if (selectedFile == null) {
                return;
            }
            new Comparison().saveToFilesSingleSimulation(selectedFile.getAbsolutePath(), this.simulation.getSimulation(), this.simulation.getParams());
        };
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        switch (evt.getPropertyName()) {
            case "modelChanged": {
                ArrayList<Graph> trueGraphs = new ArrayList<Graph>();
                for (int i = 0; i < this.simulation.getSimulation().getNumDataModels(); ++i) {
                    trueGraphs.add(this.simulation.getSimulation().getTrueGraph(i));
                }
                this.simulationGraphEditor.replace(trueGraphs);
                DataWrapper wrapper = new DataWrapper(new Parameters());
                wrapper.setDataModelList(this.simulation.getDataModelList());
                this.tabbedPane.setComponentAt(2, new DataEditor(wrapper, false, 2));
                this.showTab();
                this.firePropertyChange("modelChanged", null, null);
                break;
            }
            case "refreshParameters": {
                this.showTab();
            }
        }
    }

    @Override
    public Knowledge getKnowledge() {
        return null;
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
    }

    @Override
    public Graph getSourceGraph() {
        return null;
    }

    @Override
    public List<String> getVarNames() {
        return null;
    }
}

