/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetradapp.editor.DataModelContainer;
import edu.cmu.tetradapp.editor.GraphEditor;
import edu.cmu.tetradapp.model.GraphWrapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public final class SimulationGraphEditor
extends JPanel {
    private static final long serialVersionUID = -8394516826928341168L;
    private final List<Graph> graphs;
    private JTabbedPane tabbedPane = new JTabbedPane(2);

    public SimulationGraphEditor(List<Graph> graphs) {
        this.graphs = graphs;
        this.setLayout(new BorderLayout());
        this.reset();
    }

    public void replace(List<Graph> graphs) {
        this.tabbedPane.removeAll();
        this.setPreferredSize(new Dimension(600, 400));
        this.removeAll();
        if (!graphs.isEmpty()) {
            if (graphs.size() > 1) {
                for (int i = 0; i < graphs.size(); ++i) {
                    this.tabbedPane.addTab(SimulationGraphEditor.tabName(i + 1), new JScrollPane(this.graphDisplay(graphs.get(i))));
                }
                this.add((Component)this.tabbedPane, "Center");
            } else {
                this.tabbedPane.addTab(SimulationGraphEditor.tabName(1), new JScrollPane(this.graphDisplay(graphs.get(0))));
                this.add((Component)this.tabbedPane, "Center");
            }
        }
        this.tabbedPane.validate();
        this.tabbedPane.repaint();
    }

    private void reset() {
        this.tabbedPane().removeAll();
        this.setPreferredSize(new Dimension(600, 400));
        this.removeAll();
        int selectedIndex = -1;
        for (int i = 0; i < this.graphs.size(); ++i) {
            Graph graph = this.graphs.get(i);
            this.tabbedPane().addTab(SimulationGraphEditor.tabName(i + 1), this.graphDisplay(graph));
        }
        this.tabbedPane().setSelectedIndex(-1);
        this.add((Component)this.tabbedPane(), "Center");
        this.validate();
    }

    public DataModel getSelectedDataModel() {
        Component selectedComponent = this.tabbedPane().getSelectedComponent();
        DataModelContainer scrollPane = (DataModelContainer)((Object)selectedComponent);
        if (scrollPane == null) {
            return null;
        }
        return scrollPane.getDataModel();
    }

    public void selectFirstTab() {
        this.tabbedPane().setSelectedIndex(0);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
    }

    private static String tabName(int i) {
        return "" + i;
    }

    private JComponent graphDisplay(Graph graph) {
        GraphEditor graphEditor = new GraphEditor(new GraphWrapper(graph));
        graphEditor.enableEditing(false);
        return graphEditor.getWorkbench();
    }

    private JTabbedPane tabbedPane() {
        return this.tabbedPane;
    }
}

