/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.SplitCasesSpec;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.editor.ParameterEditor;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.util.IntTextField;
import edu.cmu.tetradapp.util.StringTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class SplitCasesParamsEditor
extends JPanel
implements ParameterEditor {
    private DataSet dataSet;
    private IntTextField numSplitsField;
    private Parameters params;
    private JPanel splitEditorPanel;

    private void setNumSplits(int numSplits) {
        if (numSplits < 1) {
            throw new IllegalArgumentException("Number of splits must be at least 1.");
        }
        this.params.set("numSplits", (Object)numSplits);
        this.splitEditorPanel.removeAll();
        SplitCasesSpec defaultSpec = SplitCasesParamsEditor.getDefaultSpec(this.dataSet.getNumRows(), numSplits);
        SplitEditor splitEditor = new SplitEditor(defaultSpec);
        this.params.set("splitCasesSpec", (Object)defaultSpec);
        this.splitEditorPanel.add((Component)splitEditor, "Center");
        this.splitEditorPanel.revalidate();
        this.splitEditorPanel.repaint();
        this.numSplitsField.setText(String.valueOf(numSplits));
        Preferences.userRoot().putInt("latestNumCategories", numSplits);
    }

    @Override
    public void setup() {
        this.numSplitsField = new IntTextField(this.params.getInt("numSplits", 3), 2);
        this.numSplitsField.setFilter((value, oldValue) -> {
            this.setNumSplits(value);
            return value;
        });
        this.splitEditorPanel = new JPanel();
        this.splitEditorPanel.setLayout(new BorderLayout());
        this.setNumSplits(this.params.getInt("numSplits", 3));
        JRadioButton shuffleButton = new JRadioButton("Shuffled order");
        JRadioButton noShuffleButton = new JRadioButton("Original order");
        shuffleButton.addActionListener(e -> this.params.set("dataShuffled", (Object)true));
        noShuffleButton.addActionListener(e -> this.params.set("dataShuffled", (Object)false));
        ButtonGroup group = new ButtonGroup();
        group.add(shuffleButton);
        group.add(noShuffleButton);
        shuffleButton.setSelected(this.params.getBoolean("dataShuffled", true));
        Box b1 = Box.createVerticalBox();
        Box b2 = Box.createHorizontalBox();
        b2.add(new JLabel("Using data in:"));
        b2.add(Box.createHorizontalGlue());
        b1.add(b2);
        Box b3 = Box.createHorizontalBox();
        b3.add(Box.createHorizontalStrut(10));
        b3.add(shuffleButton);
        b3.add(Box.createHorizontalGlue());
        b1.add(b3);
        Box b4 = Box.createHorizontalBox();
        b4.add(Box.createHorizontalStrut(10));
        b4.add(noShuffleButton);
        b4.add(Box.createHorizontalGlue());
        b1.add(b4);
        b1.add(Box.createVerticalStrut(10));
        Box b5 = Box.createHorizontalBox();
        b5.add(new JLabel("Split data into "));
        b5.add(this.numSplitsField);
        b5.add(new JLabel(" subsets as follows:"));
        b5.add(Box.createHorizontalGlue());
        b1.add(b5);
        b1.add(Box.createVerticalStrut(10));
        b1.add(this.splitEditorPanel);
        b1.add(Box.createVerticalGlue());
        this.setLayout(new BorderLayout());
        this.add((Component)b1, "Center");
    }

    @Override
    public void setParams(Parameters params) {
        this.params = params;
    }

    @Override
    public void setParentModels(Object[] parentModels) {
        if (parentModels == null || parentModels.length == 0) {
            throw new IllegalArgumentException("There must be parent model");
        }
        DataWrapper data = null;
        for (Object parent : parentModels) {
            if (!(parent instanceof DataWrapper)) continue;
            data = (DataWrapper)parent;
        }
        if (data == null) {
            throw new IllegalArgumentException("Should have have a data wrapper as a parent");
        }
        DataModel model = data.getSelectedDataModel();
        if (!(model instanceof DataSet)) {
            throw new IllegalArgumentException("The data must be tabular");
        }
        this.dataSet = (DataSet)model;
    }

    @Override
    public boolean mustBeShown() {
        return true;
    }

    private static SplitCasesSpec getDefaultSpec(int sampleSize, int numSplits) {
        int[] breakpoints = SplitCasesParamsEditor.defaultBreakpoints(sampleSize, numSplits);
        LinkedList<String> splitNames = new LinkedList<String>();
        if (numSplits == 1) {
            splitNames.add("same_data");
        } else if (numSplits == 2) {
            splitNames.add("train");
            splitNames.add("test");
        } else {
            for (int i = 0; i < numSplits; ++i) {
                splitNames.add("split_" + i);
            }
        }
        return new SplitCasesSpec(sampleSize, breakpoints, splitNames);
    }

    private static int[] defaultBreakpoints(int sampleSize, int numSplits) {
        int interval = sampleSize / numSplits;
        int[] breakpoints = new int[numSplits - 1];
        for (int i = 0; i < breakpoints.length; ++i) {
            breakpoints[i] = (i + 1) * interval;
        }
        return breakpoints;
    }

    static final class SplitEditor
    extends JComponent {
        private final int[] breakpoints;
        private final List<String> splitNames;
        private StringTextField[] splitNameFields;
        private IntTextField[] leftSplitFields;
        private IntTextField[] rightSplitFields;
        private final LinkedList<JTextField> focusTraveralOrder = new LinkedList();
        private final Map<Object, Integer> labels = new HashMap<Object, Integer>();
        private final int sampleSize;

        public SplitEditor(SplitCasesSpec spec) {
            this.sampleSize = spec.getSampleSize();
            this.breakpoints = spec.getBreakpoints();
            this.splitNames = spec.getSplitNames();
            Box rangeEditor = Box.createVerticalBox();
            this.createSplitNameFields();
            this.createRangeFields();
            for (int i = 0; i < this.splitNames.size(); ++i) {
                Box row = Box.createHorizontalBox();
                row.add(Box.createRigidArea(new Dimension(10, 0)));
                row.add(new JLabel("Name = "));
                row.add(this.splitNameFields[i]);
                row.add(new JLabel(" : row "));
                row.add(this.leftSplitFields[i]);
                row.add(new JLabel(" to row "));
                row.add(this.rightSplitFields[i]);
                row.add(Box.createHorizontalGlue());
                rangeEditor.add(row);
            }
            this.setLayout(new BorderLayout());
            this.add((Component)rangeEditor, "Center");
            this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

                @Override
                public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
                    int index = focusTraveralOrder.indexOf(aComponent);
                    int size = focusTraveralOrder.size();
                    if (index != -1) {
                        return (Component)focusTraveralOrder.get((index + 1) % size);
                    }
                    return this.getFirstComponent(focusCycleRoot);
                }

                @Override
                public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
                    int index = focusTraveralOrder.indexOf(aComponent);
                    int size = focusTraveralOrder.size();
                    if (index != -1) {
                        return (Component)focusTraveralOrder.get((index - 1) % size);
                    }
                    return this.getFirstComponent(focusCycleRoot);
                }

                @Override
                public Component getFirstComponent(Container focusCycleRoot) {
                    return (Component)focusTraveralOrder.getFirst();
                }

                @Override
                public Component getLastComponent(Container focusCycleRoot) {
                    return (Component)focusTraveralOrder.getLast();
                }

                @Override
                public Component getDefaultComponent(Container focusCycleRoot) {
                    return this.getFirstComponent(focusCycleRoot);
                }
            });
            this.setFocusCycleRoot(true);
        }

        private void createSplitNameFields() {
            this.splitNameFields = new StringTextField[this.getNumSplits()];
            for (int i = 0; i < this.getNumSplits(); ++i) {
                String split = this.splitNames.get(i);
                this.splitNameFields[i] = new StringTextField(split, 6);
                StringTextField _field = this.splitNameFields[i];
                this.splitNameFields[i].setFilter((value, oldValue) -> {
                    if (this.labels.get(_field) != null) {
                        int index = this.labels.get(_field);
                        if (value == null) {
                            value = this.splitNames.get(index);
                        }
                        for (int i1 = 0; i1 < this.splitNames.size(); ++i1) {
                            if (i1 == index || !this.splitNames.get(i1).equals(value)) continue;
                            value = this.splitNames.get(index);
                            break;
                        }
                        this.splitNames.set(index, value);
                    }
                    return value;
                });
                this.labels.put(this.splitNameFields[i], i);
                this.focusTraveralOrder.add(this.splitNameFields[i]);
            }
        }

        private void createRangeFields() {
            this.leftSplitFields = new IntTextField[this.getNumSplits()];
            this.rightSplitFields = new IntTextField[this.getNumSplits()];
            int maxSplit = this.getNumSplits() - 1;
            this.leftSplitFields[0] = new IntTextField(1, 6);
            this.leftSplitFields[0].setFilter((value, oldValue) -> oldValue);
            this.rightSplitFields[maxSplit] = new IntTextField(this.sampleSize, 6);
            this.rightSplitFields[maxSplit].setFilter((value, oldValue) -> oldValue);
            this.leftSplitFields[0].setEditable(false);
            this.rightSplitFields[maxSplit].setEditable(false);
            for (int i = 0; i < this.getNumSplits() - 1; ++i) {
                this.rightSplitFields[i] = new IntTextField(this.breakpoints[i] - 1, 6);
                this.rightSplitFields[i].setEditable(false);
                this.labels.put(this.rightSplitFields[i], i);
                this.leftSplitFields[i + 1] = new IntTextField(this.breakpoints[i], 6);
                this.labels.put(this.leftSplitFields[i + 1], i + 1);
                Integer label = this.labels.get(this.leftSplitFields[i + 1]);
                this.leftSplitFields[i + 1].setFilter((value, oldValue) -> {
                    if (label == null) {
                        return oldValue;
                    }
                    int index = label;
                    if (index - 1 > 0 && this.breakpoints[index - 2] >= value) {
                        value = this.breakpoints[index - 1];
                    }
                    if (index - 1 < this.breakpoints.length - 1 && value >= this.breakpoints[index]) {
                        value = this.breakpoints[index - 1];
                    }
                    this.breakpoints[index - 1] = value;
                    this.getRightSplitFields()[index - 1].setValue(value - 1);
                    return value;
                });
                this.labels.put(this.leftSplitFields[i + 1], i + 1);
                this.focusTraveralOrder.add(this.leftSplitFields[i + 1]);
            }
        }

        private IntTextField[] getRightSplitFields() {
            return this.rightSplitFields;
        }

        private int getNumSplits() {
            return this.splitNames.size();
        }

        public List<String> getSplitNames() {
            return this.splitNames;
        }

        public int getSampleSize() {
            return this.sampleSize;
        }
    }
}

