/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.sem.StandardizedSemIm;
import edu.cmu.tetradapp.editor.SaveComponentImage;
import edu.cmu.tetradapp.editor.StandardizedSemImGraphicalEditor;
import edu.cmu.tetradapp.editor.StandardizedSemImImpliedMatricesPanel;
import edu.cmu.tetradapp.model.StandardizedSemImWrapper;
import edu.cmu.tetradapp.util.LayoutEditable;
import edu.cmu.tetradapp.workbench.LayoutMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public final class StandardizedSemImEditor
extends JPanel
implements LayoutEditable {
    static final long serialVersionUID = 23L;
    private final StandardizedSemIm semIm;
    private StandardizedSemImGraphicalEditor standardizedSemImGraphicalEditor;
    private final JMenuItem errorTerms;
    private StandardizedSemImImpliedMatricesPanel impliedMatricesPanel;

    public StandardizedSemImEditor(StandardizedSemImWrapper wrapper) {
        StandardizedSemIm semIm = wrapper.getStandardizedSemIm();
        if (semIm == null) {
            throw new NullPointerException("The SEM IM has not been specified.");
        }
        this.semIm = semIm;
        this.setLayout(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add("Graph", this.graphicalEditor());
        tabbedPane.add("Implied Matrices", this.impliedMatricesPanel());
        this.add((Component)tabbedPane, "Center");
        JMenuBar menuBar = new JMenuBar();
        JMenu file = new JMenu("File");
        menuBar.add(file);
        file.add(new SaveComponentImage(this.standardizedSemImGraphicalEditor.getWorkbench(), "Save Graph Image..."));
        this.errorTerms = new JMenuItem();
        SemGraph graph = (SemGraph)this.graphicalEditor().getWorkbench().getGraph();
        boolean shown = wrapper.isShowErrors();
        graph.setShowErrorTerms(shown);
        this.errorTerms.addActionListener(e -> {
            JMenuItem menuItem = (JMenuItem)e.getSource();
            if ("Hide Error Terms".equals(menuItem.getText())) {
                menuItem.setText("Show Error Terms");
                SemGraph graph1 = (SemGraph)this.graphicalEditor().getWorkbench().getGraph();
                graph1.setShowErrorTerms(false);
                wrapper.setShowErrors(false);
                this.graphicalEditor().resetLabels();
            } else if ("Show Error Terms".equals(menuItem.getText())) {
                menuItem.setText("Hide Error Terms");
                SemGraph graph1 = (SemGraph)this.graphicalEditor().getWorkbench().getGraph();
                graph1.setShowErrorTerms(true);
                wrapper.setShowErrors(true);
                this.graphicalEditor().resetLabels();
            }
        });
        menuBar.add(new LayoutMenu(this));
        this.add((Component)menuBar, "North");
    }

    @Override
    public Graph getGraph() {
        return this.standardizedSemImGraphicalEditor.getWorkbench().getGraph();
    }

    public Map getModelEdgesToDisplay() {
        return this.standardizedSemImGraphicalEditor.getWorkbench().getModelEdgesToDisplay();
    }

    public Map getModelNodesToDisplay() {
        return this.standardizedSemImGraphicalEditor.getWorkbench().getModelNodesToDisplay();
    }

    @Override
    public Knowledge getKnowledge() {
        return this.standardizedSemImGraphicalEditor.getWorkbench().getKnowledge();
    }

    @Override
    public Graph getSourceGraph() {
        return this.standardizedSemImGraphicalEditor.getWorkbench().getSourceGraph();
    }

    @Override
    public void layoutByGraph(Graph graph) {
        SemGraph _graph = (SemGraph)this.standardizedSemImGraphicalEditor.getWorkbench().getGraph();
        _graph.setShowErrorTerms(false);
        this.standardizedSemImGraphicalEditor.getWorkbench().layoutByGraph(graph);
        _graph.resetErrorPositions();
        this.errorTerms.setText("Show Error Terms");
    }

    @Override
    public void layoutByKnowledge() {
        SemGraph _graph = (SemGraph)this.standardizedSemImGraphicalEditor.getWorkbench().getGraph();
        _graph.setShowErrorTerms(false);
        this.standardizedSemImGraphicalEditor.getWorkbench().layoutByKnowledge();
        _graph.resetErrorPositions();
        this.standardizedSemImGraphicalEditor.getWorkbench().setGraph(_graph);
        this.errorTerms.setText("Show Error Terms");
    }

    private StandardizedSemIm getSemIm() {
        return this.semIm;
    }

    private StandardizedSemImGraphicalEditor graphicalEditor() {
        if (this.standardizedSemImGraphicalEditor == null) {
            this.standardizedSemImGraphicalEditor = new StandardizedSemImGraphicalEditor(this.getSemIm());
            this.standardizedSemImGraphicalEditor.addPropertyChangeListener(evt -> this.firePropertyChange(evt.getPropertyName(), null, null));
            this.standardizedSemImGraphicalEditor.enableEditing(false);
        }
        return this.standardizedSemImGraphicalEditor;
    }

    private StandardizedSemImImpliedMatricesPanel impliedMatricesPanel() {
        if (this.impliedMatricesPanel == null) {
            boolean matrixSelection = false;
            this.impliedMatricesPanel = new StandardizedSemImImpliedMatricesPanel(this.getSemIm(), 0);
        }
        return this.impliedMatricesPanel;
    }
}

