/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.sem.StandardizedSemIm;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.util.DoubleTextField;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.List;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.math3.util.FastMath;

final class StandardizedSemImGraphicalEditor
extends JPanel {
    static final long serialVersionUID = 23L;
    private static final Font SMALL_FONT = new Font("Dialog", 0, 10);
    private final StandardizedSemIm semIm;
    private GraphWorkbench workbench;
    private Object lastEditedObject;
    private int savedTooltipDelay;
    private boolean editable = true;
    private double min = Double.NEGATIVE_INFINITY;
    private double max = Double.POSITIVE_INFINITY;
    private Edge editingEdge;
    private final JLabel minRangeLabel;
    private final JLabel maxRangeLabel;
    private final JLabel edgeLabel;
    private final DoubleTextField valueField;
    private final JSlider slider;
    private boolean enableEditing = true;

    public StandardizedSemImGraphicalEditor(final StandardizedSemIm semIm) {
        this.semIm = semIm;
        this.setLayout(new BorderLayout());
        JScrollPane scroll = new JScrollPane(this.workbench());
        scroll.setPreferredSize(new Dimension(450, 400));
        this.add((Component)scroll, "Center");
        Box b = Box.createVerticalBox();
        Box b1 = Box.createHorizontalBox();
        this.minRangeLabel = new JLabel();
        this.maxRangeLabel = new JLabel();
        this.edgeLabel = new JLabel();
        this.valueField = new DoubleTextField(0.0, 8, NumberFormatUtil.getInstance().getNumberFormat());
        this.slider = new JSlider();
        this.setEditorToEdge(semIm.getSemPm().getGraph().getEdges().iterator().next());
        this.valueField.setFilter((value, oldValue) -> {
            if (value == Double.POSITIVE_INFINITY || value == Double.NEGATIVE_INFINITY || value < this.max && value > this.min) {
                this.setSliderToValue(value, this.min, this.max);
                this.semIm().setParameterValue(this.editingEdge, value);
                this.resetLabels();
                this.firePropertyChange("modelChanged", null, null);
                return value;
            }
            return oldValue;
        });
        this.valueField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    double value = Double.parseDouble(StandardizedSemImGraphicalEditor.this.valueField.getText());
                    semIm.setParameterValue(StandardizedSemImGraphicalEditor.this.editingEdge, value);
                    StandardizedSemImGraphicalEditor.this.resetLabels();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public synchronized void stateChanged(ChangeEvent e) {
                double value = StandardizedSemImGraphicalEditor.this.getValueFromSlider(StandardizedSemImGraphicalEditor.this.min, StandardizedSemImGraphicalEditor.this.max);
                StandardizedSemImGraphicalEditor.this.valueField.setValue(value);
                StandardizedSemImGraphicalEditor.this.resetLabels();
            }
        });
        b1.add(new JLabel("Adjustable range for edge "));
        b1.add(this.edgeLabel);
        b1.add(new JLabel(" = ("));
        b1.add(this.minRangeLabel);
        b1.add(new JLabel(", "));
        b1.add(this.maxRangeLabel);
        b1.add(new JLabel(")"));
        b1.add(Box.createHorizontalGlue());
        b.add(b1);
        b.add(Box.createVerticalStrut(5));
        Box b2 = Box.createHorizontalBox();
        b2.add(this.slider);
        b2.add(Box.createHorizontalStrut(5));
        b2.add(new JLabel("Value ="));
        b2.add(Box.createHorizontalStrut(5));
        this.valueField.setMaximumSize(this.valueField.getPreferredSize());
        b2.add(this.valueField);
        b.add(b2);
        b.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.add((Component)b, "South");
        this.setBorder(new TitledBorder("Click parameter values to edit. (Error variances are not parameters.)"));
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        this.setSavedTooltipDelay(toolTipManager.getInitialDelay());
        this.workbench().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                StandardizedSemImGraphicalEditor.this.resetLabels();
                ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
                toolTipManager.setInitialDelay(100);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
                toolTipManager.setInitialDelay(StandardizedSemImGraphicalEditor.this.getSavedTooltipDelay());
            }
        });
        this.workbench().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (StandardizedSemImGraphicalEditor.this.workbench().contains(e.getPoint())) {
                    ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
                    toolTipManager.setInitialDelay(100);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (!StandardizedSemImGraphicalEditor.this.workbench().contains(e.getPoint())) {
                    ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
                    toolTipManager.setInitialDelay(StandardizedSemImGraphicalEditor.this.getSavedTooltipDelay());
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                StandardizedSemImGraphicalEditor.this.resetLabels();
            }
        });
    }

    public GraphWorkbench getWorkbench() {
        return this.workbench;
    }

    public void setEditable(boolean editable) {
        this.workbench().setAllowEdgeReorientations(editable);
        this.workbench().setAllowDoubleClickActions(editable);
        this.workbench().setAllowNodeEdgeSelection(editable);
        this.editable = editable;
    }

    private void beginEdgeEdit(Edge edge) {
        this.finishEdit();
        if (!this.isEditable()) {
            return;
        }
        this.setEditorToEdge(edge);
        this.setLastEditedObject(edge);
        this.workbench().repaint();
    }

    private void setEditorToEdge(Edge edge) {
        if (edge.getNode1().getNodeType() == NodeType.ERROR || edge.getNode2().getNodeType() == NodeType.ERROR) {
            return;
        }
        if (this.editingEdge != null) {
            try {
                double value = Double.parseDouble(this.valueField.getText());
                this.semIm.setParameterValue(this.editingEdge, value);
                this.resetLabels();
            }
            catch (NumberFormatException value) {
                // empty catch block
            }
        }
        double d = this.semIm().getParameterValue(edge);
        StandardizedSemIm.ParameterRange range = this.semIm().getParameterRange(edge);
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        this.editingEdge = edge;
        this.edgeLabel.setText(edge.toString());
        this.min = range.getLow();
        this.max = range.getHigh();
        this.minRangeLabel.setText(nf.format(range.getLow()));
        this.maxRangeLabel.setText(nf.format(range.getHigh()));
        this.setSliderToValue(d, this.min, this.max);
        this.valueField.setValue(d);
        this.valueField.grabFocus();
        this.valueField.setCaretPosition(0);
        this.valueField.moveCaretPosition(this.valueField.getText().length());
    }

    private void finishEdit() {
        if (this.lastEditedObject() != null) {
            this.resetLabels();
        }
    }

    private StandardizedSemIm semIm() {
        return this.semIm;
    }

    private Graph graph() {
        return this.semIm().getSemPm().getGraph();
    }

    private GraphWorkbench workbench() {
        if (this.getWorkbench() == null) {
            this.workbench = new GraphWorkbench(this.graph());
            this.getWorkbench().setAllowDoubleClickActions(false);
            this.getWorkbench().setAllowEdgeReorientations(false);
            this.getWorkbench().addPropertyChangeListener(evt -> {
                if ("BackgroundClicked".equals(evt.getPropertyName())) {
                    this.finishEdit();
                }
            });
            this.resetLabels();
        }
        return this.getWorkbench();
    }

    private void setLastEditedObject(Object o) {
        this.lastEditedObject = o;
    }

    private Object lastEditedObject() {
        return this.lastEditedObject;
    }

    public void resetLabels() {
        for (Edge o : this.graph().getEdges()) {
            this.resetEdgeLabel(o);
        }
        List<Node> nodes = this.graph().getNodes();
        for (Node node : nodes) {
            this.resetNodeLabel(node);
        }
        this.workbench().repaint();
    }

    private double getValueFromSlider(double c1, double c2) {
        int n = this.slider.getMaximum() - this.slider.getMinimum();
        int slider = this.slider.getValue();
        if (c1 == Double.NEGATIVE_INFINITY && slider == 0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (c2 == Double.POSITIVE_INFINITY && slider == 100) {
            return Double.POSITIVE_INFINITY;
        }
        return this.sliderToValue(slider, c1, c2, n);
    }

    private void setSliderToValue(double value, double c1, double c2) {
        if (value == Double.NEGATIVE_INFINITY) {
            value = Double.MIN_VALUE;
        } else if (value == Double.POSITIVE_INFINITY) {
            value = Double.MAX_VALUE;
        }
        int n = this.slider.getMaximum() - this.slider.getMinimum();
        int slider = this.valueToSlider(value, c1, c2, n);
        this.slider.setValue(slider);
    }

    private double sliderToValue(int slider, double min, double max, int n) {
        double f = min != Double.NEGATIVE_INFINITY && max != Double.POSITIVE_INFINITY ? min + (double)slider / (double)n * (max - min) : (min != Double.NEGATIVE_INFINITY ? min + FastMath.tan((double)slider / (double)n * 1.5707963267948966) : (max != Double.POSITIVE_INFINITY ? max + FastMath.tan(-(((double)n - (double)slider) / (double)n) * 1.5707963267948966) : FastMath.tan(-1.5707963267948966 + (double)slider / (double)n * Math.PI)));
        return f;
    }

    private int valueToSlider(double value, double min, double max, int n) {
        double x = min != Double.NEGATIVE_INFINITY && max != Double.POSITIVE_INFINITY ? (double)n * (value - min) / (max - min) : (min != Double.NEGATIVE_INFINITY ? 2.0 * (double)n / Math.PI * FastMath.atan(value - min) : (max != Double.POSITIVE_INFINITY ? (double)n + 2.0 * (double)n / Math.PI * FastMath.atan(value - max) : (double)n / Math.PI * (FastMath.atan(value) + 1.5707963267948966)));
        int slider = (int)FastMath.round(x);
        if (slider > 100) {
            slider = 100;
        }
        if (slider < 0) {
            slider = 0;
        }
        return slider;
    }

    private void resetEdgeLabel(Edge edge) {
        if (this.semIm().containsParameter(edge)) {
            double val = this.semIm().getParameterValue(edge);
            JLabel label = new JLabel();
            if (Edges.isBidirectedEdge(edge)) {
                label.setForeground(Color.GREEN.darker().darker());
            }
            label.setBackground(Color.white);
            label.setOpaque(true);
            label.setFont(SMALL_FONT);
            label.setText(" " + this.asString(val) + " ");
            label.addMouseListener(new EdgeMouseListener(edge, this));
            this.workbench().setEdgeLabel(edge, label);
        } else {
            this.workbench().setEdgeLabel(edge, null);
        }
    }

    private void resetNodeLabel(Node node) {
        JLabel label = new JLabel();
        label.setBackground(Color.WHITE);
        label.addMouseListener(new NodeMouseListener());
        label.setFont(SMALL_FONT);
        NodeType nodeType = node.getNodeType();
        if (nodeType != NodeType.ERROR) {
            return;
        }
        double error = this.semIm.getErrorVariance(node);
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        label.setText(nf.format(error));
        label.setOpaque(false);
        this.workbench().setNodeLabel(node, label, -10, -10);
    }

    private int getSavedTooltipDelay() {
        return this.savedTooltipDelay;
    }

    private void setSavedTooltipDelay(int savedTooltipDelay) {
        if (this.savedTooltipDelay == 0) {
            this.savedTooltipDelay = savedTooltipDelay;
        }
    }

    private String asString(double value) {
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        if (Double.isNaN(value)) {
            return " * ";
        }
        return nf.format(value);
    }

    private boolean isEditable() {
        return this.editable;
    }

    public boolean isEnableEditing() {
        return this.enableEditing;
    }

    public void enableEditing(boolean enableEditing) {
        this.enableEditing = enableEditing;
        if (this.workbench != null) {
            this.workbench.enableEditing(enableEditing);
        }
    }

    static final class EdgeMouseListener
    extends MouseAdapter {
        private final Edge edge;
        private final StandardizedSemImGraphicalEditor editor;

        public EdgeMouseListener(Edge edge, StandardizedSemImGraphicalEditor editor) {
            this.edge = edge;
            this.editor = editor;
        }

        private Edge getEdge() {
            return this.edge;
        }

        private StandardizedSemImGraphicalEditor getEditor() {
            return this.editor;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.getEditor().beginEdgeEdit(this.getEdge());
        }
    }

    static final class NodeMouseListener
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent e) {
        }
    }
}

