/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.sem.StandardizedSemIm;
import edu.cmu.tetradapp.editor.StandardizedSemImImpliedCovTable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

class StandardizedSemImImpliedMatricesPanel
extends JPanel {
    private final StandardizedSemIm semIm;
    private JTable impliedJTable;
    private JComboBox selector;

    public StandardizedSemImImpliedMatricesPanel(StandardizedSemIm semIm, int matrixSelection) {
        this.semIm = semIm;
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.selector());
        this.add(Box.createVerticalStrut(10));
        this.add(new JScrollPane(this.impliedJTable()));
        this.add(Box.createVerticalGlue());
        this.setBorder(new TitledBorder("Select Implied Matrix to View"));
        this.setMatrixSelection(matrixSelection);
    }

    private JTable impliedJTable() {
        if (this.impliedJTable == null) {
            this.impliedJTable = new JTable();
            this.impliedJTable.setTableHeader(null);
        }
        return this.impliedJTable;
    }

    private JComboBox selector() {
        if (this.selector == null) {
            this.selector = new JComboBox();
            List<String> selections = StandardizedSemImImpliedMatricesPanel.getImpliedSelections();
            for (String selection : selections) {
                this.selector.addItem(selection);
            }
            this.selector.addItemListener(e -> {
                String item = (String)e.getItem();
                this.setMatrixSelection(StandardizedSemImImpliedMatricesPanel.getImpliedSelections().indexOf(item));
            });
        }
        return this.selector;
    }

    private void setMatrixSelection(int index) {
        this.selector().setSelectedIndex(index);
        this.switchView(index);
    }

    private void switchView(int index) {
        if (index < 0 || index > 3) {
            throw new IllegalArgumentException("Matrix selection must be 0, 1, 2, or 3.");
        }
        switch (index) {
            case 0: {
                this.switchView(false, false);
                break;
            }
            case 1: {
                this.switchView(true, false);
                break;
            }
            case 2: {
                this.switchView(false, true);
                break;
            }
            case 3: {
                this.switchView(true, true);
            }
        }
    }

    private void switchView(boolean a, boolean b) {
        try {
            this.impliedJTable().setModel(new StandardizedSemImImpliedCovTable(this.getSemIm(), a, b));
            this.impliedJTable().setAutoResizeMode(0);
            this.impliedJTable().setRowSelectionAllowed(false);
            this.impliedJTable().setCellSelectionEnabled(false);
            this.impliedJTable().doLayout();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static List<String> getImpliedSelections() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Implied covariance matrix (all variables)");
        list.add("Implied covariance matrix (measured variables only)");
        list.add("Implied correlation matrix (all variables)");
        list.add("Implied correlation matrix (measured variables only)");
        return list;
    }

    private StandardizedSemIm getSemIm() {
        return this.semIm;
    }
}

