/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.algcomparison.statistic.AdjacencyFN;
import edu.cmu.tetrad.algcomparison.statistic.AdjacencyFP;
import edu.cmu.tetrad.algcomparison.statistic.AdjacencyFPR;
import edu.cmu.tetrad.algcomparison.statistic.AdjacencyPrecision;
import edu.cmu.tetrad.algcomparison.statistic.AdjacencyRecall;
import edu.cmu.tetrad.algcomparison.statistic.AdjacencyTN;
import edu.cmu.tetrad.algcomparison.statistic.AdjacencyTP;
import edu.cmu.tetrad.algcomparison.statistic.AdjacencyTPR;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadPrecision;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadPrecisionCommonEdges;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadRecall;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadRecallCommonEdges;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadTN;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadTP;
import edu.cmu.tetrad.algcomparison.statistic.AverageDegreeEst;
import edu.cmu.tetrad.algcomparison.statistic.AverageDegreeTrue;
import edu.cmu.tetrad.algcomparison.statistic.BidirectedLatentPrecision;
import edu.cmu.tetrad.algcomparison.statistic.DensityEst;
import edu.cmu.tetrad.algcomparison.statistic.DensityTrue;
import edu.cmu.tetrad.algcomparison.statistic.F1Adj;
import edu.cmu.tetrad.algcomparison.statistic.F1All;
import edu.cmu.tetrad.algcomparison.statistic.F1Arrow;
import edu.cmu.tetrad.algcomparison.statistic.MathewsCorrAdj;
import edu.cmu.tetrad.algcomparison.statistic.MathewsCorrArrow;
import edu.cmu.tetrad.algcomparison.statistic.NumBidirectedEdgesEst;
import edu.cmu.tetrad.algcomparison.statistic.NumCorrectVisibleAncestors;
import edu.cmu.tetrad.algcomparison.statistic.NumDirectedEdges;
import edu.cmu.tetrad.algcomparison.statistic.NumNondirectedEdges;
import edu.cmu.tetrad.algcomparison.statistic.NumPartiallyOrientedEdges;
import edu.cmu.tetrad.algcomparison.statistic.NumUndirectedEdges;
import edu.cmu.tetrad.algcomparison.statistic.NumberOfEdgesEst;
import edu.cmu.tetrad.algcomparison.statistic.NumberOfEdgesTrue;
import edu.cmu.tetrad.algcomparison.statistic.PercentBidirectedEdges;
import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.algcomparison.statistic.TailPrecision;
import edu.cmu.tetrad.algcomparison.statistic.TailRecall;
import edu.cmu.tetrad.algcomparison.statistic.TrueDagPrecisionArrow;
import edu.cmu.tetrad.algcomparison.statistic.TrueDagPrecisionTails;
import edu.cmu.tetrad.algcomparison.statistic.TwoCycleFalseNegative;
import edu.cmu.tetrad.algcomparison.statistic.TwoCycleFalsePositive;
import edu.cmu.tetrad.algcomparison.statistic.TwoCyclePrecision;
import edu.cmu.tetrad.algcomparison.statistic.TwoCycleRecall;
import edu.cmu.tetrad.algcomparison.statistic.TwoCycleTruePositive;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TextTable;
import edu.cmu.tetradapp.model.TabularComparison;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;

public class StatsListEditor
extends JPanel {
    private static final long serialVersionUID = 8455624852328328919L;
    private final TabularComparison comparison;
    private final Parameters params;
    private final DataModel dataModel;
    private final Graph targetGraph;
    private Graph referenceGraph;
    private JTextArea area;

    public StatsListEditor(TabularComparison comparison) {
        this.comparison = comparison;
        this.params = comparison.getParams();
        this.targetGraph = comparison.getTargetGraph();
        this.referenceGraph = comparison.getReferenceGraph();
        this.dataModel = comparison.getDataModel();
        this.setup();
    }

    private void setup() {
        JMenuBar menubar = this.menubar();
        this.show(menubar);
    }

    private void show(JMenuBar menubar) {
        this.setLayout(new BorderLayout());
        this.add((Component)menubar, "North");
        this.add((Component)this.getTableDisplay(), "Center");
        this.revalidate();
        this.repaint();
    }

    private JComponent getTableDisplay() {
        this.area = new JTextArea();
        this.area.setText(this.tableTextWithHeader());
        this.area.moveCaretPosition(0);
        this.area.setSelectionStart(0);
        this.area.setSelectionEnd(0);
        this.area.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.area.setFont(new Font("Monospaced", 1, 14));
        JScrollPane pane = new JScrollPane(this.area);
        pane.setPreferredSize(new Dimension(700, 700));
        Box b = Box.createVerticalBox();
        b.add(pane);
        return b;
    }

    @NotNull
    private String tableTextWithHeader() {
        TextTable table = this.tableText();
        return "True graph from " + this.comparison.getReferenceName() + "\nTarget graph from " + this.comparison.getTargetName() + "\n\n" + table;
    }

    @NotNull
    private TextTable tableText() {
        if (this.targetGraph == this.referenceGraph) {
            throw new IllegalArgumentException();
        }
        Graph _targetGraph = GraphUtils.replaceNodes(this.targetGraph, this.referenceGraph.getNodes());
        List<Statistic> statistics = this.statistics();
        TextTable table = new TextTable(statistics.size(), 3);
        DecimalFormat nf = new DecimalFormat("0.###");
        ArrayList<String> abbr = new ArrayList<String>();
        ArrayList<String> desc = new ArrayList<String>();
        ArrayList<Double> vals = new ArrayList<Double>();
        for (Statistic statistic : statistics) {
            try {
                vals.add(statistic.getValue(this.referenceGraph, _targetGraph, this.dataModel));
                abbr.add(statistic.getAbbreviation());
                desc.add(statistic.getDescription());
            }
            catch (Exception exception) {}
        }
        for (int i = 0; i < abbr.size(); ++i) {
            double value = (Double)vals.get(i);
            table.setToken(i, 1, Double.isNaN(value) ? "-" : "" + nf.format(value));
            table.setToken(i, 0, (String)abbr.get(i));
            table.setToken(i, 2, (String)desc.get(i));
        }
        table.setJustification(0);
        return table;
    }

    @NotNull
    private List<Statistic> statistics() {
        ArrayList<Statistic> statistics = new ArrayList<Statistic>();
        statistics.add(new AdjacencyPrecision());
        statistics.add(new AdjacencyRecall());
        statistics.add(new ArrowheadPrecision());
        statistics.add(new ArrowheadRecall());
        statistics.add(new ArrowheadPrecisionCommonEdges());
        statistics.add(new ArrowheadRecallCommonEdges());
        statistics.add(new AdjacencyTN());
        statistics.add(new AdjacencyTP());
        statistics.add(new AdjacencyTPR());
        statistics.add(new AdjacencyFPR());
        statistics.add(new AdjacencyFN());
        statistics.add(new AdjacencyFP());
        statistics.add(new AdjacencyFN());
        statistics.add(new ArrowheadTN());
        statistics.add(new ArrowheadTP());
        statistics.add(new F1Adj());
        statistics.add(new F1All());
        statistics.add(new F1Arrow());
        statistics.add(new MathewsCorrAdj());
        statistics.add(new MathewsCorrArrow());
        statistics.add(new NumberOfEdgesEst());
        statistics.add(new NumberOfEdgesTrue());
        statistics.add(new NumCorrectVisibleAncestors());
        statistics.add(new PercentBidirectedEdges());
        statistics.add(new TailPrecision());
        statistics.add(new TailRecall());
        statistics.add(new TwoCyclePrecision());
        statistics.add(new TwoCycleRecall());
        statistics.add(new TwoCycleFalsePositive());
        statistics.add(new TwoCycleFalseNegative());
        statistics.add(new TwoCycleTruePositive());
        statistics.add(new AverageDegreeEst());
        statistics.add(new AverageDegreeTrue());
        statistics.add(new DensityEst());
        statistics.add(new DensityTrue());
        statistics.add(new NumDirectedEdges());
        statistics.add(new NumUndirectedEdges());
        statistics.add(new NumPartiallyOrientedEdges());
        statistics.add(new NumNondirectedEdges());
        statistics.add(new NumBidirectedEdgesEst());
        statistics.add(new TrueDagPrecisionTails());
        statistics.add(new TrueDagPrecisionArrow());
        statistics.add(new BidirectedLatentPrecision());
        return statistics;
    }

    @NotNull
    private JMenuBar menubar() {
        JMenuBar menubar = new JMenuBar();
        JMenu menu = new JMenu("Compare To...");
        JCheckBoxMenuItem graph = new JCheckBoxMenuItem("DAG");
        graph.setBackground(Color.WHITE);
        JCheckBoxMenuItem cpdag = new JCheckBoxMenuItem("CPDAG");
        cpdag.setBackground(Color.YELLOW);
        JCheckBoxMenuItem pag = new JCheckBoxMenuItem("PAG");
        pag.setBackground(Color.GREEN.brighter().brighter());
        ButtonGroup group = new ButtonGroup();
        group.add(graph);
        group.add(cpdag);
        group.add(pag);
        menu.add(graph);
        menu.add(cpdag);
        menu.add(pag);
        menubar.add(menu);
        this.referenceGraph = GraphUtils.getComparisonGraph(this.comparison.getReferenceGraph(), this.params);
        switch (this.params.getString("graphComparisonType")) {
            case "CPDAG": {
                menu.setText("Compare to CPDAG...");
                cpdag.setSelected(true);
                break;
            }
            case "PAG": {
                menu.setText("Compare to PAG...");
                pag.setSelected(true);
                break;
            }
            default: {
                menu.setText("Compare to DAG...");
                graph.setSelected(true);
            }
        }
        graph.addActionListener(e -> {
            this.params.set("graphComparisonType", "DAG");
            menu.setText("Compare to DAG...");
            menu.setBackground(Color.WHITE);
            this.referenceGraph = GraphUtils.getComparisonGraph(this.comparison.getReferenceGraph(), this.params);
            this.area.setText(this.tableTextWithHeader());
            this.area.moveCaretPosition(0);
            this.area.setSelectionStart(0);
            this.area.setSelectionEnd(0);
            this.area.repaint();
        });
        cpdag.addActionListener(e -> {
            this.params.set("graphComparisonType", "CPDAG");
            menu.setText("Compare to CPDAG...");
            menu.setBackground(Color.YELLOW);
            this.referenceGraph = GraphUtils.getComparisonGraph(this.comparison.getReferenceGraph(), this.params);
            this.area.setText(this.tableTextWithHeader());
            this.area.moveCaretPosition(0);
            this.area.setSelectionStart(0);
            this.area.setSelectionEnd(0);
            this.area.repaint();
        });
        pag.addActionListener(e -> {
            this.params.set("graphComparisonType", "PAG");
            menu.setText("Compare to PAG...");
            menu.setBackground(Color.GREEN.brighter().brighter());
            this.referenceGraph = GraphUtils.getComparisonGraph(this.comparison.getReferenceGraph(), this.params);
            this.area.setText(this.tableTextWithHeader());
            this.area.moveCaretPosition(0);
            this.area.setSelectionStart(0);
            this.area.setSelectionEnd(0);
            this.area.repaint();
        });
        return menubar;
    }
}

