/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.util.TextTable;
import edu.cmu.tetradapp.editor.GraphEditor;
import edu.cmu.tetradapp.model.GraphWrapper;
import edu.cmu.tetradapp.model.TabularComparison;
import java.awt.Dimension;
import java.awt.Font;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class TabularComparisonEditor
extends JPanel {
    private static final long serialVersionUID = 8455624852328328919L;
    private final TabularComparison comparison;

    public TabularComparisonEditor(TabularComparison comparison) {
        this.comparison = comparison;
        this.setup();
    }

    private void setup() {
        JTabbedPane pane = new JTabbedPane(1);
        pane.addTab("Comparison", this.getTableDisplay());
        JTabbedPane pane2 = new JTabbedPane(2);
        JTabbedPane pane3 = new JTabbedPane(1);
        GraphEditor graphEditor = new GraphEditor(new GraphWrapper(this.comparison.getTargetGraph()));
        graphEditor.enableEditing(false);
        pane3.add("Target Graph", graphEditor.getWorkbench());
        graphEditor = new GraphEditor(new GraphWrapper(this.comparison.getReferenceGraph()));
        graphEditor.enableEditing(false);
        pane3.add("True Graph", graphEditor.getWorkbench());
        pane2.add("Reference Graph", pane3);
        pane.addTab("Graphs", pane2);
        this.add(pane);
    }

    private Box getTableDisplay() {
        DataSet dataSet = this.comparison.getDataSet();
        TextTable table = this.getTextTable(dataSet, new DecimalFormat("0.00"));
        StringBuilder b0 = new StringBuilder();
        String trueGraphAndTarget = "Target graphs from " + this.comparison.getTargetName() + "\nTrue graphs from " + this.comparison.getReferenceName();
        b0.append(trueGraphAndTarget).append("\n\n");
        b0.append(table);
        Map<String, String> allParamsSettings = this.comparison.getAllParamSettings();
        if (allParamsSettings != null) {
            for (String key : allParamsSettings.keySet()) {
                b0.append(key).append(" = ").append(allParamsSettings.get(key)).append("\n");
            }
        }
        JTextArea area = new JTextArea(b0.toString());
        area.setFont(new Font("Monospaced", 1, 12));
        JScrollPane pane = new JScrollPane(area);
        pane.setPreferredSize(new Dimension(700, 400));
        Box b = Box.createVerticalBox();
        Box b1 = Box.createHorizontalBox();
        b1.add(new JLabel("Tabular Comparison\b"));
        b.add(b1);
        b.add(Box.createVerticalStrut(10));
        Box b3 = Box.createHorizontalBox();
        b3.add(pane);
        b.add(b3);
        return b;
    }

    private TextTable getTextTable(DataSet dataSet, NumberFormat nf) {
        int j;
        int i;
        TextTable table = new TextTable(dataSet.getNumRows() + 2, dataSet.getNumColumns() + 1);
        table.setDelimiter(TextTable.Delimiter.TAB);
        table.setToken(0, 0, "Run");
        for (int j2 = 0; j2 < dataSet.getNumColumns(); ++j2) {
            table.setToken(0, j2 + 1, dataSet.getVariable(j2).getName());
        }
        for (i = 0; i < dataSet.getNumRows(); ++i) {
            table.setToken(i + 1, 0, Integer.toString(i + 1));
        }
        for (i = 0; i < dataSet.getNumRows(); ++i) {
            for (j = 0; j < dataSet.getNumColumns(); ++j) {
                double d = dataSet.getDouble(i, j);
                if (Double.isNaN(d)) {
                    table.setToken(i + 1, j + 1, "*");
                    continue;
                }
                table.setToken(i + 1, j + 1, nf.format(d));
            }
        }
        DecimalFormat nf2 = new DecimalFormat("0.00");
        for (j = 0; j < dataSet.getNumColumns(); ++j) {
            double sum = 0.0;
            int count = 0;
            for (int i2 = 0; i2 < dataSet.getNumRows(); ++i2) {
                double d = dataSet.getDouble(i2, j);
                if (Double.isNaN(d)) continue;
                sum += d;
                ++count;
            }
            double avg = sum / (double)count;
            if (Double.isNaN(avg)) {
                table.setToken(dataSet.getNumRows() + 2 - 1, j + 1, "*");
                continue;
            }
            table.setToken(dataSet.getNumRows() + 2 - 1, j + 1, nf2.format(avg));
        }
        table.setToken(dataSet.getNumRows() + 2 - 1, 0, "Avg");
        return table;
    }
}

