/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.data.Variable;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeVariableType;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.math3.util.FastMath;

class TabularDataTable
extends AbstractTableModel {
    private static final long serialVersionUID = 8832459230421410126L;
    private DataSet dataSet;
    private boolean categoryNamesShown = true;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public TabularDataTable(DataSet dataSet) {
        this.dataSet = dataSet;
    }

    @Override
    public String getColumnName(int col) {
        return null;
    }

    @Override
    public int getRowCount() {
        int maxRowCount = this.dataSet.getNumRows() + 3;
        return FastMath.max(maxRowCount, 100);
    }

    @Override
    public int getColumnCount() {
        return this.dataSet.getNumColumns() < 30 ? 30 : this.dataSet.getNumColumns() + this.getNumLeadingCols() + 1;
    }

    @Override
    public Object getValueAt(int row, int col) {
        int columnIndex = col - this.getNumLeadingCols();
        int rowIndex = row - 2;
        if (col >= this.getNumLeadingCols() && col < this.dataSet.getNumColumns() + this.getNumLeadingCols()) {
            Object value;
            Node variable = this.dataSet.getVariable(columnIndex);
            if (row == 0) {
                String columnHeaderNotationDefault = "C";
                String columnHeader = columnHeaderNotationDefault + (columnIndex + 1);
                if (variable instanceof DiscreteVariable) {
                    String columnHeaderNotationDiscrete = "-D";
                    columnHeader = columnHeader + columnHeaderNotationDiscrete;
                } else if (variable instanceof ContinuousVariable) {
                    String columnHeaderNotationContinuous = "-C";
                    columnHeader = columnHeader + columnHeaderNotationContinuous;
                }
                if (variable.getNodeVariableType() == NodeVariableType.INTERVENTION_STATUS) {
                    String columnHeaderNotationInterventionStatus = "-I_S";
                    columnHeader = columnHeader + columnHeaderNotationInterventionStatus;
                } else if (variable.getNodeVariableType() == NodeVariableType.INTERVENTION_VALUE) {
                    String columnHeaderNotationInterventionValue = "-I_V";
                    columnHeader = columnHeader + columnHeaderNotationInterventionValue;
                }
                return columnHeader;
            }
            if (row == 1) {
                return this.dataSet.getVariable(columnIndex).getName();
            }
            if (rowIndex >= this.dataSet.getNumRows()) {
                return null;
            }
            if (variable instanceof DiscreteVariable) {
                ((DiscreteVariable)variable).setCategoryNamesDisplayed(this.isCategoryNamesShown());
            }
            if (((Variable)variable).isMissingValue(value = this.dataSet.getObject(rowIndex, columnIndex))) {
                return "*";
            }
            return value;
        }
        if (col >= this.dataSet.getNumColumns() + this.getNumLeadingCols() && row == 0) {
            return "C" + (columnIndex + 1);
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return row > 0 && col >= 1;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        this.dataSet.ensureColumns(col - this.getNumLeadingCols() + 1, new ArrayList<String>());
        this.dataSet.ensureRows(row - this.getNumLeadingRows() + 1);
        if (col == 0) {
            throw new IllegalArgumentException("Bad col index: 0");
        }
        if (col >= this.getNumLeadingCols() && col < this.dataSet.getNumColumns() + this.getNumLeadingCols()) {
            if (row == 1) {
                this.setColumnName(col, value);
            } else if (row > 1) {
                try {
                    this.pasteIntoColumn(row, col, value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.pcs.firePropertyChange("modelChanged", null, null);
                    return;
                }
            }
        }
        this.fireTableDataChanged();
        this.pcs.firePropertyChange("modelChanged", null, null);
    }

    private void setColumnName(int col, Object value) {
        String newName;
        String oldName = this.dataSet.getVariable(col - this.getNumLeadingCols()).getName();
        if (oldName.equals(newName = (String)value)) {
            return;
        }
        this.dataSet.getVariable(col - this.getNumLeadingCols()).setName(newName);
        this.pcs.firePropertyChange("modelChanged", null, null);
        this.pcs.firePropertyChange("variableNameChanged", oldName, newName);
    }

    private void pasteIntoColumn(int row, int col, Object value) {
        int dataRow = row - this.getNumLeadingRows();
        int dataCol = col - this.getNumLeadingCols();
        Node variable = this.dataSet.getVariable(dataCol);
        if (variable instanceof ContinuousVariable && value instanceof Number) {
            this.dataSet.setObject(dataRow, dataCol, value);
            return;
        }
        if ("".equals(value) || value == null) {
            return;
        }
        String valueTrimmed = ((String)value).trim();
        boolean quoted = false;
        if (valueTrimmed.startsWith("\"") && valueTrimmed.endsWith("\"")) {
            value = valueTrimmed.substring(1, valueTrimmed.length() - 1);
            quoted = true;
        }
        if (!(variable instanceof DiscreteVariable) && this.isEmpty(this.dataSet, dataCol) && (quoted || !this.isNumber((String)value))) {
            variable = this.swapDiscreteColumnForContinuous(col);
        }
        if (((String)value).trim().equals("*")) {
            value = ((Variable)variable).getMissingValueMarker();
        }
        this.dataSet.setObject(dataRow, dataCol, value);
        this.pcs.firePropertyChange("modelChanged", null, null);
    }

    private boolean isEmpty(DataSet dataSet, int column) {
        Node variable = dataSet.getVariable(column);
        Object missingValue = ((Variable)variable).getMissingValueMarker();
        for (int i = 0; i < dataSet.getNumRows(); ++i) {
            if (dataSet.getObject(i, column).equals(missingValue)) continue;
            return false;
        }
        return true;
    }

    private Node swapDiscreteColumnForContinuous(int col) {
        Node variable = this.dataSet.getVariable(col - this.getNumLeadingCols());
        if (variable == null) {
            throw new NullPointerException();
        }
        if (!this.isEmpty(this.dataSet, col - this.getNumLeadingCols())) {
            throw new IllegalArgumentException("Old column not empty.");
        }
        String name = variable.getName();
        DiscreteVariable var = new DiscreteVariable(name);
        var.setCategoryNamesDisplayed(true);
        this.dataSet.removeColumn(col - this.getNumLeadingCols());
        this.dataSet.addVariable(col - this.getNumLeadingCols(), var);
        this.pcs.firePropertyChange("modelChanged", null, null);
        return var;
    }

    private boolean isNumber(String value) {
        try {
            Double.parseDouble(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet data) {
        if (data == null) {
            throw new NullPointerException("Data set was null.");
        }
        this.dataSet = data;
    }

    private int getNumLeadingRows() {
        return 2;
    }

    private int getNumLeadingCols() {
        return 1;
    }

    public void setCategoryNamesShown(boolean selected) {
        this.categoryNamesShown = selected;
        this.fireTableDataChanged();
    }

    public boolean isCategoryNamesShown() {
        return this.categoryNamesShown;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }
}

