/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.TimeLagGraph;
import edu.cmu.tetrad.search.IndTestDSep;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetradapp.editor.DagGraphToolbar;
import edu.cmu.tetradapp.editor.EdgeTypeTable;
import edu.cmu.tetradapp.editor.EditorWindow;
import edu.cmu.tetradapp.editor.GraphEditable;
import edu.cmu.tetradapp.editor.GraphFileMenu;
import edu.cmu.tetradapp.model.IndTestProducer;
import edu.cmu.tetradapp.model.TimeLagGraphWrapper;
import edu.cmu.tetradapp.ui.PaddingPanel;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.util.ImageUtils;
import edu.cmu.tetradapp.util.LayoutEditable;
import edu.cmu.tetradapp.workbench.DisplayEdge;
import edu.cmu.tetradapp.workbench.DisplayNode;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import edu.cmu.tetradapp.workbench.LayoutMenu;
import edu.cmu.tetradapp.workbench.LayoutUtils;
import edu.cmu.tetradapp.workbench.TimeLagGraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public final class TimeLagGraphEditor
extends JPanel
implements GraphEditable,
LayoutEditable,
IndTestProducer {
    private static final long serialVersionUID = -2425361202348129265L;
    private TimeLagGraphWorkbench workbench;
    private final LayoutEditable layoutEditable;
    private final JScrollPane graphEditorScroll = new JScrollPane();
    private final EdgeTypeTable edgeTypeTable;

    public TimeLagGraphEditor(TimeLagGraphWrapper timeLagGraphWrapper) {
        this.setLayout(new BorderLayout());
        this.layoutEditable = this;
        this.edgeTypeTable = new EdgeTypeTable();
        this.initUI(timeLagGraphWrapper);
    }

    @Override
    public void setName(String name) {
        String oldName = this.getName();
        super.setName(name);
        this.firePropertyChange("name", oldName, this.getName());
    }

    @Override
    public List getSelectedModelComponents() {
        List<Component> selectedComponents = this.getWorkbench().getSelectedComponents();
        ArrayList selectedModelComponents = new ArrayList();
        selectedComponents.forEach(comp -> {
            if (comp instanceof DisplayNode) {
                selectedModelComponents.add(((DisplayNode)comp).getModelNode());
            } else if (comp instanceof DisplayEdge) {
                selectedModelComponents.add(((DisplayEdge)comp).getModelEdge());
            }
        });
        return selectedModelComponents;
    }

    public void pasteSubsession(List sessionElements, Point upperLeft) {
        this.getWorkbench().pasteSubgraph(sessionElements, upperLeft);
        this.getWorkbench().deselectAll();
        for (Object o : sessionElements) {
            if (!(o instanceof GraphNode)) continue;
            Node modelNode = (Node)o;
            this.getWorkbench().selectNode(modelNode);
        }
        this.getWorkbench().selectConnectingEdges();
    }

    @Override
    public GraphWorkbench getWorkbench() {
        return this.workbench;
    }

    @Override
    public Graph getGraph() {
        return this.getWorkbench().getGraph();
    }

    public Map getModelEdgesToDisplay() {
        return this.getWorkbench().getModelEdgesToDisplay();
    }

    public Map getModelNodesToDisplay() {
        return this.getWorkbench().getModelNodesToDisplay();
    }

    @Override
    public void setGraph(Graph graph) {
        this.getWorkbench().setGraph(graph);
    }

    @Override
    public Knowledge getKnowledge() {
        return null;
    }

    @Override
    public Graph getSourceGraph() {
        return this.getWorkbench().getGraph();
    }

    @Override
    public void layoutByGraph(Graph graph) {
        this.getWorkbench().layoutByGraph(graph);
    }

    @Override
    public void layoutByKnowledge() {
    }

    @Override
    public Rectangle getVisibleRect() {
        return this.getWorkbench().getVisibleRect();
    }

    private void initUI(TimeLagGraphWrapper timeLagGraphWrapper) {
        TimeLagGraph graph = (TimeLagGraph)timeLagGraphWrapper.getGraph();
        this.workbench = new TimeLagGraphWorkbench(graph);
        this.workbench.addPropertyChangeListener(evt -> {
            String propertyName = evt.getPropertyName();
            String[] events = new String[]{"graph", "edgeAdded", "edgeRemoved"};
            if (Arrays.asList(events).contains(propertyName)) {
                if (this.getWorkbench() != null) {
                    TimeLagGraph targetGraph = (TimeLagGraph)this.getWorkbench().getGraph();
                    timeLagGraphWrapper.setGraph(targetGraph);
                    this.updateBootstrapTable(targetGraph);
                }
            } else if ("modelChanged".equals(propertyName)) {
                this.firePropertyChange("modelChanged", null, null);
            }
        });
        JMenuBar menuBar = this.createGraphMenuBar();
        DagGraphToolbar graphToolbar = new DagGraphToolbar(this.getWorkbench());
        graphToolbar.setMaximumSize(new Dimension(140, 450));
        this.graphEditorScroll.setPreferredSize(new Dimension(760, 450));
        this.graphEditorScroll.setViewportView(this.workbench);
        Box topBox = Box.createVerticalBox();
        topBox.setPreferredSize(new Dimension(820, 400));
        Box topGraphBox = Box.createHorizontalBox();
        topGraphBox.add(graphToolbar);
        topGraphBox.add(this.graphEditorScroll);
        Box instructionBox = Box.createHorizontalBox();
        instructionBox.setMaximumSize(new Dimension(820, 40));
        JLabel label = new JLabel("Double click variable/node rectangle to change name. More information on graph edge types and colorings");
        label.setFont(new Font("SansSerif", 0, 12));
        JButton infoBtn = new JButton(new ImageIcon(ImageUtils.getImage(this, "info.png")));
        infoBtn.setBorder(new EmptyBorder(0, 0, 0, 0));
        infoBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String helpHS = "/resources/javahelp/TetradHelp.hs";
                try {
                    URL url = this.getClass().getResource("/resources/javahelp/TetradHelp.hs");
                    HelpSet helpSet = new HelpSet(null, url);
                    helpSet.setHomeID("graph_edge_types");
                    HelpBroker broker = helpSet.createHelpBroker();
                    CSH.DisplayHelpFromSource listener = new CSH.DisplayHelpFromSource(broker);
                    listener.actionPerformed(e);
                }
                catch (Exception ee) {
                    System.out.println("HelpSet " + ee.getMessage());
                    System.out.println("HelpSet /resources/javahelp/TetradHelp.hs not found");
                    throw new IllegalArgumentException();
                }
            }
        });
        instructionBox.add(label);
        instructionBox.add(Box.createHorizontalStrut(2));
        instructionBox.add(infoBtn);
        topBox.add(topGraphBox);
        topBox.add(instructionBox);
        this.edgeTypeTable.setPreferredSize(new Dimension(820, 150));
        JTabbedPane tabbedPane = new JTabbedPane(3);
        tabbedPane.addTab("Graph", new PaddingPanel(topBox));
        tabbedPane.addTab("Edges", this.edgeTypeTable);
        this.add((Component)menuBar, "North");
        this.add((Component)tabbedPane, "Center");
        this.edgeTypeTable.update(graph);
        this.validate();
    }

    private void updateBootstrapTable(Graph graph) {
        this.edgeTypeTable.update(graph);
        this.validate();
    }

    private JMenuBar createGraphMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        GraphFileMenu fileMenu = new GraphFileMenu(this, this.getWorkbench(), false);
        JMenu editMenu = this.createNumLagsMenu();
        menuBar.add(fileMenu);
        menuBar.add(editMenu);
        menuBar.add(new LayoutMenu(this));
        return menuBar;
    }

    private JMenu createNumLagsMenu() {
        final TimeLagGraph graph = (TimeLagGraph)this.getLayoutEditable().getGraph();
        final JMenu edit = new JMenu("Number-of-Lags = " + graph.getMaxLag());
        JMenuItem configuration = new JMenuItem("Configuration...");
        edit.add(configuration);
        configuration.addActionListener(e -> {
            class ConfigurationEditor
            extends JPanel {
                private static final long serialVersionUID = 1878934284195587094L;
                private int maxLag;
                private int numInitialLags;

                public ConfigurationEditor(TimeLagGraph graph) {
                    this.maxLag = graph.getMaxLag();
                    this.numInitialLags = graph.getNumInitialLags();
                    SpinnerNumberModel maxLagSpinnerModel = new SpinnerNumberModel(graph.getMaxLag(), 0, 300, 1);
                    JSpinner maxLagSpinner = new JSpinner(maxLagSpinnerModel);
                    maxLagSpinner.addChangeListener(e -> {
                        JSpinner spinner = (JSpinner)e.getSource();
                        SpinnerNumberModel model = (SpinnerNumberModel)spinner.getModel();
                        int value = (Integer)model.getValue();
                        this.setMaxLag(value);
                    });
                    SpinnerNumberModel initialLagsSpinnerModel = new SpinnerNumberModel(graph.getNumInitialLags(), 1, 300, 1);
                    JSpinner initialLagsSpinner = new JSpinner(initialLagsSpinnerModel);
                    initialLagsSpinner.addChangeListener(e -> {
                        JSpinner spinner = (JSpinner)e.getSource();
                        SpinnerNumberModel model = (SpinnerNumberModel)spinner.getModel();
                        int value = (Integer)model.getValue();
                        this.setNumInitialLags(value);
                    });
                    this.setLayout(new BorderLayout());
                    Box box = Box.createVerticalBox();
                    Box b1 = Box.createHorizontalBox();
                    b1.add(new JLabel("Time lag graph configuration:"));
                    b1.add(Box.createHorizontalGlue());
                    box.add(b1);
                    Box b2 = Box.createHorizontalBox();
                    b2.add(new JLabel("Maximum Lag = "));
                    b2.add(Box.createHorizontalGlue());
                    b2.add(maxLagSpinner);
                    box.add(b2);
                    box.setBorder(new EmptyBorder(10, 10, 10, 10));
                    this.add((Component)box, "Center");
                }

                public int getMaxLag() {
                    return this.maxLag;
                }

                public void setMaxLag(int maxLag) {
                    this.maxLag = maxLag;
                    edit.setText("Number-of-Lags = " + maxLag);
                }

                public int getNumInitialLags() {
                    return this.numInitialLags;
                }

                public void setNumInitialLags(int numInitialLags) {
                    this.numInitialLags = numInitialLags;
                }
            }
            final ConfigurationEditor editor = new ConfigurationEditor((TimeLagGraph)this.getGraph());
            EditorWindow editorWindow = new EditorWindow(editor, "Configuration...", "Save", true, this);
            DesktopController.getInstance().addEditorWindow(editorWindow, JLayeredPane.PALETTE_LAYER);
            editorWindow.pack();
            editorWindow.setVisible(true);
            editorWindow.addInternalFrameListener(new InternalFrameAdapter(){
                {
                }

                @Override
                public void internalFrameClosed(InternalFrameEvent e) {
                    EditorWindow window = (EditorWindow)e.getSource();
                    if (window.isCanceled()) {
                        return;
                    }
                    graph.setMaxLag(editor.getMaxLag());
                    graph.setNumInitialLags(editor.getNumInitialLags());
                    LayoutUtils.lastLayout(TimeLagGraphEditor.this.getLayoutEditable());
                }
            });
        });
        return edit;
    }

    @Override
    public IndependenceTest getIndependenceTest() {
        Graph graph = this.getWorkbench().getGraph();
        EdgeListGraph listGraph = new EdgeListGraph(graph);
        return new IndTestDSep(listGraph);
    }

    private LayoutEditable getLayoutEditable() {
        return this.layoutEditable;
    }
}

