/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.TimeSeriesData;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.math3.util.FastMath;

class TimeSeriesDataDisplayTable
extends AbstractTableModel {
    private final TimeSeriesData dataSet;
    private final int colCount;
    private final int maxRowCount;

    public TimeSeriesDataDisplayTable(TimeSeriesData dataSet) {
        this.dataSet = dataSet;
        this.colCount = dataSet.getNumVars();
        this.maxRowCount = dataSet.getNumTimePoints();
    }

    @Override
    public String getColumnName(int col) {
        if (col == 0) {
            return "";
        }
        if (col < this.colCount + 1) {
            return this.dataSet.getVariableNames().get(col - 1);
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return FastMath.max(this.maxRowCount, 100);
    }

    @Override
    public int getColumnCount() {
        return this.colCount < 30 ? 30 : this.colCount + 1;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (column == 0) {
            return row + 1;
        }
        if (column < this.dataSet.getNumVars() + 1 && row < this.dataSet.getNumTimePoints()) {
            return this.dataSet.getDatum(row, column - 1);
        }
        return null;
    }

    public Class getColumnClass(int col) {
        return Number.class;
    }

    public TimeSeriesData getDataSet() {
        return this.dataSet;
    }
}

