/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.editor.EditorWindow;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class UnderliningsAction
extends AbstractAction
implements ClipboardOwner {
    private final GraphWorkbench workbench;

    public UnderliningsAction(GraphWorkbench graph) {
        super("Underlinings");
        this.workbench = graph;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Box b = Box.createVerticalBox();
        JTextArea textArea = new JTextArea();
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        JScrollPane scroll = new JScrollPane(textArea);
        scroll.setPreferredSize(new Dimension(600, 400));
        textArea.append("Underlinings:");
        boolean allEmpty = true;
        List<Node> nodes = this.workbench.getGraph().getNodes();
        Collections.sort(nodes);
        for (Node node : nodes) {
            List<String> types = this.workbench.getTriplesClassificationTypes();
            List<List<Triple>> triplesList = this.workbench.getTriplesLists(node);
            boolean existsClassification = false;
            for (List<Triple> list : triplesList) {
                if (list.isEmpty()) continue;
                existsClassification = true;
                break;
            }
            if (!existsClassification) continue;
            textArea.append("\n\nNode " + node);
            for (int j = 0; j < types.size(); ++j) {
                String type = types.get(j);
                List<Triple> triples = triplesList.get(j);
                if (triples.isEmpty()) continue;
                textArea.append("\n\n    ");
                textArea.append(type + this.niceList(triples));
            }
            allEmpty = false;
        }
        if (allEmpty) {
            textArea.append("\n\nNo underlinings were marked in this graph. All triple classifications not marked are inferable from the graph itself.");
        }
        Box b2 = Box.createHorizontalBox();
        b2.add(scroll);
        textArea.setCaretPosition(0);
        b.add(b2);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add(b);
        EditorWindow window = new EditorWindow(panel, "Underlinings", "Close", false, JOptionUtils.centeringComp());
        DesktopController.getInstance().addEditorWindow(window, JLayeredPane.PALETTE_LAYER);
        window.setVisible(true);
    }

    private String niceList(List<Triple> triples) {
        if (triples.isEmpty()) {
            return "--NONE--";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("\n\n        ");
        for (int i = 0; i < triples.size(); ++i) {
            buf.append(this.pathFor(triples.get(i), this.workbench.getGraph()));
            if (i >= triples.size() - 1) continue;
            buf.append("\n        ");
        }
        return buf.toString();
    }

    private String pathFor(Triple triple, Graph graph) {
        List<Node> path = this.asList(triple);
        return GraphUtils.pathString(graph, path);
    }

    private List<Node> asList(Triple triple) {
        LinkedList<Node> list = new LinkedList<Node>();
        list.add(triple.getX());
        list.add(triple.getY());
        list.add(triple.getZ());
        return list;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

