/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.Evidence;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.editor.UpdaterEditingTableModelObs;
import edu.cmu.tetradapp.editor.UpdaterEditingTableObs;
import edu.cmu.tetradapp.model.UpdaterWrapper;
import edu.cmu.tetradapp.util.SortingComboBox;
import edu.cmu.tetradapp.util.WatchedProcess;
import edu.cmu.tetradapp.workbench.DisplayNode;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Window;
import java.text.NumberFormat;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.table.TableCellEditor;

public class UpdatedBayesImWizardObs
extends JPanel {
    private final Evidence evidence;
    private final GraphWorkbench workbench;
    private final UpdaterWrapper updaterWrapper;
    private Node selectedNode;
    private final JComboBox varNamesComboBox;
    private final JComboBox varNamesComboBox2;
    private UpdaterEditingTableObs editingTable;
    private JPanel tablePanel;
    private final JPanel marginalsPanel;

    public UpdatedBayesImWizardObs(UpdaterWrapper updaterWrapper, GraphWorkbench workbench, int tab, Node selectedNode) {
        if (updaterWrapper == null) {
            throw new NullPointerException();
        }
        this.updaterWrapper = updaterWrapper;
        this.selectedNode = selectedNode;
        this.evidence = updaterWrapper.getBayesUpdater().getEvidence();
        this.workbench = workbench;
        this.workbench.setAllowDoubleClickActions(false);
        this.setLayout(new BorderLayout());
        this.varNamesComboBox = this.makeVarNamesDropdown();
        this.varNamesComboBox2 = this.makeVarNamesDropdown();
        Node modelNode = (Node)this.varNamesComboBox.getSelectedItem();
        workbench.deselectAll();
        workbench.selectNode(modelNode);
        selectedNode = (Node)this.varNamesComboBox.getSelectedItem();
        this.marginalsPanel = new JPanel();
        this.marginalsPanel.setLayout(new BorderLayout());
        JComponent marginalDisplay = this.createMarginalDisplay(selectedNode);
        this.marginalsPanel.add((Component)marginalDisplay, "Center");
        JTabbedPane probsPane = new JTabbedPane(1);
        this.setupMarginalsDisplay(probsPane);
        if (updaterWrapper.getBayesUpdater().getUpdatedBayesIm() != null) {
            this.setupConditionalProbabilitiesDisplay(selectedNode, updaterWrapper, probsPane);
        }
        tab = tab < probsPane.getTabCount() ? tab : 0;
        probsPane.setSelectedIndex(tab);
        this.add((Component)new JScrollPane(probsPane), "Center");
        this.varNamesComboBox.addActionListener(e -> {
            Node node = (Node)this.varNamesComboBox.getSelectedItem();
            this.setCurrentNode(node);
        });
        this.varNamesComboBox2.addActionListener(e -> {
            Node node = (Node)this.varNamesComboBox2.getSelectedItem();
            this.setCurrentNode(node);
        });
        workbench.addPropertyChangeListener(e -> {
            List selection;
            if (e.getPropertyName().equals("selectedNodes") && (selection = (List)e.getNewValue()).size() == 1) {
                Node node = (Node)selection.get(0);
                this.varNamesComboBox.setSelectedItem(node);
                DisplayNode graphNode = this.getWorkbench().getSelectedNode();
                if (graphNode == null) {
                    return;
                }
                Node tetradNode = graphNode.getModelNode();
                updaterWrapper.getParams().set("variable", (Object)updaterWrapper.getBayesUpdater().getBayesIm().getBayesPm().getVariable(tetradNode));
            }
        });
    }

    private void setupMarginalsDisplay(JTabbedPane probsPane) {
        probsPane.add("Marginal Probabilities", this.marginalsPanel);
        probsPane.addChangeListener(e -> {
            JTabbedPane tabbedPane = (JTabbedPane)e.getSource();
            int tab = tabbedPane.getSelectedIndex();
            this.firePropertyChange("updatedBayesImWizardTab", null, (Object)tab);
        });
    }

    private void setupConditionalProbabilitiesDisplay(Node selectedNode, UpdaterWrapper updaterWrapper, JTabbedPane probsPane) {
        UpdaterEditingTableModelObs editingTableModel = new UpdaterEditingTableModelObs(selectedNode, updaterWrapper.getBayesUpdater().getUpdatedBayesIm(), this);
        this.editingTable = new UpdaterEditingTableObs(editingTableModel);
        JScrollPane scroll = new JScrollPane(this.editingTable);
        scroll.setPreferredSize(new Dimension(0, 150));
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new BorderLayout());
        this.tablePanel.add((Component)scroll, "Center");
        this.editingTable.grabFocus();
        probsPane.add("Conditional Probabilities", this.createConditionalDisplay());
    }

    private JComboBox makeVarNamesDropdown() {
        SortingComboBox varNamesComboBox = new SortingComboBox(){

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        varNamesComboBox.setBackground(Color.white);
        Graph graph = this.updaterWrapper.getBayesUpdater().getManipulatedGraph();
        for (Node o : graph.getNodes()) {
            Node nodeO = o;
            if (nodeO.getNodeType() != NodeType.MEASURED) continue;
            ((JComboBox)varNamesComboBox).addItem(o);
        }
        if (this.selectedNode != null) {
            varNamesComboBox.setSelectedItem(this.selectedNode);
        } else {
            varNamesComboBox.setSelectedIndex(0);
            this.selectedNode = (Node)varNamesComboBox.getSelectedItem();
        }
        return varNamesComboBox;
    }

    private JComponent createConditionalDisplay() {
        Box conditionalBox = Box.createVerticalBox();
        Box b1 = Box.createHorizontalBox();
        b1.add(new JLabel("Probabilities for values of "));
        b1.add(this.varNamesComboBox);
        b1.add(new JLabel(" conditional on values"));
        b1.add(Box.createHorizontalGlue());
        conditionalBox.add(b1);
        Box b0 = Box.createHorizontalBox();
        b0.add(new JLabel("of its parents, updated to reflect the following evidence:"));
        b0.add(Box.createHorizontalGlue());
        conditionalBox.add(b0);
        conditionalBox.add(Box.createVerticalStrut(10));
        this.addListOfEvidence(conditionalBox);
        conditionalBox.add(Box.createVerticalStrut(20));
        Box b2 = Box.createHorizontalBox();
        b2.add(this.tablePanel);
        conditionalBox.add(b2);
        return conditionalBox;
    }

    private void addListOfEvidence(Box verticalBox) {
        boolean foundACondition = false;
        for (int i = 0; i < this.evidence.getNumNodes(); ++i) {
            if (this.evidence.hasNoEvidence(i)) continue;
            foundACondition = true;
            Node node = this.evidence.getNode(i);
            Box c = Box.createHorizontalBox();
            c.add(Box.createRigidArea(new Dimension(30, 1)));
            StringBuilder buf = new StringBuilder();
            buf.append("<html>").append(node.getName()).append(" = ");
            boolean listedOneAlready = false;
            for (int j = 0; j < this.evidence.getNumCategories(i); ++j) {
                if (!this.evidence.getProposition().isAllowed(i, j)) continue;
                if (listedOneAlready) {
                    buf.append(" <i>OR</i>  ");
                }
                BayesIm manipulatedBayesIm = this.updaterWrapper.getBayesUpdater().getManipulatedBayesIm();
                String valueName = manipulatedBayesIm.getBayesPm().getCategory(node, j);
                buf.append(valueName);
                listedOneAlready = true;
            }
            buf.append("</html>");
            c.add(new JLabel(buf.toString()));
            c.add(Box.createHorizontalGlue());
            verticalBox.add(c);
        }
        if (!foundACondition) {
            Box e = Box.createHorizontalBox();
            e.add(Box.createRigidArea(new Dimension(30, 1)));
            e.add(new JLabel("--No Evidence--"));
            e.add(Box.createHorizontalGlue());
            verticalBox.add(e);
        }
    }

    private JComponent createMarginalDisplay(Node node) throws RuntimeException {
        String value;
        int i;
        if (node == null) {
            throw new NullPointerException();
        }
        Box marginalBox = Box.createVerticalBox();
        Box b1 = Box.createHorizontalBox();
        b1.add(new JLabel("Marginal probabilities for variable "));
        b1.add(this.varNamesComboBox2);
        b1.add(new JLabel(", updated"));
        b1.add(Box.createHorizontalGlue());
        marginalBox.add(b1);
        Box b2 = Box.createHorizontalBox();
        b2.add(new JLabel("to reflect the following evidence:"));
        b2.add(Box.createHorizontalGlue());
        marginalBox.add(b2);
        marginalBox.add(Box.createRigidArea(new Dimension(1, 10)));
        this.addListOfEvidence(marginalBox);
        marginalBox.add(Box.createRigidArea(new Dimension(1, 20)));
        Node node1 = this.updaterWrapper.getBayesUpdater().getBayesIm().getNode(node.getName());
        int nodeIndex = this.updaterWrapper.getBayesUpdater().getBayesIm().getNodeIndex(node1);
        double[] priorMarginals = this.updaterWrapper.getBayesUpdater().calculatePriorMarginals(nodeIndex);
        double[] updatedMarginals = this.updaterWrapper.getBayesUpdater().calculateUpdatedMarginals(nodeIndex);
        Font font = this.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        Font smallFont = new Font("Dialog", 1, 10);
        int maxWidth = 0;
        for (i = 0; i < this.updaterWrapper.getBayesUpdater().getBayesIm().getNumColumns(nodeIndex); ++i) {
            value = this.updaterWrapper.getBayesUpdater().getBayesIm().getBayesPm().getCategory(node, i);
            String label = node + " = " + value;
            int width = fontMetrics.stringWidth(label);
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        for (i = 0; i < this.updaterWrapper.getBayesUpdater().getBayesIm().getNumColumns(nodeIndex); ++i) {
            value = this.updaterWrapper.getBayesUpdater().getBayesIm().getBayesPm().getCategory(node, i);
            Box c = Box.createHorizontalBox();
            c.add(Box.createRigidArea(new Dimension(10, 1)));
            String label = node + " = " + value;
            int width = fontMetrics.stringWidth(label);
            c.add(Box.createRigidArea(new Dimension(maxWidth - width, 0)));
            c.add(new JLabel(label));
            int priorWidth = (int)(150.0 * priorMarginals[i]);
            int updatedWidth = (int)(150.0 * updatedMarginals[i]);
            JPanel priorBar = Double.isNaN(priorMarginals[i]) || priorMarginals[i] < 0.0 ? this.makeBar(150, 3, Color.LIGHT_GRAY) : this.makeBar(priorWidth, 6, Color.BLUE.brighter());
            JPanel updatedBar = Double.isNaN(updatedMarginals[i]) || updatedMarginals[i] < 0.0 ? this.makeBar(150, 3, Color.LIGHT_GRAY) : this.makeBar(updatedWidth, 6, Color.RED);
            c.add(Box.createRigidArea(new Dimension(10, 1)));
            Box d = Box.createVerticalBox();
            Box e1 = Box.createHorizontalBox();
            e1.add(priorBar);
            e1.add(Box.createHorizontalGlue());
            Box e2 = Box.createHorizontalBox();
            e2.add(updatedBar);
            e2.add(Box.createHorizontalGlue());
            d.add(e1);
            d.add(Box.createVerticalStrut(2));
            d.add(e2);
            c.add(d);
            c.add(Box.createHorizontalGlue());
            Box f = Box.createVerticalBox();
            Box g1 = Box.createHorizontalBox();
            Box g2 = Box.createHorizontalBox();
            JLabel priorValueLabel = new JLabel(this.textLabel(priorMarginals[i]));
            JLabel marginalValueLabel = new JLabel(this.textLabel(updatedMarginals[i]));
            priorValueLabel.setFont(smallFont);
            g1.add(Box.createHorizontalGlue());
            g1.add(priorValueLabel);
            g2.add(Box.createHorizontalGlue());
            g2.add(marginalValueLabel);
            f.add(g1);
            f.add(g2);
            c.add(f);
            marginalBox.add(c);
            marginalBox.add(Box.createRigidArea(new Dimension(1, 5)));
        }
        marginalBox.add(Box.createGlue());
        return marginalBox;
    }

    private String textLabel(double prob) {
        if (Double.isNaN(prob)) {
            return "Undefined";
        }
        if (prob < 0.0) {
            return "Unidentifiable";
        }
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        return nf.format(prob);
    }

    private JPanel makeBar(final int width, final int height, Color color) {
        JPanel bar = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(width, height);
            }

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(width, height);
            }
        };
        bar.setBackground(color);
        return bar;
    }

    private void setCurrentNode(final Node node) {
        Window owner = (Window)this.getTopLevelAncestor();
        if (owner == null) {
            this.setCurrentNodeSub(node);
        } else {
            new WatchedProcess(owner){

                @Override
                public void watch() {
                    UpdatedBayesImWizardObs.this.setCurrentNodeSub(node);
                }
            };
        }
    }

    private void setCurrentNodeSub(Node node) {
        if (node == this.selectedNode) {
            return;
        }
        this.selectedNode = node;
        this.getWorkbench().deselectAll();
        this.getWorkbench().selectNode(this.selectedNode);
        if (this.varNamesComboBox.getSelectedItem() != node) {
            this.varNamesComboBox.setSelectedItem(node);
        }
        if (this.varNamesComboBox2.getSelectedItem() != node) {
            this.varNamesComboBox2.setSelectedItem(node);
        }
        if (this.updaterWrapper.getBayesUpdater().getUpdatedBayesIm() != null) {
            TableCellEditor cellEditor = this.editingTable.getCellEditor();
            if (cellEditor != null) {
                cellEditor.cancelCellEditing();
            }
            UpdaterEditingTableModelObs editingTableModel = new UpdaterEditingTableModelObs(node, this.updaterWrapper.getBayesUpdater().getUpdatedBayesIm(), this);
            this.editingTable = new UpdaterEditingTableObs(editingTableModel);
            JScrollPane scroll = new JScrollPane(this.editingTable);
            scroll.setPreferredSize(new Dimension(0, 150));
            this.tablePanel.removeAll();
            this.tablePanel.add((Component)scroll, "Center");
            this.tablePanel.revalidate();
            this.tablePanel.repaint();
        }
        this.marginalsPanel.removeAll();
        this.marginalsPanel.add((Component)this.createMarginalDisplay(node), "Center");
        this.marginalsPanel.revalidate();
        this.marginalsPanel.repaint();
    }

    private GraphWorkbench getWorkbench() {
        return this.workbench;
    }

    public Node getSelectedNode() {
        return this.selectedNode;
    }
}

