/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetradapp.editor.UpdatedBayesImWizardObs;
import javax.swing.table.AbstractTableModel;

final class UpdaterEditingTableModelObs
extends AbstractTableModel {
    private final BayesIm bayesIm;
    private final int nodeIndex;
    private final UpdatedBayesImWizardObs wizard;
    private int failedRow = -1;
    private int failedCol = -1;

    public UpdaterEditingTableModelObs(Node node, BayesIm bayesIm, UpdatedBayesImWizardObs wizard) {
        if (node == null) {
            throw new NullPointerException("Node must not be null.");
        }
        if (bayesIm == null) {
            throw new NullPointerException("Bayes IM must not be null.");
        }
        if (wizard == null) {
            throw new NullPointerException("Wizard must not be null.");
        }
        this.bayesIm = bayesIm;
        this.nodeIndex = bayesIm.getNodeIndex(node);
        this.wizard = wizard;
    }

    @Override
    public String getColumnName(int col) {
        Node node = this.getBayesIm().getNode(this.getNodeIndex());
        if (col < this.getBayesIm().getNumParents(this.getNodeIndex())) {
            int parent = this.getBayesIm().getParent(this.getNodeIndex(), col);
            return this.getBayesIm().getNode(parent).getName();
        }
        int numNodeVals = this.getBayesIm().getNumColumns(this.getNodeIndex());
        int valIndex = col - this.getBayesIm().getNumParents(this.getNodeIndex());
        if (valIndex < numNodeVals) {
            String value = this.getBayesIm().getBayesPm().getCategory(node, valIndex);
            return node.getName() + "=" + value;
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.getBayesIm().getNumRows(this.getNodeIndex());
    }

    @Override
    public int getColumnCount() {
        int numParents = this.getBayesIm().getNumParents(this.getNodeIndex());
        int numColumns = this.getBayesIm().getNumColumns(this.getNodeIndex());
        return numParents + numColumns;
    }

    @Override
    public Object getValueAt(int tableRow, int tableCol) {
        int[] parentVals = this.getBayesIm().getParentValues(this.getNodeIndex(), tableRow);
        if (tableCol < parentVals.length) {
            Node columnNode = this.getBayesIm().getNode(this.getBayesIm().getParent(this.getNodeIndex(), tableCol));
            BayesPm bayesPm = this.getBayesIm().getBayesPm();
            return bayesPm.getCategory(columnNode, parentVals[tableCol]);
        }
        int colIndex = tableCol - parentVals.length;
        if (colIndex < this.getBayesIm().getNumColumns(this.getNodeIndex())) {
            return this.getBayesIm().getProbability(this.getNodeIndex(), tableRow, colIndex);
        }
        return "null";
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col >= this.getBayesIm().getNumParents(this.getNodeIndex());
    }

    public Class getColumnClass(int col) {
        boolean isParent = col < this.getBayesIm().getNumParents(this.getNodeIndex());
        return isParent ? Object.class : Number.class;
    }

    public BayesIm getBayesIm() {
        return this.bayesIm;
    }

    public int getNodeIndex() {
        return this.nodeIndex;
    }

    public UpdatedBayesImWizardObs getWizard() {
        return this.wizard;
    }

    public int getFailedRow() {
        return this.failedRow;
    }

    public int getFailedCol() {
        return this.failedCol;
    }

    public void resetFailedRow() {
        this.failedRow = -1;
    }

    public void resetFailedCol() {
        this.failedCol = -1;
    }
}

