/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetradapp.editor.NumberCellEditor;
import edu.cmu.tetradapp.editor.NumberCellRenderer;
import edu.cmu.tetradapp.editor.UpdaterEditingTableModelObs;
import java.awt.FontMetrics;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.commons.math3.util.FastMath;

final class UpdaterEditingTableObs
extends JTable {
    private int focusRow;
    private int focusCol;

    public UpdaterEditingTableObs(UpdaterEditingTableModelObs model) {
        super(model);
        NumberCellEditor editor = new NumberCellEditor();
        editor.setEmptyString("*");
        this.setDefaultEditor(Number.class, editor);
        NumberCellRenderer renderer = new NumberCellRenderer();
        renderer.setEmptyString("*");
        this.setDefaultRenderer((Class)Number.class, (TableCellRenderer)renderer);
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setResizingAllowed(true);
        this.setAutoResizeMode(0);
        this.setCellSelectionEnabled(true);
        ListSelectionModel rowSelectionModel = this.getSelectionModel();
        rowSelectionModel.addListSelectionListener(e -> {
            ListSelectionModel m = (ListSelectionModel)e.getSource();
            this.setFocusRow(m.getAnchorSelectionIndex());
        });
        ListSelectionModel columnSelectionModel = this.getColumnModel().getSelectionModel();
        columnSelectionModel.addListSelectionListener(e -> {
            ListSelectionModel m = (ListSelectionModel)e.getSource();
            this.setFocusColumn(m.getAnchorSelectionIndex());
        });
        this.setFocusRow(0);
        this.setFocusColumn(0);
    }

    public void setDefaultRenderer(Class columnClass, TableCellRenderer renderer) {
        super.setDefaultRenderer(columnClass, renderer);
        if (this.getModel() instanceof UpdaterEditingTableModelObs) {
            UpdaterEditingTableModelObs model = (UpdaterEditingTableModelObs)this.getModel();
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            for (int i = 0; i < model.getColumnCount(); ++i) {
                int minimumWidth;
                TableColumn column = this.getColumnModel().getColumn(i);
                String columnName = model.getColumnName(i);
                int currentWidth = column.getPreferredWidth();
                if (columnName == null || (minimumWidth = fontMetrics.stringWidth(columnName) + 8) <= currentWidth) continue;
                column.setPreferredWidth(minimumWidth);
            }
        }
    }

    private void setFocusRow(int row) {
        UpdaterEditingTableModelObs editingTableModel = (UpdaterEditingTableModelObs)this.getModel();
        int failedRow = editingTableModel.getFailedRow();
        if (failedRow != -1) {
            row = failedRow;
            editingTableModel.resetFailedRow();
        }
        this.focusRow = row;
        if (this.focusRow < this.getRowCount()) {
            this.setRowSelectionInterval(this.focusRow, this.focusRow);
            this.editCellAt(this.focusRow, this.focusCol);
        }
    }

    private void setFocusColumn(int col) {
        UpdaterEditingTableModelObs editingTableModel = (UpdaterEditingTableModelObs)this.getModel();
        int failedCol = editingTableModel.getFailedCol();
        if (failedCol != -1) {
            col = failedCol;
            editingTableModel.resetFailedCol();
        }
        if (col < this.getNumParents()) {
            col = this.getNumParents();
        }
        this.focusCol = FastMath.max(col, this.getNumParents());
        if (this.focusCol >= this.getNumParents() && this.focusCol < this.getColumnCount()) {
            this.setColumnSelectionInterval(this.focusCol, this.focusCol);
            this.editCellAt(this.focusRow, this.focusCol);
        }
    }

    private int getNumParents() {
        UpdaterEditingTableModelObs editingTableModel = (UpdaterEditingTableModelObs)this.getModel();
        BayesIm bayesIm = editingTableModel.getBayesIm();
        int nodeIndex = editingTableModel.getNodeIndex();
        return bayesIm.getNumParents(nodeIndex);
    }
}

