/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor.datamanip;

import cern.colt.list.DoubleArrayList;
import cern.jet.stat.Descriptive;
import edu.cmu.tetrad.data.ContinuousDiscretizationSpec;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.data.DiscretizationSpec;
import edu.cmu.tetrad.data.Discretizer;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.editor.datamanip.DiscretizationEditor;
import edu.cmu.tetradapp.editor.datamanip.RangeEditor;
import edu.cmu.tetradapp.util.IntSpinner;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.text.NumberFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;

class ContinuousDiscretizationEditor
extends JPanel
implements DiscretizationEditor {
    private final double min;
    private final double max;
    private final JPanel rangeEditorPanel;
    private final Box selectionButtonsBox;
    private RangeEditor rangeEditor;
    private final IntSpinner categorySpinner;
    private int numberOfCategories;
    private final double[] data;
    private Method method;

    public ContinuousDiscretizationEditor(DataSet dataSet, ContinuousVariable variable) {
        if (variable == null) {
            throw new NullPointerException();
        }
        this.method = Method.NONE;
        this.data = new double[dataSet.getNumRows()];
        int col = dataSet.getColumn(variable);
        for (int i = 0; i < dataSet.getNumRows(); ++i) {
            this.data[i] = dataSet.getDouble(i, col);
        }
        this.min = Descriptive.min(new DoubleArrayList(this.data));
        this.max = Descriptive.max(new DoubleArrayList(this.data));
        this.numberOfCategories = 2;
        this.categorySpinner = new IntSpinner(2, 1, 2);
        this.categorySpinner.setMin(2);
        this.categorySpinner.setMaximumSize(this.categorySpinner.getPreferredSize());
        this.categorySpinner.setSize(this.categorySpinner.getPreferredSize());
        this.categorySpinner.setMinimumSize(this.categorySpinner.getPreferredSize());
        this.categorySpinner.setFilter(new MyFilter());
        this.categorySpinner.addChangeListener(e -> {
            JSpinner spinner = (JSpinner)e.getSource();
            if (!spinner.getValue().equals(this.numberOfCategories)) {
                this.setNumCategories((Integer)spinner.getValue());
            }
        });
        this.rangeEditorPanel = new JPanel();
        this.rangeEditorPanel.setLayout(new BorderLayout());
        this.setNumCategories(2);
        Box b1 = Box.createVerticalBox();
        b1.add(Box.createVerticalStrut(10));
        Box b3 = Box.createHorizontalBox();
        b3.add(Box.createRigidArea(new Dimension(10, 0)));
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        String label = "Min = " + nf.format(this.min) + " , Max = " + nf.format(this.max);
        b3.add(new JLabel(label));
        b3.add(Box.createHorizontalGlue());
        b1.add(b3);
        b1.add(Box.createVerticalStrut(5));
        this.selectionButtonsBox = Box.createHorizontalBox();
        this.buildSelectionBox();
        b1.add(this.selectionButtonsBox);
        b1.add(Box.createVerticalStrut(5));
        Box b5 = Box.createHorizontalBox();
        b5.add(Box.createRigidArea(new Dimension(10, 0)));
        b5.add(new JLabel("Use "));
        b5.add(this.categorySpinner);
        b5.add(new JLabel(" categories to discretize."));
        b5.add(Box.createHorizontalGlue());
        b1.add(b5);
        b1.add(Box.createVerticalStrut(10));
        Box b6 = Box.createHorizontalBox();
        b6.add(Box.createRigidArea(new Dimension(10, 0)));
        b6.add(new JLabel("Edit category names and breakpoints:"));
        b6.add(Box.createHorizontalGlue());
        b1.add(b6);
        b1.add(Box.createVerticalStrut(10));
        b1.add(this.rangeEditorPanel);
        b1.add(Box.createVerticalGlue());
        this.setLayout(new BorderLayout());
        this.add((Component)b1, "Center");
    }

    public int getNumCategories() {
        return this.numberOfCategories;
    }

    @Override
    public ContinuousDiscretizationSpec getDiscretizationSpec() {
        ContinuousDiscretizationSpec spec = this.rangeEditor.getDiscretizationSpec();
        if (this.method == Method.EQUAL_SIZE_BUCKETS) {
            spec.setMethod(1);
        } else if (this.method == Method.EVENLY_DIVIDED_INTERNVALS) {
            spec.setMethod(2);
        } else if (this.method == Method.NONE) {
            spec.setMethod(3);
        }
        return spec;
    }

    public void setMethod(Method method) {
        this.method = method;
        this.buildSelectionBox();
        this.setNumCategories(this.numberOfCategories);
    }

    public Method getMethod() {
        return this.method;
    }

    public void setDiscretizationSpec(DiscretizationSpec _spec) {
        ContinuousDiscretizationSpec spec = (ContinuousDiscretizationSpec)_spec;
        this.rangeEditorPanel.removeAll();
        if (spec.getMethod() == 2) {
            this.method = Method.EVENLY_DIVIDED_INTERNVALS;
        } else if (spec.getMethod() == 1) {
            this.method = Method.EQUAL_SIZE_BUCKETS;
        }
        this.buildSelectionBox();
        this.rangeEditor = this.createRangeEditor(spec);
        this.numberOfCategories = spec.getCategories().size();
        this.categorySpinner.setValue(this.numberOfCategories);
        this.rangeEditorPanel.add((Component)this.rangeEditor, "Center");
        this.rangeEditorPanel.revalidate();
        this.rangeEditorPanel.repaint();
    }

    public void setNumCategories(int numCategories) {
        ContinuousDiscretizationSpec defaultDiscretizationSpec;
        if (numCategories < 2) {
            throw new IllegalArgumentException();
        }
        this.numberOfCategories = numCategories;
        this.rangeEditorPanel.removeAll();
        if (this.method == Method.EVENLY_DIVIDED_INTERNVALS) {
            defaultDiscretizationSpec = this.getEvenlyDividedDiscretizationSpec(numCategories);
        } else if (this.method == Method.EQUAL_SIZE_BUCKETS) {
            defaultDiscretizationSpec = this.getEqualFreqDiscretizationSpec(numCategories);
        } else if (this.method == Method.NONE) {
            defaultDiscretizationSpec = this.getDontDiscretizeSpec(numCategories);
        } else {
            throw new IllegalStateException("Unknown method " + (Object)((Object)this.method));
        }
        this.rangeEditor = this.createRangeEditor(defaultDiscretizationSpec);
        this.rangeEditorPanel.add((Component)this.rangeEditor, "Center");
        this.rangeEditorPanel.revalidate();
        this.rangeEditorPanel.repaint();
        this.categorySpinner.setValue(numCategories);
        Preferences.userRoot().putInt("latestNumCategories", numCategories);
    }

    private void buildSelectionBox() {
        this.selectionButtonsBox.removeAll();
        Box vBox = Box.createVerticalBox();
        vBox.add(new JLabel("Discretization Method: "));
        JRadioButton none = new JRadioButton("Don't Discretize", this.method == Method.NONE);
        JRadioButton equalInterval = new JRadioButton("Evenly Distributed Intervals", this.method == Method.EVENLY_DIVIDED_INTERNVALS);
        JRadioButton equalBuckets = new JRadioButton("Evenly Distributed Values", this.method == Method.EQUAL_SIZE_BUCKETS);
        none.setHorizontalTextPosition(4);
        equalInterval.setHorizontalTextPosition(4);
        equalBuckets.setHorizontalTextPosition(4);
        ButtonGroup group = new ButtonGroup();
        group.add(equalBuckets);
        group.add(equalInterval);
        group.add(none);
        none.addActionListener(e -> {
            this.method = Method.NONE;
            this.setNumCategories(this.numberOfCategories);
        });
        equalInterval.addActionListener(e -> {
            this.method = Method.EVENLY_DIVIDED_INTERNVALS;
            this.setNumCategories(this.numberOfCategories);
        });
        equalBuckets.addActionListener(e -> {
            this.method = Method.EQUAL_SIZE_BUCKETS;
            this.setNumCategories(this.numberOfCategories);
        });
        if (this.method == Method.EQUAL_SIZE_BUCKETS) {
            equalBuckets.setSelected(true);
        } else if (this.method == Method.EVENLY_DIVIDED_INTERNVALS) {
            equalInterval.setSelected(true);
        } else if (this.method == Method.NONE) {
            none.setSelected(true);
        } else {
            none.setSelected(true);
        }
        vBox.add(none);
        vBox.add(equalBuckets);
        vBox.add(equalInterval);
        this.selectionButtonsBox.add(Box.createHorizontalStrut(10));
        this.selectionButtonsBox.add(vBox);
        this.selectionButtonsBox.add(Box.createHorizontalGlue());
    }

    private RangeEditor createRangeEditor(ContinuousDiscretizationSpec discretizationSpec) {
        return new RangeEditor(discretizationSpec);
    }

    private ContinuousDiscretizationSpec getEqualFreqDiscretizationSpec(int numCategories) {
        double[] breakpoints = Discretizer.getEqualFrequencyBreakPoints(this.data, numCategories);
        List<String> cats = ContinuousDiscretizationEditor.defaultCategories(numCategories);
        return new ContinuousDiscretizationSpec(breakpoints, cats);
    }

    private ContinuousDiscretizationSpec getDontDiscretizeSpec(int numCategories) {
        double[] breakpoints = Discretizer.getEqualFrequencyBreakPoints(this.data, numCategories);
        List<String> cats = ContinuousDiscretizationEditor.defaultCategories(numCategories);
        return new ContinuousDiscretizationSpec(breakpoints, cats, 3);
    }

    private ContinuousDiscretizationSpec getEvenlyDividedDiscretizationSpec(int numCategories) {
        double[] breakpoints = ContinuousDiscretizationEditor.defaultBreakpoints(this.max, this.min, numCategories);
        List<String> categories = ContinuousDiscretizationEditor.defaultCategories(numCategories);
        return new ContinuousDiscretizationSpec(breakpoints, categories);
    }

    private static double[] defaultBreakpoints(double max, double min, int numCategories) {
        double interval = (max - min) / (double)numCategories;
        double[] breakpoints = new double[numCategories - 1];
        for (int i = 0; i < breakpoints.length; ++i) {
            breakpoints[i] = min + (double)(i + 1) * interval;
        }
        return breakpoints;
    }

    private static List<String> defaultCategories(int numCategories) {
        LinkedList<String> categories = new LinkedList<String>();
        for (int i = 0; i < numCategories; ++i) {
            categories.add(DataUtils.defaultCategory(i));
        }
        return categories;
    }

    public static enum Method {
        EQUAL_SIZE_BUCKETS,
        EVENLY_DIVIDED_INTERNVALS,
        NONE;

    }

    private static class MyFilter
    implements IntSpinner.Filter {
        private MyFilter() {
        }

        @Override
        public int filter(int oldValue, int newValue) {
            if (newValue < 2) {
                newValue = oldValue;
            }
            return newValue;
        }
    }
}

