/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor.datamanip;

import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.data.DoubleDataBox;
import edu.cmu.tetrad.data.MixedDataBox;
import edu.cmu.tetrad.data.VerticalIntDataBox;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeVariableType;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.editor.FinalizingParameterEditor;
import edu.cmu.tetradapp.model.DataWrapper;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.lang3.SerializationUtils;

public class DeterminismEditor
extends JPanel
implements FinalizingParameterEditor {
    private static final long serialVersionUID = 6513664419620810219L;
    private DataSet sourceDataSet;
    private DataSet sourceDataSetCopy;
    private DataSet mergedDataSet;
    private Parameters parameters;

    @Override
    public void setup() {
        Box container = Box.createVerticalBox();
        container.setPreferredSize(new Dimension(360, 200));
        List<Set<Integer>> mergedList = this.detectDeterministicVars();
        Box mergedVarsBox = Box.createVerticalBox();
        mergedVarsBox.setPreferredSize(new Dimension(320, 160));
        mergedVarsBox.setBorder(BorderFactory.createTitledBorder("Deterministic Interventional Variables"));
        JTable table = new JTable();
        DefaultTableModel tableModel = new DefaultTableModel();
        table.setModel(tableModel);
        List<String> columnNames = Arrays.asList("Deterministic variables", "Merged new variable");
        tableModel.setColumnIdentifiers(columnNames.toArray());
        mergedList.forEach(indexSet -> {
            Integer[] indexArray;
            LinkedList<String> varNameList = new LinkedList<String>();
            for (Integer integer : indexArray = indexSet.toArray(new Integer[0])) {
                varNameList.add(this.sourceDataSetCopy.getVariable(integer).getName());
            }
            String varNames = String.join((CharSequence)", ", varNameList);
            String mergedVarName = String.join((CharSequence)"_", varNameList);
            List<String> rowData = Arrays.asList(varNames, mergedVarName);
            tableModel.addRow(rowData.toArray());
        });
        JScrollPane scrollPane = new JScrollPane(table);
        mergedVarsBox.add(scrollPane);
        container.add(mergedVarsBox);
        this.add((Component)container, "Center");
        this.mergeDeterministicVars(mergedList);
    }

    @Override
    public boolean finalizeEdit() {
        this.parameters.set("DeterminisedDataset", (Object)this.mergedDataSet);
        return true;
    }

    @Override
    public void setParams(Parameters params) {
        this.parameters = params;
    }

    @Override
    public void setParentModels(Object[] parentModels) {
        DataSet dataSet;
        if (parentModels == null || parentModels.length == 0) {
            throw new IllegalArgumentException("There must be parent model");
        }
        DataWrapper dataWrapper = null;
        for (Object parent : parentModels) {
            if (!(parent instanceof DataWrapper)) continue;
            dataWrapper = (DataWrapper)parent;
        }
        if (dataWrapper == null) {
            throw new IllegalArgumentException("Should have have a data wrapper as a parent");
        }
        DataModel model = dataWrapper.getSelectedDataModel();
        if (!(model instanceof DataSet)) {
            throw new IllegalArgumentException("The dataset must be a rectangular dataset");
        }
        if (!this.containsInterventionalVariables(model)) {
            throw new IllegalArgumentException("The dataset must contain interventional variables");
        }
        this.sourceDataSet = dataSet = (DataSet)model;
        this.sourceDataSetCopy = SerializationUtils.clone(dataSet);
    }

    @Override
    public boolean mustBeShown() {
        return true;
    }

    private List<Set<Integer>> detectDeterministicVars() {
        ArrayList deterministicList = new ArrayList();
        for (int i = 0; i < this.sourceDataSetCopy.getVariables().size(); ++i) {
            HashSet<Integer> set = new HashSet<Integer>();
            for (int j = i + 1; j < this.sourceDataSetCopy.getVariables().size(); ++j) {
                Node innerVar;
                Node outerVar = this.sourceDataSetCopy.getVariable(i);
                if (!this.isDeterministic(outerVar, innerVar = this.sourceDataSetCopy.getVariable(j)) || !this.isDeterministic(innerVar, outerVar)) continue;
                if (outerVar.getNodeVariableType() == innerVar.getNodeVariableType()) {
                    set.add(j);
                    continue;
                }
                if (outerVar.getNodeVariableType() != NodeVariableType.DOMAIN && innerVar.getNodeVariableType() != NodeVariableType.DOMAIN) {
                    set.add(j);
                    continue;
                }
                String fullyDeterminisedDomainVar = "fullyDeterminisedDomainVar";
                if (outerVar.getNodeVariableType() == NodeVariableType.DOMAIN) {
                    outerVar.addAttribute(fullyDeterminisedDomainVar, true);
                    continue;
                }
                innerVar.addAttribute(fullyDeterminisedDomainVar, true);
            }
            deterministicList.add(set);
        }
        ArrayList<Set<Integer>> mergedList = new ArrayList<Set<Integer>>();
        for (int k = 0; k < deterministicList.size(); ++k) {
            if (((Set)deterministicList.get(k)).isEmpty()) continue;
            HashSet<Integer> mergedSet = new HashSet<Integer>();
            mergedSet.add(k);
            mergedSet.addAll((Collection)deterministicList.get(k));
            for (Integer index : (Set)deterministicList.get(k)) {
                mergedSet.addAll((Collection)deterministicList.get(index));
                ((Set)deterministicList.get(index)).clear();
            }
            mergedList.add(mergedSet);
        }
        return mergedList;
    }

    private void mergeDeterministicVars(List<Set<Integer>> mergedList) {
        LinkedList toBeRemovedColumns = new LinkedList();
        mergedList.forEach(indexSet -> {
            LinkedList<Node> varList = new LinkedList<Node>();
            LinkedList<String> varNameList = new LinkedList<String>();
            Integer[] indexArray = indexSet.toArray(new Integer[0]);
            for (int i = 0; i < indexArray.length; ++i) {
                varList.add(this.sourceDataSetCopy.getVariable(indexArray[i]));
                varNameList.add(this.sourceDataSetCopy.getVariable(indexArray[i]).getName());
                if (i <= 0) continue;
                toBeRemovedColumns.add(indexArray[i]);
            }
            String mergedVarName = String.join((CharSequence)"_", varNameList);
            Node mergedNode = (Node)varList.get(0);
            mergedNode.setName(mergedVarName);
            NodeVariableType mergedNodeVariableType = mergedNode.getNodeVariableType();
            for (Integer integer : indexArray) {
                Node node = this.sourceDataSetCopy.getVariable(integer);
                if (node.getNodeVariableType() != NodeVariableType.INTERVENTION_VALUE || node.getNodeVariableType() == mergedNodeVariableType) continue;
                mergedNode.setNodeVariableType(NodeVariableType.INTERVENTION_VALUE);
                break;
            }
        });
        LinkedList<Node> nodeList = new LinkedList<Node>();
        HashMap<Node, Integer> origIndexMap = new HashMap<Node, Integer>();
        this.sourceDataSetCopy.getVariables().forEach(node -> {
            int columnIndex = this.sourceDataSetCopy.getColumn((Node)node);
            if (!toBeRemovedColumns.contains(columnIndex)) {
                nodeList.add((Node)node);
                origIndexMap.put((Node)node, columnIndex);
            }
        });
        this.mergedDataSet = this.createDataBoxData(nodeList, origIndexMap);
    }

    private boolean containsInterventionalVariables(DataModel model) {
        LinkedList interventionalVars = new LinkedList();
        model.getVariables().forEach(e -> {
            if (e.getNodeVariableType() == NodeVariableType.INTERVENTION_STATUS || e.getNodeVariableType() == NodeVariableType.INTERVENTION_VALUE) {
                interventionalVars.add(e.getName());
            }
        });
        return interventionalVars.size() > 0;
    }

    private boolean isDeterministic(Node x, Node y) {
        if (x instanceof DiscreteVariable && y instanceof DiscreteVariable) {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            int xColumnIndex = this.sourceDataSet.getColumn(x);
            int yColumnIndex = this.sourceDataSet.getColumn(y);
            int numRows = this.sourceDataSet.getNumRows();
            for (int i = 0; i < numRows; ++i) {
                Object objX = this.sourceDataSet.getObject(i, xColumnIndex);
                Object objY = this.sourceDataSet.getObject(i, yColumnIndex);
                if (map.containsKey(objX)) {
                    if (map.get(objX).equals(objY)) continue;
                    return false;
                }
                map.put(objX, objY);
            }
            return true;
        }
        return false;
    }

    private BoxDataSet createDataBoxData(List<Node> nodeList, Map<Node, Integer> origIndexMap) {
        boolean isDiscrete = false;
        boolean isContinuous = false;
        for (Node node : nodeList) {
            if (node instanceof ContinuousVariable) {
                isContinuous = true;
                continue;
            }
            isDiscrete = true;
        }
        if (isDiscrete && isContinuous) {
            return this.createMixedDataBox(nodeList, origIndexMap);
        }
        if (isContinuous) {
            return this.createContinuousDataBox(nodeList, origIndexMap);
        }
        if (isDiscrete) {
            return this.createDiscreteDataBox(nodeList, origIndexMap);
        }
        return null;
    }

    private BoxDataSet createMixedDataBox(List<Node> nodeList, Map<Node, Integer> origIndexMap) {
        int numOfCols = nodeList.size();
        int numOfRows = this.sourceDataSetCopy.getNumRows();
        double[][] continuousData = new double[numOfCols][];
        int[][] discreteData = new int[numOfCols][];
        for (int i = 0; i < numOfCols; ++i) {
            int j;
            Node node = nodeList.get(i);
            if (node instanceof DiscreteVariable) {
                discreteData[i] = new int[numOfRows];
                for (j = 0; j < numOfRows; ++j) {
                    discreteData[i][j] = this.sourceDataSetCopy.getInt(j, origIndexMap.get(node));
                }
                continue;
            }
            continuousData[i] = new double[numOfRows];
            for (j = 0; j < numOfRows; ++j) {
                continuousData[i][j] = this.sourceDataSetCopy.getDouble(j, origIndexMap.get(node));
            }
        }
        return new BoxDataSet(new MixedDataBox(nodeList, numOfRows, continuousData, discreteData), nodeList);
    }

    private BoxDataSet createContinuousDataBox(List<Node> nodeList, Map<Node, Integer> origIndexMap) {
        int numOfCols = nodeList.size();
        int numOfRows = this.sourceDataSetCopy.getNumRows();
        double[][] data = new double[numOfRows][numOfCols];
        for (int i = 0; i < numOfRows; ++i) {
            for (int j = 0; j < numOfCols; ++j) {
                Node node = nodeList.get(j);
                data[i][j] = this.sourceDataSetCopy.getDouble(i, origIndexMap.get(node));
            }
        }
        return new BoxDataSet(new DoubleDataBox(data), nodeList);
    }

    private BoxDataSet createDiscreteDataBox(List<Node> nodeList, Map<Node, Integer> origIndexMap) {
        int numOfCols = nodeList.size();
        int numOfRows = this.sourceDataSetCopy.getNumRows();
        int[][] data = new int[numOfCols][numOfRows];
        for (int i = 0; i < numOfCols; ++i) {
            for (int j = 0; j < numOfRows; ++j) {
                Node node = nodeList.get(i);
                data[i][j] = this.sourceDataSetCopy.getInt(j, origIndexMap.get(node));
            }
        }
        return new BoxDataSet(new VerticalIntDataBox(data), nodeList);
    }
}

