/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor.datamanip;

import edu.cmu.tetrad.data.DiscreteDiscretizationSpec;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.data.DiscretizationSpec;
import edu.cmu.tetradapp.editor.datamanip.DiscretizationEditor;
import edu.cmu.tetradapp.util.StringTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

class DiscreteDiscretizationEditor
extends JPanel
implements DiscretizationEditor {
    private RemapEditor remapEditor;
    private final DiscreteVariable variable;

    public DiscreteDiscretizationEditor(DiscreteVariable variable) {
        if (variable == null) {
            throw new NullPointerException();
        }
        this.variable = variable;
        Box b1 = Box.createVerticalBox();
        b1.add(Box.createVerticalStrut(10));
        Box b6 = Box.createHorizontalBox();
        b6.add(Box.createRigidArea(new Dimension(10, 0)));
        b6.add(new JLabel("Edit new categories that old categories should map to:"));
        b6.add(Box.createHorizontalGlue());
        b1.add(b6);
        b1.add(Box.createVerticalStrut(10));
        b1.add(this.createRemapEditor());
        b1.add(Box.createVerticalGlue());
        this.setLayout(new BorderLayout());
        this.add((Component)b1, "Center");
    }

    @Override
    public DiscretizationSpec getDiscretizationSpec() {
        return this.remapEditor.getDiscretizationSpec();
    }

    public void setDiscretizationSpec(DiscretizationSpec spec) {
        this.remapEditor.setDiscretizationSpec((DiscreteDiscretizationSpec)spec);
    }

    private RemapEditor createRemapEditor() {
        List<String> categories = DiscreteDiscretizationEditor.defaultCategories(this.variable);
        int[] remap = DiscreteDiscretizationEditor.defaultRemap(categories);
        DiscreteDiscretizationSpec discretizationSpec = new DiscreteDiscretizationSpec(remap, categories);
        this.remapEditor = new RemapEditor(this.variable, discretizationSpec);
        return this.remapEditor;
    }

    private static int[] defaultRemap(List<String> categories) {
        int[] remap = new int[categories.size()];
        for (int i = 0; i < remap.length; ++i) {
            remap[i] = i;
        }
        return remap;
    }

    private static List<String> defaultCategories(DiscreteVariable variable) {
        LinkedList<String> categories = new LinkedList<String>();
        for (int i = 0; i < variable.getNumCategories(); ++i) {
            categories.add(variable.getCategory(i));
        }
        return categories;
    }

    static final class RemapEditor
    extends JComponent {
        private final DiscreteVariable variable;
        private final List<String> newCategories = new LinkedList<String>();
        private StringTextField[] categoryFields;
        private StringTextField[] rangeFields;
        private final Map<Object, Integer> labels = new HashMap<Object, Integer>();
        private final LinkedList<StringTextField> focusTraveralOrder = new LinkedList();
        private final DiscreteVariable oldVariable;

        public RemapEditor(DiscreteVariable variable, DiscreteDiscretizationSpec spec) {
            this.variable = variable;
            if (variable == null) {
                throw new NullPointerException();
            }
            if (spec == null) {
                throw new NullPointerException();
            }
            this.oldVariable = variable;
            int[] remap = spec.getRemap();
            List<String> categories = spec.getCategories();
            for (int i = 0; i < this.oldVariable.getNumCategories(); ++i) {
                this.newCategories.add(categories.get(remap[i]));
            }
            Box panel = Box.createVerticalBox();
            this.createCategoryFields();
            this.createRangeFields();
            for (int i = 0; i < categories.size(); ++i) {
                Box row = Box.createHorizontalBox();
                row.add(Box.createRigidArea(new Dimension(10, 0)));
                row.add(new JLabel(i + 1 + ". "));
                row.add(this.categoryFields[i]);
                row.add(new BigLabel());
                row.add(this.rangeFields[i]);
                row.add(Box.createHorizontalGlue());
                panel.add(row);
            }
            this.setLayout(new BorderLayout());
            this.add((Component)panel, "Center");
            this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

                @Override
                public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
                    int index = focusTraveralOrder.indexOf(aComponent);
                    int size = focusTraveralOrder.size();
                    if (index != -1) {
                        return (Component)focusTraveralOrder.get((index + 1) % size);
                    }
                    return this.getFirstComponent(focusCycleRoot);
                }

                @Override
                public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
                    int index = focusTraveralOrder.indexOf(aComponent);
                    int size = focusTraveralOrder.size();
                    if (index != -1) {
                        return (Component)focusTraveralOrder.get((index - 1) % size);
                    }
                    return this.getFirstComponent(focusCycleRoot);
                }

                @Override
                public Component getFirstComponent(Container focusCycleRoot) {
                    return (Component)focusTraveralOrder.getFirst();
                }

                @Override
                public Component getLastComponent(Container focusCycleRoot) {
                    return (Component)focusTraveralOrder.getLast();
                }

                @Override
                public Component getDefaultComponent(Container focusCycleRoot) {
                    return this.getFirstComponent(focusCycleRoot);
                }
            });
            this.setFocusCycleRoot(true);
        }

        private void createCategoryFields() {
            this.categoryFields = new StringTextField[this.oldVariable.getNumCategories()];
            for (int i = 0; i < this.oldVariable.getNumCategories(); ++i) {
                this.categoryFields[i] = new StringTextField(this.oldVariable.getCategory(i), 6);
                this.labels.put(this.categoryFields[i], i);
                this.categoryFields[i].setEditable(false);
            }
        }

        private void createRangeFields() {
            this.rangeFields = new StringTextField[this.oldVariable.getNumCategories()];
            for (int i = 0; i < this.oldVariable.getNumCategories(); ++i) {
                this.rangeFields[i] = new StringTextField(this.oldVariable.getCategory(i), 6);
                StringTextField _field = this.rangeFields[i];
                this.rangeFields[i].setFilter((value, oldValue) -> {
                    if (this.labels.get(_field) != null) {
                        int index = this.labels.get(_field);
                        if (value == null) {
                            value = this.oldVariable.getCategory(index);
                        }
                        this.newCategories.set(index, value);
                    }
                    return value;
                });
                this.labels.put(this.rangeFields[i], i);
                this.focusTraveralOrder.add(this.rangeFields[i]);
            }
        }

        public DiscreteVariable getVariable() {
            return this.variable;
        }

        public DiscreteDiscretizationSpec getDiscretizationSpec() {
            LinkedList<String> categoryList = new LinkedList<String>();
            for (String newCategory : this.newCategories) {
                if (categoryList.contains(newCategory)) continue;
                categoryList.add(newCategory);
            }
            int[] remap = new int[this.oldVariable.getNumCategories()];
            for (int i = 0; i < remap.length; ++i) {
                String value = this.newCategories.get(i);
                remap[i] = categoryList.indexOf(value);
            }
            return new DiscreteDiscretizationSpec(remap, categoryList);
        }

        public void setDiscretizationSpec(DiscreteDiscretizationSpec spec) {
            int[] remap = spec.getRemap();
            List<String> categories = spec.getCategories();
            for (int i = 0; i < this.oldVariable.getNumCategories(); ++i) {
                this.rangeFields[i].setValue(categories.get(remap[i]));
            }
        }
    }

    static final class BigLabel
    extends JLabel {
        private static final Font FONT = new Font("Dialog", 1, 20);

        public BigLabel() {
            super(" --> ");
            this.setFont(FONT);
        }
    }
}

