/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor.datamanip;

import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.data.DiscretizationSpec;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.editor.FinalizingParameterEditor;
import edu.cmu.tetradapp.editor.datamanip.ContinuousDiscretizationEditor;
import edu.cmu.tetradapp.editor.datamanip.DiscreteDiscretizationEditor;
import edu.cmu.tetradapp.editor.datamanip.DiscretizationEditor;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.util.IntSpinner;
import edu.cmu.tetradapp.workbench.LayoutUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.math3.util.FastMath;

public class DiscretizationParamsEditor
extends JPanel
implements FinalizingParameterEditor {
    private DataSet sourceDataSet;
    private final Map<Node, DiscretizationEditor> nodeEditors = new HashMap<Node, DiscretizationEditor>();
    private JTabbedPane editorPane;
    private Parameters parameters;

    @Override
    public void setup() {
        System.out.println("setup");
        List<Node> variables = this.sourceDataSet.getVariables();
        LinkedList<Node> allVariables = new LinkedList<Node>();
        LinkedList<Node> discretizeVars = new LinkedList<Node>();
        for (Node node : variables) {
            discretizeVars.add(node);
            allVariables.add(node);
        }
        for (Node node : allVariables) {
            this.nodeEditors.put(node, this.createEditor(node));
        }
        this.finalizeEdit();
        JList<Object> discretizeVariableList = new JList<Object>(new VariableListModel(allVariables));
        discretizeVariableList.setCellRenderer(new VariableBoxRenderer());
        discretizeVariableList.getSelectionModel().setSelectionMode(2);
        discretizeVariableList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JList list = (JList)e.getSource();
                List selected = DiscretizationParamsEditor.getSelected(list);
                DiscretizationParamsEditor.this.finalizeEdit();
                if (selected.size() == 1) {
                    DiscretizationParamsEditor.this.editorPane.removeAll();
                    Node node = (Node)selected.get(0);
                    DiscretizationParamsEditor.this.editorPane.add(node.getName(), (JPanel)DiscretizationParamsEditor.this.nodeEditors.get(node));
                } else if (1 < selected.size()) {
                    if (this.allContinuous(selected)) {
                        DiscretizationParamsEditor.this.editorPane.removeAll();
                        Node first = (Node)selected.get(0);
                        Node last = (Node)selected.get(selected.size() - 1);
                        String label = first.getName() + " - " + last.getName();
                        DiscretizationParamsEditor.this.editorPane.add(label, new VariableSelectionEditor(selected));
                    } else {
                        DiscretizationParamsEditor.this.editorPane.removeAll();
                    }
                }
            }

            private boolean allContinuous(List<Node> selected) {
                for (Node node : selected) {
                    if (node instanceof ContinuousVariable) continue;
                    return false;
                }
                return true;
            }
        });
        for (Node node : discretizeVars) {
            DiscretizationSpec spec;
            JPanel editor;
            if (node instanceof ContinuousVariable) {
                ContinuousVariable continuousVariable = (ContinuousVariable)node;
                editor = new ContinuousDiscretizationEditor(this.sourceDataSet, continuousVariable);
                spec = this.getSpecs().get(node);
                if (spec == null) continue;
                ((ContinuousDiscretizationEditor)editor).setDiscretizationSpec(spec);
                this.nodeEditors.put(node, (DiscretizationEditor)((Object)editor));
                continue;
            }
            if (!(node instanceof DiscreteVariable)) continue;
            DiscreteVariable variable = (DiscreteVariable)node;
            editor = new DiscreteDiscretizationEditor(variable);
            spec = this.getSpecs().get(node);
            if (spec == null) continue;
            ((DiscreteDiscretizationEditor)editor).setDiscretizationSpec(spec);
            this.nodeEditors.put(node, (DiscretizationEditor)((Object)editor));
        }
        this.editorPane = new JTabbedPane();
        JScrollPane jScrollPane = new JScrollPane(this.editorPane);
        jScrollPane.setPreferredSize(new Dimension(400, 350));
        discretizeVariableList.setSelectedIndex(0);
        Box hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalStrut(5));
        Box selectionBox = Box.createVerticalBox();
        selectionBox.add(Box.createVerticalStrut(5));
        selectionBox.add(Box.createVerticalGlue());
        Box discreteSelectionBox = Box.createVerticalBox();
        JLabel discreteLabel = new JLabel("Variables:");
        JScrollPane discreteListPane = new JScrollPane(discretizeVariableList);
        int width2 = FastMath.max(100, discreteLabel.getPreferredSize().width);
        LayoutUtils.setAllSizes(discreteListPane, new Dimension(width2, 350 - discreteLabel.getPreferredSize().height));
        discreteSelectionBox.add(Box.createVerticalStrut(5));
        discreteSelectionBox.add(LayoutUtils.leftAlignJLabel(discreteLabel));
        discreteSelectionBox.add(discreteListPane);
        discreteSelectionBox.add(Box.createVerticalGlue());
        hBox.add(selectionBox);
        hBox.add(Box.createHorizontalStrut(4));
        hBox.add(discreteSelectionBox);
        hBox.add(Box.createHorizontalStrut(8));
        Box vBox = Box.createVerticalBox();
        vBox.add(Box.createVerticalStrut(5));
        vBox.add(jScrollPane);
        hBox.add(vBox);
        hBox.add(Box.createHorizontalStrut(5));
        this.add((Component)hBox, "Center");
    }

    @Override
    public boolean finalizeEdit() {
        if (this.nodeEditors.isEmpty()) {
            return false;
        }
        HashMap<Node, DiscretizationSpec> map = new HashMap<Node, DiscretizationSpec>();
        for (Node node : this.nodeEditors.keySet()) {
            DiscretizationEditor editor = this.nodeEditors.get(node);
            map.put(node, editor.getDiscretizationSpec());
        }
        this.parameters.set("discretizationSpecs", (Object)map);
        return true;
    }

    @Override
    public void setParams(Parameters params) {
        this.parameters = params;
        this.parameters.set("discretizationSpecs", (Object)new HashMap());
    }

    @Override
    public void setParentModels(Object[] parentModels) {
        if (parentModels == null || parentModels.length == 0) {
            throw new IllegalArgumentException("There must be parent model");
        }
        DataWrapper data = null;
        for (Object parent : parentModels) {
            if (!(parent instanceof DataWrapper)) continue;
            data = (DataWrapper)parent;
        }
        if (data == null) {
            throw new IllegalArgumentException("Should have have a data wrapper as a parent");
        }
        DataModel model = data.getSelectedDataModel();
        if (!(model instanceof DataSet)) {
            throw new IllegalArgumentException("The dataset must be a rectangular dataset");
        }
        this.sourceDataSet = (DataSet)model;
    }

    @Override
    public boolean mustBeShown() {
        return true;
    }

    private static List<Node> getSelected(JList list) {
        List selected = list.getSelectedValuesList();
        LinkedList<Node> nodes = new LinkedList<Node>();
        if (selected != null) {
            for (Object o : selected) {
                nodes.add((Node)o);
            }
        }
        return nodes;
    }

    private DiscretizationEditor createEditor(Node node) {
        if (node instanceof ContinuousVariable) {
            return new ContinuousDiscretizationEditor(this.sourceDataSet, (ContinuousVariable)node);
        }
        if (node instanceof DiscreteVariable) {
            return new DiscreteDiscretizationEditor((DiscreteVariable)node);
        }
        throw new IllegalStateException();
    }

    private void changeNumberOfCategories(int numOfCats, List<Node> nodes) {
        for (Node node : nodes) {
            DiscretizationEditor editor = this.nodeEditors.get(node);
            if (!(editor instanceof ContinuousDiscretizationEditor)) continue;
            ((ContinuousDiscretizationEditor)editor).setNumCategories(numOfCats);
        }
    }

    private void changeMethod(List<Node> nodes, ContinuousDiscretizationEditor.Method method) {
        for (Node node : nodes) {
            DiscretizationEditor editor = this.nodeEditors.get(node);
            if (!(editor instanceof ContinuousDiscretizationEditor)) continue;
            ((ContinuousDiscretizationEditor)editor).setMethod(method);
        }
    }

    private ContinuousDiscretizationEditor.Method getCommonMethod(List<Node> nodes) {
        ContinuousDiscretizationEditor.Method method = null;
        for (Node node : nodes) {
            DiscretizationEditor editor = this.nodeEditors.get(node);
            if (!(editor instanceof ContinuousDiscretizationEditor)) continue;
            ContinuousDiscretizationEditor _editor = (ContinuousDiscretizationEditor)editor;
            if (method != null && method != _editor.getMethod()) {
                return null;
            }
            method = _editor.getMethod();
        }
        return method;
    }

    private int getDefaultCategoryNum(List<Node> nodes) {
        if (nodes.isEmpty()) {
            return 3;
        }
        DiscretizationEditor editor = this.nodeEditors.get(nodes.get(0));
        if (editor instanceof ContinuousDiscretizationEditor) {
            ContinuousDiscretizationEditor _editor = (ContinuousDiscretizationEditor)editor;
            int value = _editor.getNumCategories();
            for (int i = 1; i < nodes.size(); ++i) {
                if (value == _editor.getNumCategories()) continue;
                return 3;
            }
            return value;
        }
        return -1;
    }

    public Map<Node, DiscretizationSpec> getSpecs() {
        return (Map)this.parameters.get("discretizationSpecs");
    }

    private static class VariableListModel
    extends AbstractListModel {
        private final Vector<Node> variables;

        public VariableListModel(List<Node> variables) {
            this.variables = new Vector<Node>(variables);
        }

        @Override
        public int getSize() {
            return this.variables.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.variables.get(index);
        }
    }

    private static class VariableBoxRenderer
    extends DefaultListCellRenderer {
        private VariableBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Node node = (Node)value;
            if (node == null) {
                this.setText("");
            } else {
                this.setText(node.getName());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }

    private class VariableSelectionEditor
    extends JPanel {
        private final List<Node> nodes;

        public VariableSelectionEditor(List<Node> vars) {
            this.setLayout(new BorderLayout());
            this.nodes = vars;
            IntSpinner spinner = new IntSpinner(DiscretizationParamsEditor.this.getDefaultCategoryNum(vars), 1, 3);
            ContinuousDiscretizationEditor.Method method = DiscretizationParamsEditor.this.getCommonMethod(vars);
            spinner.setMin(2);
            spinner.setFilter((oldValue, newValue) -> {
                DiscretizationParamsEditor.this.changeNumberOfCategories(newValue, this.nodes);
                return newValue;
            });
            Box vBox = Box.createVerticalBox();
            vBox.add(new JLabel("Discretization Method: "));
            JRadioButton none = new JRadioButton("Don't Discretize", method == ContinuousDiscretizationEditor.Method.NONE);
            JRadioButton equalBuckets = new JRadioButton("Evenly Distributed Values", method == ContinuousDiscretizationEditor.Method.EQUAL_SIZE_BUCKETS);
            JRadioButton equalInterval = new JRadioButton("Evenly Distributed Intervals", method == ContinuousDiscretizationEditor.Method.EVENLY_DIVIDED_INTERNVALS);
            none.setHorizontalTextPosition(4);
            equalBuckets.setHorizontalTextPosition(4);
            equalInterval.setHorizontalTextPosition(4);
            none.addActionListener(e -> DiscretizationParamsEditor.this.changeMethod(this.nodes, ContinuousDiscretizationEditor.Method.NONE));
            equalBuckets.addActionListener(e -> DiscretizationParamsEditor.this.changeMethod(this.nodes, ContinuousDiscretizationEditor.Method.EQUAL_SIZE_BUCKETS));
            equalInterval.addActionListener(e -> DiscretizationParamsEditor.this.changeMethod(this.nodes, ContinuousDiscretizationEditor.Method.EVENLY_DIVIDED_INTERNVALS));
            ButtonGroup group = new ButtonGroup();
            group.add(none);
            group.add(equalBuckets);
            group.add(equalInterval);
            vBox.add(none);
            vBox.add(equalBuckets);
            vBox.add(equalInterval);
            none.setSelected(true);
            Box buttons = Box.createHorizontalBox();
            buttons.add(vBox);
            buttons.add(Box.createHorizontalGlue());
            buttons.setBorder(new EmptyBorder(15, 5, 5, 5));
            Box cats = Box.createHorizontalBox();
            cats.add(new JLabel(" Change number of categories: "));
            cats.add(spinner);
            cats.add(Box.createHorizontalGlue());
            cats.setBorder(new EmptyBorder(5, 5, 5, 5));
            Box vBox1 = Box.createVerticalBox();
            vBox1.add(buttons);
            vBox1.add(cats);
            vBox1.add(Box.createVerticalGlue());
            this.add((Component)vBox1, "North");
        }
    }
}

