/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor.datamanip;

import edu.cmu.tetrad.data.ContinuousDiscretizationSpec;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.util.DoubleTextField;
import edu.cmu.tetradapp.util.StringTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

final class RangeEditor
extends JComponent {
    private final double[] breakpoints;
    private final List<String> categories;
    private StringTextField[] categoryFields;
    private DoubleTextField[] leftRangeFields;
    private DoubleTextField[] rightRangeFields;
    private final LinkedList<JTextField> focusTraveralOrder = new LinkedList();
    private final Map<Object, Integer> labels = new HashMap<Object, Integer>();
    private final boolean editableRange;

    public RangeEditor(ContinuousDiscretizationSpec spec) {
        this.breakpoints = spec.getBreakpoints();
        this.categories = spec.getCategories();
        this.editableRange = true;
        this.buildEditor();
    }

    public ContinuousDiscretizationSpec getDiscretizationSpec() {
        return new ContinuousDiscretizationSpec(this.breakpoints, this.categories);
    }

    private void buildEditor() {
        Box rangeEditor = Box.createVerticalBox();
        this.createCategoryFields();
        this.createRangeFields();
        for (int i = 0; i < this.categories.size(); ++i) {
            Box row = Box.createHorizontalBox();
            row.add(Box.createRigidArea(new Dimension(10, 0)));
            row.add(new JLabel(i + 1 + ". "));
            row.add(this.categoryFields[i]);
            row.add(new BigLabel(" = [ "));
            row.add(this.leftRangeFields[i]);
            row.add(new BigLabel(", "));
            row.add(this.rightRangeFields[i]);
            if (i < this.categories.size() - 1) {
                row.add(new BigLabel(" )"));
            } else {
                row.add(new BigLabel(" ]"));
            }
            row.add(Box.createHorizontalGlue());
            rangeEditor.add(row);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)rangeEditor, "Center");
        this.setFocusTraversalPolicy(new MyFocusTraversalPolicy());
        this.setFocusCycleRoot(true);
    }

    private void createCategoryFields() {
        this.categoryFields = new StringTextField[this.getNumCategories()];
        for (int i = 0; i < this.getNumCategories(); ++i) {
            String category = this.categories.get(i);
            this.categoryFields[i] = new StringTextField(category, 6);
            StringTextField _field = this.categoryFields[i];
            this.categoryFields[i].setFilter((value, oldValue) -> {
                if (this.labels.get(_field) != null) {
                    int index = this.labels.get(_field);
                    if (value == null) {
                        value = this.categories.get(index);
                    }
                    for (int i1 = 0; i1 < this.categories.size(); ++i1) {
                        if (i1 == index || !this.categories.get(i1).equals(value)) continue;
                        value = this.categories.get(index);
                        break;
                    }
                    this.categories.set(index, value);
                }
                return value;
            });
            this.labels.put(this.categoryFields[i], i);
            this.focusTraveralOrder.add(this.categoryFields[i]);
        }
    }

    private void createRangeFields() {
        this.leftRangeFields = new DoubleTextField[this.getNumCategories()];
        this.rightRangeFields = new DoubleTextField[this.getNumCategories()];
        int maxCategory = this.getNumCategories() - 1;
        this.leftRangeFields[0] = new DoubleTextField(Double.NEGATIVE_INFINITY, 6, NumberFormatUtil.getInstance().getNumberFormat());
        this.leftRangeFields[0].setFilter((value, oldValue) -> oldValue);
        this.rightRangeFields[maxCategory] = new DoubleTextField(Double.POSITIVE_INFINITY, 6, NumberFormatUtil.getInstance().getNumberFormat());
        this.rightRangeFields[maxCategory].setFilter((value, oldValue) -> oldValue);
        this.leftRangeFields[0].setEditable(false);
        this.rightRangeFields[maxCategory].setEditable(false);
        this.leftRangeFields[0].setHorizontalAlignment(0);
        this.rightRangeFields[maxCategory].setHorizontalAlignment(0);
        for (int i = 0; i < this.getNumCategories() - 1; ++i) {
            this.rightRangeFields[i] = new DoubleTextField(this.breakpoints[i], 6, NumberFormatUtil.getInstance().getNumberFormat());
            this.rightRangeFields[i].setEditable(false);
            this.labels.put(this.rightRangeFields[i], i);
            this.leftRangeFields[i + 1] = new DoubleTextField(this.breakpoints[i], 6, NumberFormatUtil.getInstance().getNumberFormat());
            this.leftRangeFields[i + 1].setEditable(this.editableRange);
            this.labels.put(this.leftRangeFields[i + 1], i + 1);
            Integer label = this.labels.get(this.leftRangeFields[i + 1]);
            this.leftRangeFields[i + 1].setFilter((value, oldValue) -> {
                if (label == null) {
                    return oldValue;
                }
                int index = label;
                if (index - 1 > 0 && !(this.breakpoints[index - 2] < value)) {
                    value = this.breakpoints[index - 1];
                }
                if (index - 1 < this.breakpoints.length - 1 && !(value < this.breakpoints[index])) {
                    value = this.breakpoints[index - 1];
                }
                this.breakpoints[index - 1] = value;
                this.getRightRangeFields()[index - 1].setValue(value);
                return value;
            });
            this.labels.put(this.leftRangeFields[i + 1], i + 1);
            this.focusTraveralOrder.add(this.leftRangeFields[i + 1]);
        }
    }

    private DoubleTextField[] getRightRangeFields() {
        return this.rightRangeFields;
    }

    private int getNumCategories() {
        return this.categories.size();
    }

    private static final class BigLabel
    extends JLabel {
        private static final Font FONT = new Font("Dialog", 1, 20);

        public BigLabel(String text) {
            super(text);
            this.setFont(FONT);
        }
    }

    private class MyFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private MyFocusTraversalPolicy() {
        }

        @Override
        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            int index = RangeEditor.this.focusTraveralOrder.indexOf(aComponent);
            int size = RangeEditor.this.focusTraveralOrder.size();
            if (index != -1) {
                return (Component)RangeEditor.this.focusTraveralOrder.get((index + 1) % size);
            }
            return this.getFirstComponent(focusCycleRoot);
        }

        @Override
        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            int index = RangeEditor.this.focusTraveralOrder.indexOf(aComponent);
            int size = RangeEditor.this.focusTraveralOrder.size();
            if (index != -1) {
                return (Component)RangeEditor.this.focusTraveralOrder.get((index - 1) % size);
            }
            return this.getFirstComponent(focusCycleRoot);
        }

        @Override
        public Component getFirstComponent(Container focusCycleRoot) {
            return (Component)RangeEditor.this.focusTraveralOrder.getFirst();
        }

        @Override
        public Component getLastComponent(Container focusCycleRoot) {
            return (Component)RangeEditor.this.focusTraveralOrder.getLast();
        }

        @Override
        public Component getDefaultComponent(Container focusCycleRoot) {
            return this.getFirstComponent(focusCycleRoot);
        }
    }
}

