/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor.search;

import edu.cmu.tetrad.algcomparison.algorithm.Algorithm;
import edu.cmu.tetrad.algcomparison.algorithm.AlgorithmFactory;
import edu.cmu.tetrad.algcomparison.algorithm.oracle.cpdag.SingleGraphAlg;
import edu.cmu.tetrad.algcomparison.utils.HasKnowledge;
import edu.cmu.tetrad.algcomparison.utils.TakesExternalGraph;
import edu.cmu.tetrad.annotation.AlgType;
import edu.cmu.tetrad.annotation.General;
import edu.cmu.tetrad.annotation.LinearGaussian;
import edu.cmu.tetrad.annotation.Mixed;
import edu.cmu.tetrad.annotation.Nonexecutable;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.app.TetradDesktop;
import edu.cmu.tetradapp.model.GeneralAlgorithmRunner;
import edu.cmu.tetradapp.ui.PaddingPanel;
import edu.cmu.tetradapp.ui.model.AlgorithmModel;
import edu.cmu.tetradapp.ui.model.AlgorithmModels;
import edu.cmu.tetradapp.ui.model.IndependenceTestModel;
import edu.cmu.tetradapp.ui.model.IndependenceTestModels;
import edu.cmu.tetradapp.ui.model.ScoreModel;
import edu.cmu.tetradapp.ui.model.ScoreModels;
import edu.cmu.tetradapp.util.DesktopController;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;

public class AlgorithmCard
extends JPanel {
    private static final long serialVersionUID = -7552068626783685630L;
    private final String ALGO_PARAM = "algo";
    private final String IND_TEST_PARAM = "ind_test";
    private final String SCORE_PARAM = "score";
    private final String ALGO_TYPE_PARAM = "algo_type";
    private final String DATASET_FILTER = "dataset_filter";
    private final String KNOWLEDGE_PARAM = "knowledge";
    private final List<JRadioButton> algoTypeOpts = new ArrayList<JRadioButton>();
    private final DefaultListModel<AlgorithmModel> algoModels = new DefaultListModel();
    private final ButtonGroup algoFilterBtnGrp = new ButtonGroup();
    private final ButtonGroup datasetFilterBtnGrp = new ButtonGroup();
    private final Map<AlgorithmModel, Map<DataType, IndependenceTestModel>> defaultIndTestModels = new HashMap<AlgorithmModel, Map<DataType, IndependenceTestModel>>();
    private final Map<AlgorithmModel, Map<DataType, ScoreModel>> defaultScoreModels = new HashMap<AlgorithmModel, Map<DataType, ScoreModel>>();
    private final JCheckBox knowledgeChkBox = new JCheckBox("accepts knowledge");
    private final JRadioButton linearGaussianRadBtn = new JRadioButton("Linear, Gaussian");
    private final JRadioButton mixedRadBtn = new JRadioButton("Mixed Discrete/Gaussian");
    private final JRadioButton generalRadBtn = new JRadioButton("General");
    private final JRadioButton allRadBtn = new JRadioButton("All");
    private final JComboBox<IndependenceTestModel> indTestComboBox = new JComboBox();
    private final JComboBox<ScoreModel> scoreComboBox = new JComboBox();
    private final JList<AlgorithmModel> algorithmList = new JList<AlgorithmModel>(this.algoModels);
    private final JTextArea algoDescTextArea = new JTextArea();
    private final JTextArea scoreDescTextArea = new JTextArea();
    private final JTextArea testDescTextArea = new JTextArea();
    private final GeneralAlgorithmRunner algorithmRunner;
    private final DataType dataType;
    private final TetradDesktop desktop;
    private final boolean multiDataAlgo;
    private boolean updatingTestModels;
    private boolean updatingScoreModels;

    public AlgorithmCard(GeneralAlgorithmRunner algorithmRunner) {
        this.algorithmRunner = algorithmRunner;
        this.dataType = this.getDataType(algorithmRunner);
        this.desktop = (TetradDesktop)DesktopController.getInstance();
        this.multiDataAlgo = algorithmRunner.getSourceGraph() == null && algorithmRunner.getDataModelList().size() > 1;
        this.initComponents();
        this.initListeners();
        this.resetAllSettings();
        this.algorithmList.setSelectionMode(0);
    }

    private void initComponents() {
        this.initDescriptionTextAreas();
        JButton resetSettingsBtn = new JButton("Reset All Settings");
        resetSettingsBtn.addActionListener(e -> this.resetAllSettings());
        JPanel westMainSouthPanel = new JPanel(new BorderLayout(0, 10));
        westMainSouthPanel.add((Component)new TestAndScorePanel(), "Center");
        westMainSouthPanel.add((Component)resetSettingsBtn, "South");
        JPanel westMainWestPanel = new JPanel(new BorderLayout(0, 10));
        westMainWestPanel.add((Component)new AlgorithmFilterPanel(), "Center");
        westMainWestPanel.add((Component)westMainSouthPanel, "South");
        JPanel westMainPanel = new JPanel(new BorderLayout(5, 0));
        westMainPanel.add((Component)westMainWestPanel, "West");
        westMainPanel.add((Component)new AlgorithmListPanel(), "East");
        JPanel testAndScoreDescPanel = new JPanel();
        testAndScoreDescPanel.setLayout(new BoxLayout(testAndScoreDescPanel, 1));
        testAndScoreDescPanel.add(new DescriptionPanel("Test Description", this.testDescTextArea));
        testAndScoreDescPanel.add(Box.createVerticalStrut(10));
        testAndScoreDescPanel.add(new DescriptionPanel("Score Description", this.scoreDescTextArea));
        JPanel centerMainPanel = new JPanel(new BorderLayout(0, 10));
        centerMainPanel.add((Component)new DescriptionPanel("Algorithm Description", this.algoDescTextArea), "Center");
        centerMainPanel.add((Component)testAndScoreDescPanel, "South");
        centerMainPanel.setPreferredSize(new Dimension(235, 200));
        this.setLayout(new BorderLayout(10, 0));
        this.add((Component)westMainPanel, "West");
        this.add((Component)centerMainPanel, "Center");
        if (this.algorithmRunner.hasMissingValues()) {
            this.setPreferredSize(new Dimension(308, 291));
        } else {
            this.setPreferredSize(new Dimension(308, 241));
        }
    }

    private void initListeners() {
        this.knowledgeChkBox.addActionListener(e -> this.refreshAlgorithmList());
        this.linearGaussianRadBtn.addActionListener(e -> this.refreshTestAndScoreList());
        this.mixedRadBtn.addActionListener(e -> this.refreshTestAndScoreList());
        this.generalRadBtn.addActionListener(e -> this.refreshTestAndScoreList());
        this.allRadBtn.addActionListener(e -> this.refreshTestAndScoreList());
        this.algorithmList.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting() && !this.algorithmList.isSelectionEmpty()) {
                this.setAlgorithmDescription();
                this.refreshTestAndScoreList();
                this.validateAlgorithmOption();
            }
        });
        this.indTestComboBox.addActionListener(e -> {
            if (!this.updatingTestModels && this.indTestComboBox.getSelectedIndex() >= 0) {
                this.setIndepTestDescription();
                AlgorithmModel algoModel = this.algorithmList.getSelectedValue();
                Map<DataType, IndependenceTestModel> map = this.defaultIndTestModels.get(algoModel);
                if (map == null) {
                    map = new EnumMap<DataType, IndependenceTestModel>(DataType.class);
                    this.defaultIndTestModels.put(algoModel, map);
                }
                map.put(this.dataType, this.indTestComboBox.getItemAt(this.indTestComboBox.getSelectedIndex()));
            }
        });
        this.scoreComboBox.addActionListener(e -> {
            if (!this.updatingScoreModels && this.scoreComboBox.getSelectedIndex() >= 0) {
                this.setScoreDescription();
                AlgorithmModel algoModel = this.algorithmList.getSelectedValue();
                Map<DataType, ScoreModel> map = this.defaultScoreModels.get(algoModel);
                if (map == null) {
                    map = new EnumMap<DataType, ScoreModel>(DataType.class);
                    this.defaultScoreModels.put(algoModel, map);
                }
                map.put(this.dataType, this.scoreComboBox.getItemAt(this.scoreComboBox.getSelectedIndex()));
            }
        });
    }

    private void initDescriptionTextAreas() {
        this.algoDescTextArea.setWrapStyleWord(true);
        this.algoDescTextArea.setLineWrap(true);
        this.algoDescTextArea.setEditable(false);
        this.scoreDescTextArea.setWrapStyleWord(true);
        this.scoreDescTextArea.setLineWrap(true);
        this.scoreDescTextArea.setEditable(false);
        this.scoreDescTextArea.setRows(6);
        this.testDescTextArea.setWrapStyleWord(true);
        this.testDescTextArea.setLineWrap(true);
        this.testDescTextArea.setEditable(false);
        this.testDescTextArea.setRows(6);
    }

    private DataType getDataType(GeneralAlgorithmRunner algorithmRunner) {
        DataModelList dataModelList = algorithmRunner.getDataModelList();
        if (dataModelList.containsEmptyData()) {
            if (algorithmRunner.getSourceGraph() == null) {
                return null;
            }
            return DataType.Graph;
        }
        DataModel dataSet = dataModelList.get(0);
        if (dataSet.isContinuous() && !(dataSet instanceof ICovarianceMatrix)) {
            return DataType.Continuous;
        }
        if (dataSet.isDiscrete()) {
            return DataType.Discrete;
        }
        if (dataSet.isMixed()) {
            return DataType.Mixed;
        }
        if (dataSet instanceof ICovarianceMatrix) {
            return DataType.Covariance;
        }
        return null;
    }

    public AlgorithmModel getSelectedAlgorithm() {
        return this.algorithmList.getSelectedValue();
    }

    public IndependenceTestModel getSelectedIndependenceTest() {
        if (this.indTestComboBox.isEnabled()) {
            return this.indTestComboBox.getItemAt(this.indTestComboBox.getSelectedIndex());
        }
        return null;
    }

    public ScoreModel getSelectedScore() {
        if (this.scoreComboBox.isEnabled()) {
            this.scoreComboBox.getItemAt(this.scoreComboBox.getSelectedIndex());
        }
        return null;
    }

    private void rememberUserAlgoSelections(Map<String, Object> userAlgoSelections) {
        userAlgoSelections.put(this.IND_TEST_PARAM, this.indTestComboBox.getSelectedItem());
        userAlgoSelections.put(this.SCORE_PARAM, this.scoreComboBox.getSelectedItem());
        userAlgoSelections.put(this.ALGO_TYPE_PARAM, this.algoFilterBtnGrp.getSelection().getActionCommand());
        userAlgoSelections.put(this.DATASET_FILTER, this.datasetFilterBtnGrp.getSelection().getActionCommand());
        userAlgoSelections.put(this.KNOWLEDGE_PARAM, this.knowledgeChkBox.isSelected());
        if (this.algorithmRunner.getGraphs() != null && !this.algorithmRunner.getGraphs().isEmpty()) {
            userAlgoSelections.put(this.ALGO_PARAM, this.algorithmRunner.getAlgorithm().getClass().getAnnotation(edu.cmu.tetrad.annotation.Algorithm.class).name());
        } else {
            userAlgoSelections.put(this.ALGO_PARAM, this.algorithmList.getSelectedValue().toString());
        }
    }

    private void restoreUserAlgoSelections(Map<String, Object> userAlgoSelections) {
        Comparable<IndependenceTestModel> model;
        int i;
        int size;
        ComboBoxModel<Comparable<IndependenceTestModel>> comboBoxModels;
        String value;
        String actCmd;
        Object obj = userAlgoSelections.get(this.DATASET_FILTER);
        if (obj != null && obj instanceof String) {
            actCmd = String.valueOf(obj);
            Enumeration<AbstractButton> e2 = this.datasetFilterBtnGrp.getElements();
            while (e2.hasMoreElements()) {
                JRadioButton radBtn = (JRadioButton)e2.nextElement();
                if (!radBtn.getActionCommand().equals(actCmd)) continue;
                radBtn.setSelected(true);
                break;
            }
        }
        if ((obj = userAlgoSelections.get(this.KNOWLEDGE_PARAM)) != null && obj instanceof Boolean) {
            this.knowledgeChkBox.setSelected((Boolean)obj);
        }
        if ((obj = userAlgoSelections.get(this.ALGO_TYPE_PARAM)) != null && obj instanceof String) {
            actCmd = String.valueOf(obj);
            Optional<JRadioButton> opt = this.algoTypeOpts.stream().filter(e -> e.getActionCommand().equals(actCmd)).findFirst();
            opt.ifPresent(jRadioButton -> jRadioButton.setSelected(true));
        }
        this.refreshAlgorithmList();
        this.refreshTestAndScoreList();
        String selectedAlgoName = null;
        if (this.algorithmRunner.getGraphs() != null && this.algorithmRunner.getGraphs().size() > 0) {
            selectedAlgoName = this.algorithmRunner.getAlgorithm().getClass().getAnnotation(edu.cmu.tetrad.annotation.Algorithm.class).name();
        } else {
            obj = userAlgoSelections.get(this.ALGO_PARAM);
            if (obj != null && obj instanceof String) {
                selectedAlgoName = (String)obj;
            }
        }
        Enumeration<AlgorithmModel> enums = this.algoModels.elements();
        while (enums.hasMoreElements()) {
            AlgorithmModel model2 = enums.nextElement();
            if (!model2.toString().equals(selectedAlgoName)) continue;
            this.algorithmList.setSelectedValue(model2, true);
            break;
        }
        if ((obj = userAlgoSelections.get(this.IND_TEST_PARAM)) != null && obj instanceof IndependenceTestModel) {
            value = obj.toString();
            comboBoxModels = this.indTestComboBox.getModel();
            size = comboBoxModels.getSize();
            for (i = 0; i < size; ++i) {
                model = (IndependenceTestModel)comboBoxModels.getElementAt(i);
                if (!((IndependenceTestModel)model).toString().equals(value)) continue;
                userAlgoSelections.put(this.IND_TEST_PARAM, model);
                this.indTestComboBox.getModel().setSelectedItem(model);
                break;
            }
        }
        if ((obj = userAlgoSelections.get(this.SCORE_PARAM)) != null && obj instanceof ScoreModel) {
            value = obj.toString();
            comboBoxModels = this.scoreComboBox.getModel();
            size = comboBoxModels.getSize();
            for (i = 0; i < size; ++i) {
                model = (ScoreModel)comboBoxModels.getElementAt(i);
                if (!((ScoreModel)model).toString().equals(value)) continue;
                userAlgoSelections.put(this.SCORE_PARAM, model);
                this.scoreComboBox.getModel().setSelectedItem(model);
                break;
            }
        }
    }

    public void refresh() {
        this.restoreUserAlgoSelections(this.algorithmRunner.getUserAlgoSelections());
    }

    public void saveStates() {
        this.rememberUserAlgoSelections(this.algorithmRunner.getUserAlgoSelections());
    }

    public Algorithm getAlgorithmFromInterface(AlgorithmModel algoModel, IndependenceTestModel indTestModel, ScoreModel scoreModel) {
        Class algoClass = algoModel.getAlgorithm().getClazz();
        Class indTestClass = indTestModel == null ? null : indTestModel.getIndependenceTest().getClazz();
        Class scoreClass = scoreModel == null ? null : scoreModel.getScore().getClazz();
        Algorithm algorithm = null;
        try {
            algorithm = AlgorithmFactory.create((Class<? extends Algorithm>)algoClass, indTestClass, scoreClass);
        }
        catch (IllegalAccessException | InstantiationException exception) {
            TetradLogger.getInstance().forceLogMessage(exception.toString());
        }
        if (algorithm != null && algorithm instanceof TakesExternalGraph && this.algorithmRunner.getSourceGraph() != null && !this.algorithmRunner.getDataModelList().isEmpty()) {
            SingleGraphAlg externalGraph = new SingleGraphAlg(this.algorithmRunner.getSourceGraph());
            ((TakesExternalGraph)((Object)algorithm)).setExternalGraph(externalGraph);
        }
        return algorithm;
    }

    public boolean isAllValid() {
        boolean missingScore;
        AlgorithmModel algoModel = this.algorithmList.getSelectedValue();
        IndependenceTestModel indTestModel = this.indTestComboBox.getItemAt(this.indTestComboBox.getSelectedIndex());
        ScoreModel scoreModel = this.scoreComboBox.getItemAt(this.scoreComboBox.getSelectedIndex());
        boolean missingTest = algoModel.isRequiredTest() && indTestModel == null;
        boolean bl = missingScore = algoModel.isRequiredScore() && scoreModel == null;
        if (missingTest && missingScore) {
            String msg = String.format("%s requires both test and score.", algoModel.getAlgorithm().getAnnotation().name());
            JOptionPane.showMessageDialog(this.desktop, msg, "Please Note", 1);
            return false;
        }
        if (missingTest) {
            String msg = String.format("%s requires independence test.", algoModel.getAlgorithm().getAnnotation().name());
            JOptionPane.showMessageDialog(this.desktop, msg, "Please Note", 1);
            return false;
        }
        if (missingScore) {
            String msg = String.format("%s requires score.", algoModel.getAlgorithm().getAnnotation().name());
            JOptionPane.showMessageDialog(this.desktop, msg, "Please Note", 1);
            return false;
        }
        this.algorithmRunner.setAlgorithm(this.getAlgorithmFromInterface(algoModel, indTestModel, scoreModel));
        return true;
    }

    private void validateAlgorithmOption() {
        this.firePropertyChange("algoFwdBtn", null, (Object)true);
        AlgorithmModel algoModel = this.algorithmList.getSelectedValue();
        Class algoClass = algoModel.getAlgorithm().getClazz();
        if (algoClass.isAnnotationPresent(Nonexecutable.class)) {
            String msg;
            try {
                Object algo = algoClass.newInstance();
                Method m = algoClass.getDeclaredMethod("getDescription", new Class[0]);
                m.setAccessible(true);
                try {
                    msg = String.valueOf(m.invoke(algo, new Object[0]));
                }
                catch (InvocationTargetException exception) {
                    msg = "";
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException exception) {
                TetradLogger.getInstance().forceLogMessage(exception.toString());
                msg = "";
            }
            this.firePropertyChange("algoFwdBtn", null, (Object)false);
            JOptionPane.showMessageDialog(this.desktop, msg, "Please Note", 1);
        } else {
            String cmd;
            if (TakesExternalGraph.class.isAssignableFrom(algoClass) && (this.algorithmRunner.getSourceGraph() == null || this.algorithmRunner.getDataModelList().isEmpty())) {
                try {
                    Object algo = algoClass.newInstance();
                    Method m = algoClass.getDeclaredMethod("setExternalGraph", Algorithm.class);
                    m.setAccessible(true);
                    try {
                        Object algorithm = null;
                        m.invoke(algo, algorithm);
                    }
                    catch (IllegalArgumentException | InvocationTargetException exception) {
                        this.firePropertyChange("algoFwdBtn", null, (Object)false);
                        JOptionPane.showMessageDialog(this.desktop, exception.getCause().getMessage(), "Please Note", 1);
                    }
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException exception) {
                    TetradLogger.getInstance().forceLogMessage(exception.toString());
                }
            }
            if ((cmd = algoModel.getAlgorithm().getAnnotation().command()).equalsIgnoreCase("ts-fci") || cmd.equalsIgnoreCase("ts-gfci") || cmd.equalsIgnoreCase("ts-imgs")) {
                DataModel dataModel = this.algorithmRunner.getDataModel();
                Knowledge knowledge = this.algorithmRunner.getKnowledge();
                if ((knowledge == null || knowledge.isEmpty()) && (dataModel.getKnowledge() == null || dataModel.getKnowledge().isEmpty())) {
                    this.firePropertyChange("algoFwdBtn", null, (Object)false);
                    JOptionPane.showMessageDialog(this.desktop, "Time-series algorithm needs lagged data", "Please Note", 1);
                }
            }
        }
    }

    private void refreshAlgorithmList() {
        this.algoModels.clear();
        ButtonModel selectedAlgoType = this.algoFilterBtnGrp.getSelection();
        if (selectedAlgoType != null) {
            AlgorithmModels algorithmModels = AlgorithmModels.getInstance();
            String algoType = selectedAlgoType.getActionCommand();
            if ("all".equals(algoType)) {
                if (this.knowledgeChkBox.isSelected()) {
                    algorithmModels.getModels(this.dataType, this.multiDataAlgo).stream().filter(e -> HasKnowledge.class.isAssignableFrom(e.getAlgorithm().getClazz())).forEach(e -> this.algoModels.addElement((AlgorithmModel)e));
                } else {
                    algorithmModels.getModels(this.dataType, this.multiDataAlgo).stream().forEach(e -> this.algoModels.addElement((AlgorithmModel)e));
                }
            } else if (this.knowledgeChkBox.isSelected()) {
                algorithmModels.getModels(AlgType.valueOf(algoType), this.dataType, this.multiDataAlgo).stream().filter(e -> HasKnowledge.class.isAssignableFrom(e.getAlgorithm().getClazz())).forEach(e -> this.algoModels.addElement((AlgorithmModel)e));
            } else {
                algorithmModels.getModels(AlgType.valueOf(algoType), this.dataType, this.multiDataAlgo).stream().forEach(e -> this.algoModels.addElement((AlgorithmModel)e));
            }
            if (this.algoModels.isEmpty()) {
                this.algoDescTextArea.setText("");
                this.firePropertyChange("algoFwdBtn", null, (Object)false);
            } else {
                this.algorithmList.setSelectedIndex(0);
                this.firePropertyChange("algoFwdBtn", null, (Object)true);
            }
        }
        this.scoreComboBox.setEnabled(this.scoreComboBox.getItemCount() > 0);
    }

    private void refreshTestList() {
        this.updatingTestModels = true;
        this.indTestComboBox.removeAllItems();
        AlgorithmModel algoModel = this.algorithmList.getSelectedValue();
        if (algoModel != null && algoModel.isRequiredTest()) {
            List<IndependenceTestModel> models = IndependenceTestModels.getInstance().getModels(this.dataType);
            if (this.linearGaussianRadBtn.isSelected()) {
                models.stream().filter(e -> e.getIndependenceTest().getClazz().isAnnotationPresent(LinearGaussian.class)).forEach(e -> this.indTestComboBox.addItem((IndependenceTestModel)e));
            } else if (this.mixedRadBtn.isSelected()) {
                models.stream().filter(e -> e.getIndependenceTest().getClazz().isAnnotationPresent(Mixed.class)).forEach(e -> this.indTestComboBox.addItem((IndependenceTestModel)e));
            } else if (this.generalRadBtn.isSelected()) {
                models.stream().filter(e -> e.getIndependenceTest().getClazz().isAnnotationPresent(General.class)).forEach(e -> this.indTestComboBox.addItem((IndependenceTestModel)e));
            } else if (this.allRadBtn.isSelected()) {
                models.stream().forEach(e -> this.indTestComboBox.addItem((IndependenceTestModel)e));
            }
        }
        this.updatingTestModels = false;
        if (this.indTestComboBox.getItemCount() > 0) {
            IndependenceTestModel testModel;
            this.indTestComboBox.setEnabled(true);
            Map<DataType, IndependenceTestModel> map = this.defaultIndTestModels.get(algoModel);
            if (map == null) {
                map = new EnumMap<DataType, IndependenceTestModel>(DataType.class);
                this.defaultIndTestModels.put(algoModel, map);
            }
            if ((testModel = map.get((Object)this.dataType)) == null && (testModel = IndependenceTestModels.getInstance().getDefaultModel(this.dataType)) == null) {
                testModel = this.indTestComboBox.getItemAt(0);
            }
            this.indTestComboBox.setSelectedItem(testModel);
        } else {
            this.indTestComboBox.setEnabled(false);
        }
        if (this.indTestComboBox.getSelectedIndex() == -1) {
            this.testDescTextArea.setText("");
        }
    }

    private void refreshScoreList() {
        this.updatingScoreModels = true;
        this.scoreComboBox.removeAllItems();
        AlgorithmModel algoModel = this.algorithmList.getSelectedValue();
        if (algoModel != null && algoModel.isRequiredScore()) {
            List<ScoreModel> models = ScoreModels.getInstance().getModels(this.dataType);
            if (this.linearGaussianRadBtn.isSelected()) {
                models.stream().filter(e -> e.getScore().getClazz().isAnnotationPresent(LinearGaussian.class)).forEach(e -> this.scoreComboBox.addItem((ScoreModel)e));
            } else if (this.mixedRadBtn.isSelected()) {
                models.stream().filter(e -> e.getScore().getClazz().isAnnotationPresent(Mixed.class)).forEach(e -> this.scoreComboBox.addItem((ScoreModel)e));
            } else if (this.generalRadBtn.isSelected()) {
                models.stream().filter(e -> e.getScore().getClazz().isAnnotationPresent(General.class)).forEach(e -> this.scoreComboBox.addItem((ScoreModel)e));
            } else if (this.allRadBtn.isSelected()) {
                models.stream().forEach(e -> this.scoreComboBox.addItem((ScoreModel)e));
            }
        }
        this.updatingScoreModels = false;
        if (this.scoreComboBox.getItemCount() > 0) {
            ScoreModel scoreModel;
            this.scoreComboBox.setEnabled(true);
            Map<DataType, ScoreModel> map = this.defaultScoreModels.get(algoModel);
            if (map == null) {
                map = new EnumMap<DataType, ScoreModel>(DataType.class);
                this.defaultScoreModels.put(algoModel, map);
            }
            if ((scoreModel = map.get((Object)this.dataType)) == null && (scoreModel = ScoreModels.getInstance().getDefaultModel(this.dataType)) == null) {
                scoreModel = this.scoreComboBox.getItemAt(0);
            }
            this.scoreComboBox.setSelectedItem(scoreModel);
        } else {
            this.scoreComboBox.setEnabled(false);
        }
        if (this.scoreComboBox.getSelectedIndex() == -1) {
            this.scoreDescTextArea.setText("");
        }
    }

    private void refreshTestAndScoreList() {
        this.refreshTestList();
        this.refreshScoreList();
    }

    private void resetAllSettings() {
        this.defaultIndTestModels.clear();
        this.defaultScoreModels.clear();
        this.datasetFilterBtnGrp.setSelected(this.allRadBtn.getModel(), true);
        this.knowledgeChkBox.setSelected(false);
        if (!this.algoTypeOpts.isEmpty()) {
            this.algoTypeOpts.get(0).setSelected(true);
        }
        this.refreshAlgorithmList();
        this.refreshTestList();
        this.refreshScoreList();
    }

    private void setAlgorithmDescription() {
        AlgorithmModel model = this.algorithmList.getSelectedValue();
        if (model == null) {
            this.algoDescTextArea.setText("");
        } else {
            this.algoDescTextArea.setText(model.getDescription());
            this.algoDescTextArea.setCaretPosition(0);
        }
    }

    private void setScoreDescription() {
        ScoreModel model = this.scoreComboBox.getItemAt(this.scoreComboBox.getSelectedIndex());
        if (model == null) {
            this.scoreDescTextArea.setText("");
        } else {
            this.scoreDescTextArea.setText(model.getDescription());
            this.scoreDescTextArea.setCaretPosition(0);
        }
    }

    private void setIndepTestDescription() {
        IndependenceTestModel model = this.indTestComboBox.getItemAt(this.indTestComboBox.getSelectedIndex());
        if (model == null) {
            this.testDescTextArea.setText("");
        } else {
            this.testDescTextArea.setText(model.getDescription());
            this.testDescTextArea.setCaretPosition(0);
        }
    }

    private class TestAndScorePanel
    extends JPanel {
        private static final long serialVersionUID = -1594897454478052884L;

        public TestAndScorePanel() {
            this.initComponents();
        }

        private void initComponents() {
            AlgorithmCard.this.linearGaussianRadBtn.setActionCommand("linear-gaussian");
            AlgorithmCard.this.mixedRadBtn.setActionCommand("mixed");
            AlgorithmCard.this.generalRadBtn.setActionCommand("general");
            AlgorithmCard.this.allRadBtn.setActionCommand("all");
            AlgorithmCard.this.datasetFilterBtnGrp.add(AlgorithmCard.this.linearGaussianRadBtn);
            AlgorithmCard.this.datasetFilterBtnGrp.add(AlgorithmCard.this.mixedRadBtn);
            AlgorithmCard.this.datasetFilterBtnGrp.add(AlgorithmCard.this.generalRadBtn);
            AlgorithmCard.this.datasetFilterBtnGrp.add(AlgorithmCard.this.allRadBtn);
            AlgorithmCard.this.datasetFilterBtnGrp.setSelected(AlgorithmCard.this.allRadBtn.getModel(), true);
            JLabel assumptionsLabel = new JLabel();
            JLabel testLabel = new JLabel();
            JLabel scoreLabel = new JLabel();
            this.setBorder(BorderFactory.createTitledBorder("Choose Statistical Test and Score"));
            assumptionsLabel.setText("Filter by dataset properties:");
            testLabel.setText("Test:");
            scoreLabel.setText("Score:");
            if (AlgorithmCard.this.algorithmRunner.hasMissingValues()) {
                JLabel missingValueAlert = new JLabel();
                JLabel testwiseDeletionAlert = new JLabel();
                Color red = new Color(255, 0, 0);
                missingValueAlert.setForeground(red);
                missingValueAlert.setText("Dataset contains missing values;");
                testwiseDeletionAlert.setForeground(red);
                testwiseDeletionAlert.setText("testwise deletion will be used.");
                GroupLayout layout = new GroupLayout(this);
                this.setLayout(layout);
                layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(testLabel).addComponent(scoreLabel)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(AlgorithmCard.this.indTestComboBox, 0, 239, Short.MAX_VALUE).addComponent(AlgorithmCard.this.scoreComboBox, 0, 239, Short.MAX_VALUE))).addComponent(assumptionsLabel).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(AlgorithmCard.this.mixedRadBtn).addComponent(AlgorithmCard.this.linearGaussianRadBtn).addComponent(AlgorithmCard.this.generalRadBtn).addComponent(AlgorithmCard.this.allRadBtn))).addComponent(missingValueAlert).addComponent(testwiseDeletionAlert)).addContainerGap(-1, Short.MAX_VALUE)));
                layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(assumptionsLabel).addComponent(AlgorithmCard.this.linearGaussianRadBtn).addComponent(AlgorithmCard.this.mixedRadBtn).addComponent(AlgorithmCard.this.generalRadBtn).addComponent(AlgorithmCard.this.allRadBtn).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(missingValueAlert).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(testwiseDeletionAlert).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(testLabel).addComponent(AlgorithmCard.this.indTestComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(AlgorithmCard.this.scoreComboBox, -2, -1, -2).addComponent(scoreLabel)).addContainerGap(-1, Short.MAX_VALUE)));
            } else {
                GroupLayout layout = new GroupLayout(this);
                this.setLayout(layout);
                layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(testLabel).addComponent(scoreLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(AlgorithmCard.this.indTestComboBox, 0, 239, Short.MAX_VALUE).addComponent(AlgorithmCard.this.scoreComboBox, 0, 239, Short.MAX_VALUE))).addComponent(assumptionsLabel).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(AlgorithmCard.this.mixedRadBtn).addComponent(AlgorithmCard.this.linearGaussianRadBtn).addComponent(AlgorithmCard.this.generalRadBtn).addComponent(AlgorithmCard.this.allRadBtn)))).addContainerGap(-1, Short.MAX_VALUE)));
                layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(assumptionsLabel).addComponent(AlgorithmCard.this.linearGaussianRadBtn).addComponent(AlgorithmCard.this.mixedRadBtn).addComponent(AlgorithmCard.this.generalRadBtn).addComponent(AlgorithmCard.this.allRadBtn).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(testLabel).addComponent(AlgorithmCard.this.indTestComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(AlgorithmCard.this.scoreComboBox, -2, -1, -2).addComponent(scoreLabel)).addContainerGap(-1, Short.MAX_VALUE)));
            }
        }
    }

    private class AlgorithmFilterPanel
    extends JPanel {
        private static final long serialVersionUID = -3120503093689632462L;

        public AlgorithmFilterPanel() {
            this.populateAlgoTypeOptions();
            this.initComponents();
        }

        private void initComponents() {
            Box algoTypesBox = Box.createVerticalBox();
            Box algTypesBoxLabelBox = Box.createHorizontalBox();
            algTypesBoxLabelBox.add(new JLabel("Show algorithms that: "));
            algTypesBoxLabelBox.setAlignmentX(0.0f);
            algoTypesBox.add(algTypesBoxLabelBox);
            Box algoTypeOptionAllBox = Box.createHorizontalBox();
            algoTypeOptionAllBox.setAlignmentX(0.0f);
            algoTypesBox.add(algoTypeOptionAllBox);
            if (!AlgorithmCard.this.algoTypeOpts.isEmpty()) {
                Dimension indentSize = new Dimension(10, 20);
                AlgorithmCard.this.algoTypeOpts.forEach(btn -> {
                    Box box = Box.createHorizontalBox();
                    box.setAlignmentX(0.0f);
                    box.add(Box.createRigidArea(indentSize));
                    box.add((Component)btn);
                    algoTypesBox.add(box);
                });
            }
            Box priorKnowledgeBox = Box.createVerticalBox();
            Box priorKnowledgeLabelBox = Box.createHorizontalBox();
            priorKnowledgeLabelBox.add(new JLabel("Show only: "));
            priorKnowledgeLabelBox.setAlignmentX(0.0f);
            Box priorKnowledgeOptionBox = Box.createHorizontalBox();
            priorKnowledgeOptionBox.setAlignmentX(0.0f);
            priorKnowledgeOptionBox.add(Box.createRigidArea(new Dimension(10, 20)));
            priorKnowledgeOptionBox.add(AlgorithmCard.this.knowledgeChkBox);
            priorKnowledgeBox.add(priorKnowledgeLabelBox);
            priorKnowledgeBox.add(priorKnowledgeOptionBox);
            Box algoFiltersBox = Box.createVerticalBox();
            algoFiltersBox.setAlignmentX(0.0f);
            algoFiltersBox.add(algoTypesBox);
            algoFiltersBox.add(Box.createVerticalStrut(10));
            algoFiltersBox.add(priorKnowledgeBox);
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createTitledBorder("Algorithm Filters"));
            this.add((Component)new PaddingPanel(algoFiltersBox), "Center");
        }

        private void populateAlgoTypeOptions() {
            JRadioButton showAllRadBtn = new JRadioButton("show all");
            showAllRadBtn.setActionCommand("all");
            showAllRadBtn.addActionListener(e -> AlgorithmCard.this.refreshAlgorithmList());
            AlgorithmCard.this.algoTypeOpts.add(showAllRadBtn);
            AlgorithmCard.this.algoFilterBtnGrp.add(showAllRadBtn);
            Arrays.stream(AlgType.values()).forEach(item -> {
                String name = item.name();
                JRadioButton radioButton = new JRadioButton(name.replace("_", " "));
                radioButton.setActionCommand(name);
                radioButton.addActionListener(e -> AlgorithmCard.this.refreshAlgorithmList());
                AlgorithmCard.this.algoTypeOpts.add(radioButton);
                AlgorithmCard.this.algoFilterBtnGrp.add(radioButton);
            });
        }
    }

    private class AlgorithmListPanel
    extends JPanel {
        private static final long serialVersionUID = -7068543172769683902L;

        public AlgorithmListPanel() {
            this.initComponents();
        }

        private void initComponents() {
            JScrollPane scrollPane = new JScrollPane(AlgorithmCard.this.algorithmList);
            this.setBorder(BorderFactory.createTitledBorder("Choose Algorithm"));
            GroupLayout layout = new GroupLayout(this);
            this.setLayout(layout);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(scrollPane, -1, 206, Short.MAX_VALUE).addContainerGap()));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(scrollPane, -1, 254, Short.MAX_VALUE).addContainerGap()));
        }
    }

    private static class DescriptionPanel
    extends JPanel {
        private static final long serialVersionUID = 2329356999486712496L;
        final String borderTitle;
        final Component view;

        public DescriptionPanel(String borderTitle, Component view) {
            this.borderTitle = borderTitle;
            this.view = view;
            this.initComponents();
        }

        private void initComponents() {
            JScrollPane scrollPane = new JScrollPane(this.view);
            this.setBorder(BorderFactory.createTitledBorder(this.borderTitle));
            this.setPreferredSize(new Dimension(235, 150));
            GroupLayout layout = new GroupLayout(this);
            this.setLayout(layout);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(scrollPane, -1, 366, Short.MAX_VALUE).addContainerGap()));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(scrollPane, -1, 254, Short.MAX_VALUE).addContainerGap()));
        }
    }
}

