/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor.search;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetradapp.editor.EdgeTypeTable;
import edu.cmu.tetradapp.editor.GraphPropertiesAction;
import edu.cmu.tetradapp.editor.PagColorer;
import edu.cmu.tetradapp.editor.PathsAction;
import edu.cmu.tetradapp.editor.SaveComponentImage;
import edu.cmu.tetradapp.editor.SelectBidirectedAction;
import edu.cmu.tetradapp.editor.SelectDirectedAction;
import edu.cmu.tetradapp.editor.SelectLatentsAction;
import edu.cmu.tetradapp.editor.SelectUndirectedAction;
import edu.cmu.tetradapp.editor.UnderliningsAction;
import edu.cmu.tetradapp.model.GeneralAlgorithmRunner;
import edu.cmu.tetradapp.ui.PaddingPanel;
import edu.cmu.tetradapp.util.ImageUtils;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;

public class GraphCard
extends JPanel {
    private static final long serialVersionUID = -7654484444146823298L;
    private final GeneralAlgorithmRunner algorithmRunner;
    private GraphWorkbench workbench;

    public GraphCard(GeneralAlgorithmRunner algorithmRunner) {
        this.algorithmRunner = algorithmRunner;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(50, 406));
    }

    public void refresh() {
        this.removeAll();
        this.setBorder(BorderFactory.createTitledBorder(this.algorithmRunner.getAlgorithm().getDescription()));
        Graph graph = this.algorithmRunner.getGraph();
        JTabbedPane tabbedPane = new JTabbedPane(4);
        tabbedPane.addTab("Graph", new PaddingPanel(this.createGraphPanel(graph)));
        tabbedPane.addTab("Edges", this.createEdgeTypeTable(graph));
        this.add((Component)tabbedPane, "Center");
        this.add((Component)this.menuBar(), "North");
        this.revalidate();
        this.repaint();
    }

    JMenuBar menuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu file = new JMenu("File");
        file.add(new SaveComponentImage(this.workbench, "Save Graph Image..."));
        menuBar.add(file);
        JMenu graph = new JMenu("Graph");
        graph.add(new GraphPropertiesAction(this.workbench));
        graph.add(new PathsAction(this.workbench));
        graph.add(new UnderliningsAction(this.workbench));
        graph.add(new JMenuItem(new SelectDirectedAction(this.workbench)));
        graph.add(new JMenuItem(new SelectBidirectedAction(this.workbench)));
        graph.add(new JMenuItem(new SelectUndirectedAction(this.workbench)));
        graph.add(new JMenuItem(new SelectLatentsAction(this.workbench)));
        graph.add(new PagColorer(this.workbench));
        menuBar.add(graph);
        return menuBar;
    }

    private EdgeTypeTable createEdgeTypeTable(Graph graph) {
        EdgeTypeTable edgeTypeTable = new EdgeTypeTable();
        edgeTypeTable.setPreferredSize(new Dimension(825, 100));
        edgeTypeTable.update(graph);
        return edgeTypeTable;
    }

    private JPanel createGraphPanel(Graph graph) {
        GraphWorkbench graphWorkbench = new GraphWorkbench(graph);
        graphWorkbench.enableEditing(false);
        this.workbench = graphWorkbench;
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setPreferredSize(new Dimension(825, 406));
        mainPanel.add((Component)new JScrollPane(graphWorkbench), "Center");
        mainPanel.add((Component)this.createInstructionBox(), "South");
        return mainPanel;
    }

    private Box createInstructionBox() {
        JLabel label = new JLabel("More information on graph edge types and colorings");
        label.setFont(new Font("SansSerif", 0, 12));
        JButton infoBtn = new JButton(new ImageIcon(ImageUtils.getImage(this, "info.png")));
        infoBtn.setBorder(new EmptyBorder(0, 0, 0, 0));
        infoBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String helpHS = "/resources/javahelp/TetradHelp.hs";
                try {
                    URL url = this.getClass().getResource("/resources/javahelp/TetradHelp.hs");
                    HelpSet helpSet = new HelpSet(null, url);
                    helpSet.setHomeID("graph_edge_types");
                    HelpBroker broker = helpSet.createHelpBroker();
                    CSH.DisplayHelpFromSource listener = new CSH.DisplayHelpFromSource(broker);
                    listener.actionPerformed(e);
                }
                catch (Exception ee) {
                    System.out.println("HelpSet " + ee.getMessage());
                    System.out.println("HelpSet /resources/javahelp/TetradHelp.hs not found");
                    throw new IllegalArgumentException();
                }
            }
        });
        Box instruction = Box.createHorizontalBox();
        instruction.add(label);
        instruction.add(Box.createHorizontalStrut(5));
        instruction.add(infoBtn);
        Box instructionBox = Box.createVerticalBox();
        instructionBox.add(Box.createVerticalStrut(5));
        instructionBox.add(instruction);
        instructionBox.add(Box.createVerticalStrut(5));
        return instructionBox;
    }
}

