/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor.simulation;

import edu.cmu.tetrad.algcomparison.graph.Cyclic;
import edu.cmu.tetrad.algcomparison.graph.ErdosRenyi;
import edu.cmu.tetrad.algcomparison.graph.RandomForward;
import edu.cmu.tetrad.algcomparison.graph.RandomGraph;
import edu.cmu.tetrad.algcomparison.graph.RandomSingleFactorMim;
import edu.cmu.tetrad.algcomparison.graph.RandomTwoFactorMim;
import edu.cmu.tetrad.algcomparison.graph.ScaleFree;
import edu.cmu.tetrad.algcomparison.graph.SingleGraph;
import edu.cmu.tetrad.algcomparison.simulation.BayesNetSimulation;
import edu.cmu.tetrad.algcomparison.simulation.BooleanGlassSimulation;
import edu.cmu.tetrad.algcomparison.simulation.ConditionalGaussianSimulation;
import edu.cmu.tetrad.algcomparison.simulation.GeneralSemSimulation;
import edu.cmu.tetrad.algcomparison.simulation.GeneralSemSimulationSpecial1;
import edu.cmu.tetrad.algcomparison.simulation.LeeHastieSimulation;
import edu.cmu.tetrad.algcomparison.simulation.LinearFisherModel;
import edu.cmu.tetrad.algcomparison.simulation.SemSimulation;
import edu.cmu.tetrad.algcomparison.simulation.StandardizedSemSimulation;
import edu.cmu.tetrad.algcomparison.simulation.TimeSeriesSemSimulation;
import edu.cmu.tetrad.data.simulation.LoadContinuousDataAndGraphs;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetradapp.model.Simulation;
import edu.cmu.tetradapp.ui.PaddingPanel;
import edu.cmu.tetradapp.util.ParameterComponents;
import edu.cmu.tetradapp.util.WatchedProcess;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.util.Arrays;
import java.util.LinkedHashSet;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;

public class ParameterTab
extends JPanel {
    private static final long serialVersionUID = 7074205549192562786L;
    private static final String[] GRAPH_ITEMS = new String[]{"Random Foward DAG (Fixed Average Degree)", "Erdos-Renyi DAG (Fixed Edge Probability)", "Scale Free DAG (Bollobas et al.)", "Cyclic (Constructed From Small Loops)", "Random One Factor MIM", "Random Two Factor MIM"};
    private static final String[] SOURCE_GRAPH_ITEMS = new String[]{"Bayes Net", "Structural Equation Model", "Linear Fisher Model", "Lee & Hastie", "Conditional Gaussian", "Time Series"};
    private static final JLabel NO_PARAM_LBL = new JLabel("No parameters to edit");
    private final JComboBox<String> graphsDropdown = new JComboBox();
    private final JComboBox<String> simulationsDropdown = new JComboBox();
    private final Box parameterBox = Box.createVerticalBox();
    private final Simulation simulation;
    private boolean initial = true;

    public ParameterTab(Simulation simulation) {
        this.simulation = simulation;
        if (simulation.getSimulation() == null) {
            simulation.setSimulation(new BayesNetSimulation(new RandomForward()), simulation.getParams());
            simulation.setFixedSimulation(false);
        } else if (simulation.getSimulation() instanceof BooleanGlassSimulation) {
            simulation.setFixedGraph(true);
        }
        this.initComponents();
        if (simulation.getDataModelList().isEmpty()) {
            this.refreshParameters();
        } else {
            this.showParameters();
        }
    }

    private Component getPanel() {
        return null;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createSimulationOptionBox(), "North");
        this.add((Component)this.createParameterPanel(), "Center");
        this.add((Component)this.createSimulationButtonBox(), "South");
    }

    private void refreshParameters() {
        RandomGraph randomGraph = this.newRandomGraph();
        this.newSimulation(randomGraph);
        this.showParameters();
        this.firePropertyChange("refreshParameters", null, null);
    }

    @NotNull
    private RandomGraph newRandomGraph() {
        RandomGraph randomGraph;
        SingleGraph singleGraph = randomGraph = this.simulation.getSourceGraph() == null ? new SingleGraph(new EdgeListGraph()) : new SingleGraph(this.simulation.getSourceGraph());
        if (!this.simulation.isFixedGraph()) {
            String graphItem = this.graphsDropdown.getItemAt(this.graphsDropdown.getSelectedIndex());
            this.simulation.getParams().set("graphsDropdownPreference", graphItem);
            switch (graphItem) {
                case "Random Foward DAG (Fixed Average Degree)": {
                    randomGraph = new RandomForward();
                    break;
                }
                case "Erdos-Renyi DAG (Fixed Edge Probability)": {
                    randomGraph = new ErdosRenyi();
                    break;
                }
                case "Scale Free DAG (Bollobas et al.)": {
                    randomGraph = new ScaleFree();
                    break;
                }
                case "Cyclic (Constructed From Small Loops)": {
                    randomGraph = new Cyclic();
                    break;
                }
                case "Random One Factor MIM": {
                    randomGraph = new RandomSingleFactorMim();
                    break;
                }
                case "Random Two Factor MIM": {
                    randomGraph = new RandomTwoFactorMim();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized simulation type: " + graphItem);
                }
            }
        }
        return randomGraph;
    }

    private void newSimulation(RandomGraph randomGraph) {
        if (!this.simulation.isFixedSimulation()) {
            String simulationItem = this.simulationsDropdown.getItemAt(this.simulationsDropdown.getSelectedIndex());
            this.simulation.getParams().set("simulationsDropdownPreference", simulationItem);
            this.simulation.setFixedGraph(randomGraph instanceof SingleGraph);
            if (this.simulation.getSourceGraph() == null) {
                switch (simulationItem) {
                    case "Bayes Net": {
                        this.simulation.setSimulation(new BayesNetSimulation(randomGraph), this.simulation.getParams());
                        break;
                    }
                    case "Structural Equation Model": {
                        this.simulation.setSimulation(new SemSimulation(randomGraph), this.simulation.getParams());
                        break;
                    }
                    case "Linear Fisher Model": {
                        this.simulation.setSimulation(new LinearFisherModel(randomGraph), this.simulation.getParams());
                        break;
                    }
                    case "General Structural Equation Model": {
                        this.simulation.setSimulation(new GeneralSemSimulationSpecial1(randomGraph), this.simulation.getParams());
                        break;
                    }
                    case "Lee & Hastie": {
                        this.simulation.setSimulation(new LeeHastieSimulation(randomGraph), this.simulation.getParams());
                        break;
                    }
                    case "Conditional Gaussian": {
                        this.simulation.setSimulation(new ConditionalGaussianSimulation(randomGraph), this.simulation.getParams());
                        break;
                    }
                    case "Time Series": {
                        this.simulation.setSimulation(new TimeSeriesSemSimulation(randomGraph), this.simulation.getParams());
                        break;
                    }
                    case "Boolean Glass Simulation": {
                        this.simulation.setSimulation(new BooleanGlassSimulation(randomGraph), this.simulation.getParams());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unrecognized simulation type: " + simulationItem);
                    }
                }
            } else {
                switch (simulationItem) {
                    case "Bayes Net": {
                        this.simulation.setSimulation(new BayesNetSimulation(randomGraph), this.simulation.getParams());
                        break;
                    }
                    case "Structural Equation Model": {
                        this.simulation.setSimulation(new SemSimulation(randomGraph), this.simulation.getParams());
                        break;
                    }
                    case "Linear Fisher Model": {
                        this.simulation.setSimulation(new LinearFisherModel(randomGraph), this.simulation.getParams());
                        break;
                    }
                    case "Lee & Hastie": {
                        this.simulation.setSimulation(new LeeHastieSimulation(randomGraph), this.simulation.getParams());
                        break;
                    }
                    case "Conditional Gaussian": {
                        this.simulation.setSimulation(new ConditionalGaussianSimulation(randomGraph), this.simulation.getParams());
                        break;
                    }
                    case "Time Series": {
                        this.simulation.setSimulation(new TimeSeriesSemSimulation(randomGraph), this.simulation.getParams());
                    }
                }
            }
        }
    }

    private void showParameters() {
        boolean fixedGraph = this.simulation.isFixedGraph();
        this.graphsDropdown.setEnabled(!fixedGraph);
        this.simulationsDropdown.setEnabled(!this.simulation.isFixedSimulation());
        this.parameterBox.removeAll();
        if (this.simulation.getSimulation() != null) {
            LinkedHashSet<String> params = new LinkedHashSet<String>(this.simulation.getSimulation().getParameters());
            if (params.isEmpty()) {
                this.parameterBox.add((Component)NO_PARAM_LBL, "North");
            } else {
                Box parameters = Box.createVerticalBox();
                Box[] paramBoxes = ParameterComponents.toArray(ParameterComponents.createParameterComponents(params, this.simulation.getParams()));
                int lastIndex = paramBoxes.length - 1;
                for (int i = 0; i < lastIndex; ++i) {
                    parameters.add(paramBoxes[i]);
                    parameters.add(Box.createVerticalStrut(10));
                }
                parameters.add(paramBoxes[lastIndex]);
                this.parameterBox.add((Component)new PaddingPanel(parameters), "Center");
            }
        }
        this.parameterBox.validate();
        this.parameterBox.repaint();
    }

    private Box createSimulationButtonBox() {
        Dimension buttonSize = new Dimension(268, 25);
        JButton button = new JButton("Simulate");
        button.setMinimumSize(buttonSize);
        button.setMaximumSize(buttonSize);
        button.setPreferredSize(buttonSize);
        button.setAlignmentX(0.5f);
        button.addActionListener(e -> this.simulate());
        Box box = Box.createVerticalBox();
        box.add(Box.createVerticalStrut(20));
        box.add(button);
        return box;
    }

    private JPanel createParameterPanel() {
        JPanel paramPanel = new JPanel(new BorderLayout(0, 5));
        paramPanel.add((Component)new JLabel("Parameters for your simulation are listed below. Please adjust the parameter values."), "North");
        paramPanel.add((Component)new JScrollPane(this.parameterBox), "Center");
        return paramPanel;
    }

    private Box createSimulationOptionBox() {
        Box simOptBox = Box.createVerticalBox();
        if (!this.simulation.isFixedGraph()) {
            Arrays.stream(GRAPH_ITEMS).forEach(this.graphsDropdown::addItem);
            this.graphsDropdown.setMaximumSize(this.graphsDropdown.getPreferredSize());
            this.graphsDropdown.setSelectedItem(this.simulation.getParams().getString("graphsDropdownPreference", GRAPH_ITEMS[0]));
            this.graphsDropdown.addActionListener(e -> this.refreshParameters());
            simOptBox.add(this.createLabeledComponent("Type of Graph: ", this.graphsDropdown));
            simOptBox.add(Box.createVerticalStrut(10));
        }
        String[] simulationItems = this.getSimulationItems(this.simulation);
        Arrays.stream(simulationItems).forEach(this.simulationsDropdown::addItem);
        this.simulationsDropdown.setMaximumSize(this.simulationsDropdown.getPreferredSize());
        this.simulationsDropdown.setSelectedItem(this.simulation.getParams().getString("simulationsDropdownPreference", simulationItems[0]));
        this.simulationsDropdown.addActionListener(e -> this.refreshParameters());
        simOptBox.add(this.createLabeledComponent("Type of Simulation: ", this.simulationsDropdown));
        simOptBox.add(Box.createVerticalStrut(20));
        return simOptBox;
    }

    private void simulate() {
        int ret = JOptionPane.showConfirmDialog(this.getPanel(), "Simulate new dataset(s)?", "Confirm", 2);
        if (ret == 2) {
            JOptionPane.showMessageDialog(this.getPanel(), "Keeping existing datasets(s)");
            return;
        }
        new WatchedProcess((Window)this.getTopLevelAncestor()){

            @Override
            public void watch() {
                try {
                    RandomGraph randomGraph = ParameterTab.this.newRandomGraph();
                    ParameterTab.this.newSimulation(randomGraph);
                    ParameterTab.this.simulation.getSimulation().createData(ParameterTab.this.simulation.getParams(), false);
                    ParameterTab.this.initial = false;
                    ParameterTab.this.firePropertyChange("modelChanged", null, null);
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                    Throwable cause = exception;
                    if (exception.getCause() != null) {
                        cause = exception.getCause();
                    }
                    if (cause.getMessage() == null || cause.getMessage().trim().isEmpty()) {
                        throw new IllegalArgumentException("Exception in creating data. Check model setup or parameter settings.");
                    }
                    throw new IllegalArgumentException(cause.getMessage());
                }
            }
        };
    }

    private Box createLabeledComponent(String text, Component comp) {
        Box box = Box.createHorizontalBox();
        box.add(new JLabel(text));
        box.add(Box.createGlue());
        if (comp != null) {
            box.add(comp);
        }
        return box;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String[] getSimulationItems(Simulation simulation) {
        if (!simulation.isFixedSimulation()) return SOURCE_GRAPH_ITEMS;
        if (simulation.getSimulation() instanceof BayesNetSimulation) {
            return new String[]{"Bayes Net"};
        }
        if (simulation.getSimulation() instanceof SemSimulation) {
            return new String[]{"Structural Equation Model"};
        }
        if (simulation.getSimulation() instanceof LinearFisherModel) {
            return new String[]{"Linear Fisher Model"};
        }
        if (simulation.getSimulation() instanceof StandardizedSemSimulation) {
            return new String[]{"Standardized Structural Equation Model"};
        }
        if (simulation.getSimulation() instanceof GeneralSemSimulation) {
            return new String[]{"General Structural Equation Model"};
        }
        if (!(simulation.getSimulation() instanceof LoadContinuousDataAndGraphs)) throw new IllegalStateException("Not expecting that model type: " + simulation.getSimulation().getClass());
        return new String[]{"Loaded From Files"};
    }

    public boolean isInitial() {
        return this.initial;
    }
}

