/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.knowledge_editor;

import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.model.IndependenceFactsModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class IndependenceFactsEditor
extends JPanel {
    private final IndependenceFactsModel facts;
    private JTextArea textArea;

    public IndependenceFactsEditor(IndependenceFactsModel facts) {
        if (facts == null) {
            throw new NullPointerException();
        }
        this.facts = facts;
        this.setLayout(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add("Text", this.textDisplay());
        tabbedPane.addChangeListener(e -> this.resetTextDisplay());
        this.add((Component)tabbedPane, "Center");
        this.setPreferredSize(new Dimension(550, 500));
    }

    private Component textDisplay() {
        JButton loadButton = new JButton("Load from File");
        JButton parseButton = new JButton("Parse Text");
        loadButton.addActionListener(e -> {
            JFileChooser chooser = IndependenceFactsEditor.getJFileChooser();
            chooser.setFileSelectionMode(2);
            chooser.showOpenDialog(this);
            File file = chooser.getSelectedFile();
            if (file == null) {
                return;
            }
            Preferences.userRoot().put("fileSaveLocation", file.getParent());
            try {
                this.facts.setFacts(IndependenceFactsModel.loadFacts(new FileReader(file)).getFacts());
                this.getTextArea().setText(this.facts.toString());
            }
            catch (IOException e1) {
                throw new RuntimeException("Couldn't find that file: " + file.getAbsolutePath());
            }
        });
        parseButton.addActionListener(e -> {
            try {
                String text = this.getTextArea().getText();
                this.facts.setFacts(IndependenceFactsModel.loadFacts(new CharArrayReader(text.toCharArray())).getFacts());
                this.getTextArea().setText(this.facts.toString());
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), e1.getMessage());
            }
        });
        Box b = Box.createVerticalBox();
        this.textArea = new JTextArea();
        this.resetTextDisplay();
        b.add(this.getTextArea());
        Box b2 = Box.createHorizontalBox();
        b2.add(Box.createHorizontalGlue());
        b2.add(loadButton);
        b2.add(parseButton);
        b.add(b2);
        return b;
    }

    private void resetTextDisplay() {
        this.getTextArea().setFont(new Font("Monospaced", 0, 12));
        this.getTextArea().setBorder(new CompoundBorder(new LineBorder(Color.black), new EmptyBorder(3, 3, 3, 3)));
        this.getTextArea().setText(this.facts.toString());
    }

    private JTextArea getTextArea() {
        return this.textArea;
    }

    private static JFileChooser getJFileChooser() {
        JFileChooser chooser = new JFileChooser();
        String sessionSaveLocation = Preferences.userRoot().get("fileSaveLocation", "");
        chooser.setCurrentDirectory(new File(sessionSaveLocation));
        chooser.resetChoosableFileFilters();
        chooser.setFileSelectionMode(2);
        return chooser;
    }
}

