/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.knowledge_editor;

import edu.cmu.tetrad.data.DataWriter;
import edu.cmu.tetrad.data.DelimiterType;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.KnowledgeEdge;
import edu.cmu.tetrad.data.SimpleDataLoader;
import edu.cmu.tetrad.graph.LayoutUtil;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeVariableType;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.knowledge_editor.KnowledgeEditorToolbar;
import edu.cmu.tetradapp.knowledge_editor.KnowledgeGraph;
import edu.cmu.tetradapp.knowledge_editor.KnowledgeModelEdge;
import edu.cmu.tetradapp.knowledge_editor.KnowledgeModelNode;
import edu.cmu.tetradapp.knowledge_editor.KnowledgeWorkbench;
import edu.cmu.tetradapp.knowledge_editor.ListTransferable;
import edu.cmu.tetradapp.knowledge_editor.OtherGroupsEditor;
import edu.cmu.tetradapp.model.ForbiddenGraphModel;
import edu.cmu.tetradapp.model.KnowledgeBoxModel;
import edu.cmu.tetradapp.model.RemoveNonSkeletonEdgesModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.TransferHandler;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;
import org.apache.commons.math3.util.FastMath;

public class KnowledgeBoxEditor
extends JPanel {
    private static final long serialVersionUID = 959706288096545158L;
    private static final long EDGE_LIMIT = 100L;
    private final Color UNSELECTED_BG = new Color(153, 204, 204);
    private final Color SELECTED_BG = new Color(255, 204, 102);
    private final Map<String, JLabel> labelMap = new HashMap<String, JLabel>();
    private final List<Node> vars;
    private final List<String> firstTierVars = new LinkedList<String>();
    private final List<String> secondTierVars = new LinkedList<String>();
    private final KnowledgeBoxModel knowledgeBoxModel;
    private Knowledge knowledge;
    private KnowledgeWorkbench edgeWorkbench;
    private JPanel tiersPanel;
    private boolean showForbiddenExplicitly;
    private boolean showForbiddenByTiers;
    private boolean showRequired;
    private boolean showRequiredByGroups;
    private boolean showForbiddenByGroups;
    private final JTabbedPane tabbedPane;
    private int numTiers = 3;

    public KnowledgeBoxEditor(ForbiddenGraphModel knowledgeBoxModel) {
        this((KnowledgeBoxModel)knowledgeBoxModel);
    }

    public KnowledgeBoxEditor(RemoveNonSkeletonEdgesModel knowledgeBoxModel) {
        this((KnowledgeBoxModel)knowledgeBoxModel);
    }

    public KnowledgeBoxEditor(KnowledgeBoxModel knowledgeBoxModel) {
        JTabbedPane tabbedPane;
        this.vars = knowledgeBoxModel.getVariables();
        this.knowledge = knowledgeBoxModel.getKnowledge();
        this.knowledgeBoxModel = knowledgeBoxModel;
        this.setLayout(new BorderLayout());
        this.tabbedPane = tabbedPane = new JTabbedPane(2);
        this.resetTabbedPane();
        this.add((Component)tabbedPane, "Center");
        this.setPreferredSize(new Dimension(640, 500));
        this.add((Component)this.menuBar(), "North");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                TetradLogger.getInstance().log("knowledge", "Edited Knowledge:");
                TetradLogger.getInstance().log("knowledge", KnowledgeBoxEditor.this.knowledge.toString());
            }
        });
        this.initComponents();
    }

    private void initComponents() {
        this.getKnowledge().getVariables().forEach(e -> this.labelMap.put((String)e, this.createJLabel((String)e)));
        this.getKnowledge().getVariablesNotInTiers().forEach(e -> this.labelMap.put((String)e, this.createJLabel((String)e)));
    }

    private JLabel createJLabel(String name) {
        JLabel label = new JLabel(String.format("  %s  ", name));
        label.setOpaque(true);
        label.setHorizontalAlignment(0);
        label.setBorder(new CompoundBorder(new MatteBorder(2, 2, 2, 2, Color.WHITE), new LineBorder(Color.BLACK)));
        label.setForeground(Color.BLACK);
        label.setBackground(this.UNSELECTED_BG);
        return label;
    }

    private JMenuBar menuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu file = new JMenu("File");
        menuBar.add(file);
        JMenuItem loadKnowledge = new JMenuItem("Load Knowledge...");
        JMenuItem saveKnowledge = new JMenuItem("Save Knowledge...");
        file.add(loadKnowledge);
        file.add(saveKnowledge);
        loadKnowledge.addActionListener(e -> {
            JFileChooser chooser = new JFileChooser();
            String sessionSaveLocation = Preferences.userRoot().get("fileSaveLocation", "");
            chooser.setCurrentDirectory(new File(sessionSaveLocation));
            chooser.setFileSelectionMode(0);
            int ret1 = chooser.showOpenDialog(JOptionUtils.centeringComp());
            if (ret1 != 0) {
                return;
            }
            File selectedFile = chooser.getSelectedFile();
            if (selectedFile == null) {
                return;
            }
            Preferences.userRoot().put("fileSaveLocation", selectedFile.getParent());
            try {
                Knowledge knowledge = SimpleDataLoader.loadKnowledge(selectedFile, DelimiterType.WHITESPACE, "//");
                this.setKnowledge(knowledge);
                this.resetTabbedPane();
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), e1.getMessage());
                e1.printStackTrace();
            }
        });
        saveKnowledge.addActionListener(e -> {
            JFileChooser chooser = new JFileChooser();
            String sessionSaveLocation = Preferences.userRoot().get("fileSaveLocation", "");
            chooser.setCurrentDirectory(new File(sessionSaveLocation));
            chooser.setFileSelectionMode(0);
            int ret1 = chooser.showSaveDialog(JOptionUtils.centeringComp());
            if (ret1 != 0) {
                return;
            }
            File selectedFile = chooser.getSelectedFile();
            if (selectedFile == null) {
                return;
            }
            Preferences.userRoot().put("fileSaveLocation", selectedFile.getParent());
            try {
                DataWriter.saveKnowledge(this.knowledge, new FileWriter(selectedFile));
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), e1.getMessage());
            }
        });
        return menuBar;
    }

    public void resetTabbedPane() {
        this.tabbedPane.removeAll();
        this.tabbedPane.add("Tiers", this.tierDisplay());
        this.tabbedPane.add("Other Groups", new OtherGroupsEditor(this.knowledge, this.knowledge.getVariables()));
        this.tabbedPane.add("Edges", this.edgeDisplay());
        this.tabbedPane.addChangeListener(e -> {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            if (pane.getSelectedIndex() == 0) {
                this.setNumDisplayTiers(FastMath.max(this.getNumTiers(), this.knowledge.getNumTiers()));
            } else if (pane.getSelectedIndex() == 2) {
                this.resetEdgeDisplay(null);
            }
        });
    }

    private Box tierDisplay() {
        if (this.getNumTiers() < 0) {
            int numTiers = this.getKnowledge().getNumTiers();
            int _default = (int)(FastMath.pow((double)this.vars.size(), 0.5) + 1.0);
            numTiers = FastMath.max(numTiers, _default);
            this.setNumDisplayTiers(numTiers);
        }
        Box b = Box.createVerticalBox();
        b.setBorder(new EmptyBorder(5, 5, 5, 5));
        Box b1 = Box.createHorizontalBox();
        b1.add(new JLabel("Not in tier:"));
        b1.add(Box.createHorizontalGlue());
        b1.add(new JLabel("# Tiers = "));
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(this.getNumTiers(), 2, 100, 1);
        spinnerNumberModel.addChangeListener(e -> {
            SpinnerNumberModel model = (SpinnerNumberModel)e.getSource();
            int numTiers = model.getNumber().intValue();
            this.setNumDisplayTiers(numTiers);
            this.setNumTiers(numTiers);
            model.setValue(numTiers);
            for (int i = this.getNumTiers(); i <= this.getKnowledge().getMaxTierForbiddenWithin(); ++i) {
                this.getKnowledge().setTierForbiddenWithin(i, false);
            }
            this.notifyKnowledge();
        });
        JSpinner spinner = new JSpinner(spinnerNumberModel);
        spinner.setMaximumSize(spinner.getPreferredSize());
        b1.add(spinner);
        b.add(b1);
        this.tiersPanel = new JPanel();
        this.tiersPanel.setLayout(new BorderLayout());
        this.tiersPanel.add((Component)this.getTierBoxes(this.getNumTiers()), "Center");
        b.add(this.tiersPanel);
        Box c = Box.createHorizontalBox();
        c.add(new JLabel("Use shift key to select multiple items."));
        c.add(Box.createGlue());
        b.add(c);
        return b;
    }

    private void setNumDisplayTiers(int numTiers) {
        if (numTiers < 2) {
            int knowledgeTiers = this.getKnowledge().getNumTiers();
            int defaultTiers = (int)(FastMath.pow((double)this.getVarNames().size(), 0.5) + 1.0);
            numTiers = FastMath.max(knowledgeTiers, defaultTiers);
        }
        this.setNumTiers(numTiers);
        for (int i = numTiers; i < this.getKnowledge().getNumTiers(); ++i) {
            List<String> vars = this.getKnowledge().getTier(i);
            for (String var : vars) {
                this.getKnowledge().removeFromTiers(var);
            }
        }
        this.tiersPanel.removeAll();
        this.tiersPanel.add((Component)this.getTierBoxes(this.getNumTiers()), "Center");
        this.tiersPanel.revalidate();
        this.tiersPanel.repaint();
    }

    private void checkInterventionalVariables() {
        this.vars.forEach(e -> {
            if (e.getNodeVariableType() == NodeVariableType.INTERVENTION_STATUS || e.getNodeVariableType() == NodeVariableType.INTERVENTION_VALUE) {
                this.firstTierVars.add(e.getName());
            } else if (e.getAttribute("fullyDeterminisedDomainVar") != null) {
                if (((Boolean)e.getAttribute("fullyDeterminisedDomainVar")).booleanValue()) {
                    this.firstTierVars.add(e.getName());
                }
            } else {
                this.secondTierVars.add(e.getName());
            }
        });
    }

    private Box getTierBoxes(int numTiers) {
        this.checkInterventionalVariables();
        if (this.getKnowledge().isEmpty() && !this.firstTierVars.isEmpty()) {
            this.getKnowledge().setTier(0, this.firstTierVars);
            this.getKnowledge().setTier(1, this.secondTierVars);
        }
        for (Node var : this.vars) {
            this.getKnowledge().addVariable(var.getName());
        }
        Box container = Box.createVerticalBox();
        this.initComponents();
        List<String> varsNotInTiers = this.getKnowledge().getVariablesNotInTiers();
        DragDropList varsNotInTiersList = new DragDropList(varsNotInTiers, -1);
        varsNotInTiersList.setBorder(null);
        Box varsNotInTiersBox = Box.createHorizontalBox();
        JScrollPane jScrollPane1 = new JScrollPane(varsNotInTiersList);
        jScrollPane1.setPreferredSize(new Dimension(640, 50));
        varsNotInTiersBox.add(jScrollPane1);
        Box tiersBox = Box.createVerticalBox();
        LinkedList<JCheckBox> forbiddenCheckboxes = new LinkedList<JCheckBox>();
        for (int tier = 0; tier < numTiers; ++tier) {
            Box textRow = Box.createHorizontalBox();
            textRow.add(new JLabel("Tier " + (tier + 1)));
            int _tier = tier;
            textRow.add(Box.createHorizontalGlue());
            JButton regexAdd = new JButton("Find");
            JCheckBox forbiddenCheckbox = new JCheckBox("Forbid Within Tier", this.getKnowledge().isTierForbiddenWithin(_tier));
            JCheckBox causesOnlyNextTierCheckbox = new JCheckBox("Can Cause Only Next Tier", this.getKnowledge().isOnlyCanCauseNextTier(_tier));
            KnowledgeBoxEditor upReference = this;
            forbiddenCheckbox.addActionListener(e -> {
                JCheckBox checkbox = (JCheckBox)e.getSource();
                try {
                    this.getKnowledge().setTierForbiddenWithin(_tier, checkbox.isSelected());
                }
                catch (Exception e1) {
                    checkbox.setSelected(false);
                    JOptionPane.showMessageDialog(upReference, e1.getMessage());
                }
                this.notifyKnowledge();
            });
            forbiddenCheckboxes.add(forbiddenCheckbox);
            textRow.add(regexAdd);
            regexAdd.addActionListener(e -> {
                String regex = JOptionPane.showInputDialog("Search Cpdag");
                try {
                    this.getKnowledge().removeFromTiers(regex);
                    this.getKnowledge().addToTier(_tier, regex);
                }
                catch (IllegalArgumentException iae) {
                    JOptionPane.showMessageDialog(upReference, iae.getMessage());
                }
                this.notifyKnowledge();
                this.tiersPanel.removeAll();
                this.tiersPanel.add((Component)this.getTierBoxes(this.getNumTiers()), "Center");
                this.tiersPanel.revalidate();
                this.tiersPanel.repaint();
            });
            textRow.add(forbiddenCheckbox);
            causesOnlyNextTierCheckbox.addActionListener(e -> {
                JCheckBox checkbox = (JCheckBox)e.getSource();
                try {
                    this.getKnowledge().setOnlyCanCauseNextTier(_tier, checkbox.isSelected());
                }
                catch (Exception e1) {
                    checkbox.setSelected(false);
                    JOptionPane.showMessageDialog(upReference, e1.getMessage());
                }
                this.notifyKnowledge();
            });
            if (tier + 2 < numTiers) {
                textRow.add(causesOnlyNextTierCheckbox);
            }
            tiersBox.add(textRow);
            List<String> tierNames = this.getKnowledge().getTier(tier);
            DragDropList tierList = new DragDropList(tierNames, tier);
            Box tierBox = Box.createHorizontalBox();
            JScrollPane jScrollPane = new JScrollPane(tierList);
            jScrollPane.setPreferredSize(new Dimension(600, 50));
            tierBox.add(jScrollPane);
            tiersBox.add(tierBox);
        }
        JScrollPane tiersScrollPane = new JScrollPane(tiersBox);
        tiersScrollPane.setPreferredSize(new Dimension(640, 400));
        if (!this.firstTierVars.isEmpty()) {
            ((JCheckBox)forbiddenCheckboxes.get(0)).setSelected(true);
            this.getKnowledge().setTierForbiddenWithin(0, true);
        }
        container.add(varsNotInTiersBox);
        container.add(Box.createVerticalStrut(5));
        container.add(tiersScrollPane);
        return container;
    }

    private JPanel edgeDisplay() {
        KnowledgeGraph graph = new KnowledgeGraph(this.getKnowledge());
        graph.addPropertyChangeListener(evt -> {
            if ("modelChanged".equals(evt.getPropertyName())) {
                this.notifyKnowledge();
            }
        });
        this.edgeWorkbench = new KnowledgeWorkbench(graph);
        this.resetEdgeDisplay(null);
        JCheckBox showForbiddenByTiersCheckbox = new JCheckBox("Show Forbidden By Tiers", this.showForbiddenByTiers);
        JCheckBox showForbiddenGroupsCheckBox = new JCheckBox("Show Forbidden by Groups", this.showForbiddenByGroups);
        JCheckBox showForbiddenExplicitlyCheckbox = new JCheckBox("Show Forbidden Explicitly", this.showForbiddenExplicitly);
        JCheckBox showRequiredGroupsCheckBox = new JCheckBox("Show Required by Groups", this.showRequiredByGroups);
        JCheckBox showRequiredExplicitlyCheckbox = new JCheckBox("Show Required Explicitly", this.showRequired);
        showRequiredGroupsCheckBox.addActionListener(e -> {
            JCheckBox box = (JCheckBox)e.getSource();
            this.showRequiredByGroups = box.isSelected();
            this.resetEdgeDisplay(showRequiredGroupsCheckBox);
        });
        showForbiddenGroupsCheckBox.addActionListener(e -> {
            JCheckBox box = (JCheckBox)e.getSource();
            this.showForbiddenByGroups = box.isSelected();
            this.resetEdgeDisplay(showForbiddenGroupsCheckBox);
        });
        showForbiddenByTiersCheckbox.addActionListener(e -> {
            JCheckBox checkBox = (JCheckBox)e.getSource();
            this.setShowForbiddenByTiers(checkBox.isSelected());
            this.resetEdgeDisplay(showForbiddenByTiersCheckbox);
        });
        showForbiddenExplicitlyCheckbox.addActionListener(e -> {
            JCheckBox checkBox = (JCheckBox)e.getSource();
            this.setShowForbiddenExplicitly(checkBox.isSelected());
            this.resetEdgeDisplay(showForbiddenExplicitlyCheckbox);
        });
        showRequiredExplicitlyCheckbox.addActionListener(e -> {
            JCheckBox checkBox = (JCheckBox)e.getSource();
            this.setShowRequired(checkBox.isSelected());
            this.resetEdgeDisplay(showRequiredExplicitlyCheckbox);
        });
        JPanel workbenchPanel = new JPanel();
        workbenchPanel.setLayout(new BorderLayout());
        workbenchPanel.add((Component)new JScrollPane(this.edgeWorkbench), "Center");
        workbenchPanel.setBorder(new TitledBorder("Forbidden and Required Edges"));
        JPanel display = new JPanel();
        display.setPreferredSize(new Dimension(640, 450));
        display.setLayout(new BorderLayout());
        KnowledgeEditorToolbar b2 = new KnowledgeEditorToolbar(this.edgeWorkbench, this.edgeWorkbench.getSourceGraph());
        display.add((Component)b2, "West");
        display.add((Component)workbenchPanel, "Center");
        Box showOptionsBox = Box.createVerticalBox();
        Box forbiddenOptionsBox = Box.createHorizontalBox();
        forbiddenOptionsBox.add(showForbiddenByTiersCheckbox);
        forbiddenOptionsBox.add(showForbiddenGroupsCheckBox);
        forbiddenOptionsBox.add(showForbiddenExplicitlyCheckbox);
        forbiddenOptionsBox.add(Box.createHorizontalGlue());
        Box requiredOptionsBox = Box.createHorizontalBox();
        requiredOptionsBox.add(showRequiredGroupsCheckBox);
        requiredOptionsBox.add(showRequiredExplicitlyCheckbox);
        requiredOptionsBox.add(Box.createHorizontalGlue());
        showOptionsBox.add(forbiddenOptionsBox);
        showOptionsBox.add(requiredOptionsBox);
        display.add((Component)showOptionsBox, "South");
        return display;
    }

    private void resetEdgeDisplay(JCheckBox checkBox) {
        boolean arrangedAll;
        String errMsg;
        List<KnowledgeEdge> list;
        Knowledge knowledge = this.getKnowledge();
        KnowledgeGraph graph = new KnowledgeGraph(this.getKnowledge());
        this.getVarNames().forEach(e -> {
            knowledge.addVariable((String)e);
            graph.addNode(new KnowledgeModelNode((String)e));
        });
        if (this.showRequiredByGroups) {
            list = knowledge.getListOfRequiredEdges();
            if ((long)list.size() > 100L) {
                this.showRequiredByGroups = false;
                if (checkBox != null) {
                    checkBox.setSelected(false);
                }
                errMsg = String.format("The number of edges to show exceeds the limit %d.", 100L);
                JOptionPane.showMessageDialog(this, errMsg, "Unable To Display Edges", 0);
            } else {
                list.forEach(e -> {
                    String to;
                    String from = e.getFrom();
                    if (knowledge.isRequiredByGroups(from, to = e.getTo())) {
                        KnowledgeModelNode fromNode = (KnowledgeModelNode)graph.getNode(from);
                        KnowledgeModelNode toNode = (KnowledgeModelNode)graph.getNode(to);
                        graph.addEdge(new KnowledgeModelEdge(fromNode, toNode, 4));
                    }
                });
            }
        }
        if (this.showForbiddenByGroups) {
            list = knowledge.getListOfForbiddenEdges();
            if ((long)list.size() > 100L) {
                this.showForbiddenByGroups = false;
                if (checkBox != null) {
                    checkBox.setSelected(false);
                }
                errMsg = String.format("The number of edges to show exceeds the limit %d.", 100L);
                JOptionPane.showMessageDialog(this, errMsg, "Unable To Display Edges", 0);
            } else {
                list.forEach(e -> {
                    String to;
                    String from = e.getFrom();
                    if (knowledge.isForbiddenByGroups(from, to = e.getTo())) {
                        KnowledgeModelNode fromNode = (KnowledgeModelNode)graph.getNode(from);
                        KnowledgeModelNode toNode = (KnowledgeModelNode)graph.getNode(to);
                        graph.addEdge(new KnowledgeModelEdge(fromNode, toNode, 3));
                    }
                });
            }
        }
        if (this.showRequired) {
            list = knowledge.getListOfExplicitlyRequiredEdges();
            if ((long)list.size() > 100L) {
                this.showRequired = false;
                if (checkBox != null) {
                    checkBox.setSelected(false);
                }
                errMsg = String.format("The number of edges to show exceeds the limit %d.", 100L);
                JOptionPane.showMessageDialog(this, errMsg, "Unable To Display Edges", 0);
            } else {
                list.forEach(e -> {
                    String from = e.getFrom();
                    String to = e.getTo();
                    KnowledgeModelNode fromNode = (KnowledgeModelNode)graph.getNode(from);
                    KnowledgeModelNode toNode = (KnowledgeModelNode)graph.getNode(to);
                    if (fromNode != null && toNode != null) {
                        graph.addEdge(new KnowledgeModelEdge(fromNode, toNode, 2));
                    }
                });
            }
        }
        if (this.showForbiddenByTiers) {
            list = knowledge.getListOfForbiddenEdges();
            if ((long)list.size() > 100L) {
                this.showForbiddenByTiers = false;
                if (checkBox != null) {
                    checkBox.setSelected(false);
                }
                errMsg = String.format("The number of edges to show exceeds the limit %d.", 100L);
                JOptionPane.showMessageDialog(this, errMsg, "Unable To Display Edges", 0);
            } else {
                list.forEach(e -> {
                    String to;
                    String from = e.getFrom();
                    if (knowledge.isForbiddenByTiers(from, to = e.getTo())) {
                        KnowledgeModelNode fromNode = (KnowledgeModelNode)graph.getNode(from);
                        KnowledgeModelNode toNode = (KnowledgeModelNode)graph.getNode(to);
                        if (fromNode == null) {
                            graph.addNode(new KnowledgeModelNode(from));
                            fromNode = (KnowledgeModelNode)graph.getNode(from);
                        }
                        if (toNode == null) {
                            graph.addNode(new KnowledgeModelNode(to));
                            toNode = (KnowledgeModelNode)graph.getNode(to);
                        }
                        KnowledgeModelEdge knowledgeModelEdge = new KnowledgeModelEdge(fromNode, toNode, 1);
                        graph.addEdge(knowledgeModelEdge);
                    }
                });
            }
        }
        if (this.showForbiddenExplicitly) {
            list = knowledge.getListOfExplicitlyForbiddenEdges();
            if ((long)list.size() > 100L) {
                this.showForbiddenExplicitly = false;
                if (checkBox != null) {
                    checkBox.setSelected(false);
                }
                errMsg = String.format("The number of edges to show exceeds the limit %d.", 100L);
                JOptionPane.showMessageDialog(this, errMsg, "Unable To Display Edges", 0);
            } else {
                list.forEach(e -> {
                    KnowledgeModelNode toNode;
                    String from = e.getFrom();
                    String to = e.getTo();
                    KnowledgeModelNode fromNode = (KnowledgeModelNode)graph.getNode(from);
                    KnowledgeModelEdge edge = new KnowledgeModelEdge(fromNode, toNode = (KnowledgeModelNode)graph.getNode(to), 0);
                    if (!graph.containsEdge(edge)) {
                        graph.addEdge(edge);
                    }
                });
            }
        }
        if (!(arrangedAll = LayoutUtil.arrangeBySourceGraph(graph, this.edgeWorkbench.getGraph()))) {
            LayoutUtil.circleLayout(graph, 200, 200, 150);
        }
        this.edgeWorkbench.setGraph(graph);
        this.notifyKnowledge();
    }

    private void notifyKnowledge() {
        this.firePropertyChange("modelChanged", null, null);
    }

    private Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException();
        }
        this.knowledge = knowledge;
        this.knowledgeBoxModel.setKnowledge(knowledge);
    }

    private List<String> getVarNames() {
        return this.knowledge.getVariables();
    }

    private void setShowForbiddenExplicitly(boolean showForbiddenExplicitly) {
        this.showForbiddenExplicitly = showForbiddenExplicitly;
    }

    private void setShowRequired(boolean showRequired) {
        this.showRequired = showRequired;
    }

    private void setShowForbiddenByTiers(boolean showForbiddenByTiers) {
        this.showForbiddenByTiers = showForbiddenByTiers;
    }

    private int getNumTiers() {
        return this.numTiers;
    }

    private void setNumTiers(int numTiers) {
        this.numTiers = numTiers;
    }

    private class DragDropList
    extends JList<String> {
        private static final long serialVersionUID = 7240458207688841986L;
        private final List<String> items;
        private final int tier;

        public DragDropList(List<String> items, int tier) {
            this.items = items;
            this.tier = tier;
            this.initComponents();
        }

        private void initComponents() {
            this.setLayoutOrientation(2);
            this.setVisibleRowCount(0);
            this.setDropMode(DropMode.ON_OR_INSERT);
            this.setDragEnabled(true);
            this.setCellRenderer((list, value, index, isSelected, cellHasFocus) -> {
                JLabel label = (JLabel)KnowledgeBoxEditor.this.labelMap.get(value);
                if (label == null) {
                    label = new JLabel();
                }
                label.setBackground(isSelected ? KnowledgeBoxEditor.this.SELECTED_BG : KnowledgeBoxEditor.this.UNSELECTED_BG);
                return label;
            });
            this.setTransferHandler(new TransferHandler(){
                private static final long serialVersionUID = 3109256773218160485L;

                @Override
                public boolean canImport(TransferHandler.TransferSupport info) {
                    return info.isDataFlavorSupported(ListTransferable.DATA_FLAVOR);
                }

                @Override
                protected Transferable createTransferable(JComponent c) {
                    JList source = (JList)c;
                    List list = source.getSelectedValuesList();
                    if (list == null) {
                        DragDropList.this.getToolkit().beep();
                        list = Collections.EMPTY_LIST;
                    }
                    return new ListTransferable(list);
                }

                @Override
                public int getSourceActions(JComponent c) {
                    return 3;
                }

                @Override
                public boolean importData(TransferHandler.TransferSupport info) {
                    if (!info.isDrop()) {
                        return false;
                    }
                    JList source = (JList)info.getComponent();
                    DefaultListModel listModel = (DefaultListModel)source.getModel();
                    Knowledge knowledge = KnowledgeBoxEditor.this.getKnowledge();
                    Transferable transferable = info.getTransferable();
                    try {
                        List list = (List)transferable.getTransferData(ListTransferable.DATA_FLAVOR);
                        list.forEach(name -> {
                            if (DragDropList.this.tier >= 0) {
                                try {
                                    knowledge.removeFromTiers((String)name);
                                    knowledge.addToTier(DragDropList.this.tier, (String)name);
                                    KnowledgeBoxEditor.this.notifyKnowledge();
                                    listModel.addElement(name);
                                    DragDropList.this.sort(listModel);
                                }
                                catch (IllegalStateException e) {
                                    JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), e.getMessage());
                                }
                            } else {
                                knowledge.removeFromTiers((String)name);
                                KnowledgeBoxEditor.this.notifyKnowledge();
                                listModel.addElement(name);
                                DragDropList.this.sort(listModel);
                            }
                        });
                    }
                    catch (UnsupportedFlavorException | IOException exception) {
                        exception.printStackTrace(System.err);
                        return false;
                    }
                    return true;
                }

                @Override
                protected void exportDone(JComponent c, Transferable data, int action) {
                    if (action == 2) {
                        JList source = (JList)c;
                        DefaultListModel listModel = (DefaultListModel)source.getModel();
                        try {
                            List list = (List)data.getTransferData(ListTransferable.DATA_FLAVOR);
                            list.forEach(listModel::removeElement);
                        }
                        catch (UnsupportedFlavorException | IOException exception) {
                            // empty catch block
                        }
                    }
                }
            });
            DefaultListModel listModel = new DefaultListModel();
            this.items.forEach(listModel::addElement);
            this.setModel(listModel);
        }

        private void sort(DefaultListModel<String> listModel) {
            Object[] elements = listModel.toArray();
            String[] values = new String[elements.length];
            for (int i = 0; i < elements.length; ++i) {
                values[i] = (String)elements[i];
            }
            Arrays.sort(values, (o1, o2) -> {
                String[] tokens1 = o1.split(":");
                String[] tokens2 = o2.split(":");
                if (tokens1.length == 1) {
                    tokens1 = new String[]{tokens1[0], "0"};
                }
                if (tokens2.length == 1) {
                    tokens2 = new String[]{tokens2[0], "0"};
                }
                int i1 = tokens1[1].compareTo(tokens2[1]);
                int i0 = tokens1[0].compareTo(tokens2[0]);
                if (i1 == 0) {
                    return i0;
                }
                return i1;
            });
            listModel.clear();
            Arrays.stream(values).forEach(listModel::addElement);
        }
    }
}

