/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.knowledge_editor;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetradapp.knowledge_editor.KnowledgeDisplayNode;
import edu.cmu.tetradapp.knowledge_editor.KnowledgeModelEdge;
import edu.cmu.tetradapp.workbench.DisplayNode;
import edu.cmu.tetradapp.workbench.IDisplayEdge;
import edu.cmu.tetradapp.workbench.PointPair;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.apache.commons.math3.util.FastMath;

public class KnowledgeDisplayEdge
extends JComponent
implements IDisplayEdge {
    private static final int HALF_ANCHORED = 0;
    private static final int ANCHORED_UNSELECTED = 1;
    private static final int ANCHORED_SELECTED = 2;
    public static final int FORBIDDEN_EXPLICITLY = 3;
    private static final int FORBIDDEN_BY_TIERS = 4;
    public static final int REQUIRED = 5;
    private static final int REQUIRED_BY_GROUPS = 6;
    private static final int FORBIDDEN_BY_GROUPS = 7;
    private final Color forbiddenExplicitlyColor = Color.MAGENTA.darker().darker();
    private final Color forbiddenGroupsColor = Color.MAGENTA.brighter();
    private final Color requiredGroupsColor = Color.GREEN.brighter();
    private final Color forbiddenByTiersColor = Color.LIGHT_GRAY;
    private final Color requiredColor = Color.GREEN.darker();
    private final Color selectedColor = Color.red;
    private Color highlightedColor = Color.red.darker().darker();
    private Edge modelEdge;
    private int mode;
    private int type;
    private final DisplayNode node1;
    private DisplayNode node2;
    private Point mouseTrackPoint = new Point();
    private Point relativeMouseTrackPoint = new Point();
    private Polygon clickRegion;
    private boolean showAdjacenciesOnly = false;
    private double offset;
    private PointPair connectedPoints;
    private final ComponentHandler compHandler = new ComponentHandler();
    private final PropertyChangeHandler propertyChangeHandler = new PropertyChangeHandler();
    private boolean solid = true;
    private boolean thick = false;

    public KnowledgeDisplayEdge(KnowledgeDisplayNode node1, KnowledgeDisplayNode node2, int type) {
        if (node1 == null) {
            throw new NullPointerException("Node1 must not be null.");
        }
        if (node2 == null) {
            throw new NullPointerException("Node2 must not be null.");
        }
        if (type != 3 && type != 4 && type != 5 && type != 6 && type != 7) {
            throw new IllegalArgumentException();
        }
        this.node1 = node1;
        this.node2 = node2;
        this.mode = 1;
        this.type = type;
        node1.addComponentListener(this.compHandler);
        node2.addComponentListener(this.compHandler);
        node1.addPropertyChangeListener(this.propertyChangeHandler);
        node2.addPropertyChangeListener(this.propertyChangeHandler);
        this.resetBounds();
    }

    public KnowledgeDisplayEdge(Edge modelEdge, DisplayNode node1, DisplayNode node2) {
        if (modelEdge == null) {
            throw new NullPointerException("Model edge must not be null.");
        }
        if (node1 == null) {
            throw new NullPointerException("Node1 must not be null.");
        }
        if (node2 == null) {
            throw new NullPointerException("Node2 must not be null.");
        }
        this.modelEdge = modelEdge;
        this.node1 = node1;
        this.node2 = node2;
        this.mode = 1;
        node1.addComponentListener(this.compHandler);
        node2.addComponentListener(this.compHandler);
        KnowledgeModelEdge _modelEdge = (KnowledgeModelEdge)modelEdge;
        int edgeType = _modelEdge.getType();
        if (edgeType == 0) {
            this.type = 3;
        } else if (edgeType == 1) {
            this.type = 4;
        } else if (edgeType == 2) {
            this.type = 5;
        } else if (edgeType == 4) {
            this.type = 6;
        } else if (edgeType == 3) {
            this.type = 7;
        }
        node1.addPropertyChangeListener(this.propertyChangeHandler);
        node2.addPropertyChangeListener(this.propertyChangeHandler);
        this.resetBounds();
    }

    public KnowledgeDisplayEdge(DisplayNode node1, Point mouseTrackPoint, int type) {
        if (node1 == null) {
            throw new NullPointerException("Node1 must not be null.");
        }
        if (mouseTrackPoint == null) {
            throw new NullPointerException("Mouse track point must not be null.");
        }
        if (type != 3 && type != 4 && type != 5 && type != 6 && type != 7) {
            throw new IllegalArgumentException();
        }
        this.node1 = node1;
        this.mouseTrackPoint = mouseTrackPoint;
        this.mode = 0;
        this.type = type;
        this.resetBounds();
    }

    @Override
    public void paint(Graphics g) {
        switch (this.mode) {
            case 0: {
                g.setColor(this.getLineColor());
                Point point = this.getRelativeMouseTrackPoint();
                this.setConnectedPoints(this.calculateEdge(this.getNode1(), point));
                if (this.getConnectedPoints() == null) break;
                this.drawEdge(g);
                break;
            }
            case 1: {
                g.setColor(this.getLineColor());
                this.setConnectedPoints(this.calculateEdge((Component)this.getNode1(), this.getNode2()));
                if (this.getConnectedPoints() == null) break;
                this.drawEdge(g);
                break;
            }
            case 2: {
                g.setColor(this.selectedColor);
                this.setConnectedPoints(this.calculateEdge((Component)this.getNode1(), this.getNode2()));
                if (this.getConnectedPoints() == null) break;
                this.drawEdge(g);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void drawEdge(Graphics g) {
        this.getConnectedPoints().getFrom().translate(-this.getLocation().x, -this.getLocation().y);
        this.getConnectedPoints().getTo().translate(-this.getLocation().x, -this.getLocation().y);
        this.setClickRegion();
        g.drawLine(this.getConnectedPoints().getFrom().x, this.getConnectedPoints().getFrom().y, this.getConnectedPoints().getTo().x, this.getConnectedPoints().getTo().y);
        if (!this.isShowAdjacenciesOnly()) {
            this.drawEndpoints(this.getConnectedPoints(), g);
        }
        this.firePropertyChange("newPointPair", null, this.getConnectedPoints());
    }

    @Override
    public boolean contains(int x, int y) {
        Polygon clickRegion = this.getClickRegion();
        if (clickRegion != null) {
            return clickRegion.contains(new Point(x, y));
        }
        return false;
    }

    private Polygon getClickRegion() {
        if (this.clickRegion == null && this.getConnectedPoints() != null) {
            this.clickRegion = KnowledgeDisplayEdge.getSleeve(this.getConnectedPoints());
        }
        return this.clickRegion;
    }

    @Override
    public final PointPair getPointPair() {
        switch (this.mode) {
            case 0: {
                Point point = this.getRelativeMouseTrackPoint();
                this.setConnectedPoints(this.calculateEdge(this.getNode1(), point));
                break;
            }
            case 1: 
            case 2: {
                this.setConnectedPoints(this.calculateEdge((Component)this.getNode1(), this.getNode2()));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this.getConnectedPoints();
    }

    @Override
    public final DisplayNode getComp1() {
        return this.getNode1();
    }

    @Override
    public final DisplayNode getComp2() {
        return this.getNode2();
    }

    public final int getMode() {
        return this.mode;
    }

    @Override
    public final Point getTrackPoint() {
        return this.mouseTrackPoint;
    }

    @Override
    public final boolean isSelected() {
        return this.mode == 2;
    }

    @Override
    public final void setSelected(boolean selected) {
        if (selected == this.isSelected()) {
            return;
        }
        boolean oldSelected = this.isSelected();
        if (this.mode != 0) {
            this.mode = selected ? 2 : 1;
            this.firePropertyChange("selected", oldSelected, selected);
            this.repaint();
        }
    }

    @Override
    public void launchAssociatedEditor() {
    }

    @Override
    public final void updateTrackPoint(Point p) {
        if (this.mode != 0) {
            throw new IllegalStateException("Cannot call the updateTrackPoint method when the edge is not in HALF_ANCHORED mode.");
        }
        this.mouseTrackPoint = new Point(p);
        this.resetBounds();
        this.repaint();
    }

    @Override
    public final DisplayNode getNode1() {
        return this.node1;
    }

    @Override
    public final DisplayNode getNode2() {
        return this.node2;
    }

    @Override
    public final PointPair getConnectedPoints() {
        return this.connectedPoints;
    }

    @Override
    public final void setConnectedPoints(PointPair connectedPoints) {
        this.connectedPoints = connectedPoints;
    }

    @Override
    public final Point getRelativeMouseTrackPoint() {
        return this.relativeMouseTrackPoint;
    }

    private void setClickRegion() {
        this.clickRegion = null;
    }

    private PointPair calculateEdge(Component comp1, Component comp2) {
        Rectangle r1 = comp1.getBounds();
        Rectangle r2 = comp2.getBounds();
        Point c1 = new Point((int)((double)r1.x + (double)r1.width / 2.0), (int)((double)r1.y + (double)r1.height / 2.0));
        Point c2 = new Point((int)((double)r2.x + (double)r2.width / 2.0), (int)((double)r2.y + (double)r2.height / 2.0));
        double angle = FastMath.atan2(c1.y - c2.y, c1.x - c2.x);
        Point d = new Point((int)(this.offset * FastMath.cos(angle += 1.5707963267948966)), (int)(this.offset * FastMath.sin(angle)));
        c1.translate(d.x, d.y);
        c2.translate(d.x, d.y);
        Point p1 = this.getBoundaryIntersection(comp1, c1, c2);
        Point p2 = this.getBoundaryIntersection(comp2, c2, c1);
        if (p1 == null || p2 == null) {
            c1 = new Point((int)((double)r1.x + (double)r1.width / 2.0), (int)((double)r1.y + (double)r1.height / 2.0));
            c2 = new Point((int)((double)r2.x + (double)r2.width / 2.0), (int)((double)r2.y + (double)r2.height / 2.0));
            p1 = this.getBoundaryIntersection(comp1, c1, c2);
            p2 = this.getBoundaryIntersection(comp2, c2, c1);
        }
        if (p1 == null || p2 == null) {
            return null;
        }
        return new PointPair(p1, p2);
    }

    private PointPair calculateEdge(DisplayNode comp, Point p) {
        Rectangle r = comp.getBounds();
        Point p1 = new Point((int)((double)r.x + (double)r.width / 2.0), (int)((double)r.y + (double)r.height / 2.0));
        Point p2 = new Point(p);
        p2.translate(this.getLocation().x, this.getLocation().y);
        Point p3 = this.getBoundaryIntersection(comp, p1, p2);
        return p3 == null ? null : new PointPair(p3, p2);
    }

    private static double distance(Point p1, Point p2) {
        double d = (p1.x - p2.x) * (p1.x - p2.x);
        d += (double)((p1.y - p2.y) * (p1.y - p2.y));
        d = FastMath.sqrt(d);
        return d;
    }

    private void drawEndpoints(PointPair pp, Graphics g) {
        if (this.getModelEdge() != null) {
            Endpoint endpointA = this.getModelEdge().getEndpoint1();
            Endpoint endpointB = this.getModelEdge().getEndpoint2();
            if (endpointA == Endpoint.CIRCLE) {
                KnowledgeDisplayEdge.drawCircleEndpoint(pp.getTo(), pp.getFrom(), g);
            } else if (endpointA == Endpoint.ARROW) {
                KnowledgeDisplayEdge.drawArrowEndpoint(pp.getTo(), pp.getFrom(), g);
            }
            if (endpointB == Endpoint.CIRCLE) {
                KnowledgeDisplayEdge.drawCircleEndpoint(pp.getFrom(), pp.getTo(), g);
            } else if (endpointB == Endpoint.ARROW) {
                KnowledgeDisplayEdge.drawArrowEndpoint(pp.getFrom(), pp.getTo(), g);
            }
        } else {
            KnowledgeDisplayEdge.drawArrowEndpoint(pp.getFrom(), pp.getTo(), g);
        }
    }

    private static void drawArrowEndpoint(Point from, Point to, Graphics g) {
        double a = to.x - from.x;
        double b = from.y - to.y;
        double theta = FastMath.atan2(b, a);
        int itheta = (int)(theta * 360.0 / (Math.PI * 2) + 180.0);
        g.fillArc(to.x - 18, to.y - 18, 36, 36, itheta - 15, 30);
    }

    private static void drawCircleEndpoint(Point from, Point to, Graphics g) {
        int diameter = 13;
        double a = to.x - from.x;
        double b = from.y - to.y;
        double theta = FastMath.atan2(b, a);
        int xminus = (int)(FastMath.cos(theta) * 13.0 / 2.0);
        int yplus = (int)(FastMath.sin(theta) * 13.0 / 2.0);
        g.fillOval(to.x - xminus - 6, to.y + yplus - 6, 13, 13);
        Color c = g.getColor();
        g.setColor(Color.white);
        g.fillOval(to.x - xminus - 3 - 1, to.y + yplus - 3 - 1, 9, 9);
        g.setColor(c);
    }

    private Point getBoundaryIntersection(Component comp, Point pIn, Point pOut) {
        Point loc = comp.getLocation();
        if (!comp.contains(pIn.x - loc.x, pIn.y - loc.y)) {
            return null;
        }
        if (comp.contains(pOut.x - loc.x, pOut.y - loc.y)) {
            return null;
        }
        Point pFrom = new Point(pOut);
        Point pTo = new Point(pIn);
        Point pMid = null;
        while (KnowledgeDisplayEdge.distance(pFrom, pTo) > 2.0) {
            pMid = new Point((pFrom.x + pTo.x) / 2, (pFrom.y + pTo.y) / 2);
            if (comp.contains(pMid.x - loc.x, pMid.y - loc.y)) {
                pTo = pMid;
                continue;
            }
            pFrom = pMid;
        }
        return pMid;
    }

    private static Polygon getSleeve(PointPair pp) {
        if (pp == null || pp.getFrom() == null || pp.getTo() == null) {
            return null;
        }
        int d = 7;
        if (FastMath.abs(pp.getFrom().y - pp.getTo().y) <= 3) {
            return KnowledgeDisplayEdge.getHorizSleeve(pp);
        }
        int[] xpoints = new int[4];
        int[] ypoints = new int[4];
        double qx = pp.getTo().x - pp.getFrom().x;
        double qy = pp.getTo().y - pp.getFrom().y;
        double sx = 49.0 / (1.0 + qx * qx / (qy * qy));
        sx = FastMath.pow(sx, 0.5);
        double sy = -(qx / qy) * sx;
        Point t = new Point((int)(sx += (double)pp.getFrom().x + 1.0) - pp.getFrom().x, (int)(sy += (double)pp.getFrom().y + 1.0) - pp.getFrom().y);
        xpoints[0] = pp.getFrom().x + t.x;
        xpoints[1] = pp.getTo().x + t.x;
        xpoints[2] = pp.getTo().x - t.x;
        xpoints[3] = pp.getFrom().x - t.x;
        ypoints[0] = pp.getFrom().y + t.y;
        ypoints[1] = pp.getTo().y + t.y;
        ypoints[2] = pp.getTo().y - t.y;
        ypoints[3] = pp.getFrom().y - t.y;
        return new Polygon(xpoints, ypoints, 4);
    }

    private static Polygon getHorizSleeve(PointPair pp) {
        int[] xpoints = new int[4];
        int[] ypoints = new int[4];
        xpoints[0] = pp.getFrom().x;
        xpoints[1] = pp.getFrom().x;
        xpoints[2] = pp.getTo().x;
        xpoints[3] = pp.getTo().x;
        ypoints[0] = pp.getFrom().y + 7;
        ypoints[1] = pp.getFrom().y - 7;
        ypoints[2] = pp.getTo().y - 7;
        ypoints[3] = pp.getTo().y + 7;
        return new Polygon(xpoints, ypoints, 4);
    }

    private void resetBounds() {
        switch (this.mode) {
            case 0: {
                Rectangle temp = new Rectangle(this.mouseTrackPoint.x, this.mouseTrackPoint.y, 0, 0);
                Rectangle r = this.getNode1().getBounds().union(temp.getBounds());
                r = r.union(new Rectangle(r.x - 3, r.y - 3, r.width + 6, r.height + 6));
                this.setBounds(r);
                Rectangle node1RelativeBounds = new Rectangle(this.getNode1().getBounds());
                this.relativeMouseTrackPoint = new Point(this.mouseTrackPoint);
                node1RelativeBounds.translate(-this.getLocation().x, -this.getLocation().y);
                this.getRelativeMouseTrackPoint().translate(-this.getLocation().x, -this.getLocation().y);
                break;
            }
            case 1: 
            case 2: {
                Rectangle r1 = this.node1.getBounds();
                Rectangle r2 = this.node2.getBounds();
                Point c1 = new Point((int)((double)r1.x + (double)r1.width / 2.0), (int)((double)r1.y + (double)r1.height / 2.0));
                Point c2 = new Point((int)((double)r2.x + (double)r2.width / 2.0), (int)((double)r2.y + (double)r2.height / 2.0));
                double angle = FastMath.atan2(c1.y - c2.y, c1.x - c2.x);
                Point d = new Point((int)(this.offset * FastMath.cos(angle += 1.5707963267948966)), (int)(this.offset * FastMath.sin(angle)));
                r1.translate(d.x, d.y);
                r2.translate(d.x, d.y);
                Rectangle r3 = r1.getBounds().union(r2.getBounds());
                r3 = r3.union(new Rectangle(r3.x - 3, r3.y - 3, r3.width + 6, r3.height + 6));
                this.setBounds(r3);
                Rectangle node1RelativeBounds = new Rectangle(this.getNode1().getBounds());
                Rectangle node2RelativeBounds = new Rectangle(this.getNode2().getBounds());
                node1RelativeBounds.translate(-this.getLocation().x, -this.getLocation().y);
                node2RelativeBounds.translate(-this.getLocation().x, -this.getLocation().y);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private boolean isShowAdjacenciesOnly() {
        return this.showAdjacenciesOnly;
    }

    @Override
    public final Edge getModelEdge() {
        return this.modelEdge;
    }

    @Override
    public double getOffset() {
        return this.offset;
    }

    @Override
    public void setOffset(double offset) {
        this.offset = offset;
    }

    public int getType() {
        return this.type;
    }

    @Override
    public Color getLineColor() {
        if (this.type == 3) {
            return this.forbiddenExplicitlyColor;
        }
        if (this.type == 4) {
            return this.forbiddenByTiersColor;
        }
        if (this.type == 5) {
            return this.requiredColor;
        }
        if (this.type == 6) {
            return this.requiredGroupsColor;
        }
        if (this.type == 7) {
            return this.forbiddenGroupsColor;
        }
        throw new IllegalStateException();
    }

    @Override
    public void setLineColor(Color lineColor) {
    }

    @Override
    public boolean getSolid() {
        return this.solid;
    }

    @Override
    public void setSolid(boolean solid) {
        this.solid = solid;
    }

    @Override
    public void setThick(boolean thick) {
        this.thick = thick;
    }

    @Override
    public Color getSelectedColor() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSelectedColor(Color selectedColor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Color getHighlightedColor() {
        return this.highlightedColor;
    }

    @Override
    public void setHighlightedColor(Color highlightedColor) {
        this.highlightedColor = highlightedColor;
    }

    @Override
    public float getStrokeWidth() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setStrokeWidth(float strokeWidth) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHighlighted(boolean highlighted) {
    }

    public void setShowAdjacenciesOnly(boolean showAdjacenciesOnly) {
        this.showAdjacenciesOnly = showAdjacenciesOnly;
    }

    private final class ComponentHandler
    extends ComponentAdapter {
        private ComponentHandler() {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            KnowledgeDisplayEdge.this.resetBounds();
            KnowledgeDisplayEdge.this.repaint();
        }
    }

    private final class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if ("selected".equals(name) && Boolean.FALSE.equals(evt.getNewValue())) {
                KnowledgeDisplayEdge.this.setSelected(false);
            }
        }
    }
}

