/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.knowledge_editor;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Paths;
import edu.cmu.tetrad.graph.TimeLagGraph;
import edu.cmu.tetrad.graph.Underlines;
import edu.cmu.tetrad.util.TetradSerializableExcluded;
import edu.cmu.tetradapp.knowledge_editor.KnowledgeModelEdge;
import edu.cmu.tetradapp.knowledge_editor.KnowledgeModelNode;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class KnowledgeGraph
implements Graph,
TetradSerializableExcluded {
    static final long serialVersionUID = 23L;
    private final Graph graph = new EdgeListGraph();
    private final Knowledge knowledge;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final Paths paths;

    public KnowledgeGraph(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException();
        }
        this.knowledge = knowledge;
        this.paths = new Paths(this.graph);
    }

    public static KnowledgeGraph serializableInstance() {
        return new KnowledgeGraph(Knowledge.serializableInstance());
    }

    @Override
    public final void transferNodesAndEdges(Graph graph) throws IllegalArgumentException {
        this.getGraph().transferNodesAndEdges(graph);
        for (Node node : this.getGraph().getNodes()) {
            node.getAllAttributes().clear();
        }
    }

    @Override
    public final void transferAttributes(Graph graph) throws IllegalArgumentException {
        this.getGraph().transferAttributes(graph);
    }

    @Override
    public Underlines underlines() {
        return this.graph.underlines();
    }

    @Override
    public Paths paths() {
        return this.paths;
    }

    @Override
    public boolean isParameterizable(Node node) {
        return false;
    }

    @Override
    public boolean isTimeLagModel() {
        return false;
    }

    @Override
    public TimeLagGraph getTimeLagGraph() {
        return null;
    }

    @Override
    public List<Node> getSepset(Node n1, Node n2) {
        return this.graph.getSepset(n1, n2);
    }

    @Override
    public void setNodes(List<Node> nodes) {
        this.graph.setNodes(nodes);
    }

    @Override
    public List<String> getNodeNames() {
        return this.getGraph().getNodeNames();
    }

    @Override
    public void fullyConnect(Endpoint endpoint) {
        this.getGraph().fullyConnect(endpoint);
    }

    @Override
    public void reorientAllWith(Endpoint endpoint) {
        this.getGraph().reorientAllWith(endpoint);
    }

    @Override
    public List<Node> getAdjacentNodes(Node node) {
        return this.getGraph().getAdjacentNodes(node);
    }

    @Override
    public List<Node> getNodesInTo(Node node, Endpoint endpoint) {
        return this.getGraph().getNodesInTo(node, endpoint);
    }

    @Override
    public List<Node> getNodesOutTo(Node node, Endpoint n) {
        return this.getGraph().getNodesOutTo(node, n);
    }

    @Override
    public List<Node> getNodes() {
        return this.getGraph().getNodes();
    }

    @Override
    public boolean removeEdge(Node node1, Node node2) {
        return this.removeEdge(this.getEdge(node1, node2));
    }

    @Override
    public boolean removeEdges(Node node1, Node node2) {
        return this.getGraph().removeEdges(node1, node2);
    }

    @Override
    public boolean isAdjacentTo(Node nodeX, Node nodeY) {
        return this.getGraph().isAdjacentTo(nodeX, nodeY);
    }

    @Override
    public boolean setEndpoint(Node node1, Node node2, Endpoint endpoint) {
        return this.getGraph().setEndpoint(node1, node2, endpoint);
    }

    @Override
    public Endpoint getEndpoint(Node node1, Node node2) {
        return this.getGraph().getEndpoint(node1, node2);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof KnowledgeGraph)) {
            return false;
        }
        return this.getGraph().equals(o);
    }

    @Override
    public Graph subgraph(List<Node> nodes) {
        return this.getGraph().subgraph(nodes);
    }

    @Override
    public boolean addDirectedEdge(Node nodeA, Node nodeB) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addUndirectedEdge(Node nodeA, Node nodeB) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addNondirectedEdge(Node nodeA, Node nodeB) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addPartiallyOrientedEdge(Node nodeA, Node nodeB) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addBidirectedEdge(Node nodeA, Node nodeB) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addEdge(Edge edge) {
        if (!(edge instanceof KnowledgeModelEdge)) {
            return false;
        }
        KnowledgeModelEdge _edge = (KnowledgeModelEdge)edge;
        KnowledgeModelNode _node1 = (KnowledgeModelNode)_edge.getNode1();
        KnowledgeModelNode _node2 = (KnowledgeModelNode)_edge.getNode2();
        String from = _node1.getName();
        String to = _node2.getName();
        if (_edge.getType() == 0) {
            this.knowledge.setForbidden(from, to);
        } else if (_edge.getType() == 2) {
            this.knowledge.setRequired(from, to);
        } else if (_edge.getType() == 1) {
            if (!this.knowledge.isForbiddenByTiers(from, to)) {
                throw new IllegalArgumentException("Edge " + from + "-->" + to + " is not forbidden by tiers.");
            }
        } else if (_edge.getType() == 3) {
            if (!this.knowledge.isForbiddenByGroups(from, to)) {
                throw new IllegalArgumentException("Edge " + from + "-->" + to + " is not forbidden by groups.");
            }
        } else if (_edge.getType() == 4 && !this.knowledge.isRequiredByGroups(from, to)) {
            throw new IllegalArgumentException("Edge " + from + "-->" + to + " is not required by groups.");
        }
        if (!this.getGraph().containsEdge(edge)) {
            return this.getGraph().addEdge(edge);
        }
        return false;
    }

    @Override
    public boolean addNode(Node node) {
        return this.getGraph().addNode(node);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.getGraph().addPropertyChangeListener(l);
    }

    @Override
    public boolean containsEdge(Edge edge) {
        return this.getGraph().containsEdge(edge);
    }

    @Override
    public boolean containsNode(Node node) {
        return this.getGraph().containsNode(node);
    }

    @Override
    public Set<Edge> getEdges() {
        return this.getGraph().getEdges();
    }

    @Override
    public List<Edge> getEdges(Node node) {
        return this.getGraph().getEdges(node);
    }

    @Override
    public List<Edge> getEdges(Node node1, Node node2) {
        return this.getGraph().getEdges(node1, node2);
    }

    @Override
    public Node getNode(String name) {
        return this.getGraph().getNode(name);
    }

    @Override
    public int getNumEdges() {
        return this.getGraph().getNumEdges();
    }

    @Override
    public int getNumNodes() {
        return this.getGraph().getNumNodes();
    }

    @Override
    public int getNumEdges(Node node) {
        return this.getGraph().getNumEdges(node);
    }

    @Override
    public boolean removeEdge(Edge edge) {
        KnowledgeModelEdge _edge = (KnowledgeModelEdge)edge;
        KnowledgeModelNode _node1 = (KnowledgeModelNode)_edge.getNode1();
        KnowledgeModelNode _node2 = (KnowledgeModelNode)_edge.getNode2();
        String from = _node1.getName();
        String to = _node2.getName();
        if (_edge.getType() == 0) {
            this.getKnowledge().removeForbidden(from, to);
        } else if (_edge.getType() == 2) {
            this.getKnowledge().removeRequired(from, to);
        } else {
            if (_edge.getType() == 1) {
                throw new IllegalArgumentException("Please use the tiers interface to remove edges forbidden by tiers.");
            }
            if (_edge.getType() == 3) {
                throw new IllegalArgumentException("Please use the Other Groups interface to remove edges forbidden by groups.");
            }
            if (_edge.getType() == 4) {
                throw new IllegalArgumentException("Please use the Other Groups interface to remove edges required by groups.");
            }
        }
        return this.getGraph().removeEdge(edge);
    }

    @Override
    public boolean removeEdges(Collection<Edge> edges) {
        boolean removed = false;
        for (Edge edge : edges) {
            removed = removed || this.removeEdge(edge);
        }
        return removed;
    }

    @Override
    public boolean removeNode(Node node) {
        return this.getGraph().removeNode(node);
    }

    @Override
    public void clear() {
        this.getGraph().clear();
    }

    @Override
    public boolean removeNodes(List<Node> nodes) {
        return this.getGraph().removeNodes(nodes);
    }

    @Override
    public boolean isDefNoncollider(Node node1, Node node2, Node node3) {
        return this.getGraph().isDefNoncollider(node1, node2, node3);
    }

    @Override
    public boolean isDefCollider(Node node1, Node node2, Node node3) {
        return this.getGraph().isDefCollider(node1, node2, node3);
    }

    @Override
    public List<Node> getChildren(Node node) {
        return this.getGraph().getChildren(node);
    }

    @Override
    public int getDegree() {
        return this.getGraph().getDegree();
    }

    @Override
    public Edge getEdge(Node node1, Node node2) {
        return this.getGraph().getEdge(node1, node2);
    }

    @Override
    public Edge getDirectedEdge(Node node1, Node node2) {
        return this.getGraph().getDirectedEdge(node1, node2);
    }

    @Override
    public List<Node> getParents(Node node) {
        return this.getGraph().getParents(node);
    }

    @Override
    public int getIndegree(Node node) {
        return this.getGraph().getIndegree(node);
    }

    @Override
    public int getDegree(Node node) {
        return this.getGraph().getDegree(node);
    }

    @Override
    public int getOutdegree(Node node) {
        return this.getGraph().getOutdegree(node);
    }

    @Override
    public boolean isChildOf(Node node1, Node node2) {
        return this.getGraph().isChildOf(node1, node2);
    }

    @Override
    public boolean isParentOf(Node node1, Node node2) {
        return this.getGraph().isParentOf(node1, node2);
    }

    @Override
    public boolean isExogenous(Node node) {
        return this.getGraph().isExogenous(node);
    }

    @Override
    public String toString() {
        return this.getGraph().toString();
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    private Graph getGraph() {
        return this.graph;
    }

    @Override
    public Map<String, Object> getAllAttributes() {
        return this.attributes;
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public void removeAttribute(String key) {
        this.attributes.remove(key);
    }

    @Override
    public void addAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }
}

